---
layout: post
title: Leaflet 1.9 released
description: The v1.9 release is setting the stage for the first major version bump of Leaflet since 2016!
author: Jon Koops
authorsite: https://github.com/jonkoops
---

The v1.9 release is setting the stage for the first major version bump of Leaflet since 2016! A lot has changed since then, and it's time for Leaflet to grow together with the web platform.

After this release, we are branching off the 1.x code and putting it in _maintenance mode_ — reserving potential 1.x releases _only_ for critical bugfixes. Although **version 2.0** is still far away and will take some time to take shape, we plan to make the following changes:

- **Dropping support for Internet Explorer**.
This has been a long time coming, but now that Internet Explorer is [officially end-of-life](https://blogs.windows.com/windowsexperience/2022/06/15/internet-explorer-11-has-retired-and-is-officially-out-of-support-what-you-need-to-know/), it's time to say goodbye. Going forward, Leaflet will move to an evergreen strategy that targets browsers like Firefox, Chrome, Edge and Safari.
- **Embracing modern JavaScript**.
To maintain backwards compatibility, Leaflet is written entirely in ES5, a version of JavaScript supported by legacy browsers. So we have not been able to make use of many great JavaScript features (e.g. [standardized classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes), instead having to rely on our [own implementation](https://leafletjs.com/reference.html#class)). By adopting a more modern version of the ECMAScript standard, we can start working towards aligning Leaflet with what is expected from a modern JavaScript library.
- **Standardized modules**.
When we released Leaflet v1, the landscape in the JavaScript world was very different and full of competing module standards such as CommonJS, AMD and UMD. Today, [ECMAScript modules](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules) have become the clear way forward to unite the JavaScript ecosystem under one banner. Moving forward, Leaflet will only be distributed in a single standardized module system, greatly reducing complexity of our distributed code.
- **Removing the Leaflet global**.
As a developer using Leaflet, the capital letter `L` is probably intimately familiar to you. This is the Leaflet global where all of Leaflet's functionality lives. To allow compiler tooling to better eliminate dead-code through a process called [tree-shaking](https://developer.mozilla.org/en-US/docs/Glossary/Tree_shaking), we are removing this global variable. To preserve backwards compatibility with older plugins, we will provide a shim that can be imported manually that will restore this functionality.

Check out [the full changelog here](https://github.com/Leaflet/Leaflet/releases/tag/v1.9.0).

**Edit**: [v1.9.1 patch](https://github.com/Leaflet/Leaflet/releases/tag/v1.9.1) has been released to address compatibility with _Leaflet.markercluster_ plugin.

**Edit**: [v1.9.2 patch](https://github.com/Leaflet/Leaflet/releases/tag/v1.9.2) has been released which reverts ESM support because of numerous compatibility issues with plugins.

**Edit**: [v1.9.3 patch](https://github.com/Leaflet/Leaflet/releases/tag/v1.9.3) has been released which resolves some bug fixes and accessibility issues.

Cheers,<br>
The Leaflet team.

[![Stand With Ukraine](https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner-direct.svg)](https://stand-with-ukraine.pp.ua)
