---
layout: v2
title: Tutorials
bodyclass: examples
---

## Leaflet Tutorials

Every tutorial here comes with step-by-step code explanation and is easy enough even for beginner JavaScript developers.


{% include tutorial_link.html
page="quick-start/"
thumbnail="quick-start/thumbnail.png"
title="Leaflet Quick Start Guide"
description="A simple step-by-step guide that will quickly get you started with Leaflet basics, including setting up a Leaflet map (with OpenStreetMap tiles) on your page, working with markers, polylines and popups, and dealing with events."
%}


{% include tutorial_link.html
page="mobile/"
thumbnail="mobile/thumbnail.png"
title="Leaflet on Mobile"
description="In this tutorial, you'll learn how to create a fullscreen map tuned for mobile devices like iPhone, iPad or Android phones, and how to easily detect and use the current user location."
%}


{% include tutorial_link.html
page="custom-icons/"
thumbnail="custom-icons/thumbnail.png"
title="Markers with Custom Icons"
description="In this pretty tutorial, you'll learn how to easily define your own icons for use by the markers you put on the map."
%}


{% include tutorial_link.html
page="accessibility/"
thumbnail="accessibility/thumbnail.png"
title="Accessible maps"
description="A guide to basic Leaflet accessibility - make your maps usable to persons of a wide range of abilities."
%}


{% include tutorial_link.html
page="geojson/"
thumbnail="geojson/thumbnail.png"
title="Using GeoJSON with Leaflet"
description="In this tutorial, you'll learn how to create and interact with map vectors created from [GeoJSON](http://geojson.org/) objects."
%}


{% include tutorial_link.html
page="choropleth/"
thumbnail="choropleth/thumbnail.png"
title="Interactive Choropleth Map"
description="A case study of creating a colorful interactive [choropleth map](http://en.wikipedia.org/wiki/Choropleth_map) of US States Population Density with GeoJSON and some custom controls. News websites will love this."
%}


{% include tutorial_link.html
page="layers-control/"
thumbnail="layers-control/thumbnail.png"
title="Layer Groups and Layers Control"
description="A tutorial on how to manage groups of layers and use the layer switching control."
%}


{% include tutorial_link.html
page="zoom-levels/"
thumbnail="zoom-levels/thumbnail.png"
title="Zoom levels"
description="A deeper look into what zoom levels are."
%}

{% include tutorial_link.html
page="crs-simple/crs-simple.html"
thumbnail="crs-simple/thumbnail.png"
title="Non-geographical maps"
description="A primer on `L.CRS.Simple`, how to make maps with no concept of \"latitude\" or \"longitude\"."
%}


{% include tutorial_link.html
page="wms/wms.html"
thumbnail="wms/thumbnail.png"
title="WMS and TMS"
description="How to integrate with WMS and TMS services from professional GIS software."
%}


{% include tutorial_link.html
page="map-panes/"
thumbnail="map-panes/thumbnail.png"
title="Working with map panes"
description="How the default map panes work to display overlays on top of tiles, and how to override that."
%}


{% include tutorial_link.html
page="overlays/"
thumbnail="overlays/thumbnail.gif"
title="Overlays: Image, Video, SVG"
description="Leaflet can help you display images, videos and SVG elements somewhere on the map."
%}

***

The following tutorials cover how to create plugins for Leaflet, and are intended only for developers experienced in JavaScript:


{% include tutorial_link.html
page="extending/extending-1-classes.html"
thumbnail="extending/thumbnail-1.png"
title="Extending Leaflet: Class Theory"
description="An overview of Leaflet's classes, class inheritance, and conventions."
%}


{% include tutorial_link.html
page="extending/extending-2-layers.html"
thumbnail="extending/thumbnail-2.png"
title="Extending Leaflet: Layers"
description="How to extend layers or create new ones, using specific entry points for doing so."
%}


{% include tutorial_link.html
page="extending/extending-3-controls.html"
thumbnail="extending/thumbnail-3.png"
title="Extending Leaflet: Handlers and Controls"
description="How to extend or create non-layers."
%}

