dev.spec({

    z: 111,
    "type": "horizontalBar",
    "color": "color",
    "x": ['cat', "x1"],
    "y": ["y1", "y2"],
    "guide": [
        {
            "x": {
                "label": "Entity Type",
            },
            "y": {
                "label": "Feature",
                "tickLabel": "name"
            }
        },
        {
            enableColorToBarPosition: false,
            "x": {
                "label": "Count"
            },
            "y": {
                "label": "Name"
            },
            "color": {
                "label": "Entity Type",
                "tickLabel": "name"
            }
        }
    ],
    "dimensions": {
        "x1": {
            "type": "measure",
            "scale": "linear"
        },
        "y1": {
            "type": "category",
            "scale": "ordinal",
            "value": "id"
        },
        "y2": {
            "type": "category",
            "scale": "ordinal"
        },
        "color": {
            "type": "category",
            "scale": "ordinal",
            "value": "id"
        },
        "cat": {
            "type": "category",
            "scale": "ordinal"
        }
    },
    "data": [
        {
            "x1": 1,
            "y1": null,
            "y2": "board filter is shrunken beyond usability on horizontal resolutions < 800px",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Cards context menu is replaced to lists one in One by One mode",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Child tpr shouldn't be moved to the final state if current user doesn't have access to it",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Data layer exception when rename state to the same name as another state has but using different Case",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Non-admin should not be able to move states",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Open/total User Stories unit: 'U' icon is absent",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Quick Add new release in Project View - counter doesn't update",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Show more dissapears if it is in collapsed row and I mouse over it's row",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Tab counter is not updated",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "Unable to open view generated from start page, zoom level is invalid",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": null,
            "y2": "You won't see releases which are from Iteration-based process Projects in the Project w/o Iterations practice, though these releases are related to not-iterative projects already",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 84637, "name": "Cross-project Releases"},
            "y2": "In case feature 'Cross Project Releases' is toggled after using it -> the Release card stays shown on board for all the related projects.",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 84637, "name": "Cross-project Releases"},
            "y2": "Permissions / context",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 84637, "name": "Cross-project Releases"},
            "y2": "Release is deleted when I delete the main project",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 84637, "name": "Cross-project Releases"},
            "y2": "'Releases' tab on Project View should show all related releases",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 49128, "name": "Custom Graphic Reports MVF"},
            "y2": "Client-Server RnD in the wild",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 49126, "name": "Dashboards MVF"},
            "y2": "Add Dashboard",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 49126, "name": "Dashboards MVF"},
            "y2": "Dashboard setup with Widgets tab",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 49126, "name": "Dashboards MVF"},
            "y2": "Dashboards routing",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 54570, "name": "Easy States setup MVF"},
            "y2": "Back browser button isn't working when go back from View list to Process list",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 54570, "name": "Easy States setup MVF"},
            "y2": "Links to projects in project popup",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 54570, "name": "Easy States setup MVF"},
            "y2": "Reorder states",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 54570, "name": "Easy States setup MVF"},
            "y2": "User should be redirected to view after Process setup close",
            "color": {"id": 8, "name": "Bug"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 89998, "name": "Hierarchical Test Plans MMF"},
            "y2": "Show parent Test Plan Run on a Test Run/Plan Run View",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }, {
            "x1": 1,
            "y1": {"id": 90017, "name": "Test Plan Parameters MVF"},
            "y2": "Close child Test Plan Runs (move to the final state) when a parent Test Plan Run is moved to a final state",
            "color": {"id": 4, "name": "UserStory"},
            "dataItem": null
        }
    ].map(function (row) {
            row.x1 = Math.random();
            row.cat = row.color.name;
            return row;
        })
        .reduce(function (memo, r) {
            return memo.concat([
                'A',
                'B',
                'C',
                'D',
                'E'
            ].map(function (s) {
                    var z = JSON.parse(JSON.stringify(r));
                    z.cat = z.cat + ' ' + s;
                    return z;
                }));
        }, [])
});