dev.spec({

    sel: 1111,

    xsize: {
        width: 800,
        height: 380
    },

    data: [
        [24.0, 55.0,   4000, 'P', '0', 'Kowno'],
        [25.3, 54.7,   4000, 'P', '0', 'Wilna'],
        [26.4, 54.4,   4000, 'P', '0', 'Smorgon'],
        [26.8, 54.3,   4000, 'P', '0', 'Molodechno'],
        [27.7, 55.2,   4000, 'P', '0', 'Gloubokoe'],
        [27.6, 53.9,   4000, 'P', '0', 'Minsk'],
        [28.5, 54.3,   4000, 'P', '0', 'Studienska'],
        [28.7, 55.5,   4000, 'P', '0', 'Polotzk'],
        [29.2, 54.4,   4000, 'P', '0', 'Bobr'],
        [30.2, 55.3,   4000, 'P', '0', 'Vitebsk'],
        [30.4, 54.4,   4000, 'P', '0', 'Orscha'],
        [30.4, 53.9,   4000, 'P', '0', 'Mohilow'],
        [32.0, 54.8,   4000, 'P', '0', 'Smolensk'],
        [34.3, 55.2,   4000, 'P', '0', 'Wixma'],
        [34.4, 55.5,   4000, 'P', '0', 'Chjat'],
        [36.0, 55.5,   4000, 'P', '0', 'Mojaisk'],
        [37.6, 55.8,   4000, 'P', '0', 'Moscow'],
        [36.6, 55.3,   4000, 'P', '0', 'Tarantino'],
        [36.5, 55.0,   4000, 'P', '0', 'Malo-jarosewli'],

        [24.0, 54.9, 340000, 'A', '1'],
        [24.5, 55.0, 340000, 'A', '1'],
        [25.5, 54.5, 340000, 'A', '1'],
        [26.0, 54.7, 320000, 'A', '1'],
        [27.0, 54.8, 300000, 'A', '1'],
        [28.0, 54.9, 280000, 'A', '1'],
        [28.5, 55.0, 240000, 'A', '1'],
        [29.0, 55.1, 210000, 'A', '1'],
        [30.0, 55.2, 180000, 'A', '1'],
        [30.3, 55.3, 175000, 'A', '1'],
        [32.0, 54.8, 145000, 'A', '1'],
        [33.2, 54.9, 140000, 'A', '1'],
        [34.4, 55.5, 127100, 'A', '1'],
        [35.5, 55.4, 100000, 'A', '1'],
        [36.0, 55.5, 100000, 'A', '1'],
        [37.6, 55.8, 100000, 'A', '1'],
        [37.7, 55.7, 100000, 'R', '1'],
        [37.5, 55.7,  98000, 'R', '1'],
        [37.0, 55.0,  97000, 'R', '1'],
        [36.6, 55.0,  96000, 'R', '1'],
        [36.8, 55.0,  96000, 'R', '1'],
        [35.4, 55.3,  87000, 'R', '1'],
        [34.3, 55.2,  55000, 'R', '1'],
        [33.3, 54.8,  37000, 'R', '1'],
        [32.0, 54.6,  24000, 'R', '1'],
        [30.4, 54.4,  20000, 'R', '1'],
        [29.2, 54.3,  20000, 'R', '1'],
        [28.5, 54.2,  20000, 'R', '1'],
        [28.3, 54.3,  20000, 'R', '1'],
        [27.5, 54.5,  20000, 'R', '1'],
        [26.8, 54.3,  12000, 'R', '1'],
        [26.4, 54.4,  14000, 'R', '1'],
        [25.0, 54.4,   8000, 'R', '1'],
        [24.4, 54.4,   4000, 'R', '1'],
        [24.2, 54.4,   4000, 'R', '1'],
        [24.1, 54.4,   4000, 'R', '1'],
        [24.0, 55.1,  60000, 'A', '2'],
        [24.5, 55.2,  60000, 'A', '2'],
        [25.5, 54.7,  60000, 'A', '2'],
        [26.6, 55.7,  40000, 'A', '2'],
        [27.4, 55.6,  33000, 'A', '2'],
        [28.7, 55.5,  33000, 'A', '2'],
        [28.7, 55.5,  33000, 'R', '2'],
        [28.5, 54.15, 30000, 'R', '2'],
        [28.3, 54.25, 28000, 'R', '2'],
        [24.0, 55.2,  22000, 'A', '3'],
        [24.5, 55.3,  22000, 'A', '3'],
        [24.6, 55.8,   6000, 'A', '3'],
        [24.6, 55.8,   6000, 'R', '3'],
        [24.2, 54.4,   6000, 'R', '3'],
        [24.1, 54.4,   6000, 'R', '3']
    ].map(function (row) {
            var ar = {
                P: 'Place',
                A: 'Advance',
                R: 'Retreat'
            };
            return {
                lon: row[0],
                lat: row[1],
                survivors: row[2],
                direction: ar[row[3]],
                group: row[4],
                place: row[5]
            };
        }),

    type: 'line',
    x: 'lon',
    y: 'lat',
    size: 'survivors',
    label: 'place',
    split: 'group',
    color: 'direction',
    guide: {
        showGridLines: 'x',
        padding: {l: 45, r: 10, t: 10, b: 10},
        x: {
            nice: false,
            min: 24,
            max: 38,
            hide: true
        },
        y: {
            nice: false,
            min: 53.5,
            max: 56,
            hide: false,
            padding: 20,
            rotate: 270,
            textAnchor: 'middle',
            label: {
                text: 'Latitude',
                cssClass: 'label inline',
                dock: 'right',
                textAnchor: 'end',
                padding: -14
            }
        },
        size: {
            func: 'linear',
            minSize: 2,
            maxSize: 25
        },
        color: {
            brewer: {
                'Place': 'rgba(0,0,0,0)',
                'Advance': '#FF0000',
                'Retreat': '#000000'
            }
        }
    },
    settings: {
        specEngine: 'NONE',
        layoutEngine: 'NONE'
    },
    plugins: [
        tauCharts.api.plugins.get('legend')(),
        tauCharts.api.plugins.get('annotations')({
            items: [
                {
                    dim: 'lon',
                    val: [26, 31],
                    text: 'The territory of modern Belarus',
                    color: '#2c7fb8'
                }
            ]
        }),
        tauCharts.api.plugins.get('tooltip')()
    ]
});

dev.spec({

    sel: 1111,

    xsize: {
        width: 800,
        height: 180
    },

    data: [

        [37.6, 0, 'Oct 18', 6],
        [36.0, 0, 'Oct 24', 14],
        [33.2, -9, 'Nov 9', 5],
        [32.0, -21, 'Nov 14', 7],
        [29.2, -11, 'Nov 21', 7],
        [28.5, -20, 'Nov 28', 4],
        [27.2, -24, 'Dec 1', 5],
        [26.7, -30, 'Dec 6', 1],
        [25.3, -26, 'Dec 7', 0]
    ]
        .reduce(function (memo, x, i, list) {
            var curr = x;
            var next = (list.length - i > 1) ? list[i + 1] : curr;
            next = JSON.parse(JSON.stringify(next)); // clone
            curr.push(i);
            next.push(i);
            next[3] = curr[3];
            return memo.concat([curr, next]);
        }, [])
        .map(function (row) {

            return {
                lon: row[0],
                temperature: row[1],
                date: row[2],
                days: row[3],
                way: row[4]
            };
        }),

    test: [

        [37.6,   0, 'Oct 18',  6, 'Moscow-Mojaisk'],
        [36.0,   0, 'Oct 24',  6, 'Moscow-Mojaisk'],

        [36.0,   0, 'Oct 24', 14, 'Mojaisk-Wixma'],
        [33.2,  -9, 'Nov 9',  14, 'Mojaisk-Wixma'],

        [33.2,  -9, 'Nov 9',   5, 'Wixma-Smolensk'],
        [32.0, -21, 'Nov 14',  5, 'Wixma-Smolensk'],

        [32.0, -21, 'Nov 14',  7, 'Smolensk-Bobr'],
        [29.2, -11, 'Nov 21',  7, 'Smolensk-Bobr'],

        [29.2, -11, 'Nov 21',  7, 'Bobr-Studienska'],
        [28.5, -20, 'Nov 28',  7, 'Bobr-Studienska'],

        [28.5, -20, 'Nov 28', 4, 'Studienska-Molodechno'],
        [27.2, -24, 'Dec 1',  4, 'Studienska-Molodechno'],

        [27.2, -24, 'Dec 1',  5, 'Molodechno-Smorgon'],
        [26.7, -30, 'Dec 6',  5, 'Molodechno-Smorgon'],

        [26.7, -30, 'Dec 6',  1, 'Smorgon-Wilna'],
        [25.3, -26, 'Dec 7',  1, 'Smorgon-Wilna']

    ],

    type: 'line',
    x: 'lon',
    y: 'temperature',
    split: 'way',
    color: 'days',
    label: 'date',
    guide: {
        showGridLines: 'xy',
        padding: {l: 45, b: 50, t: 10, r: 10},
        x: {
            nice: false,
            min: 24,
            max: 38,
            hide: false,
            padding: 20,
            label: {
                text: 'Longitude',
                cssClass: 'label inline',
                dock: 'right',
                textAnchor: 'end',
                padding: -2
            }
        },
        y: {
            nice: false,
            min: -33,
            max: 2,
            hide: false,
            padding: 20,
            label: {
                text: 'Temperature',
                cssClass: 'label inline',
                dock: 'right',
                textAnchor: 'end',
                padding: -14
            }
        },
        color: {
            brewer: ['#eee', '#000']
        }
    },
    settings: {
        specEngine: 'NONE',
        layoutEngine: 'NONE'
    },
    plugins: [
        tauCharts.api.plugins.get('legend')(),
        tauCharts.api.plugins.get('tooltip')(),
        tauCharts.api.plugins.get('annotations')({
            items: [
                {
                    dim: 'temperature',
                    val: -10,
                    text: 'Usual winter',
                    color: '#2c7fb8'
                }
                ,
                {
                    dim: 'temperature',
                    val: -20,
                    text: 'Really cold...',
                    color: '#08519C'
                }
                ,
                {
                    dim: 'temperature',
                    val: -30,
                    text: 'Too cold to alive',
                    color: '#253494'
                }
            ]
        })
    ]
});


dev.drop({
    "title": "facets_ stacked-bar",
    "thumbnails": {
        "small": "/api/v1/drops/572317a43dc68e2100c10621/thumbnail?drop=44a30b8ad48b1d032bd0a76021215270c176611e&source=1461916345630&config=small",
        "medium": "/api/v1/drops/572317a43dc68e2100c10621/thumbnail?drop=44a30b8ad48b1d032bd0a76021215270c176611e&source=1461916345630&config=medium",
        "large": "/api/v1/drops/572317a43dc68e2100c10621/thumbnail?drop=44a30b8ad48b1d032bd0a76021215270c176611e&source=1461916345630&config=large",
        "opengraph": "/api/v1/drops/572317a43dc68e2100c10621/thumbnail?drop=44a30b8ad48b1d032bd0a76021215270c176611e&source=1461916345630&config=opengraph",
        "twitter_card_summary_large_image": "/api/v1/drops/572317a43dc68e2100c10621/thumbnail?drop=44a30b8ad48b1d032bd0a76021215270c176611e&source=1461916345630&config=twitter_card_summary_large_image"
    },
    "source": {
        "_id": "572312b93dc68e2100c10602",
        "original": {
            "type": "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "encoding": "7bit",
            "name": "olympicathletes_0.xlsx"
        },
        "date": "2016-04-29T07:52:25.630Z",
        "buildInFiltersAllowed": true,
        "singleDropPerSource": false,
        "rawDataAllowed": true,
        "suggestionsAllowed": true,
        "remoteDataProcessing": false,
        "formulasAllowed": false,
        "isAppDynamicSchemaSource": false,
        "queryAllowed": false,
        "dataProcessingMode": "local",
        "version": "1461916345630",
        "id": "572312b93dc68e2100c10602"
    },
    "spec": {
        "type": "stacked-bar",
        "trendline": null,
        "dimensions": {
            "sport_3_89": {"type": "category", "scale": "ordinal"},
            "age_4_100": {"type": "category", "scale": "ordinal"},
            "row_number_5_57": {"type": "measure", "scale": "linear"},
            "gold_medals_5_52": {"type": "measure", "scale": "linear"},
            "country_4_59": {"type": "category", "scale": "ordinal"}
        },
        "guide": [{"x": {"label": "Sport"}}, {
            "x": {"label": "Intervals(Age)"},
            "y": {"label": "Count of records"},
            "size": {"label": "SUM(Gold Medals)"},
            "color": {"label": "Country"}
        }],
        "tooltip": {
            "fields": ["gold_medals_5_52", "country_4_59", "row_number_5_57", "sport_3_89", "age_4_100"],
            "formatters": {}
        },
        "x": ["sport_3_89", "age_4_100"],
        "y": ["row_number_5_57"],
        "size": "gold_medals_5_52",
        "color": "country_4_59",
        "annotations": []
    },
    "data": [
        ["Volleyball", -1, "No Value", 3, "Brazil", 0],
        ["Hockey", -1, "No Value", 2, "Argentina", 0],
        ["Weightlifting", 0, "15 - 19", 1, "Azerbaijan", 0], ["Gymnastics", 0, "15 - 19", 17, "United States", 10], ["Gymnastics", 0, "15 - 19", 13, "Russia", 3], ["Basketball", 0, "15 - 19", 1, "Australia", 0], ["Basketball", 0, "15 - 19", 1, "Spain", 0], ["Basketball", 0, "15 - 19", 1, "Russia", 0], ["Swimming", 0, "15 - 19", 2, "France", 1], ["Swimming", 0, "15 - 19", 1, "Ukraine", 2], ["Basketball", 0, "15 - 19", 2, "United States", 1], ["Short-Track Speed Skating", 0, "15 - 19", 12, "South Korea", 11], ["Beach Volleyball", 0, "15 - 19", 1, "China", 0], ["Gymnastics", 0, "15 - 19", 11, "China", 10], ["Gymnastics", 0, "15 - 19", 19, "Romania", 14], ["Boxing", 0, "15 - 19", 1, "Mexico", 0], ["Boxing", 0, "15 - 19", 1, "Turkey", 0], ["Boxing", 0, "15 - 19", 1, "Uzbekistan", 0], ["Boxing", 0, "15 - 19", 1, "Great Britain", 0], ["Boxing", 0, "15 - 19", 2, "United States", 1], ["Boxing", 0, "15 - 19", 3, "Cuba", 2], ["Swimming", 0, "15 - 19", 14, "China", 3], ["Swimming", 0, "15 - 19", 2, "Great Britain", 2], ["Swimming", 0, "15 - 19", 1, "South Korea", 1], ["Swimming", 0, "15 - 19", 3, "Japan", 0], ["Boxing", 0, "15 - 19", 2, "Azerbaijan", 0], ["Swimming", 0, "15 - 19", 1, "Romania", 2], ["Short-Track Speed Skating", 0, "15 - 19", 5, "United States", 1], ["Short-Track Speed Skating", 0, "15 - 19", 3, "Canada", 0], ["Short-Track Speed Skating", 0, "15 - 19", 3, "China", 2], ["Speed Skating", 0, "15 - 19", 2, "Netherlands", 1], ["Boxing", 0, "15 - 19", 1, "Tajikistan", 0], ["Ski Jumping", 0, "15 - 19", 1, "Austria", 2], ["Baseball", 0, "15 - 19", 1, "South Korea", 0], ["Baseball", 0, "15 - 19", 1, "Cuba", 1], ["Gymnastics", 0, "15 - 19", 3, "Great Britain", 0], ["Gymnastics", 0, "15 - 19", 2, "Japan", 0], ["Canoeing", 0, "15 - 19", 1, "Denmark", 0], ["Canoeing", 0, "15 - 19", 1, "Australia", 0], ["Fencing", 0, "15 - 19", 2, "China", 1], ["Canoeing", 0, "15 - 19", 1, "Czech Republic", 0], ["Fencing", 0, "15 - 19", 2, "United States", 1], ["Archery", 0, "15 - 19", 1, "Ukraine", 0], ["Archery", 0, "15 - 19", 3, "Chinese Taipei", 0], ["Archery", 0, "15 - 19", 1, "Australia", 0], ["Archery", 0, "15 - 19", 1, "Mexico", 0], ["Diving", 0, "15 - 19", 16, "China", 15], ["Athletics", 0, "15 - 19", 1, "Poland", 1], ["Athletics", 0, "15 - 19", 1, "France", 0], ["Athletics", 0, "15 - 19", 2, "United States", 1], ["Athletics", 0, "15 - 19", 1, "Ethiopia", 0], ["Athletics", 0, "15 - 19", 1, "Czech Republic", 0], ["Athletics", 0, "15 - 19", 2, "Jamaica", 0], ["Athletics", 0, "15 - 19", 5, "Nigeria", 2], ["Athletics", 0, "15 - 19", 2, "Russia", 1], ["Athletics", 0, "15 - 19", 1, "Dominican Republic", 0], ["Canoeing", 0, "15 - 19", 2, "Germany", 1], ["Athletics", 0, "15 - 19", 2, "Trinidad and Tobago", 1], ["Athletics", 0, "15 - 19", 5, "Kenya", 2], ["Athletics", 0, "15 - 19", 1, "Grenada", 1], ["Athletics", 0, "15 - 19", 1, "China", 1], ["Swimming", 0, "15 - 19", 28, "United States", 24], ["Athletics", 0, "15 - 19", 1, "Botswana", 0], ["Cross Country Skiing", 0, "15 - 19", 1, "Germany", 0], ["Cycling", 0, "15 - 19", 1, "Russia", 1], ["Cycling", 0, "15 - 19", 1, "Netherlands", 0], ["Archery", 0, "15 - 19", 3, "South Korea", 4], ["Cycling", 0, "15 - 19", 1, "Great Britain", 1], ["Diving", 0, "15 - 19", 2, "Canada", 0], ["Diving", 0, "15 - 19", 4, "Russia", 0], ["Diving", 0, "15 - 19", 1, "Germany", 0], ["Diving", 0, "15 - 19", 1, "Malaysia", 0], ["Diving", 0, "15 - 19", 1, "United States", 0], ["Diving", 0, "15 - 19", 2, "Mexico", 0], ["Diving", 0, "15 - 19", 1, "Great Britain", 0], ["Diving", 0, "15 - 19", 2, "Australia", 0], ["Fencing", 0, "15 - 19", 1, "Switzerland", 0], ["Fencing", 0, "15 - 19", 1, "France", 1], ["Fencing", 0, "15 - 19", 1, "Poland", 0], ["Fencing", 0, "15 - 19", 1, "Germany", 0], ["Fencing", 0, "15 - 19", 1, "Russia", 0], ["Fencing", 0, "15 - 19", 2, "Ukraine", 2], ["Wrestling", 0, "15 - 19", 1, "Azerbaijan", 1], ["Wrestling", 0, "15 - 19", 1, "Russia", 1], ["Freestyle Skiing", 0, "15 - 19", 1, "United States", 0], ["Wrestling", 0, "15 - 19", 2, "China", 1], ["Figure Skating", 0, "15 - 19", 1, "Russia", 0], ["Figure Skating", 0, "15 - 19", 1, "United States", 1], ["Weightlifting", 0, "15 - 19", 4, "Russia", 0], ["Figure Skating", 0, "15 - 19", 1, "South Korea", 1], ["Weightlifting", 0, "15 - 19", 1, "Kazakhstan", 1], ["Figure Skating", 0, "15 - 19", 1, "Japan", 0], ["Football", 0, "15 - 19", 1, "Norway", 1], ["Weightlifting", 0, "15 - 19", 1, "Moldova", 0], ["Football", 0, "15 - 19", 5, "Cameroon", 5], ["Weightlifting", 0, "15 - 19", 1, "North Korea", 1], ["Football", 0, "15 - 19", 1, "United States", 1], ["Swimming", 0, "15 - 19", 18, "Australia", 14], ["Football", 0, "15 - 19", 1, "Italy", 0], ["Weightlifting", 0, "15 - 19", 2, "Indonesia", 0], ["Weightlifting", 0, "15 - 19", 3, "China", 1], ["Football", 0, "15 - 19", 3, "Nigeria", 0], ["Football", 0, "15 - 19", 1, "Mexico", 1], ["Football", 0, "15 - 19", 1, "Japan", 0], ["Football", 0, "15 - 19", 10, "Brazil", 0], ["Weightlifting", 0, "15 - 19", 1, "Turkey", 1], ["Weightlifting", 0, "15 - 19", 1, "United States", 0], ["Weightlifting", 0, "15 - 19", 2, "Poland", 0], ["Gymnastics", 0, "15 - 19", 2, "Spain", 1], ["Gymnastics", 0, "15 - 19", 1, "France", 1], ["Gymnastics", 0, "15 - 19", 1, "North Korea", 1], ["Waterpolo", 0, "15 - 19", 3, "Spain", 0], ["Gymnastics", 0, "15 - 19", 2, "South Korea", 1], ["Gymnastics", 0, "15 - 19", 2, "Ukraine", 0], ["Waterpolo", 0, "15 - 19", 1, "Serbia", 0], ["Handball", 0, "15 - 19", 1, "South Korea", 0], ["Waterpolo", 0, "15 - 19", 2, "Australia", 0], ["Waterpolo", 0, "15 - 19", 2, "United States", 1], ["Handball", 0, "15 - 19", 1, "Montenegro", 0], ["Waterpolo", 0, "15 - 19", 1, "Netherlands", 1], ["Waterpolo", 0, "15 - 19", 1, "Italy", 1], ["Hockey", 0, "15 - 19", 1, "Germany", 0], ["Hockey", 0, "15 - 19", 2, "Australia", 2], ["Hockey", 0, "15 - 19", 1, "China", 0], ["Hockey", 0, "15 - 19", 1, "Spain", 0], ["Softball", 0, "15 - 19", 1, "Japan", 0], ["Hockey", 0, "15 - 19", 2, "Netherlands", 2], ["Hockey", 0, "15 - 19", 2, "Argentina", 0], ["Badminton", 0, "15 - 19", 1, "South Korea", 1], ["Ice Hockey", 0, "15 - 19", 1, "Russia", 0], ["Ice Hockey", 0, "15 - 19", 4, "United States", 0], ["Ice Hockey", 0, "15 - 19", 11, "Sweden", 0], ["Volleyball", 0, "15 - 19", 1, "China", 0], ["Ice Hockey", 0, "15 - 19", 2, "Canada", 2], ["Volleyball", 0, "15 - 19", 2, "Cuba", 0], ["Ice Hockey", 0, "15 - 19", 3, "Finland", 0], ["Volleyball", 0, "15 - 19", 2, "Russia", 0], ["Table Tennis", 0, "15 - 19", 1, "Japan", 0], ["Judo", 0, "15 - 19", 1, "Brazil", 0], ["Judo", 0, "15 - 19", 1, "Greece", 1], ["Table Tennis", 0, "15 - 19", 1, "Germany", 0], ["Table Tennis", 0, "15 - 19", 1, "China", 0], ["Judo", 0, "15 - 19", 1, "South Korea", 0], ["Judo", 0, "15 - 19", 1, "France", 0], ["Judo", 0, "15 - 19", 1, "Cuba", 0], ["Judo", 0, "15 - 19", 1, "Japan", 0], ["Trampoline", 0, "15 - 19", 4, "China", 2], ["Taekwondo", 0, "15 - 19", 1, "Russia", 0], ["Taekwondo", 0, "15 - 19", 1, "Great Britain", 1], ["Taekwondo", 0, "15 - 19", 1, "Colombia", 0], ["Nordic Combined", 0, "15 - 19", 1, "Finland", 0], ["Taekwondo", 0, "15 - 19", 2, "Turkey", 0], ["Nordic Combined", 0, "15 - 19", 2, "Germany", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 6, "Greece", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 6, "Bulgaria", 0], ["Taekwondo", 0, "15 - 19", 2, "Thailand", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 2, "China", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 7, "Italy", 0], ["Taekwondo", 0, "15 - 19", 1, "Croatia", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 14, "Belarus", 0], ["Taekwondo", 0, "15 - 19", 1, "South Korea", 0], ["Taekwondo", 0, "15 - 19", 1, "China", 1], ["Taekwondo", 0, "15 - 19", 1, "Chinese Taipei", 0], ["Rhythmic Gymnastics", 0, "15 - 19", 23, "Russia", 21], ["Rowing", 0, "15 - 19", 1, "China", 1], ["Tennis", 0, "15 - 19", 1, "Great Britain", 0], ["Tennis", 0, "15 - 19", 1, "Russia", 0], ["Tennis", 0, "15 - 19", 1, "United States", 1], ["Synchronized Swimming", 0, "15 - 19", 1, "Spain", 0], ["Synchronized Swimming", 0, "15 - 19", 1, "China", 0], ["Synchronized Swimming", 0, "15 - 19", 2, "Russia", 2], ["Synchronized Swimming", 0, "15 - 19", 1, "United States", 0], ["Sailing", 0, "15 - 19", 1, "Australia", 0], ["Swimming", 0, "15 - 19", 1, "Lithuania", 1], ["Swimming", 0, "15 - 19", 1, "Canada", 0], ["Swimming", 0, "15 - 19", 5, "Russia", 1], ["Swimming", 0, "15 - 19", 4, "Netherlands", 1], ["Swimming", 0, "15 - 19", 3, "Hungary", 1], ["Swimming", 0, "15 - 19", 4, "Germany", 0], ["Swimming", 0, "15 - 19", 1, "Italy", 0], ["Swimming", 0, "15 - 19", 1, "South Africa", 1], ["Swimming", 0, "15 - 19", 1, "Sweden", 0], ["Short-Track Speed Skating", 0, "15 - 19", 2, "Italy", 0], ["Shooting", 0, "15 - 19", 1, "China", 1], ["Shooting", 0, "15 - 19", 1, "Ukraine", 1], ["Shooting", 0, "15 - 19", 1, "Czech Republic", 0], ["Speed Skating", 0, "15 - 19", 2, "United States", 0], ["Shooting", 0, "15 - 19", 1, "United States", 1], ["Shooting", 0, "15 - 19", 2, "South Korea", 1], ["Ski Jumping", 0, "15 - 19", 1, "Finland", 0], ["Ski Jumping", 0, "15 - 19", 1, "Germany", 1], ["Snowboarding", 0, "15 - 19", 4, "United States", 3], ["Snowboarding", 0, "15 - 19", 1, "Germany", 0], ["Athletics", 1, "20 - 24", 4, "Ukraine", 0], ["Speed Skating", 1, "20 - 24", 1, "Czech Republic", 2], ["Archery", 1, "20 - 24", 2, "Ukraine", 0], ["Speed Skating", 1, "20 - 24", 2, "Italy", 3], ["Archery", 1, "20 - 24", 3, "Chinese Taipei", 0], ["Archery", 1, "20 - 24", 1, "France", 0], ["Archery", 1, "20 - 24", 1, "Mexico", 0], ["Archery", 1, "20 - 24", 5, "Italy", 2], ["Archery", 1, "20 - 24", 3, "Japan", 0], ["Archery", 1, "20 - 24", 7, "China", 0], ["Basketball", 1, "20 - 24", 14, "Australia", 0], ["Alpine Skiing", 1, "20 - 24", 1, "France", 1], ["Diving", 1, "20 - 24", 5, "United States", 2], ["Basketball", 1, "20 - 24", 12, "Russia", 0], ["Diving", 1, "20 - 24", 13, "China", 13], ["Alpine Skiing", 1, "20 - 24", 1, "Italy", 0], ["Diving", 1, "20 - 24", 6, "Russia", 3], ["Alpine Skiing", 1, "20 - 24", 1, "Germany", 1], ["Diving", 1, "20 - 24", 5, "Australia", 1], ["Alpine Skiing", 1, "20 - 24", 1, "Norway", 0], ["Alpine Skiing", 1, "20 - 24", 2, "Switzerland", 1], ["Athletics", 1, "20 - 24", 1, "Spain", 0], ["Athletics", 1, "20 - 24", 1, "Barbados", 0], ["Beach Volleyball", 1, "20 - 24", 1, "Spain", 0], ["Athletics", 1, "20 - 24", 1, "Bulgaria", 1], ["Athletics", 1, "20 - 24", 1, "Brazil", 0], ["Athletics", 1, "20 - 24", 1, "Sri Lanka", 0], ["Athletics", 1, "20 - 24", 1, "Mexico", 0], ["Athletics", 1, "20 - 24", 1, "Iceland", 0], ["Athletics", 1, "20 - 24", 1, "Morocco", 0], ["Cycling", 1, "20 - 24", 15, "Australia", 6], ["Athletics", 1, "20 - 24", 1, "Saudi Arabia", 0], ["Athletics", 1, "20 - 24", 2, "Latvia", 0], ["Cycling", 1, "20 - 24", 7, "Germany", 4], ["Athletics", 1, "20 - 24", 2, "Greece", 1], ["Athletics", 1, "20 - 24", 1, "Norway", 1], ["Athletics", 1, "20 - 24", 1, "Eritrea", 0], ["Cross Country Skiing", 1, "20 - 24", 5, "Sweden", 4], ["Athletics", 1, "20 - 24", 2, "Poland", 1], ["Ski Jumping", 1, "20 - 24", 4, "Austria", 4], ["Athletics", 1, "20 - 24", 3, "Sweden", 2], ["Cross Country Skiing", 1, "20 - 24", 6, "Russia", 3], ["Athletics", 1, "20 - 24", 1, "Kazakhstan", 0], ["Badminton", 1, "20 - 24", 5, "South Korea", 0], ["Beach Volleyball", 1, "20 - 24", 2, "China", 0], ["Beach Volleyball", 1, "20 - 24", 1, "Latvia", 0], ["Cross Country Skiing", 1, "20 - 24", 6, "Germany", 2], ["Biathlon", 1, "20 - 24", 1, "Austria", 0], ["Athletics", 1, "20 - 24", 2, "Japan", 0], ["Canoeing", 1, "20 - 24", 24, "Germany", 14], ["Athletics", 1, "20 - 24", 1, "Italy", 1], ["Biathlon", 1, "20 - 24", 1, "Croatia", 0], ["Athletics", 1, "20 - 24", 1, "France", 0], ["Athletics", 1, "20 - 24", 2, "Belarus", 1], ["Athletics", 1, "20 - 24", 1, "Sudan", 0], ["Athletics", 1, "20 - 24", 9, "Nigeria", 1], ["Nordic Combined", 1, "20 - 24", 4, "Finland", 5], ["Athletics", 1, "20 - 24", 1, "Portugal", 1], ["Athletics", 1, "20 - 24", 1, "Belgium", 0], ["Athletics", 1, "20 - 24", 1, "New Zealand", 1], ["Canoeing", 1, "20 - 24", 2, "Spain", 2], ["Canoeing", 1, "20 - 24", 13, "Hungary", 5], ["Athletics", 1, "20 - 24", 10, "Cuba", 3], ["Athletics", 1, "20 - 24", 5, "South Africa", 0], ["Gymnastics", 1, "20 - 24", 9, "Japan", 5], ["Athletics", 1, "20 - 24", 7, "Bahamas", 2], ["Gymnastics", 1, "20 - 24", 17, "China", 20], ["Canoeing", 1, "20 - 24", 1, "Canada", 1], ["Athletics", 1, "20 - 24", 2, "Croatia", 1], ["Athletics", 1, "20 - 24", 15, "Kenya", 6], ["Canoeing", 1, "20 - 24", 1, "Bulgaria", 0], ["Athletics", 1, "20 - 24", 4, "Algeria", 1], ["Canoeing", 1, "20 - 24", 3, "Romania", 1], ["Biathlon", 1, "20 - 24", 1, "Belarus", 0], ["Badminton", 1, "20 - 24", 2, "Japan", 0], ["Athletics", 1, "20 - 24", 1, "Uganda", 1], ["Gymnastics", 1, "20 - 24", 8, "Romania", 5], ["Athletics", 1, "20 - 24", 4, "Germany", 1], ["Athletics", 1, "20 - 24", 3, "Great Britain", 2], ["Biathlon", 1, "20 - 24", 6, "France", 1], ["Athletics", 1, "20 - 24", 6, "China", 3], ["Athletics", 1, "20 - 24", 1, "Canada", 0], ["Biathlon", 1, "20 - 24", 4, "Russia", 2], ["Gymnastics", 1, "20 - 24", 12, "United States", 1], ["Athletics", 1, "20 - 24", 2, "Turkey", 0], ["Basketball", 1, "20 - 24", 5, "Lithuania", 0], ["Athletics", 1, "20 - 24", 1, "Qatar", 0], ["Athletics", 1, "20 - 24", 1, "Guatemala", 0], ["Bobsleigh", 1, "20 - 24", 1, "Switzerland", 0], ["Badminton", 1, "20 - 24", 21, "China", 10], ["Cross Country Skiing", 1, "20 - 24", 1, "Czech Republic", 0], ["Bobsleigh", 1, "20 - 24", 4, "Germany", 3], ["Cross Country Skiing", 1, "20 - 24", 2, "Switzerland", 1], ["Curling", 1, "20 - 24", 2, "Switzerland", 0], ["Curling", 1, "20 - 24", 2, "United States", 0], ["Athletics", 1, "20 - 24", 6, "Trinidad and Tobago", 0], ["Curling", 1, "20 - 24", 2, "Canada", 1], ["Athletics", 1, "20 - 24", 13, "Ethiopia", 7], ["Curling", 1, "20 - 24", 1, "China", 0], ["Athletics", 1, "20 - 24", 7, "Australia", 0], ["Athletics", 1, "20 - 24", 33, "Russia", 8], ["Cycling", 1, "20 - 24", 1, "Lithuania", 0], ["Cycling", 1, "20 - 24", 1, "Portugal", 0], ["Cycling", 1, "20 - 24", 15, "Great Britain", 12], ["Cycling", 1, "20 - 24", 1, "Poland", 0], ["Cycling", 1, "20 - 24", 2, "Netherlands", 1], ["Cycling", 1, "20 - 24", 1, "Latvia", 1], ["Athletics", 1, "20 - 24", 2, "Romania", 1], ["Cycling", 1, "20 - 24", 2, "Switzerland", 0], ["Cycling", 1, "20 - 24", 3, "Ukraine", 0], ["Cycling", 1, "20 - 24", 1, "Sweden", 0], ["Cycling", 1, "20 - 24", 3, "Russia", 0], ["Cycling", 1, "20 - 24", 1, "China", 0], ["Alpine Skiing", 1, "20 - 24", 4, "Austria", 1], ["Cycling", 1, "20 - 24", 1, "Italy", 0], ["Alpine Skiing", 1, "20 - 24", 4, "United States", 2], ["Archery", 1, "20 - 24", 9, "South Korea", 10], ["Cycling", 1, "20 - 24", 1, "United States", 0], ["Bobsleigh", 1, "20 - 24", 1, "United States", 1], ["Cycling", 1, "20 - 24", 2, "Colombia", 1], ["Bobsleigh", 1, "20 - 24", 1, "Canada", 1], ["Archery", 1, "20 - 24", 4, "United States", 0], ["Wrestling", 1, "20 - 24", 2, "Armenia", 0], ["Boxing", 1, "20 - 24", 1, "Morocco", 0], ["Cycling", 1, "20 - 24", 5, "Denmark", 1], ["Wrestling", 1, "20 - 24", 6, "United States", 3], ["Cycling", 1, "20 - 24", 8, "New Zealand", 0], ["Cycling", 1, "20 - 24", 2, "Canada", 0], ["Cycling", 1, "20 - 24", 10, "France", 4], ["Diving", 1, "20 - 24", 1, "Great Britain", 0], ["Boxing", 1, "20 - 24", 2, "Uzbekistan", 0], ["Diving", 1, "20 - 24", 3, "Ukraine", 0], ["Wrestling", 1, "20 - 24", 3, "Iran", 1], ["Boxing", 1, "20 - 24", 1, "Czech Republic", 0], ["Diving", 1, "20 - 24", 2, "Germany", 0], ["Biathlon", 1, "20 - 24", 3, "Germany", 5], ["Diving", 1, "20 - 24", 3, "Mexico", 0], ["Wrestling", 1, "20 - 24", 1, "Poland", 0], ["Wrestling", 1, "20 - 24", 3, "China", 1], ["Biathlon", 1, "20 - 24", 3, "Norway", 3], ["Wrestling", 1, "20 - 24", 2, "Turkey", 1], ["Boxing", 1, "20 - 24", 1, "Moldova", 0], ["Wrestling", 1, "20 - 24", 4, "Georgia", 0], ["Wrestling", 1, "20 - 24", 23, "Russia", 12], ["Wrestling", 1, "20 - 24", 2, "South Korea", 2], ["Boxing", 1, "20 - 24", 1, "Georgia", 0], ["Swimming", 1, "20 - 24", 12, "Netherlands", 7], ["Boxing", 1, "20 - 24", 1, "Belarus", 0], ["Diving", 1, "20 - 24", 5, "Canada", 0], ["Equestrian", 1, "20 - 24", 1, "France", 1], ["Equestrian", 1, "20 - 24", 1, "Netherlands", 0], ["Fencing", 1, "20 - 24", 1, "Switzerland", 0], ["Wrestling", 1, "20 - 24", 3, "Hungary", 0], ["Athletics", 1, "20 - 24", 22, "Jamaica", 11], ["Short-Track Speed Skating", 1, "20 - 24", 10, "South Korea", 10], ["Boxing", 1, "20 - 24", 2, "Germany", 0], ["Swimming", 1, "20 - 24", 50, "Australia", 31], ["Fencing", 1, "20 - 24", 3, "Poland", 0], ["Wrestling", 1, "20 - 24", 1, "Mongolia", 0], ["Wrestling", 1, "20 - 24", 6, "Azerbaijan", 2], ["Athletics", 1, "20 - 24", 46, "United States", 33], ["Boxing", 1, "20 - 24", 2, "North Korea", 0], ["Fencing", 1, "20 - 24", 9, "China", 1], ["Wrestling", 1, "20 - 24", 1, "North Korea", 0], ["Fencing", 1, "20 - 24", 1, "Hungary", 1], ["Swimming", 1, "20 - 24", 73, "United States", 69], ["Fencing", 1, "20 - 24", 4, "Ukraine", 2], ["Alpine Skiing", 1, "20 - 24", 2, "Sweden", 1], ["Fencing", 1, "20 - 24", 3, "Romania", 1], ["Wrestling", 1, "20 - 24", 2, "Kyrgyzstan", 0], ["Fencing", 1, "20 - 24", 11, "Russia", 6], ["Fencing", 1, "20 - 24", 3, "South Korea", 2], ["Wrestling", 1, "20 - 24", 1, "France", 1], ["Fencing", 1, "20 - 24", 3, "Japan", 0], ["Wrestling", 1, "20 - 24", 5, "Japan", 3], ["Fencing", 1, "20 - 24", 1, "Egypt", 0], ["Boxing", 1, "20 - 24", 2, "South Korea", 0], ["Freestyle Skiing", 1, "20 - 24", 1, "Belarus", 0], ["Wrestling", 1, "20 - 24", 1, "Colombia", 0], ["Freestyle Skiing", 1, "20 - 24", 1, "Russia", 0], ["Freestyle Skiing", 1, "20 - 24", 1, "Australia", 1], ["Wrestling", 1, "20 - 24", 2, "Belarus", 0], ["Wrestling", 1, "20 - 24", 2, "Kazakhstan", 0], ["Wrestling", 1, "20 - 24", 3, "Bulgaria", 0], ["Wrestling", 1, "20 - 24", 4, "Uzbekistan", 1], ["Freestyle Skiing", 1, "20 - 24", 3, "China", 1], ["Table Tennis", 1, "20 - 24", 19, "China", 18], ["Wrestling", 1, "20 - 24", 1, "Egypt", 1], ["Freestyle Skiing", 1, "20 - 24", 4, "United States", 1], ["Freestyle Skiing", 1, "20 - 24", 1, "France", 0], ["Freestyle Skiing", 1, "20 - 24", 3, "Canada", 2], ["Wrestling", 1, "20 - 24", 2, "Ukraine", 1], ["Boxing", 1, "20 - 24", 2, "Romania", 0], ["Wrestling", 1, "20 - 24", 3, "Cuba", 1], ["Table Tennis", 1, "20 - 24", 2, "Germany", 0], ["Figure Skating", 1, "20 - 24", 3, "China", 0], ["Figure Skating", 1, "20 - 24", 5, "Russia", 4], ["Wrestling", 1, "20 - 24", 1, "Greece", 0], ["Figure Skating", 1, "20 - 24", 1, "Switzerland", 0], ["Figure Skating", 1, "20 - 24", 2, "Japan", 1], ["Weightlifting", 1, "20 - 24", 9, "Russia", 1], ["Figure Skating", 1, "20 - 24", 5, "Canada", 3], ["Boxing", 1, "20 - 24", 1, "Bulgaria", 0], ["Boxing", 1, "20 - 24", 1, "Syria", 0], ["Figure Skating", 1, "20 - 24", 8, "United States", 1], ["Tennis", 1, "20 - 24", 1, "Belarus", 1], ["Weightlifting", 1, "20 - 24", 1, "Moldova", 0], ["Weightlifting", 1, "20 - 24", 2, "Romania", 0], ["Boxing", 1, "20 - 24", 4, "Thailand", 2], ["Boxing", 1, "20 - 24", 2, "Azerbaijan", 0], ["Weightlifting", 1, "20 - 24", 2, "Chinese Taipei", 0], ["Weightlifting", 1, "20 - 24", 4, "Kazakhstan", 2], ["Tennis", 1, "20 - 24", 1, "Chile", 1], ["Weightlifting", 1, "20 - 24", 6, "Indonesia", 0], ["Weightlifting", 1, "20 - 24", 4, "Ukraine", 1], ["Football", 1, "20 - 24", 6, "Norway", 6], ["Weightlifting", 1, "20 - 24", 6, "North Korea", 3], ["Boxing", 1, "20 - 24", 1, "India", 0], ["Weightlifting", 1, "20 - 24", 16, "China", 12], ["Football", 1, "20 - 24", 14, "Chile", 0], ["Football", 1, "20 - 24", 17, "Spain", 0], ["Football", 1, "20 - 24", 11, "Cameroon", 11], ["Weightlifting", 1, "20 - 24", 5, "Iran", 3], ["Tennis", 1, "20 - 24", 2, "United States", 2], ["Weightlifting", 1, "20 - 24", 5, "Belarus", 1], ["Weightlifting", 1, "20 - 24", 4, "Thailand", 2], ["Synchronized Swimming", 1, "20 - 24", 7, "Spain", 0], ["Boxing", 1, "20 - 24", 1, "Turkey", 0], ["Synchronized Swimming", 1, "20 - 24", 10, "China", 0], ["Weightlifting", 1, "20 - 24", 2, "Poland", 1], ["Football", 1, "20 - 24", 15, "Italy", 0], ["Football", 1, "20 - 24", 14, "Paraguay", 0], ["Weightlifting", 1, "20 - 24", 1, "Vietnam", 0], ["Boxing", 1, "20 - 24", 1, "Armenia", 0], ["Weightlifting", 1, "20 - 24", 5, "South Korea", 2], ["Boxing", 1, "20 - 24", 4, "France", 1], ["Weightlifting", 1, "20 - 24", 2, "Armenia", 0], ["Weightlifting", 1, "20 - 24", 2, "Turkey", 1], ["Football", 1, "20 - 24", 23, "Germany", 0], ["Synchronized Swimming", 1, "20 - 24", 16, "Russia", 20], ["Football", 1, "20 - 24", 12, "Nigeria", 0], ["Football", 1, "20 - 24", 30, "Argentina", 30], ["Weightlifting", 1, "20 - 24", 4, "Bulgaria", 1], ["Boxing", 1, "20 - 24", 1, "Dominican Republic", 1], ["Football", 1, "20 - 24", 4, "Japan", 0], ["Weightlifting", 1, "20 - 24", 1, "Hungary", 0], ["Synchronized Swimming", 1, "20 - 24", 5, "United States", 0], ["Basketball", 1, "20 - 24", 4, "Brazil", 0], ["Football", 1, "20 - 24", 5, "Canada", 0], ["Football", 1, "20 - 24", 22, "United States", 17], ["Football", 1, "20 - 24", 15, "South Korea", 0], ["Football", 1, "20 - 24", 12, "Mexico", 12], ["Weightlifting", 1, "20 - 24", 1, "Venezuela", 0], ["Cross Country Skiing", 1, "20 - 24", 3, "Norway", 3], ["Football", 1, "20 - 24", 42, "Brazil", 0], ["Gymnastics", 1, "20 - 24", 1, "Latvia", 1], ["Gymnastics", 1, "20 - 24", 1, "Greece", 0], ["Synchronized Swimming", 1, "20 - 24", 11, "Japan", 0], ["Gymnastics", 1, "20 - 24", 1, "Poland", 0], ["Weightlifting", 1, "20 - 24", 1, "Mexico", 1], ["Swimming", 1, "20 - 24", 6, "Great Britain", 0], ["Gymnastics", 1, "20 - 24", 1, "Canada", 1], ["Swimming", 1, "20 - 24", 2, "Spain", 0], ["Boxing", 1, "20 - 24", 1, "Lithuania", 0], ["Gymnastics", 1, "20 - 24", 1, "Spain", 1], ["Weightlifting", 1, "20 - 24", 1, "Qatar", 0], ["Gymnastics", 1, "20 - 24", 2, "South Korea", 0], ["Gymnastics", 1, "20 - 24", 1, "Croatia", 0], ["Boxing", 1, "20 - 24", 3, "Mongolia", 1], ["Swimming", 1, "20 - 24", 1, "South Korea", 0], ["Gymnastics", 1, "20 - 24", 2, "France", 0], ["Gymnastics", 1, "20 - 24", 1, "Brazil", 1], ["Waterpolo", 1, "20 - 24", 7, "Spain", 0], ["Basketball", 1, "20 - 24", 1, "Italy", 0], ["Waterpolo", 1, "20 - 24", 4, "Croatia", 4], ["Alpine Skiing", 1, "20 - 24", 2, "Croatia", 4], ["Waterpolo", 1, "20 - 24", 28, "United States", 2], ["Handball", 1, "20 - 24", 4, "Hungary", 0], ["Waterpolo", 1, "20 - 24", 1, "Italy", 0], ["Handball", 1, "20 - 24", 10, "Denmark", 10], ["Waterpolo", 1, "20 - 24", 13, "Australia", 4], ["Swimming", 1, "20 - 24", 3, "Brazil", 1], ["Waterpolo", 1, "20 - 24", 6, "Serbia", 0], ["Handball", 1, "20 - 24", 2, "Germany", 0], ["Handball", 1, "20 - 24", 1, "Ukraine", 0], ["Swimming", 1, "20 - 24", 14, "France", 6], ["Handball", 1, "20 - 24", 7, "South Korea", 0], ["Swimming", 1, "20 - 24", 13, "Germany", 2], ["Swimming", 1, "20 - 24", 11, "Russia", 0], ["Handball", 1, "20 - 24", 3, "Iceland", 0], ["Handball", 1, "20 - 24", 9, "Russia", 1], ["Waterpolo", 1, "20 - 24", 5, "Netherlands", 5], ["Swimming", 1, "20 - 24", 3, "Ukraine", 2], ["Waterpolo", 1, "20 - 24", 13, "Hungary", 13], ["Handball", 1, "20 - 24", 5, "Spain", 0], ["Handball", 1, "20 - 24", 11, "Norway", 6], ["Handball", 1, "20 - 24", 4, "Montenegro", 0], ["Swimming", 1, "20 - 24", 18, "Japan", 3], ["Handball", 1, "20 - 24", 4, "Sweden", 0], ["Handball", 1, "20 - 24", 7, "Croatia", 5], ["Handball", 1, "20 - 24", 4, "France", 4], ["Hockey", 1, "20 - 24", 6, "South Korea", 0], ["Waterpolo", 1, "20 - 24", 8, "Russia", 0], ["Swimming", 1, "20 - 24", 2, "Austria", 0], ["Waterpolo", 1, "20 - 24", 7, "Serbia and Montenegro", 0], ["Badminton", 1, "20 - 24", 1, "Netherlands", 0], ["Swimming", 1, "20 - 24", 2, "Hungary", 1], ["Swimming", 1, "20 - 24", 1, "Slovakia", 0], ["Waterpolo", 1, "20 - 24", 4, "Greece", 0], ["Boxing", 1, "20 - 24", 3, "Italy", 0], ["Hockey", 1, "20 - 24", 5, "China", 0], ["Basketball", 1, "20 - 24", 5, "Argentina", 3], ["Volleyball", 1, "20 - 24", 4, "United States", 0], ["Basketball", 1, "20 - 24", 2, "France", 0], ["Hockey", 1, "20 - 24", 4, "Spain", 0], ["Badminton", 1, "20 - 24", 6, "Indonesia", 3], ["Hockey", 1, "20 - 24", 21, "Germany", 15], ["Hockey", 1, "20 - 24", 19, "Argentina", 0], ["Hockey", 1, "20 - 24", 23, "Australia", 8], ["Volleyball", 1, "20 - 24", 13, "Brazil", 7], ["Hockey", 1, "20 - 24", 5, "Great Britain", 0], ["Volleyball", 1, "20 - 24", 4, "Japan", 0], ["Hockey", 1, "20 - 24", 34, "Netherlands", 14], ["Short-Track Speed Skating", 1, "20 - 24", 11, "Canada", 4], ["Short-Track Speed Skating", 1, "20 - 24", 1, "Bulgaria", 0], ["Ice Hockey", 1, "20 - 24", 4, "Russia", 0], ["Volleyball", 1, "20 - 24", 22, "Russia", 3], ["Boxing", 1, "20 - 24", 4, "China", 0], ["Ice Hockey", 1, "20 - 24", 3, "Czech Republic", 0], ["Boxing", 1, "20 - 24", 2, "Brazil", 0], ["Volleyball", 1, "20 - 24", 4, "Italy", 0], ["Ice Hockey", 1, "20 - 24", 16, "Sweden", 1], ["Volleyball", 1, "20 - 24", 11, "China", 7], ["Speed Skating", 1, "20 - 24", 5, "Netherlands", 2], ["Speed Skating", 1, "20 - 24", 4, "South Korea", 3], ["Boxing", 1, "20 - 24", 7, "United States", 1], ["Speed Skating", 1, "20 - 24", 4, "United States", 1], ["Volleyball", 1, "20 - 24", 6, "Cuba", 2], ["Swimming", 1, "20 - 24", 1, "Poland", 1], ["Ice Hockey", 1, "20 - 24", 13, "Finland", 0], ["Ice Hockey", 1, "20 - 24", 40, "United States", 0], ["Volleyball", 1, "20 - 24", 2, "Serbia and Montenegro", 2], ["Ice Hockey", 1, "20 - 24", 36, "Canada", 36], ["Table Tennis", 1, "20 - 24", 1, "Japan", 0], ["Judo", 1, "20 - 24", 1, "Kyrgyzstan", 0], ["Boxing", 1, "20 - 24", 9, "Kazakhstan", 2], ["Judo", 1, "20 - 24", 1, "Italy", 1], ["Judo", 1, "20 - 24", 1, "Portugal", 0], ["Boxing", 1, "20 - 24", 3, "Ireland", 0], ["Judo", 1, "20 - 24", 1, "Estonia", 0], ["Gymnastics", 1, "20 - 24", 11, "Russia", 3], ["Table Tennis", 1, "20 - 24", 1, "Singapore", 0], ["Boxing", 1, "20 - 24", 6, "Great Britain", 3], ["Ski Jumping", 1, "20 - 24", 4, "Finland", 0], ["Table Tennis", 1, "20 - 24", 1, "North Korea", 0], ["Judo", 1, "20 - 24", 1, "Austria", 0], ["Table Tennis", 1, "20 - 24", 1, "Denmark", 0], ["Judo", 1, "20 - 24", 3, "Germany", 1], ["Table Tennis", 1, "20 - 24", 2, "South Korea", 1], ["Judo", 1, "20 - 24", 2, "North Korea", 0], ["Swimming", 1, "20 - 24", 5, "South Africa", 4], ["Judo", 1, "20 - 24", 1, "Uzbekistan", 0], ["Triathlon", 1, "20 - 24", 2, "Great Britain", 1], ["Ski Jumping", 1, "20 - 24", 1, "Switzerland", 2], ["Judo", 1, "20 - 24", 2, "Slovenia", 0], ["Judo", 1, "20 - 24", 1, "Argentina", 0], ["Boxing", 1, "20 - 24", 8, "Ukraine", 2], ["Ski Jumping", 1, "20 - 24", 1, "Poland", 0], ["Triathlon", 1, "20 - 24", 1, "Portugal", 0], ["Judo", 1, "20 - 24", 2, "Mongolia", 1], ["Triathlon", 1, "20 - 24", 1, "Australia", 0], ["Judo", 1, "20 - 24", 1, "Azerbaijan", 1], ["Judo", 1, "20 - 24", 2, "Ukraine", 0], ["Judo", 1, "20 - 24", 1, "Algeria", 0], ["Triathlon", 1, "20 - 24", 1, "Switzerland", 0], ["Judo", 1, "20 - 24", 2, "Netherlands", 0], ["Judo", 1, "20 - 24", 7, "China", 2], ["Judo", 1, "20 - 24", 2, "Belgium", 0], ["Judo", 1, "20 - 24", 1, "Canada", 0], ["Judo", 1, "20 - 24", 2, "Georgia", 2], ["Trampoline", 1, "20 - 24", 3, "China", 1], ["Judo", 1, "20 - 24", 5, "Brazil", 1], ["Trampoline", 1, "20 - 24", 5, "Canada", 1], ["Trampoline", 1, "20 - 24", 1, "Russia", 0], ["Judo", 1, "20 - 24", 8, "South Korea", 1], ["Shooting", 1, "20 - 24", 3, "Italy", 2], ["Judo", 1, "20 - 24", 2, "United States", 1], ["Judo", 1, "20 - 24", 7, "Cuba", 1], ["Judo", 1, "20 - 24", 6, "France", 1], ["Judo", 1, "20 - 24", 3, "Russia", 1], ["Trampoline", 1, "20 - 24", 1, "Germany", 0], ["Judo", 1, "20 - 24", 12, "Japan", 6], ["Trampoline", 1, "20 - 24", 1, "Australia", 0], ["Taekwondo", 1, "20 - 24", 1, "Russia", 0], ["Luge", 1, "20 - 24", 2, "Austria", 2], ["Boxing", 1, "20 - 24", 14, "Cuba", 5], ["Taekwondo", 1, "20 - 24", 4, "Cuba", 1], ["Taekwondo", 1, "20 - 24", 3, "Mexico", 1], ["Luge", 1, "20 - 24", 1, "Latvia", 0], ["Taekwondo", 1, "20 - 24", 2, "Spain", 1], ["Luge", 1, "20 - 24", 5, "Germany", 3], ["Taekwondo", 1, "20 - 24", 5, "China", 3], ["Modern Pentathlon", 1, "20 - 24", 1, "Belarus", 0], ["Modern Pentathlon", 1, "20 - 24", 1, "Hungary", 0], ["Boxing", 1, "20 - 24", 7, "Russia", 3], ["Taekwondo", 1, "20 - 24", 10, "South Korea", 7], ["Modern Pentathlon", 1, "20 - 24", 1, "Germany", 1], ["Taekwondo", 1, "20 - 24", 1, "Serbia", 1], ["Taekwondo", 1, "20 - 24", 4, "United States", 1], ["Modern Pentathlon", 1, "20 - 24", 1, "Great Britain", 0], ["Nordic Combined", 1, "20 - 24", 3, "Austria", 0], ["Taekwondo", 1, "20 - 24", 1, "Great Britain", 0], ["Swimming", 1, "20 - 24", 5, "Sweden", 0], ["Shooting", 1, "20 - 24", 2, "Czech Republic", 1], ["Taekwondo", 1, "20 - 24", 1, "Gabon", 0], ["Taekwondo", 1, "20 - 24", 1, "Thailand", 0], ["Badminton", 1, "20 - 24", 1, "India", 0], ["Taekwondo", 1, "20 - 24", 4, "Turkey", 1], ["Baseball", 1, "20 - 24", 3, "Japan", 0], ["Nordic Combined", 1, "20 - 24", 1, "Italy", 0], ["Nordic Combined", 1, "20 - 24", 1, "France", 1], ["Taekwondo", 1, "20 - 24", 1, "Kazakhstan", 0], ["Taekwondo", 1, "20 - 24", 1, "Nigeria", 0], ["Taekwondo", 1, "20 - 24", 1, "Venezuela", 0], ["Taekwondo", 1, "20 - 24", 1, "Brazil", 0], ["Shooting", 1, "20 - 24", 2, "South Korea", 0], ["Baseball", 1, "20 - 24", 11, "Australia", 0], ["Taekwondo", 1, "20 - 24", 1, "Afghanistan", 0], ["Rhythmic Gymnastics", 1, "20 - 24", 3, "China", 0], ["Baseball", 1, "20 - 24", 18, "South Korea", 9], ["Baseball", 1, "20 - 24", 18, "Cuba", 8], ["Taekwondo", 1, "20 - 24", 1, "Croatia", 0], ["Taekwondo", 1, "20 - 24", 2, "Canada", 0], ["Rhythmic Gymnastics", 1, "20 - 24", 2, "Ukraine", 0], ["Baseball", 1, "20 - 24", 25, "United States", 12], ["Canoeing", 1, "20 - 24", 1, "Cuba", 0], ["Taekwondo", 1, "20 - 24", 1, "France", 0], ["Canoeing", 1, "20 - 24", 2, "Sweden", 0], ["Taekwondo", 1, "20 - 24", 2, "Chinese Taipei", 1], ["Rhythmic Gymnastics", 1, "20 - 24", 8, "Russia", 7], ["Rowing", 1, "20 - 24", 7, "Romania", 6], ["Taekwondo", 1, "20 - 24", 2, "Iran", 0], ["Taekwondo", 1, "20 - 24", 2, "Greece", 1], ["Taekwondo", 1, "20 - 24", 1, "Egypt", 0], ["Rhythmic Gymnastics", 1, "20 - 24", 7, "Belarus", 0], ["Canoeing", 1, "20 - 24", 2, "Great Britain", 0], ["Canoeing", 1, "20 - 24", 3, "France", 2], ["Nordic Combined", 1, "20 - 24", 1, "Norway", 0], ["Taekwondo", 1, "20 - 24", 1, "Norway", 0], ["Rhythmic Gymnastics", 1, "20 - 24", 4, "Italy", 0], ["Rowing", 1, "20 - 24", 1, "Norway", 0], ["Rowing", 1, "20 - 24", 1, "Slovenia", 1], ["Rowing", 1, "20 - 24", 3, "Czech Republic", 0], ["Taekwondo", 1, "20 - 24", 1, "Australia", 0], ["Rowing", 1, "20 - 24", 1, "Russia", 1], ["Tennis", 1, "20 - 24", 1, "Argentina", 0], ["Rowing", 1, "20 - 24", 1, "Belarus", 0], ["Nordic Combined", 1, "20 - 24", 6, "Germany", 0], ["Rowing", 1, "20 - 24", 1, "Poland", 1], ["Rowing", 1, "20 - 24", 10, "Italy", 2], ["Rowing", 1, "20 - 24", 8, "Netherlands", 0], ["Rowing", 1, "20 - 24", 7, "France", 1], ["Rowing", 1, "20 - 24", 1, "South Africa", 1], ["Gymnastics", 1, "20 - 24", 3, "Germany", 0], ["Rowing", 1, "20 - 24", 5, "Canada", 0], ["Rowing", 1, "20 - 24", 8, "Croatia", 0], ["Rowing", 1, "20 - 24", 14, "United States", 5], ["Tennis", 1, "20 - 24", 1, "Spain", 1], ["Rowing", 1, "20 - 24", 5, "China", 2], ["Tennis", 1, "20 - 24", 2, "Russia", 0], ["Tennis", 1, "20 - 24", 1, "Switzerland", 1], ["Rowing", 1, "20 - 24", 2, "Greece", 0], ["Tennis", 1, "20 - 24", 3, "China", 2], ["Rowing", 1, "20 - 24", 12, "Australia", 0], ["Tennis", 1, "20 - 24", 1, "Serbia", 0], ["Tennis", 1, "20 - 24", 1, "Croatia", 0], ["Tennis", 1, "20 - 24", 1, "Belgium", 1], ["Rowing", 1, "20 - 24", 4, "Ukraine", 2], ["Rowing", 1, "20 - 24", 18, "Great Britain", 7], ["Tennis", 1, "20 - 24", 1, "Australia", 0], ["Rowing", 1, "20 - 24", 4, "Denmark", 2], ["Rowing", 1, "20 - 24", 16, "Germany", 8], ["Sailing", 1, "20 - 24", 1, "Germany", 0], ["Sailing", 1, "20 - 24", 1, "Argentina", 0], ["Gymnastics", 1, "20 - 24", 3, "Great Britain", 0], ["Tennis", 1, "20 - 24", 1, "France", 0], ["Tennis", 1, "20 - 24", 1, "Germany", 0], ["Sailing", 1, "20 - 24", 1, "Norway", 1], ["Sailing", 1, "20 - 24", 1, "Ukraine", 0], ["Swimming", 1, "20 - 24", 8, "Italy", 4], ["Sailing", 1, "20 - 24", 1, "Israel", 0], ["Sailing", 1, "20 - 24", 1, "Brazil", 0], ["Sailing", 1, "20 - 24", 1, "United States", 0], ["Swimming", 1, "20 - 24", 15, "China", 4], ["Canoeing", 1, "20 - 24", 8, "Slovakia", 4], ["Canoeing", 1, "20 - 24", 2, "China", 2], ["Sailing", 1, "20 - 24", 2, "Greece", 0], ["Short-Track Speed Skating", 1, "20 - 24", 9, "China", 6], ["Synchronized Swimming", 1, "20 - 24", 7, "Canada", 0], ["Synchronized Swimming", 1, "20 - 24", 1, "France", 0], ["Sailing", 1, "20 - 24", 2, "China", 1], ["Sailing", 1, "20 - 24", 1, "Finland", 0], ["Sailing", 1, "20 - 24", 1, "Spain", 1], ["Swimming", 1, "20 - 24", 2, "Canada", 0], ["Sailing", 1, "20 - 24", 1, "Sweden", 1], ["Canoeing", 1, "20 - 24", 2, "Australia", 0], ["Sailing", 1, "20 - 24", 6, "Great Britain", 4], ["Sailing", 1, "20 - 24", 2, "Denmark", 0], ["Sailing", 1, "20 - 24", 1, "Cyprus", 0], ["Canoeing", 1, "20 - 24", 2, "Ukraine", 0], ["Swimming", 1, "20 - 24", 1, "Serbia", 0], ["Gymnastics", 1, "20 - 24", 5, "Ukraine", 0], ["Swimming", 1, "20 - 24", 1, "Denmark", 0], ["Canoeing", 1, "20 - 24", 1, "Portugal", 0], ["Swimming", 1, "20 - 24", 1, "Slovenia", 0], ["Canoeing", 1, "20 - 24", 5, "Poland", 0], ["Swimming", 1, "20 - 24", 1, "Tunisia", 1], ["Sailing", 1, "20 - 24", 5, "Australia", 3], ["Swimming", 1, "20 - 24", 1, "Norway", 0], ["Sailing", 1, "20 - 24", 4, "New Zealand", 2], ["Swimming", 1, "20 - 24", 1, "Argentina", 0], ["Swimming", 1, "20 - 24", 1, "Trinidad and Tobago", 0], ["Sailing", 1, "20 - 24", 5, "Netherlands", 1], ["Canoeing", 1, "20 - 24", 5, "Czech Republic", 0], ["Swimming", 1, "20 - 24", 1, "Croatia", 0], ["Swimming", 1, "20 - 24", 2, "Romania", 1], ["Fencing", 1, "20 - 24", 5, "Italy", 3], ["Shooting", 1, "20 - 24", 1, "Denmark", 0], ["Shooting", 1, "20 - 24", 1, "Australia", 0], ["Swimming", 1, "20 - 24", 2, "Zimbabwe", 2], ["Short-Track Speed Skating", 1, "20 - 24", 6, "United States", 1], ["Shooting", 1, "20 - 24", 1, "Great Britain", 1], ["Canoeing", 1, "20 - 24", 7, "Russia", 2], ["Basketball", 1, "20 - 24", 5, "Spain", 0], ["Canoeing", 1, "20 - 24", 1, "New Zealand", 1], ["Basketball", 1, "20 - 24", 29, "United States", 22], ["Fencing", 1, "20 - 24", 8, "United States", 1], ["Shooting", 1, "20 - 24", 3, "Russia", 0], ["Short-Track Speed Skating", 1, "20 - 24", 4, "Italy", 0], ["Shooting", 1, "20 - 24", 1, "France", 0], ["Shooting", 1, "20 - 24", 1, "Slovakia", 0], ["Speed Skating", 1, "20 - 24", 1, "Norway", 0], ["Speed Skating", 1, "20 - 24", 9, "Canada", 4], ["Canoeing", 1, "20 - 24", 9, "Belarus", 2], ["Speed Skating", 1, "20 - 24", 2, "Japan", 0], ["Shooting", 1, "20 - 24", 2, "Germany", 0], ["Fencing", 1, "20 - 24", 6, "France", 3], ["Shooting", 1, "20 - 24", 11, "China", 5], ["Speed Skating", 1, "20 - 24", 2, "China", 0], ["Shooting", 1, "20 - 24", 1, "Serbia", 0], ["Speed Skating", 1, "20 - 24", 2, "Poland", 0], ["Speed Skating", 1, "20 - 24", 2, "Russia", 0], ["Cross Country Skiing", 1, "20 - 24", 1, "Poland", 0], ["Shooting", 1, "20 - 24", 4, "United States", 2], ["Skeleton", 1, "20 - 24", 1, "United States", 1], ["Skeleton", 1, "20 - 24", 1, "Great Britain", 0], ["Skeleton", 1, "20 - 24", 1, "Russia", 0], ["Fencing", 1, "20 - 24", 5, "Germany", 1], ["Ski Jumping", 1, "20 - 24", 3, "Slovenia", 0], ["Softball", 1, "20 - 24", 19, "United States", 14], ["Cross Country Skiing", 1, "20 - 24", 1, "France", 0], ["Ski Jumping", 1, "20 - 24", 3, "Germany", 2], ["Softball", 1, "20 - 24", 9, "Australia", 0], ["Softball", 1, "20 - 24", 19, "Japan", 6], ["Ski Jumping", 1, "20 - 24", 3, "Norway", 0], ["Snowboarding", 1, "20 - 24", 1, "Slovakia", 0], ["Cross Country Skiing", 1, "20 - 24", 1, "Canada", 1], ["Snowboarding", 1, "20 - 24", 3, "Switzerland", 2], ["Archery", 1, "20 - 24", 1, "Netherlands", 0], ["Speed Skating", 1, "20 - 24", 2, "Germany", 1], ["Snowboarding", 1, "20 - 24", 1, "Norway", 0], ["Snowboarding", 1, "20 - 24", 1, "Canada", 0], ["Snowboarding", 1, "20 - 24", 3, "France", 0], ["Snowboarding", 1, "20 - 24", 2, "Finland", 0], ["Snowboarding", 1, "20 - 24", 8, "United States", 2], ["Snowboarding", 1, "20 - 24", 1, "Austria", 0], ["Snowboarding", 1, "20 - 24", 1, "Australia", 1], ["Snowboarding", 1, "20 - 24", 1, "Russia", 0], ["Snowboarding", 2, "25 - 29", 3, "United States", 1], ["Athletics", 2, "25 - 29", 1, "Tunisia", 0], ["Snowboarding", 2, "25 - 29", 1, "Austria", 0], ["Swimming", 2, "25 - 29", 38, "United States", 41], ["Snowboarding", 2, "25 - 29", 3, "Switzerland", 1], ["Badminton", 2, "25 - 29", 5, "Indonesia", 2], ["Badminton", 2, "25 - 29", 4, "Great Britain", 0], ["Speed Skating", 2, "25 - 29", 4, "Canada", 1], ["Badminton", 2, "25 - 29", 2, "Russia", 0], ["Cross Country Skiing", 2, "25 - 29", 10, "Norway", 11], ["Badminton", 2, "25 - 29", 4, "Denmark", 0], ["Badminton", 2, "25 - 29", 2, "Malaysia", 0], ["Swimming", 2, "25 - 29", 23, "Australia", 13], ["Swimming", 2, "25 - 29", 14, "Netherlands", 7], ["Snowboarding", 2, "25 - 29", 1, "Canada", 0], ["Diving", 2, "25 - 29", 4, "Russia", 2], ["Basketball", 2, "25 - 29", 6, "Brazil", 0], ["Softball", 2, "25 - 29", 15, "Japan", 8], ["Snowboarding", 2, "25 - 29", 2, "France", 1], ["Snowboarding", 2, "25 - 29", 1, "Sweden", 0], ["Snowboarding", 2, "25 - 29", 1, "Italy", 0], ["Softball", 2, "25 - 29", 17, "United States", 10], ["Ski Jumping", 2, "25 - 29", 2, "Austria", 2], ["Basketball", 2, "25 - 29", 6, "Lithuania", 0], ["Biathlon", 2, "25 - 29", 6, "Norway", 7], ["Basketball", 2, "25 - 29", 8, "Italy", 0], ["Ski Jumping", 2, "25 - 29", 3, "Finland", 0], ["Ski Jumping", 2, "25 - 29", 1, "Slovenia", 0], ["Softball", 2, "25 - 29", 19, "Australia", 0], ["Swimming", 2, "25 - 29", 10, "France", 4], ["Speed Skating", 2, "25 - 29", 1, "Norway", 0], ["Skeleton", 2, "25 - 29", 1, "Latvia", 0], ["Skeleton", 2, "25 - 29", 1, "Germany", 0], ["Swimming", 2, "25 - 29", 9, "Japan", 2], ["Basketball", 2, "25 - 29", 10, "Argentina", 5], ["Basketball", 2, "25 - 29", 17, "Australia", 0], ["Skeleton", 2, "25 - 29", 2, "Great Britain", 1], ["Swimming", 2, "25 - 29", 8, "Germany", 0], ["Skeleton", 2, "25 - 29", 1, "Canada", 0], ["Basketball", 2, "25 - 29", 16, "Russia", 0], ["Basketball", 2, "25 - 29", 12, "Spain", 0], ["Short-Track Speed Skating", 2, "25 - 29", 5, "United States", 0], ["Short-Track Speed Skating", 2, "25 - 29", 12, "Canada", 8], ["Short-Track Speed Skating", 2, "25 - 29", 3, "China", 2], ["Skeleton", 2, "25 - 29", 1, "Austria", 0], ["Speed Skating", 2, "25 - 29", 6, "United States", 5], ["Basketball", 2, "25 - 29", 17, "France", 0], ["Shooting", 2, "25 - 29", 2, "Slovakia", 0], ["Shooting", 2, "25 - 29", 6, "United States", 4], ["Speed Skating", 2, "25 - 29", 10, "Netherlands", 4], ["Shooting", 2, "25 - 29", 2, "Croatia", 1], ["Basketball", 2, "25 - 29", 39, "United States", 35], ["Beach Volleyball", 2, "25 - 29", 1, "Australia", 1], ["Beach Volleyball", 2, "25 - 29", 1, "Switzerland", 0], ["Speed Skating", 2, "25 - 29", 6, "Germany", 6], ["Ski Jumping", 2, "25 - 29", 5, "Norway", 1], ["Nordic Combined", 2, "25 - 29", 3, "United States", 1], ["Shooting", 2, "25 - 29", 3, "France", 1], ["Shooting", 2, "25 - 29", 1, "Denmark", 0], ["Speed Skating", 2, "25 - 29", 1, "Italy", 1], ["Beach Volleyball", 2, "25 - 29", 1, "China", 0], ["Shooting", 2, "25 - 29", 3, "India", 1], ["Beach Volleyball", 2, "25 - 29", 5, "United States", 5], ["Beach Volleyball", 2, "25 - 29", 1, "Latvia", 0], ["Shooting", 2, "25 - 29", 2, "Romania", 1], ["Beach Volleyball", 2, "25 - 29", 8, "Brazil", 1], ["Biathlon", 2, "25 - 29", 1, "Bulgaria", 0], ["Biathlon", 2, "25 - 29", 1, "Ukraine", 0], ["Shooting", 2, "25 - 29", 2, "Czech Republic", 0], ["Nordic Combined", 2, "25 - 29", 4, "Germany", 1], ["Shooting", 2, "25 - 29", 1, "Great Britain", 1], ["Biathlon", 2, "25 - 29", 1, "Kazakhstan", 0], ["Nordic Combined", 2, "25 - 29", 6, "Austria", 5], ["Shooting", 2, "25 - 29", 1, "Germany", 0], ["Biathlon", 2, "25 - 29", 1, "Austria", 0], ["Shooting", 2, "25 - 29", 1, "Cuba", 0], ["Gymnastics", 2, "25 - 29", 4, "China", 6], ["Cycling", 2, "25 - 29", 3, "China", 0], ["Shooting", 2, "25 - 29", 2, "Finland", 0], ["Speed Skating", 2, "25 - 29", 3, "Japan", 0], ["Bobsleigh", 2, "25 - 29", 1, "Italy", 0], ["Bobsleigh", 2, "25 - 29", 4, "Russia", 0], ["Cycling", 2, "25 - 29", 8, "France", 6], ["Cross Country Skiing", 2, "25 - 29", 1, "Poland", 1], ["Bobsleigh", 2, "25 - 29", 10, "United States", 4], ["Bobsleigh", 2, "25 - 29", 2, "Canada", 0], ["Cross Country Skiing", 2, "25 - 29", 7, "Sweden", 5], ["Boxing", 2, "25 - 29", 1, "Romania", 0], ["Cross Country Skiing", 2, "25 - 29", 8, "Russia", 3], ["Biathlon", 2, "25 - 29", 10, "Russia", 4], ["Boxing", 2, "25 - 29", 1, "Hungary", 0], ["Short-Track Speed Skating", 2, "25 - 29", 1, "Australia", 1], ["Boxing", 2, "25 - 29", 1, "Algeria", 0], ["Biathlon", 2, "25 - 29", 7, "Germany", 7], ["Shooting", 2, "25 - 29", 1, "Russia", 1], ["Athletics", 2, "25 - 29", 28, "Jamaica", 12], ["Athletics", 2, "25 - 29", 54, "United States", 28], ["Boxing", 2, "25 - 29", 1, "Germany", 0], ["Alpine Skiing", 2, "25 - 29", 1, "Norway", 1], ["Short-Track Speed Skating", 2, "25 - 29", 1, "Bulgaria", 0], ["Table Tennis", 2, "25 - 29", 3, "Singapore", 0], ["Table Tennis", 2, "25 - 29", 7, "China", 8], ["Tennis", 2, "25 - 29", 1, "Great Britain", 1], ["Boxing", 2, "25 - 29", 1, "Belarus", 0], ["Shooting", 2, "25 - 29", 1, "North Korea", 0], ["Short-Track Speed Skating", 2, "25 - 29", 4, "Italy", 0], ["Boxing", 2, "25 - 29", 2, "Egypt", 0], ["Boxing", 2, "25 - 29", 3, "China", 2], ["Shooting", 2, "25 - 29", 1, "Austria", 0], ["Boxing", 2, "25 - 29", 2, "France", 0], ["Tennis", 2, "25 - 29", 2, "Chile", 2], ["Boxing", 2, "25 - 29", 5, "Cuba", 2], ["Synchronized Swimming", 2, "25 - 29", 7, "Spain", 0], ["Synchronized Swimming", 2, "25 - 29", 15, "Russia", 19], ["Boxing", 2, "25 - 29", 1, "Moldova", 0], ["Synchronized Swimming", 2, "25 - 29", 7, "China", 0], ["Boxing", 2, "25 - 29", 2, "Italy", 1], ["Shooting", 2, "25 - 29", 1, "Australia", 1], ["Boxing", 2, "25 - 29", 2, "Thailand", 0], ["Swimming", 2, "25 - 29", 1, "Sweden", 1], ["Swimming", 2, "25 - 29", 1, "Great Britain", 0], ["Boxing", 2, "25 - 29", 4, "Kazakhstan", 3], ["Swimming", 2, "25 - 29", 2, "South Africa", 1], ["Shooting", 2, "25 - 29", 1, "Bulgaria", 1], ["Synchronized Swimming", 2, "25 - 29", 9, "Japan", 0], ["Boxing", 2, "25 - 29", 1, "Bulgaria", 0], ["Swimming", 2, "25 - 29", 1, "Belarus", 0], ["Swimming", 2, "25 - 29", 1, "Tunisia", 1], ["Swimming", 2, "25 - 29", 1, "Romania", 0], ["Boxing", 2, "25 - 29", 2, "Azerbaijan", 0], ["Boxing", 2, "25 - 29", 2, "Japan", 1], ["Swimming", 2, "25 - 29", 1, "Costa Rica", 0], ["Boxing", 2, "25 - 29", 1, "India", 0], ["Boxing", 2, "25 - 29", 4, "Ukraine", 1], ["Boxing", 2, "25 - 29", 2, "South Korea", 0], ["Speed Skating", 2, "25 - 29", 4, "Russia", 0], ["Sailing", 2, "25 - 29", 6, "Spain", 5], ["Sailing", 2, "25 - 29", 2, "New Zealand", 1], ["Sailing", 2, "25 - 29", 8, "Australia", 7], ["Ski Jumping", 2, "25 - 29", 1, "Switzerland", 2], ["Sailing", 2, "25 - 29", 11, "Great Britain", 3], ["Swimming", 2, "25 - 29", 4, "Italy", 0], ["Ski Jumping", 2, "25 - 29", 1, "Germany", 1], ["Sailing", 2, "25 - 29", 4, "Argentina", 0], ["Boxing", 2, "25 - 29", 4, "Ireland", 1], ["Swimming", 2, "25 - 29", 1, "Norway", 0], ["Boxing", 2, "25 - 29", 12, "Russia", 4], ["Boxing", 2, "25 - 29", 2, "Uzbekistan", 1], ["Sailing", 2, "25 - 29", 3, "Finland", 0], ["Shooting", 2, "25 - 29", 1, "Ukraine", 0], ["Boxing", 2, "25 - 29", 3, "Great Britain", 2], ["Sailing", 2, "25 - 29", 5, "France", 1], ["Shooting", 2, "25 - 29", 2, "South Korea", 1], ["Baseball", 2, "25 - 29", 8, "Australia", 0], ["Swimming", 2, "25 - 29", 3, "Russia", 0], ["Baseball", 2, "25 - 29", 12, "Japan", 0], ["Sailing", 2, "25 - 29", 2, "Poland", 0], ["Baseball", 2, "25 - 29", 22, "Cuba", 7], ["Baseball", 2, "25 - 29", 20, "South Korea", 10], ["Swimming", 2, "25 - 29", 2, "Canada", 0], ["Swimming", 2, "25 - 29", 2, "Hungary", 1], ["Shooting", 2, "25 - 29", 8, "China", 4], ["Swimming", 2, "25 - 29", 4, "Brazil", 0], ["Sailing", 2, "25 - 29", 1, "Belgium", 0], ["Synchronized Swimming", 2, "25 - 29", 1, "Canada", 0], ["Synchronized Swimming", 2, "25 - 29", 1, "France", 0], ["Baseball", 2, "25 - 29", 13, "United States", 8], ["Rowing", 2, "25 - 29", 30, "Australia", 3], ["Sailing", 2, "25 - 29", 1, "Netherlands", 0], ["Rowing", 2, "25 - 29", 9, "Romania", 9], ["Canoeing", 2, "25 - 29", 1, "Israel", 0], ["Sailing", 2, "25 - 29", 3, "Sweden", 0], ["Rowing", 2, "25 - 29", 31, "Netherlands", 0], ["Canoeing", 2, "25 - 29", 2, "Sweden", 2], ["Canoeing", 2, "25 - 29", 1, "China", 1], ["Synchronized Swimming", 2, "25 - 29", 2, "United States", 0], ["Gymnastics", 2, "25 - 29", 6, "United States", 0], ["Canoeing", 2, "25 - 29", 1, "United States", 0], ["Sailing", 2, "25 - 29", 2, "Brazil", 0], ["Sailing", 2, "25 - 29", 5, "Germany", 0], ["Canoeing", 2, "25 - 29", 1, "New Zealand", 0], ["Canoeing", 2, "25 - 29", 4, "Cuba", 0], ["Gymnastics", 2, "25 - 29", 1, "Russia", 0], ["Gymnastics", 2, "25 - 29", 3, "Romania", 0], ["Sailing", 2, "25 - 29", 2, "United States", 1], ["Sailing", 2, "25 - 29", 1, "Lithuania", 0], ["Sailing", 2, "25 - 29", 4, "Denmark", 3], ["Sailing", 2, "25 - 29", 2, "China", 1], ["Canoeing", 2, "25 - 29", 9, "Slovakia", 3], ["Tennis", 2, "25 - 29", 1, "Australia", 0], ["Sailing", 2, "25 - 29", 1, "Greece", 1], ["Gymnastics", 2, "25 - 29", 6, "Japan", 2], ["Canoeing", 2, "25 - 29", 1, "Togo", 0], ["Canoeing", 2, "25 - 29", 1, "Lithuania", 0], ["Sailing", 2, "25 - 29", 1, "Israel", 1], ["Sailing", 2, "25 - 29", 2, "Austria", 1], ["Canoeing", 2, "25 - 29", 1, "Portugal", 0], ["Gymnastics", 2, "25 - 29", 1, "South Korea", 0], ["Sailing", 2, "25 - 29", 2, "Ukraine", 0], ["Gymnastics", 2, "25 - 29", 1, "Bulgaria", 0], ["Canoeing", 2, "25 - 29", 2, "Italy", 1], ["Canoeing", 2, "25 - 29", 8, "Poland", 0], ["Canoeing", 2, "25 - 29", 4, "Czech Republic", 0], ["Tennis", 2, "25 - 29", 1, "Belgium", 0], ["Fencing", 2, "25 - 29", 19, "Italy", 12], ["Canoeing", 2, "25 - 29", 1, "South Africa", 0], ["Sailing", 2, "25 - 29", 2, "Japan", 0], ["Sailing", 2, "25 - 29", 1, "Czech Republic", 0], ["Tennis", 2, "25 - 29", 2, "Canada", 2], ["Canoeing", 2, "25 - 29", 7, "Great Britain", 1], ["Sailing", 2, "25 - 29", 1, "Slovenia", 0], ["Canoeing", 2, "25 - 29", 6, "France", 2], ["Fencing", 2, "25 - 29", 3, "United States", 0], ["Canoeing", 2, "25 - 29", 5, "Canada", 0], ["Fencing", 2, "25 - 29", 13, "France", 8], ["Cross Country Skiing", 2, "25 - 29", 1, "Switzerland", 0], ["Cross Country Skiing", 2, "25 - 29", 1, "Austria", 1], ["Cross Country Skiing", 2, "25 - 29", 2, "Canada", 1], ["Equestrian", 2, "25 - 29", 6, "Germany", 4], ["Tennis", 2, "25 - 29", 2, "Netherlands", 0], ["Equestrian", 2, "25 - 29", 5, "Great Britain", 5], ["Archery", 2, "25 - 29", 1, "Germany", 0], ["Archery", 2, "25 - 29", 3, "Ukraine", 1], ["Rowing", 2, "25 - 29", 20, "Germany", 11], ["Archery", 2, "25 - 29", 1, "France", 0], ["Tennis", 2, "25 - 29", 1, "Argentina", 0], ["Rowing", 2, "25 - 29", 38, "Great Britain", 17], ["Rowing", 2, "25 - 29", 9, "Italy", 1], ["Archery", 2, "25 - 29", 1, "United States", 0], ["Rowing", 2, "25 - 29", 14, "New Zealand", 8], ["Rowing", 2, "25 - 29", 3, "South Africa", 2], ["Rowing", 2, "25 - 29", 23, "Canada", 5], ["Rowing", 2, "25 - 29", 38, "United States", 19], ["Tennis", 2, "25 - 29", 1, "Croatia", 0], ["Archery", 2, "25 - 29", 2, "Italy", 1], ["Rowing", 2, "25 - 29", 11, "France", 4], ["Archery", 2, "25 - 29", 1, "Japan", 0], ["Diving", 2, "25 - 29", 7, "China", 9], ["Alpine Skiing", 2, "25 - 29", 1, "Finland", 0], ["Tennis", 2, "25 - 29", 2, "Germany", 0], ["Alpine Skiing", 2, "25 - 29", 1, "Croatia", 0], ["Tennis", 2, "25 - 29", 1, "China", 0], ["Alpine Skiing", 2, "25 - 29", 4, "France", 2], ["Alpine Skiing", 2, "25 - 29", 3, "Switzerland", 0], ["Rowing", 2, "25 - 29", 8, "Denmark", 1], ["Rowing", 2, "25 - 29", 9, "Poland", 3], ["Tennis", 2, "25 - 29", 3, "United States", 2], ["Alpine Skiing", 2, "25 - 29", 1, "Czech Republic", 0], ["Alpine Skiing", 2, "25 - 29", 3, "Italy", 2], ["Alpine Skiing", 2, "25 - 29", 3, "Sweden", 0], ["Diving", 2, "25 - 29", 6, "Australia", 1], ["Tennis", 2, "25 - 29", 3, "Spain", 0], ["Rowing", 2, "25 - 29", 1, "Ukraine", 1], ["Tennis", 2, "25 - 29", 1, "Switzerland", 1], ["Diving", 2, "25 - 29", 3, "Canada", 0], ["Cycling", 2, "25 - 29", 14, "Great Britain", 8], ["Cycling", 2, "25 - 29", 7, "United States", 1], ["Athletics", 2, "25 - 29", 1, "Mozambique", 1], ["Athletics", 2, "25 - 29", 1, "Algeria", 1], ["Cycling", 2, "25 - 29", 12, "Germany", 5], ["Cycling", 2, "25 - 29", 10, "Australia", 7], ["Cycling", 2, "25 - 29", 4, "Switzerland", 1], ["Athletics", 2, "25 - 29", 1, "Austria", 0], ["Rowing", 2, "25 - 29", 3, "Czech Republic", 0], ["Cycling", 2, "25 - 29", 5, "New Zealand", 1], ["Rowing", 2, "25 - 29", 3, "Greece", 0], ["Rowing", 2, "25 - 29", 2, "China", 1], ["Athletics", 2, "25 - 29", 4, "Brazil", 0], ["Rowing", 2, "25 - 29", 3, "Belarus", 1], ["Cycling", 2, "25 - 29", 6, "Spain", 0], ["Athletics", 2, "25 - 29", 2, "South Africa", 0], ["Athletics", 2, "25 - 29", 2, "Lithuania", 1], ["Rowing", 2, "25 - 29", 1, "Estonia", 0], ["Athletics", 2, "25 - 29", 1, "Dominican Republic", 1], ["Athletics", 2, "25 - 29", 2, "Denmark", 0], ["Athletics", 2, "25 - 29", 2, "Portugal", 0], ["Athletics", 2, "25 - 29", 1, "Cameroon", 1], ["Athletics", 2, "25 - 29", 1, "Hungary", 0], ["Cross Country Skiing", 2, "25 - 29", 10, "Germany", 3], ["Athletics", 2, "25 - 29", 1, "Sweden", 1], ["Athletics", 2, "25 - 29", 1, "Mexico", 0], ["Athletics", 2, "25 - 29", 2, "Spain", 0], ["Cross Country Skiing", 2, "25 - 29", 2, "Estonia", 2], ["Athletics", 2, "25 - 29", 6, "Greece", 2], ["Athletics", 2, "25 - 29", 4, "Romania", 0], ["Cross Country Skiing", 2, "25 - 29", 2, "Czech Republic", 0], ["Tennis", 2, "25 - 29", 4, "Russia", 2], ["Tennis", 2, "25 - 29", 2, "Czech Republic", 0], ["Tennis", 2, "25 - 29", 3, "France", 0], ["Athletics", 2, "25 - 29", 2, "New Zealand", 1], ["Athletics", 2, "25 - 29", 2, "Norway", 1], ["Cross Country Skiing", 2, "25 - 29", 4, "Italy", 0], ["Taekwondo", 2, "25 - 29", 1, "Vietnam", 0], ["Athletics", 2, "25 - 29", 4, "Japan", 3], ["Athletics", 2, "25 - 29", 1, "Panama", 1], ["Rowing", 2, "25 - 29", 5, "Croatia", 0], ["Athletics", 2, "25 - 29", 4, "Italy", 1], ["Rowing", 2, "25 - 29", 2, "Slovenia", 1], ["Rowing", 2, "25 - 29", 5, "Russia", 1], ["Canoeing", 2, "25 - 29", 18, "Hungary", 14], ["Rowing", 2, "25 - 29", 2, "Norway", 1], ["Rowing", 2, "25 - 29", 2, "Bulgaria", 0], ["Rowing", 2, "25 - 29", 1, "Switzerland", 0], ["Rowing", 2, "25 - 29", 1, "Lithuania", 0], ["Athletics", 2, "25 - 29", 2, "Belgium", 0], ["Taekwondo", 2, "25 - 29", 1, "Japan", 0], ["Athletics", 2, "25 - 29", 1, "Canada", 0], ["Taekwondo", 2, "25 - 29", 1, "Cuba", 0], ["Taekwondo", 2, "25 - 29", 1, "Russia", 0], ["Taekwondo", 2, "25 - 29", 1, "Spain", 0], ["Taekwondo", 2, "25 - 29", 1, "Australia", 1], ["Canoeing", 2, "25 - 29", 3, "Ukraine", 2], ["Rhythmic Gymnastics", 2, "25 - 29", 1, "Italy", 0], ["Athletics", 2, "25 - 29", 2, "Slovenia", 1], ["Taekwondo", 2, "25 - 29", 1, "Great Britain", 0], ["Taekwondo", 2, "25 - 29", 1, "Norway", 0], ["Athletics", 2, "25 - 29", 1, "Latvia", 0], ["Taekwondo", 2, "25 - 29", 3, "Mexico", 1], ["Rhythmic Gymnastics", 2, "25 - 29", 1, "China", 0], ["Taekwondo", 2, "25 - 29", 2, "Greece", 0], ["Taekwondo", 2, "25 - 29", 1, "Dominican Republic", 0], ["Taekwondo", 2, "25 - 29", 1, "Croatia", 0], ["Athletics", 2, "25 - 29", 6, "Belarus", 2], ["Athletics", 2, "25 - 29", 6, "Nigeria", 2], ["Taekwondo", 2, "25 - 29", 5, "Chinese Taipei", 1], ["Taekwondo", 2, "25 - 29", 1, "Afghanistan", 0], ["Nordic Combined", 2, "25 - 29", 2, "Finland", 0], ["Taekwondo", 2, "25 - 29", 2, "Iran", 1], ["Athletics", 2, "25 - 29", 1, "Estonia", 1], ["Modern Pentathlon", 2, "25 - 29", 2, "Lithuania", 1], ["Canoeing", 2, "25 - 29", 5, "Spain", 1], ["Modern Pentathlon", 2, "25 - 29", 2, "Hungary", 1], ["Modern Pentathlon", 2, "25 - 29", 1, "Brazil", 0], ["Taekwondo", 2, "25 - 29", 3, "Italy", 1], ["Modern Pentathlon", 2, "25 - 29", 1, "Czech Republic", 1], ["Modern Pentathlon", 2, "25 - 29", 4, "Great Britain", 1], ["Canoeing", 2, "25 - 29", 4, "Belarus", 4], ["Modern Pentathlon", 2, "25 - 29", 3, "Russia", 3], ["Taekwondo", 2, "25 - 29", 2, "China", 1], ["Modern Pentathlon", 2, "25 - 29", 1, "Ukraine", 0], ["Canoeing", 2, "25 - 29", 9, "Australia", 4], ["Canoeing", 2, "25 - 29", 22, "Germany", 8], ["Modern Pentathlon", 2, "25 - 29", 1, "Latvia", 0], ["Taekwondo", 2, "25 - 29", 4, "United States", 1], ["Modern Pentathlon", 2, "25 - 29", 1, "United States", 0], ["Taekwondo", 2, "25 - 29", 3, "South Korea", 3], ["Taekwondo", 2, "25 - 29", 4, "France", 0], ["Luge", 2, "25 - 29", 5, "Germany", 1], ["Athletics", 2, "25 - 29", 3, "Poland", 1], ["Luge", 2, "25 - 29", 3, "Austria", 2], ["Taekwondo", 2, "25 - 29", 2, "Germany", 0], ["Luge", 2, "25 - 29", 2, "Latvia", 0], ["Athletics", 2, "25 - 29", 9, "Cuba", 2], ["Athletics", 2, "25 - 29", 2, "China", 0], ["Canoeing", 2, "25 - 29", 4, "Russia", 1], ["Athletics", 2, "25 - 29", 1, "Kazakhstan", 1], ["Taekwondo", 2, "25 - 29", 1, "Argentina", 1], ["Athletics", 2, "25 - 29", 3, "Finland", 1], ["Luge", 2, "25 - 29", 2, "United States", 0], ["Canoeing", 2, "25 - 29", 2, "Norway", 1], ["Luge", 2, "25 - 29", 1, "Italy", 1], ["Judo", 2, "25 - 29", 1, "Colombia", 0], ["Athletics", 2, "25 - 29", 8, "Ukraine", 1], ["Judo", 2, "25 - 29", 9, "Cuba", 2], ["Athletics", 2, "25 - 29", 8, "Australia", 3], ["Athletics", 2, "25 - 29", 11, "Bahamas", 5], ["Canoeing", 2, "25 - 29", 2, "Romania", 1], ["Judo", 2, "25 - 29", 4, "Romania", 1], ["Judo", 2, "25 - 29", 1, "Hungary", 0], ["Judo", 2, "25 - 29", 5, "Brazil", 0], ["Athletics", 2, "25 - 29", 6, "France", 1], ["Trampoline", 2, "25 - 29", 1, "Russia", 1], ["Judo", 2, "25 - 29", 4, "Italy", 1], ["Trampoline", 2, "25 - 29", 2, "Ukraine", 1], ["Judo", 2, "25 - 29", 2, "Great Britain", 0], ["Bobsleigh", 2, "25 - 29", 3, "Switzerland", 0], ["Athletics", 2, "25 - 29", 1, "Bahrain", 0], ["Judo", 2, "25 - 29", 7, "Netherlands", 1], ["Trampoline", 2, "25 - 29", 1, "Uzbekistan", 0], ["Judo", 2, "25 - 29", 17, "Japan", 10], ["Judo", 2, "25 - 29", 1, "Greece", 0], ["Judo", 2, "25 - 29", 8, "Russia", 2], ["Trampoline", 2, "25 - 29", 1, "Canada", 0], ["Judo", 2, "25 - 29", 5, "South Korea", 2], ["Trampoline", 2, "25 - 29", 1, "China", 0], ["Judo", 2, "25 - 29", 1, "United States", 0], ["Athletics", 2, "25 - 29", 1, "Colombia", 0], ["Judo", 2, "25 - 29", 2, "Mongolia", 0], ["Judo", 2, "25 - 29", 4, "Germany", 1], ["Triathlon", 2, "25 - 29", 1, "Canada", 1], ["Judo", 2, "25 - 29", 2, "Uzbekistan", 0], ["Bobsleigh", 2, "25 - 29", 8, "Germany", 5], ["Judo", 2, "25 - 29", 6, "China", 3], ["Athletics", 2, "25 - 29", 4, "Czech Republic", 2], ["Triathlon", 2, "25 - 29", 1, "Czech Republic", 0], ["Triathlon", 2, "25 - 29", 1, "Switzerland", 0], ["Athletics", 2, "25 - 29", 6, "Germany", 1], ["Athletics", 2, "25 - 29", 1, "Iran", 0], ["Judo", 2, "25 - 29", 3, "North Korea", 0], ["Biathlon", 2, "25 - 29", 1, "Slovakia", 1], ["Judo", 2, "25 - 29", 1, "Algeria", 0], ["Judo", 2, "25 - 29", 1, "Tajikistan", 0], ["Judo", 2, "25 - 29", 7, "France", 1], ["Athletics", 2, "25 - 29", 1, "Puerto Rico", 0], ["Triathlon", 2, "25 - 29", 1, "New Zealand", 0], ["Biathlon", 2, "25 - 29", 5, "France", 1], ["Badminton", 2, "25 - 29", 17, "China", 11], ["Judo", 2, "25 - 29", 1, "Egypt", 0], ["Badminton", 2, "25 - 29", 11, "South Korea", 3], ["Triathlon", 2, "25 - 29", 2, "Germany", 1], ["Cross Country Skiing", 2, "25 - 29", 3, "Finland", 0], ["Athletics", 2, "25 - 29", 11, "Kenya", 2], ["Judo", 2, "25 - 29", 1, "Austria", 0], ["Triathlon", 2, "25 - 29", 1, "Sweden", 0], ["Triathlon", 2, "25 - 29", 1, "Spain", 0], ["Triathlon", 2, "25 - 29", 3, "Australia", 1], ["Curling", 2, "25 - 29", 1, "Great Britain", 1], ["Athletics", 2, "25 - 29", 9, "Ethiopia", 6], ["Judo", 2, "25 - 29", 3, "Georgia", 1], ["Athletics", 2, "25 - 29", 12, "Great Britain", 7], ["Athletics", 2, "25 - 29", 2, "Turkey", 1], ["Athletics", 2, "25 - 29", 36, "Russia", 9], ["Judo", 2, "25 - 29", 1, "Kazakhstan", 0], ["Curling", 2, "25 - 29", 3, "Norway", 1], ["Table Tennis", 2, "25 - 29", 1, "Denmark", 0], ["Judo", 2, "25 - 29", 1, "Bulgaria", 0], ["Table Tennis", 2, "25 - 29", 2, "Hong Kong", 0], ["Judo", 2, "25 - 29", 2, "Belgium", 0], ["Table Tennis", 2, "25 - 29", 1, "Germany", 0], ["Judo", 2, "25 - 29", 1, "Slovakia", 0], ["Judo", 2, "25 - 29", 2, "Belarus", 1], ["Curling", 2, "25 - 29", 3, "China", 0], ["Curling", 2, "25 - 29", 6, "Switzerland", 0], ["Judo", 2, "25 - 29", 1, "Israel", 0], ["Table Tennis", 2, "25 - 29", 9, "South Korea", 0], ["Curling", 2, "25 - 29", 8, "Canada", 6], ["Athletics", 2, "25 - 29", 4, "Morocco", 2], ["Judo", 2, "25 - 29", 1, "Spain", 1], ["Judo", 2, "25 - 29", 1, "Canada", 0], ["Cycling", 2, "25 - 29", 1, "Uruguay", 0], ["Cycling", 2, "25 - 29", 1, "Kazakhstan", 0], ["Judo", 2, "25 - 29", 1, "Ukraine", 0], ["Judo", 2, "25 - 29", 1, "Turkey", 1], ["Judo", 2, "25 - 29", 1, "Australia", 0], ["Judo", 2, "25 - 29", 1, "Estonia", 0], ["Table Tennis", 2, "25 - 29", 1, "Japan", 0], ["Judo", 2, "25 - 29", 1, "Latvia", 0], ["Cycling", 2, "25 - 29", 2, "Belgium", 0], ["Ice Hockey", 2, "25 - 29", 33, "Canada", 33], ["Ice Hockey", 2, "25 - 29", 34, "United States", 0], ["Cycling", 2, "25 - 29", 3, "Ukraine", 0], ["Volleyball", 2, "25 - 29", 7, "Serbia and Montenegro", 7], ["Cycling", 2, "25 - 29", 1, "Belarus", 0], ["Cycling", 2, "25 - 29", 1, "Canada", 0], ["Athletics", 2, "25 - 29", 6, "Trinidad and Tobago", 0], ["Ice Hockey", 2, "25 - 29", 22, "Finland", 0], ["Alpine Skiing", 2, "25 - 29", 8, "Austria", 3], ["Cycling", 2, "25 - 29", 4, "Japan", 0], ["Cycling", 2, "25 - 29", 1, "Denmark", 0], ["Volleyball", 2, "25 - 29", 8, "Cuba", 4], ["Cycling", 2, "25 - 29", 1, "Sweden", 0], ["Cycling", 2, "25 - 29", 2, "Russia", 0], ["Volleyball", 2, "25 - 29", 12, "China", 5], ["Alpine Skiing", 2, "25 - 29", 2, "United States", 1], ["Ice Hockey", 2, "25 - 29", 23, "Sweden", 12], ["Ice Hockey", 2, "25 - 29", 8, "Czech Republic", 0], ["Alpine Skiing", 2, "25 - 29", 1, "Slovenia", 0], ["Alpine Skiing", 2, "25 - 29", 2, "Germany", 2], ["Cycling", 2, "25 - 29", 1, "Netherlands", 1], ["Cycling", 2, "25 - 29", 1, "Colombia", 0], ["Cycling", 2, "25 - 29", 1, "Latvia", 1], ["Archery", 2, "25 - 29", 10, "South Korea", 9], ["Archery", 2, "25 - 29", 6, "China", 1], ["Cycling", 2, "25 - 29", 1, "Hong Kong", 0], ["Cycling", 2, "25 - 29", 1, "Czech Republic", 1], ["Ice Hockey", 2, "25 - 29", 10, "Russia", 0], ["Cycling", 2, "25 - 29", 1, "Norway", 0], ["Volleyball", 2, "25 - 29", 16, "United States", 4], ["Wrestling", 2, "25 - 29", 8, "Ukraine", 1], ["Wrestling", 2, "25 - 29", 6, "Azerbaijan", 1], ["Volleyball", 2, "25 - 29", 14, "Italy", 0], ["Cycling", 2, "25 - 29", 1, "Italy", 0], ["Wrestling", 2, "25 - 29", 3, "India", 0], ["Wrestling", 2, "25 - 29", 1, "Puerto Rico", 0], ["Hockey", 2, "25 - 29", 6, "Great Britain", 0], ["Hockey", 2, "25 - 29", 31, "Argentina", 0], ["Diving", 2, "25 - 29", 1, "Ukraine", 0], ["Wrestling", 2, "25 - 29", 2, "Sweden", 0], ["Diving", 2, "25 - 29", 1, "Great Britain", 0], ["Hockey", 2, "25 - 29", 41, "Australia", 16], ["Diving", 2, "25 - 29", 2, "Greece", 2], ["Hockey", 2, "25 - 29", 56, "Netherlands", 22], ["Wrestling", 2, "25 - 29", 8, "Kazakhstan", 0], ["Hockey", 2, "25 - 29", 34, "Germany", 28], ["Wrestling", 2, "25 - 29", 3, "France", 0], ["Volleyball", 2, "25 - 29", 5, "Japan", 0], ["Diving", 2, "25 - 29", 6, "Germany", 0], ["Wrestling", 2, "25 - 29", 12, "Japan", 4], ["Volleyball", 2, "25 - 29", 32, "Russia", 6], ["Hockey", 2, "25 - 29", 8, "Spain", 0], ["Wrestling", 2, "25 - 29", 2, "Armenia", 0], ["Hockey", 2, "25 - 29", 4, "China", 0], ["Wrestling", 2, "25 - 29", 2, "Lithuania", 0], ["Wrestling", 2, "25 - 29", 14, "Russia", 7], ["Volleyball", 2, "25 - 29", 33, "Brazil", 19], ["Diving", 2, "25 - 29", 3, "Mexico", 0], ["Wrestling", 2, "25 - 29", 8, "Iran", 3], ["Waterpolo", 2, "25 - 29", 5, "Greece", 0], ["Equestrian", 2, "25 - 29", 2, "Netherlands", 1], ["Equestrian", 2, "25 - 29", 2, "Brazil", 0], ["Hockey", 2, "25 - 29", 10, "South Korea", 0], ["Waterpolo", 2, "25 - 29", 14, "Serbia and Montenegro", 0], ["Handball", 2, "25 - 29", 8, "France", 8], ["Equestrian", 2, "25 - 29", 2, "United States", 1], ["Handball", 2, "25 - 29", 18, "Spain", 0], ["Handball", 2, "25 - 29", 14, "Croatia", 6], ["Handball", 2, "25 - 29", 25, "Norway", 17], ["Handball", 2, "25 - 29", 10, "Sweden", 0], ["Wrestling", 2, "25 - 29", 7, "Cuba", 3], ["Equestrian", 2, "25 - 29", 1, "Sweden", 0], ["Handball", 2, "25 - 29", 6, "Montenegro", 0], ["Equestrian", 2, "25 - 29", 2, "Switzerland", 0], ["Wrestling", 2, "25 - 29", 1, "Hungary", 0], ["Equestrian", 2, "25 - 29", 1, "New Zealand", 0], ["Equestrian", 2, "25 - 29", 2, "Saudi Arabia", 0], ["Waterpolo", 2, "25 - 29", 18, "Russia", 0], ["Fencing", 2, "25 - 29", 1, "Cuba", 0], ["Wrestling", 2, "25 - 29", 6, "Georgia", 1], ["Wrestling", 2, "25 - 29", 1, "Estonia", 0], ["Wrestling", 2, "25 - 29", 1, "Colombia", 0], ["Waterpolo", 2, "25 - 29", 4, "Netherlands", 4], ["Waterpolo", 2, "25 - 29", 16, "Hungary", 16], ["Wrestling", 2, "25 - 29", 10, "United States", 3], ["Fencing", 2, "25 - 29", 1, "Switzerland", 1], ["Fencing", 2, "25 - 29", 3, "Hungary", 0], ["Fencing", 2, "25 - 29", 3, "Poland", 0], ["Handball", 2, "25 - 29", 12, "South Korea", 0], ["Wrestling", 2, "25 - 29", 3, "Uzbekistan", 2], ["Handball", 2, "25 - 29", 8, "Iceland", 0], ["Wrestling", 2, "25 - 29", 4, "Bulgaria", 1], ["Fencing", 2, "25 - 29", 1, "Ukraine", 1], ["Handball", 2, "25 - 29", 16, "Russia", 7], ["Fencing", 2, "25 - 29", 1, "Norway", 0], ["Fencing", 2, "25 - 29", 1, "Venezuela", 1], ["Fencing", 2, "25 - 29", 6, "China", 3], ["Fencing", 2, "25 - 29", 12, "Russia", 6], ["Fencing", 2, "25 - 29", 2, "Romania", 0], ["Wrestling", 2, "25 - 29", 1, "Germany", 0], ["Handball", 2, "25 - 29", 18, "Denmark", 18], ["Wrestling", 2, "25 - 29", 2, "Belarus", 0], ["Fencing", 2, "25 - 29", 10, "South Korea", 3], ["Handball", 2, "25 - 29", 11, "Ukraine", 0], ["Handball", 2, "25 - 29", 5, "Germany", 0], ["Waterpolo", 2, "25 - 29", 2, "Spain", 0], ["Fencing", 2, "25 - 29", 2, "Japan", 0], ["Fencing", 2, "25 - 29", 10, "Germany", 1], ["Wrestling", 2, "25 - 29", 3, "Canada", 2], ["Wrestling", 2, "25 - 29", 1, "Italy", 1], ["Freestyle Skiing", 2, "25 - 29", 1, "Czech Republic", 1], ["Handball", 2, "25 - 29", 5, "Hungary", 0], ["Freestyle Skiing", 2, "25 - 29", 1, "Norway", 1], ["Freestyle Skiing", 2, "25 - 29", 1, "Japan", 0], ["Wrestling", 2, "25 - 29", 6, "South Korea", 1], ["Freestyle Skiing", 2, "25 - 29", 2, "Finland", 1], ["Gymnastics", 2, "25 - 29", 1, "Hungary", 1], ["Wrestling", 2, "25 - 29", 4, "Turkey", 1], ["Freestyle Skiing", 2, "25 - 29", 1, "France", 0], ["Gymnastics", 2, "25 - 29", 3, "France", 0], ["Gymnastics", 2, "25 - 29", 1, "Great Britain", 0], ["Waterpolo", 2, "25 - 29", 4, "Croatia", 4], ["Waterpolo", 2, "25 - 29", 19, "Australia", 7], ["Gymnastics", 2, "25 - 29", 1, "Netherlands", 1], ["Freestyle Skiing", 2, "25 - 29", 1, "Belarus", 0], ["Freestyle Skiing", 2, "25 - 29", 2, "Switzerland", 2], ["Freestyle Skiing", 2, "25 - 29", 1, "Austria", 0], ["Gymnastics", 2, "25 - 29", 1, "Spain", 0], ["Gymnastics", 2, "25 - 29", 1, "Uzbekistan", 0], ["Waterpolo", 2, "25 - 29", 23, "United States", 7], ["Waterpolo", 2, "25 - 29", 13, "Serbia", 0], ["Waterpolo", 2, "25 - 29", 13, "Italy", 6], ["Gymnastics", 2, "25 - 29", 1, "Italy", 1], ["Weightlifting", 2, "25 - 29", 1, "Nigeria", 0], ["Gymnastics", 2, "25 - 29", 2, "Ukraine", 1], ["Weightlifting", 2, "25 - 29", 1, "United States", 1], ["Wrestling", 2, "25 - 29", 1, "Poland", 0], ["Gymnastics", 2, "25 - 29", 1, "Latvia", 0], ["Weightlifting", 2, "25 - 29", 1, "India", 0], ["Gymnastics", 2, "25 - 29", 1, "Greece", 1], ["Wrestling", 2, "25 - 29", 1, "Greece", 0], ["Freestyle Skiing", 2, "25 - 29", 3, "Canada", 1], ["Freestyle Skiing", 2, "25 - 29", 2, "China", 0], ["Weightlifting", 2, "25 - 29", 4, "Greece", 1], ["Weightlifting", 2, "25 - 29", 1, "Bulgaria", 1], ["Weightlifting", 2, "25 - 29", 1, "Latvia", 0], ["Freestyle Skiing", 2, "25 - 29", 3, "Australia", 2], ["Weightlifting", 2, "25 - 29", 1, "North Korea", 0], ["Freestyle Skiing", 2, "25 - 29", 3, "United States", 0], ["Figure Skating", 2, "25 - 29", 1, "Canada", 1], ["Football", 2, "25 - 29", 21, "United States", 15], ["Football", 2, "25 - 29", 8, "Canada", 0], ["Figure Skating", 2, "25 - 29", 1, "Italy", 0], ["Figure Skating", 2, "25 - 29", 2, "France", 2], ["Wrestling", 2, "25 - 29", 1, "Macedonia", 0], ["Football", 2, "25 - 29", 11, "Japan", 0], ["Figure Skating", 2, "25 - 29", 2, "China", 0], ["Football", 2, "25 - 29", 12, "Brazil", 0], ["Wrestling", 2, "25 - 29", 1, "North Korea", 0], ["Football", 2, "25 - 29", 3, "South Korea", 0], ["Weightlifting", 2, "25 - 29", 3, "Thailand", 1], ["Wrestling", 2, "25 - 29", 1, "China", 0], ["Wrestling", 2, "25 - 29", 1, "Finland", 0], ["Football", 2, "25 - 29", 1, "Mexico", 1], ["Figure Skating", 2, "25 - 29", 1, "Germany", 0], ["Weightlifting", 2, "25 - 29", 2, "Georgia", 1], ["Weightlifting", 2, "25 - 29", 2, "Turkey", 1], ["Weightlifting", 2, "25 - 29", 1, "Germany", 1], ["Weightlifting", 2, "25 - 29", 2, "Iran", 1], ["Football", 2, "25 - 29", 19, "Germany", 0], ["Weightlifting", 2, "25 - 29", 2, "Poland", 0], ["Figure Skating", 2, "25 - 29", 9, "Russia", 3], ["Football", 2, "25 - 29", 1, "Nigeria", 0], ["Weightlifting", 2, "25 - 29", 1, "Cuba", 0], ["Weightlifting", 2, "25 - 29", 1, "France", 0], ["Weightlifting", 2, "25 - 29", 3, "Chinese Taipei", 0], ["Weightlifting", 2, "25 - 29", 2, "Colombia", 0], ["Weightlifting", 2, "25 - 29", 10, "Russia", 0], ["Football", 2, "25 - 29", 1, "Argentina", 1], ["Weightlifting", 2, "25 - 29", 1, "Ukraine", 1], ["Football", 2, "25 - 29", 1, "Italy", 0], ["Weightlifting", 2, "25 - 29", 1, "Japan", 0], ["Weightlifting", 2, "25 - 29", 4, "Kazakhstan", 2], ["Weightlifting", 2, "25 - 29", 12, "China", 10], ["Weightlifting", 2, "25 - 29", 5, "Belarus", 0], ["Weightlifting", 2, "25 - 29", 3, "Armenia", 0], ["Football", 2, "25 - 29", 8, "Norway", 8], ["Weightlifting", 2, "25 - 29", 1, "Canada", 0], ["Football", 2, "25 - 29", 1, "Chile", 0], ["Football", 2, "25 - 29", 2, "Cameroon", 2], ["Rowing", 3, "30 - 34", 1, "Greece", 0], ["Football", 3, "30 - 34", 2, "Norway", 2], ["Football", 3, "30 - 34", 3, "Paraguay", 0], ["Football", 3, "30 - 34", 3, "Argentina", 3], ["Football", 3, "30 - 34", 8, "Germany", 0], ["Weightlifting", 3, "30 - 34", 1, "Latvia", 0], ["Football", 3, "30 - 34", 6, "Brazil", 0], ["Figure Skating", 3, "30 - 34", 4, "China", 1], ["Weightlifting", 3, "30 - 34", 2, "Greece", 1], ["Figure Skating", 3, "30 - 34", 1, "Germany", 0], ["Football", 3, "30 - 34", 16, "United States", 14], ["Snowboarding", 3, "30 - 34", 1, "France", 0], ["Figure Skating", 3, "30 - 34", 2, "Ukraine", 0], ["Football", 3, "30 - 34", 5, "Canada", 0], ["Figure Skating", 3, "30 - 34", 1, "Russia", 1], ["Badminton", 3, "30 - 34", 1, "South Korea", 0], ["Weightlifting", 3, "30 - 34", 1, "Turkey", 1], ["Weightlifting", 3, "30 - 34", 2, "Croatia", 1], ["Football", 3, "30 - 34", 2, "Mexico", 2], ["Figure Skating", 3, "30 - 34", 1, "Italy", 0], ["Wrestling", 3, "30 - 34", 1, "Finland", 0], ["Weightlifting", 3, "30 - 34", 1, "Russia", 0], ["Snowboarding", 3, "30 - 34", 2, "Canada", 2], ["Wrestling", 3, "30 - 34", 1, "Bulgaria", 0], ["Weightlifting", 3, "30 - 34", 1, "Ukraine", 0], ["Football", 3, "30 - 34", 2, "Japan", 0], ["Freestyle Skiing", 3, "30 - 34", 3, "Norway", 0], ["Wrestling", 3, "30 - 34", 1, "Hungary", 1], ["Freestyle Skiing", 3, "30 - 34", 1, "Belarus", 1], ["Gymnastics", 3, "30 - 34", 1, "Hungary", 1], ["Weightlifting", 3, "30 - 34", 2, "Germany", 0], ["Gymnastics", 3, "30 - 34", 1, "United States", 0], ["Wrestling", 3, "30 - 34", 1, "France", 0], ["Weightlifting", 3, "30 - 34", 1, "Hungary", 0], ["Gymnastics", 3, "30 - 34", 1, "Germany", 0], ["Badminton", 3, "30 - 34", 3, "Indonesia", 0], ["Wrestling", 3, "30 - 34", 3, "Russia", 1], ["Freestyle Skiing", 3, "30 - 34", 1, "Australia", 0], ["Gymnastics", 3, "30 - 34", 1, "Poland", 1], ["Waterpolo", 3, "30 - 34", 2, "Croatia", 2], ["Gymnastics", 3, "30 - 34", 2, "Italy", 0], ["Waterpolo", 3, "30 - 34", 10, "Italy", 6], ["Freestyle Skiing", 3, "30 - 34", 1, "France", 0], ["Handball", 3, "30 - 34", 2, "Denmark", 2], ["Swimming", 3, "30 - 34", 4, "United States", 5], ["Snowboarding", 3, "30 - 34", 1, "Netherlands", 1], ["Handball", 3, "30 - 34", 6, "Hungary", 0], ["Handball", 3, "30 - 34", 3, "Ukraine", 0], ["Snowboarding", 3, "30 - 34", 2, "United States", 1], ["Swimming", 3, "30 - 34", 2, "Netherlands", 1], ["Snowboarding", 3, "30 - 34", 1, "Switzerland", 1], ["Waterpolo", 3, "30 - 34", 5, "Australia", 2], ["Fencing", 3, "30 - 34", 5, "South Korea", 1], ["Snowboarding", 3, "30 - 34", 1, "Austria", 0], ["Handball", 3, "30 - 34", 6, "Germany", 0], ["Badminton", 3, "30 - 34", 2, "China", 2], ["Wrestling", 3, "30 - 34", 2, "Turkey", 0], ["Badminton", 3, "30 - 34", 3, "Denmark", 0], ["Wrestling", 3, "30 - 34", 1, "Tajikistan", 0], ["Waterpolo", 3, "30 - 34", 9, "United States", 2], ["Fencing", 3, "30 - 34", 3, "United States", 0], ["Handball", 3, "30 - 34", 12, "Russia", 4], ["Fencing", 3, "30 - 34", 5, "China", 1], ["Handball", 3, "30 - 34", 2, "Iceland", 0], ["Handball", 3, "30 - 34", 7, "South Korea", 0], ["Waterpolo", 3, "30 - 34", 6, "Serbia", 0], ["Softball", 3, "30 - 34", 12, "Australia", 0], ["Fencing", 3, "30 - 34", 4, "Germany", 0], ["Basketball", 3, "30 - 34", 1, "Brazil", 0], ["Fencing", 3, "30 - 34", 2, "Romania", 0], ["Fencing", 3, "30 - 34", 1, "Spain", 0], ["Fencing", 3, "30 - 34", 2, "Poland", 0], ["Softball", 3, "30 - 34", 7, "Japan", 1], ["Waterpolo", 3, "30 - 34", 9, "Hungary", 9], ["Waterpolo", 3, "30 - 34", 1, "Netherlands", 1], ["Basketball", 3, "30 - 34", 1, "Lithuania", 0], ["Cycling", 3, "30 - 34", 3, "Netherlands", 4], ["Handball", 3, "30 - 34", 2, "Montenegro", 0], ["Wrestling", 3, "30 - 34", 1, "Uzbekistan", 1], ["Ski Jumping", 3, "30 - 34", 1, "Austria", 1], ["Fencing", 3, "30 - 34", 6, "Russia", 2], ["Fencing", 3, "30 - 34", 4, "Hungary", 2], ["Basketball", 3, "30 - 34", 3, "Italy", 0], ["Wrestling", 3, "30 - 34", 2, "Japan", 1], ["Ski Jumping", 3, "30 - 34", 3, "Germany", 0], ["Handball", 3, "30 - 34", 11, "France", 11], ["Fencing", 3, "30 - 34", 2, "Cuba", 0], ["Wrestling", 3, "30 - 34", 2, "Kazakhstan", 0], ["Softball", 3, "30 - 34", 7, "United States", 4], ["Waterpolo", 3, "30 - 34", 4, "Greece", 0], ["Speed Skating", 3, "30 - 34", 1, "Norway", 0], ["Skeleton", 3, "30 - 34", 1, "Canada", 1], ["Basketball", 3, "30 - 34", 8, "Argentina", 4], ["Skeleton", 3, "30 - 34", 1, "Germany", 0], ["Speed Skating", 3, "30 - 34", 1, "China", 0], ["Equestrian", 3, "30 - 34", 2, "Switzerland", 1], ["Basketball", 3, "30 - 34", 7, "Russia", 0], ["Skeleton", 3, "30 - 34", 2, "Switzerland", 1], ["Equestrian", 3, "30 - 34", 1, "Ireland", 0], ["Speed Skating", 3, "30 - 34", 1, "Italy", 1], ["Equestrian", 3, "30 - 34", 4, "Great Britain", 0], ["Basketball", 3, "30 - 34", 5, "France", 0], ["Equestrian", 3, "30 - 34", 1, "New Zealand", 0], ["Skeleton", 3, "30 - 34", 2, "United States", 1], ["Basketball", 3, "30 - 34", 6, "Spain", 0], ["Handball", 3, "30 - 34", 6, "Norway", 5], ["Basketball", 3, "30 - 34", 22, "United States", 22], ["Basketball", 3, "30 - 34", 11, "Australia", 0], ["Handball", 3, "30 - 34", 17, "Spain", 0], ["Equestrian", 3, "30 - 34", 2, "Denmark", 0], ["Shooting", 3, "30 - 34", 2, "Poland", 1], ["Shooting", 3, "30 - 34", 6, "China", 3], ["Equestrian", 3, "30 - 34", 1, "Australia", 0], ["Shooting", 3, "30 - 34", 1, "Belgium", 0], ["Beach Volleyball", 3, "30 - 34", 1, "Switzerland", 0], ["Beach Volleyball", 3, "30 - 34", 1, "Spain", 0], ["Shooting", 3, "30 - 34", 3, "United States", 1], ["Shooting", 3, "30 - 34", 5, "Italy", 1], ["Handball", 3, "30 - 34", 7, "Croatia", 3], ["Speed Skating", 3, "30 - 34", 2, "Russia", 1], ["Equestrian", 3, "30 - 34", 2, "France", 2], ["Speed Skating", 3, "30 - 34", 1, "Poland", 0], ["Equestrian", 3, "30 - 34", 1, "Sweden", 0], ["Nordic Combined", 3, "30 - 34", 3, "Austria", 4], ["Equestrian", 3, "30 - 34", 1, "Brazil", 1], ["Beach Volleyball", 3, "30 - 34", 7, "Brazil", 1], ["Beach Volleyball", 3, "30 - 34", 8, "United States", 5], ["Handball", 3, "30 - 34", 10, "Sweden", 0], ["Beach Volleyball", 3, "30 - 34", 4, "Germany", 2], ["Waterpolo", 3, "30 - 34", 10, "Russia", 0], ["Equestrian", 3, "30 - 34", 1, "Saudi Arabia", 0], ["Biathlon", 3, "30 - 34", 1, "Poland", 0], ["Biathlon", 3, "30 - 34", 1, "Belarus", 0], ["Waterpolo", 3, "30 - 34", 3, "Serbia and Montenegro", 0], ["Shooting", 3, "30 - 34", 1, "Serbia", 0], ["Biathlon", 3, "30 - 34", 1, "Slovakia", 0], ["Bobsleigh", 3, "30 - 34", 1, "Russia", 0], ["Wrestling", 3, "30 - 34", 1, "Cuba", 0], ["Wrestling", 3, "30 - 34", 2, "Sweden", 1], ["Shooting", 3, "30 - 34", 1, "Czech Republic", 1], ["Diving", 3, "30 - 34", 1, "United States", 0], ["Cycling", 3, "30 - 34", 10, "Great Britain", 7], ["Shooting", 3, "30 - 34", 1, "Mongolia", 0], ["Diving", 3, "30 - 34", 1, "Canada", 0], ["Hockey", 3, "30 - 34", 5, "China", 0], ["Hockey", 3, "30 - 34", 3, "Spain", 0], ["Hockey", 3, "30 - 34", 9, "Germany", 6], ["Hockey", 3, "30 - 34", 5, "Great Britain", 0], ["Wrestling", 3, "30 - 34", 3, "Canada", 0], ["Volleyball", 3, "30 - 34", 14, "Italy", 0], ["Wrestling", 3, "30 - 34", 4, "Georgia", 1], ["Bobsleigh", 3, "30 - 34", 6, "United States", 1], ["Volleyball", 3, "30 - 34", 12, "United States", 6], ["Wrestling", 3, "30 - 34", 1, "Egypt", 0], ["Diving", 3, "30 - 34", 1, "Australia", 0], ["Shooting", 3, "30 - 34", 2, "Ukraine", 2], ["Hockey", 3, "30 - 34", 15, "Australia", 6], ["Volleyball", 3, "30 - 34", 20, "Brazil", 8], ["Bobsleigh", 3, "30 - 34", 5, "Canada", 1], ["Cross Country Skiing", 3, "30 - 34", 8, "Italy", 6], ["Boxing", 3, "30 - 34", 1, "Spain", 0], ["Hockey", 3, "30 - 34", 11, "Argentina", 0], ["Hockey", 3, "30 - 34", 19, "Netherlands", 9], ["Wrestling", 3, "30 - 34", 4, "United States", 0], ["Cycling", 3, "30 - 34", 6, "United States", 1], ["Biathlon", 3, "30 - 34", 4, "Norway", 1], ["Biathlon", 3, "30 - 34", 10, "Germany", 3], ["Athletics", 3, "30 - 34", 21, "United States", 7], ["Ice Hockey", 3, "30 - 34", 4, "Russia", 0], ["Volleyball", 3, "30 - 34", 12, "Russia", 2], ["Volleyball", 3, "30 - 34", 3, "Japan", 0], ["Shooting", 3, "30 - 34", 2, "Australia", 1], ["Alpine Skiing", 3, "30 - 34", 1, "United States", 1], ["Boxing", 3, "30 - 34", 1, "Uzbekistan", 0], ["Alpine Skiing", 3, "30 - 34", 5, "Austria", 3], ["Shooting", 3, "30 - 34", 1, "Slovakia", 0], ["Table Tennis", 3, "30 - 34", 1, "China", 1], ["Cycling", 3, "30 - 34", 1, "Canada", 0], ["Cycling", 3, "30 - 34", 4, "France", 1], ["Boxing", 3, "30 - 34", 1, "Egypt", 0], ["Archery", 3, "30 - 34", 2, "South Korea", 2], ["Cycling", 3, "30 - 34", 1, "Cuba", 0], ["Alpine Skiing", 3, "30 - 34", 3, "Norway", 3], ["Tennis", 3, "30 - 34", 6, "United States", 5], ["Ice Hockey", 3, "30 - 34", 11, "Czech Republic", 0], ["Alpine Skiing", 3, "30 - 34", 1, "Croatia", 0], ["Short-Track Speed Skating", 3, "30 - 34", 1, "China", 0], ["Ice Hockey", 3, "30 - 34", 10, "Sweden", 8], ["Shooting", 3, "30 - 34", 1, "Germany", 1], ["Shooting", 3, "30 - 34", 1, "Spain", 0], ["Volleyball", 3, "30 - 34", 4, "Cuba", 2], ["Cycling", 3, "30 - 34", 5, "Spain", 2], ["Shooting", 3, "30 - 34", 1, "India", 0], ["Volleyball", 3, "30 - 34", 2, "Serbia and Montenegro", 2], ["Boxing", 3, "30 - 34", 4, "Cuba", 2], ["Boxing", 3, "30 - 34", 1, "Mauritius", 0], ["Athletics", 3, "30 - 34", 2, "Poland", 3], ["Athletics", 3, "30 - 34", 4, "Bahamas", 3], ["Cycling", 3, "30 - 34", 4, "Italy", 3], ["Short-Track Speed Skating", 3, "30 - 34", 3, "Canada", 0], ["Shooting", 3, "30 - 34", 1, "Kuwait", 0], ["Cycling", 3, "30 - 34", 1, "Norway", 1], ["Cycling", 3, "30 - 34", 1, "Mexico", 0], ["Ice Hockey", 3, "30 - 34", 20, "United States", 0], ["Cycling", 3, "30 - 34", 1, "China", 0], ["Cycling", 3, "30 - 34", 1, "Belgium", 0], ["Synchronized Swimming", 3, "30 - 34", 2, "Spain", 0], ["Athletics", 3, "30 - 34", 6, "Great Britain", 4], ["Shooting", 3, "30 - 34", 2, "Sweden", 2], ["Cycling", 3, "30 - 34", 1, "Switzerland", 0], ["Ice Hockey", 3, "30 - 34", 22, "Canada", 22], ["Boxing", 3, "30 - 34", 1, "China", 1], ["Boxing", 3, "30 - 34", 1, "Mongolia", 0], ["Ice Hockey", 3, "30 - 34", 19, "Finland", 0], ["Table Tennis", 3, "30 - 34", 2, "Germany", 0], ["Boxing", 3, "30 - 34", 3, "Russia", 1], ["Synchronized Swimming", 3, "30 - 34", 1, "United States", 0], ["Table Tennis", 3, "30 - 34", 3, "South Korea", 0], ["Judo", 3, "30 - 34", 2, "Italy", 0], ["Table Tennis", 3, "30 - 34", 2, "Singapore", 0], ["Shooting", 3, "30 - 34", 1, "Lithuania", 1], ["Boxing", 3, "30 - 34", 2, "Thailand", 1], ["Shooting", 3, "30 - 34", 1, "Belarus", 0], ["Shooting", 3, "30 - 34", 1, "Moldova", 0], ["Speed Skating", 3, "30 - 34", 5, "Canada", 2], ["Judo", 3, "30 - 34", 1, "Estonia", 0], ["Shooting", 3, "30 - 34", 1, "Serbia and Montenegro", 0], ["Judo", 3, "30 - 34", 1, "United States", 0], ["Curling", 3, "30 - 34", 4, "Canada", 1], ["Speed Skating", 3, "30 - 34", 2, "United States", 1], ["Speed Skating", 3, "30 - 34", 6, "Germany", 4], ["Judo", 3, "30 - 34", 3, "Cuba", 0], ["Curling", 3, "30 - 34", 8, "Switzerland", 0], ["Judo", 3, "30 - 34", 2, "China", 1], ["Table Tennis", 3, "30 - 34", 1, "Chinese Taipei", 0], ["Speed Skating", 3, "30 - 34", 5, "Netherlands", 2], ["Curling", 3, "30 - 34", 3, "Finland", 0], ["Curling", 3, "30 - 34", 2, "Sweden", 2], ["Table Tennis", 3, "30 - 34", 2, "France", 0], ["Curling", 3, "30 - 34", 1, "United States", 0], ["Judo", 3, "30 - 34", 2, "Japan", 1], ["Sailing", 3, "30 - 34", 4, "Netherlands", 0], ["Curling", 3, "30 - 34", 3, "Great Britain", 3], ["Table Tennis", 3, "30 - 34", 1, "Sweden", 0], ["Ski Jumping", 3, "30 - 34", 1, "Poland", 0], ["Curling", 3, "30 - 34", 2, "Norway", 2], ["Boxing", 3, "30 - 34", 3, "Italy", 0], ["Swimming", 3, "30 - 34", 1, "Australia", 0], ["Athletics", 3, "30 - 34", 7, "Jamaica", 1], ["Sailing", 3, "30 - 34", 13, "Great Britain", 6], ["Athletics", 3, "30 - 34", 18, "Russia", 8], ["Cross Country Skiing", 3, "30 - 34", 1, "Slovenia", 0], ["Triathlon", 3, "30 - 34", 2, "New Zealand", 1], ["Triathlon", 3, "30 - 34", 1, "Canada", 0], ["Judo", 3, "30 - 34", 1, "Azerbaijan", 0], ["Biathlon", 3, "30 - 34", 3, "Sweden", 2], ["Triathlon", 3, "30 - 34", 1, "Austria", 1], ["Biathlon", 3, "30 - 34", 7, "France", 1], ["Biathlon", 3, "30 - 34", 6, "Russia", 5], ["Sailing", 3, "30 - 34", 3, "Denmark", 0], ["Boxing", 3, "30 - 34", 1, "Brazil", 0], ["Biathlon", 3, "30 - 34", 3, "Austria", 0], ["Judo", 3, "30 - 34", 1, "Switzerland", 0], ["Shooting", 3, "30 - 34", 2, "South Korea", 2], ["Judo", 3, "30 - 34", 1, "Slovenia", 1], ["Triathlon", 3, "30 - 34", 1, "Australia", 0], ["Judo", 3, "30 - 34", 1, "Hungary", 0], ["Judo", 3, "30 - 34", 1, "South Korea", 1], ["Judo", 3, "30 - 34", 2, "Russia", 0], ["Trampoline", 3, "30 - 34", 1, "Germany", 1], ["Trampoline", 3, "30 - 34", 2, "Russia", 1], ["Athletics", 3, "30 - 34", 3, "Estonia", 1], ["Athletics", 3, "30 - 34", 6, "Kenya", 1], ["Bobsleigh", 3, "30 - 34", 4, "Switzerland", 0], ["Swimming", 3, "30 - 34", 2, "Germany", 0], ["Athletics", 3, "30 - 34", 1, "Slovenia", 0], ["Judo", 3, "30 - 34", 4, "France", 2], ["Bobsleigh", 3, "30 - 34", 7, "Germany", 5], ["Athletics", 3, "30 - 34", 2, "China", 0], ["Judo", 3, "30 - 34", 1, "Great Britain", 0], ["Judo", 3, "30 - 34", 3, "Netherlands", 0], ["Judo", 3, "30 - 34", 3, "Germany", 0], ["Shooting", 3, "30 - 34", 7, "Russia", 1], ["Canoeing", 3, "30 - 34", 2, "Norway", 2], ["Athletics", 3, "30 - 34", 5, "Germany", 0], ["Judo", 3, "30 - 34", 1, "North Korea", 1], ["Athletics", 3, "30 - 34", 1, "Hungary", 1], ["Baseball", 3, "30 - 34", 3, "Australia", 0], ["Baseball", 3, "30 - 34", 9, "Japan", 0], ["Luge", 3, "30 - 34", 2, "United States", 0], ["Shooting", 3, "30 - 34", 1, "Bulgaria", 1], ["Athletics", 3, "30 - 34", 1, "Dominican Republic", 1], ["Luge", 3, "30 - 34", 3, "Italy", 1], ["Canoeing", 3, "30 - 34", 3, "Russia", 0], ["Luge", 3, "30 - 34", 1, "Russia", 0], ["Sailing", 3, "30 - 34", 1, "Poland", 0], ["Athletics", 3, "30 - 34", 2, "Czech Republic", 2], ["Sailing", 3, "30 - 34", 2, "Sweden", 0], ["Luge", 3, "30 - 34", 4, "Germany", 1], ["Modern Pentathlon", 3, "30 - 34", 1, "Czech Republic", 0], ["Baseball", 3, "30 - 34", 17, "Cuba", 7], ["Baseball", 3, "30 - 34", 8, "South Korea", 4], ["Athletics", 3, "30 - 34", 1, "Trinidad and Tobago", 0], ["Athletics", 3, "30 - 34", 3, "Morocco", 0], ["Modern Pentathlon", 3, "30 - 34", 1, "Lithuania", 0], ["Athletics", 3, "30 - 34", 2, "Greece", 0], ["Athletics", 3, "30 - 34", 4, "Belarus", 0], ["Baseball", 3, "30 - 34", 9, "United States", 3], ["Sailing", 3, "30 - 34", 4, "Australia", 1], ["Canoeing", 3, "30 - 34", 7, "Germany", 3], ["Athletics", 3, "30 - 34", 2, "Belgium", 1], ["Sailing", 3, "30 - 34", 2, "Greece", 1], ["Modern Pentathlon", 3, "30 - 34", 1, "China", 0], ["Canoeing", 3, "30 - 34", 5, "Great Britain", 3], ["Nordic Combined", 3, "30 - 34", 1, "Finland", 1], ["Taekwondo", 3, "30 - 34", 1, "Spain", 0], ["Nordic Combined", 3, "30 - 34", 1, "United States", 0], ["Taekwondo", 3, "30 - 34", 1, "Iran", 1], ["Taekwondo", 3, "30 - 34", 1, "Venezuela", 0], ["Taekwondo", 3, "30 - 34", 1, "France", 0], ["Athletics", 3, "30 - 34", 4, "Ukraine", 1], ["Canoeing", 3, "30 - 34", 1, "Romania", 0], ["Athletics", 3, "30 - 34", 1, "Brazil", 1], ["Rowing", 3, "30 - 34", 1, "Lithuania", 0], ["Athletics", 3, "30 - 34", 1, "Cameroon", 1], ["Rowing", 3, "30 - 34", 4, "France", 3], ["Rowing", 3, "30 - 34", 7, "Romania", 8], ["Sailing", 3, "30 - 34", 5, "Spain", 1], ["Athletics", 3, "30 - 34", 1, "Ecuador", 0], ["Rowing", 3, "30 - 34", 2, "Croatia", 0], ["Rowing", 3, "30 - 34", 2, "Russia", 2], ["Canoeing", 3, "30 - 34", 9, "Hungary", 5], ["Sailing", 3, "30 - 34", 2, "France", 0], ["Tennis", 3, "30 - 34", 2, "France", 0], ["Rowing", 3, "30 - 34", 1, "Bulgaria", 0], ["Rowing", 3, "30 - 34", 12, "Netherlands", 1], ["Cross Country Skiing", 3, "30 - 34", 2, "Estonia", 1], ["Tennis", 3, "30 - 34", 1, "Switzerland", 0], ["Athletics", 3, "30 - 34", 1, "Lithuania", 1], ["Athletics", 3, "30 - 34", 1, "France", 0], ["Synchronized Swimming", 3, "30 - 34", 2, "Russia", 2], ["Athletics", 3, "30 - 34", 2, "Italy", 1], ["Rowing", 3, "30 - 34", 1, "Norway", 1], ["Sailing", 3, "30 - 34", 3, "Italy", 1], ["Canoeing", 3, "30 - 34", 3, "Ukraine", 0], ["Cross Country Skiing", 3, "30 - 34", 8, "Norway", 3], ["Rowing", 3, "30 - 34", 7, "Italy", 1], ["Football", 3, "30 - 34", 2, "Chile", 0], ["Rowing", 3, "30 - 34", 2, "Finland", 0], ["Rowing", 3, "30 - 34", 3, "Poland", 3], ["Cross Country Skiing", 3, "30 - 34", 3, "Sweden", 2], ["Canoeing", 3, "30 - 34", 3, "Italy", 2], ["Athletics", 3, "30 - 34", 1, "Denmark", 0], ["Tennis", 3, "30 - 34", 1, "Australia", 0], ["Canoeing", 3, "30 - 34", 3, "Poland", 0], ["Canoeing", 3, "30 - 34", 1, "Austria", 0], ["Cross Country Skiing", 3, "30 - 34", 3, "Finland", 0], ["Canoeing", 3, "30 - 34", 1, "China", 1], ["Canoeing", 3, "30 - 34", 1, "Denmark", 0], ["Sailing", 3, "30 - 34", 1, "Slovenia", 0], ["Gymnastics", 3, "30 - 34", 1, "Bulgaria", 0], ["Cross Country Skiing", 3, "30 - 34", 7, "Germany", 1], ["Rowing", 3, "30 - 34", 2, "Belarus", 0], ["Sailing", 3, "30 - 34", 1, "Argentina", 0], ["Canoeing", 3, "30 - 34", 2, "Canada", 0], ["Cross Country Skiing", 3, "30 - 34", 4, "Czech Republic", 1], ["Cycling", 3, "30 - 34", 5, "Australia", 2], ["Cycling", 3, "30 - 34", 7, "Germany", 3], ["Athletics", 3, "30 - 34", 1, "Ethiopia", 0], ["Canoeing", 3, "30 - 34", 2, "Czech Republic", 1], ["Canoeing", 3, "30 - 34", 5, "Australia", 1], ["Sailing", 3, "30 - 34", 3, "Ukraine", 0], ["Athletics", 3, "30 - 34", 1, "Nigeria", 1], ["Canoeing", 3, "30 - 34", 5, "Slovakia", 1], ["Tennis", 3, "30 - 34", 1, "Russia", 0], ["Sailing", 3, "30 - 34", 2, "Brazil", 1], ["Fencing", 3, "30 - 34", 14, "Italy", 6], ["Sailing", 3, "30 - 34", 1, "Canada", 0], ["Rowing", 3, "30 - 34", 2, "Slovenia", 0], ["Canoeing", 3, "30 - 34", 2, "France", 1], ["Cycling", 3, "30 - 34", 5, "Russia", 1], ["Tennis", 3, "30 - 34", 1, "Belgium", 0], ["Fencing", 3, "30 - 34", 9, "France", 6], ["Rowing", 3, "30 - 34", 6, "Denmark", 5], ["Canoeing", 3, "30 - 34", 3, "Belarus", 0], ["Athletics", 3, "30 - 34", 1, "Ireland", 0], ["Athletics", 3, "30 - 34", 2, "Cuba", 0], ["Athletics", 3, "30 - 34", 1, "Portugal", 0], ["Sailing", 3, "30 - 34", 2, "Austria", 2], ["Athletics", 3, "30 - 34", 1, "Kazakhstan", 1], ["Sailing", 3, "30 - 34", 2, "Finland", 2], ["Athletics", 3, "30 - 34", 1, "Norway", 1], ["Rowing", 3, "30 - 34", 2, "South Africa", 1], ["Rowing", 3, "30 - 34", 9, "Germany", 5], ["Alpine Skiing", 3, "30 - 34", 2, "Switzerland", 1], ["Tennis", 3, "30 - 34", 2, "Sweden", 0], ["Rowing", 3, "30 - 34", 1, "Czech Republic", 1], ["Tennis", 3, "30 - 34", 3, "Spain", 0], ["Cross Country Skiing", 3, "30 - 34", 1, "Austria", 0], ["Diving", 3, "30 - 34", 4, "Russia", 0], ["Cross Country Skiing", 3, "30 - 34", 2, "Switzerland", 0], ["Rowing", 3, "30 - 34", 20, "Great Britain", 7], ["Alpine Skiing", 3, "30 - 34", 1, "France", 0], ["Cross Country Skiing", 3, "30 - 34", 1, "Canada", 0], ["Rowing", 3, "30 - 34", 3, "New Zealand", 2], ["Rowing", 3, "30 - 34", 3, "Ukraine", 1], ["Rowing", 3, "30 - 34", 8, "United States", 3], ["Equestrian", 3, "30 - 34", 4, "Germany", 3], ["Fencing", 3, "30 - 34", 1, "Switzerland", 0], ["Sailing", 3, "30 - 34", 1, "New Zealand", 0], ["Cross Country Skiing", 3, "30 - 34", 2, "Russia", 2], ["Archery", 3, "30 - 34", 1, "Germany", 0], ["Rowing", 3, "30 - 34", 11, "Australia", 1], ["Equestrian", 3, "30 - 34", 5, "United States", 1], ["Equestrian", 3, "30 - 34", 5, "Netherlands", 1], ["Archery", 3, "30 - 34", 1, "Ukraine", 0], ["Rowing", 3, "30 - 34", 17, "Canada", 4], ["Archery", 3, "30 - 34", 1, "Australia", 1], ["Archery", 3, "30 - 34", 1, "Russia", 0], ["Archery", 3, "30 - 34", 1, "Great Britain", 0], ["Archery", 3, "30 - 34", 1, "France", 0], ["Sailing", 3, "30 - 34", 1, "Norway", 0], ["Triathlon", 3, "30 - 34", 2, "Switzerland", 2], ["Equestrian", 4, "35 - 39", 5, "Germany", 5], ["Figure Skating", 4, "35 - 39", 1, "China", 1], ["Weightlifting", 4, "35 - 39", 2, "Colombia", 1], ["Football", 4, "35 - 39", 4, "United States", 4], ["Softball", 4, "35 - 39", 1, "Japan", 0], ["Waterpolo", 4, "35 - 39", 3, "Croatia", 3], ["Wrestling", 4, "35 - 39", 1, "Slovakia", 0], ["Tennis", 4, "35 - 39", 1, "Argentina", 0], ["Softball", 4, "35 - 39", 2, "United States", 2], ["Archery", 4, "35 - 39", 1, "Germany", 0], ["Handball", 4, "35 - 39", 1, "Norway", 0], ["Equestrian", 4, "35 - 39", 1, "Spain", 0], ["Equestrian", 4, "35 - 39", 8, "Great Britain", 1], ["Equestrian", 4, "35 - 39", 6, "United States", 3], ["Handball", 4, "35 - 39", 2, "Germany", 0], ["Cross Country Skiing", 4, "35 - 39", 3, "Italy", 1], ["Archery", 4, "35 - 39", 1, "Italy", 1], ["Cross Country Skiing", 4, "35 - 39", 1, "Austria", 0], ["Sailing", 4, "35 - 39", 1, "Ukraine", 0], ["Handball", 4, "35 - 39", 4, "Russia", 3], ["Waterpolo", 4, "35 - 39", 1, "Italy", 0], ["Handball", 4, "35 - 39", 1, "Iceland", 0], ["Sailing", 4, "35 - 39", 1, "Norway", 0], ["Handball", 4, "35 - 39", 2, "South Korea", 0], ["Cross Country Skiing", 4, "35 - 39", 1, "Estonia", 1], ["Rowing", 4, "35 - 39", 7, "Australia", 2], ["Rowing", 4, "35 - 39", 3, "Great Britain", 2], ["Cycling", 4, "35 - 39", 5, "Great Britain", 3], ["Athletics", 4, "35 - 39", 1, "Mexico", 0], ["Rowing", 4, "35 - 39", 1, "Canada", 0], ["Rowing", 4, "35 - 39", 2, "Italy", 0], ["Sailing", 4, "35 - 39", 1, "Germany", 0], ["Basketball", 4, "35 - 39", 1, "Brazil", 0], ["Waterpolo", 4, "35 - 39", 1, "Hungary", 1], ["Fencing", 4, "35 - 39", 6, "Italy", 3], ["Tennis", 4, "35 - 39", 1, "United States", 0], ["Wrestling", 4, "35 - 39", 1, "Spain", 0], ["Cycling", 4, "35 - 39", 2, "Spain", 1], ["Fencing", 4, "35 - 39", 2, "Russia", 2], ["Athletics", 4, "35 - 39", 1, "Germany", 1], ["Sailing", 4, "35 - 39", 1, "France", 0], ["Athletics", 4, "35 - 39", 1, "Bahamas", 1], ["Sailing", 4, "35 - 39", 1, "Canada", 0], ["Canoeing", 4, "35 - 39", 1, "Norway", 1], ["Sailing", 4, "35 - 39", 6, "United States", 0], ["Rowing", 4, "35 - 39", 1, "Germany", 0], ["Fencing", 4, "35 - 39", 1, "Hungary", 0], ["Sailing", 4, "35 - 39", 1, "Greece", 0], ["Sailing", 4, "35 - 39", 2, "Austria", 2], ["Athletics", 4, "35 - 39", 3, "Belarus", 1], ["Cycling", 4, "35 - 39", 2, "Russia", 1], ["Handball", 4, "35 - 39", 1, "Montenegro", 0], ["Rowing", 4, "35 - 39", 1, "Bulgaria", 1], ["Rowing", 4, "35 - 39", 2, "Denmark", 2], ["Athletics", 4, "35 - 39", 1, "Jamaica", 0], ["Softball", 4, "35 - 39", 5, "Australia", 0], ["Handball", 4, "35 - 39", 2, "Croatia", 1], ["Waterpolo", 4, "35 - 39", 1, "Netherlands", 1], ["Canoeing", 4, "35 - 39", 1, "Slovakia", 1], ["Rowing", 4, "35 - 39", 6, "Romania", 4], ["Handball", 4, "35 - 39", 5, "Sweden", 0], ["Rowing", 4, "35 - 39", 1, "Belarus", 0], ["Athletics", 4, "35 - 39", 1, "Poland", 1], ["Rowing", 4, "35 - 39", 1, "Poland", 1], ["Athletics", 4, "35 - 39", 3, "Russia", 0], ["Sailing", 4, "35 - 39", 2, "Italy", 0], ["Tennis", 4, "35 - 39", 1, "Belarus", 1], ["Athletics", 4, "35 - 39", 1, "Brazil", 0], ["Canoeing", 4, "35 - 39", 5, "Italy", 1], ["Canoeing", 4, "35 - 39", 1, "Canada", 0], ["Rowing", 4, "35 - 39", 2, "Netherlands", 1], ["Sailing", 4, "35 - 39", 1, "Sweden", 0], ["Fencing", 4, "35 - 39", 1, "France", 0], ["Athletics", 4, "35 - 39", 1, "Norway", 0], ["Sailing", 4, "35 - 39", 2, "Denmark", 1], ["Rowing", 4, "35 - 39", 1, "Estonia", 0], ["Canoeing", 4, "35 - 39", 3, "Hungary", 2], ["Sailing", 4, "35 - 39", 1, "Spain", 1], ["Sailing", 4, "35 - 39", 2, "Australia", 1], ["Athletics", 4, "35 - 39", 1, "Kenya", 0], ["Basketball", 4, "35 - 39", 1, "Argentina", 0], ["Athletics", 4, "35 - 39", 1, "Morocco", 0], ["Modern Pentathlon", 4, "35 - 39", 1, "Lithuania", 0], ["Sailing", 4, "35 - 39", 4, "Brazil", 1], ["Basketball", 4, "35 - 39", 3, "United States", 3], ["Handball", 4, "35 - 39", 7, "France", 7], ["Athletics", 4, "35 - 39", 2, "Romania", 1], ["Shooting", 4, "35 - 39", 3, "Belarus", 0], ["Athletics", 4, "35 - 39", 1, "Ukraine", 0], ["Baseball", 4, "35 - 39", 1, "South Korea", 1], ["Baseball", 4, "35 - 39", 14, "Cuba", 1], ["Athletics", 4, "35 - 39", 1, "Lithuania", 0], ["Equestrian", 4, "35 - 39", 1, "Sweden", 0], ["Shooting", 4, "35 - 39", 5, "Russia", 1], ["Luge", 4, "35 - 39", 1, "Italy", 0], ["Baseball", 4, "35 - 39", 2, "Australia", 0], ["Luge", 4, "35 - 39", 3, "Germany", 1], ["Luge", 4, "35 - 39", 1, "Austria", 0], ["Canoeing", 4, "35 - 39", 1, "Germany", 2], ["Athletics", 4, "35 - 39", 2, "Japan", 0], ["Baseball", 4, "35 - 39", 1, "United States", 1], ["Skeleton", 4, "35 - 39", 2, "Canada", 1], ["Swimming", 4, "35 - 39", 1, "United States", 0], ["Bobsleigh", 4, "35 - 39", 3, "Germany", 3], ["Biathlon", 4, "35 - 39", 2, "Norway", 1], ["Athletics", 4, "35 - 39", 1, "Italy", 0], ["Triathlon", 4, "35 - 39", 1, "United States", 0], ["Sailing", 4, "35 - 39", 2, "Argentina", 0], ["Cross Country Skiing", 4, "35 - 39", 2, "Norway", 0], ["Snowboarding", 4, "35 - 39", 1, "France", 0], ["Curling", 4, "35 - 39", 1, "Switzerland", 0], ["Curling", 4, "35 - 39", 1, "Great Britain", 1], ["Curling", 4, "35 - 39", 1, "Finland", 0], ["Curling", 4, "35 - 39", 1, "United States", 0], ["Basketball", 4, "35 - 39", 5, "Australia", 0], ["Sailing", 4, "35 - 39", 4, "Great Britain", 2], ["Curling", 4, "35 - 39", 4, "Norway", 2], ["Handball", 4, "35 - 39", 4, "Spain", 0], ["Curling", 4, "35 - 39", 5, "Sweden", 5], ["Equestrian", 4, "35 - 39", 1, "New Zealand", 0], ["Table Tennis", 4, "35 - 39", 1, "South Korea", 0], ["Skeleton", 4, "35 - 39", 1, "Switzerland", 0], ["Shooting", 4, "35 - 39", 1, "Azerbaijan", 1], ["Speed Skating", 4, "35 - 39", 1, "Netherlands", 0], ["Shooting", 4, "35 - 39", 1, "Australia", 0], ["Shooting", 4, "35 - 39", 1, "Czech Republic", 0], ["Shooting", 4, "35 - 39", 1, "Bulgaria", 1], ["Beach Volleyball", 4, "35 - 39", 1, "Australia", 1], ["Beach Volleyball", 4, "35 - 39", 1, "United States", 0], ["Curling", 4, "35 - 39", 6, "Canada", 0], ["Shooting", 4, "35 - 39", 1, "United States", 0], ["Cycling", 4, "35 - 39", 1, "Italy", 0], ["Equestrian", 4, "35 - 39", 4, "Australia", 3], ["Beach Volleyball", 4, "35 - 39", 3, "Brazil", 0], ["Cycling", 4, "35 - 39", 1, "France", 0], ["Equestrian", 4, "35 - 39", 1, "Netherlands", 1], ["Shooting", 4, "35 - 39", 1, "Slovenia", 1], ["Cycling", 4, "35 - 39", 1, "Canada", 1], ["Shooting", 4, "35 - 39", 1, "Switzerland", 0], ["Cycling", 4, "35 - 39", 1, "Colombia", 0], ["Cycling", 4, "35 - 39", 1, "Netherlands", 0], ["Cycling", 4, "35 - 39", 2, "Switzerland", 0], ["Shooting", 4, "35 - 39", 1, "Serbia and Montenegro", 0], ["Shooting", 4, "35 - 39", 2, "Cuba", 1], ["Shooting", 4, "35 - 39", 1, "France", 0], ["Cycling", 4, "35 - 39", 1, "Argentina", 1], ["Ice Hockey", 4, "35 - 39", 7, "Finland", 0], ["Biathlon", 4, "35 - 39", 2, "Germany", 1], ["Ice Hockey", 4, "35 - 39", 7, "United States", 0], ["Shooting", 4, "35 - 39", 2, "Hungary", 1], ["Volleyball", 4, "35 - 39", 2, "Russia", 1], ["Volleyball", 4, "35 - 39", 4, "United States", 2], ["Biathlon", 4, "35 - 39", 1, "Russia", 0], ["Waterpolo", 4, "35 - 39", 2, "Russia", 0], ["Cycling", 4, "35 - 39", 1, "Kazakhstan", 1], ["Speed Skating", 4, "35 - 39", 1, "Japan", 0], ["Equestrian", 4, "35 - 39", 1, "Brazil", 0], ["Equestrian", 4, "35 - 39", 1, "Switzerland", 0], ["Ice Hockey", 4, "35 - 39", 1, "Czech Republic", 0], ["Shooting", 4, "35 - 39", 1, "Ukraine", 1], ["Ice Hockey", 4, "35 - 39", 4, "Sweden", 3], ["Shooting", 4, "35 - 39", 1, "Norway", 0], ["Shooting", 4, "35 - 39", 3, "Italy", 0], ["Bobsleigh", 4, "35 - 39", 1, "United States", 0], ["Shooting", 4, "35 - 39", 1, "Germany", 0], ["Bobsleigh", 4, "35 - 39", 1, "Italy", 0], ["Ice Hockey", 4, "35 - 39", 1, "Russia", 0], ["Waterpolo", 4, "35 - 39", 1, "United States", 0], ["Shooting", 4, "35 - 39", 3, "China", 0], ["Bobsleigh", 4, "35 - 39", 1, "Russia", 0], ["Speed Skating", 4, "35 - 39", 1, "Germany", 1], ["Volleyball", 4, "35 - 39", 3, "Brazil", 2], ["Cycling", 4, "35 - 39", 2, "Germany", 1], ["Shooting", 4, "35 - 39", 1, "Finland", 1], ["Shooting", 4, "35 - 39", 1, "Georgia", 0], ["Cycling", 4, "35 - 39", 3, "United States", 2], ["Bobsleigh", 4, "35 - 39", 2, "Canada", 0], ["Speed Skating", 4, "35 - 39", 1, "Canada", 0], ["Waterpolo", 4, "35 - 39", 1, "Serbia and Montenegro", 0], ["Volleyball", 4, "35 - 39", 4, "Italy", 0], ["Hockey", 4, "35 - 39", 2, "Netherlands", 1], ["Hockey", 4, "35 - 39", 1, "China", 0], ["Ice Hockey", 4, "35 - 39", 11, "Canada", 11], ["Rowing", 5, "40 - 44", 1, "Slovenia", 0], ["Ice Hockey", 5, "40 - 44", 1, "Russia", 0], ["Shooting", 5, "40 - 44", 1, "United Arab Emirates", 1], ["Equestrian", 5, "40 - 44", 1, "New Zealand", 0], ["Shooting", 5, "40 - 44", 1, "United States", 0], ["Ice Hockey", 5, "40 - 44", 1, "United States", 0], ["Cycling", 5, "40 - 44", 1, "Germany", 0], ["Biathlon", 5, "40 - 44", 1, "Norway", 1], ["Shooting", 5, "40 - 44", 1, "Italy", 1], ["Ice Hockey", 5, "40 - 44", 1, "Czech Republic", 0], ["Shooting", 5, "40 - 44", 2, "China", 1], ["Ice Hockey", 5, "40 - 44", 1, "Canada", 1], ["Cycling", 5, "40 - 44", 1, "Argentina", 1], ["Shooting", 5, "40 - 44", 1, "Azerbaijan", 0], ["Shooting", 5, "40 - 44", 1, "Germany", 1], ["Athletics", 5, "40 - 44", 1, "Jamaica", 0], ["Equestrian", 5, "40 - 44", 8, "Netherlands", 1], ["Shooting", 5, "40 - 44", 2, "Russia", 1], ["Cycling", 5, "40 - 44", 1, "Belgium", 0], ["Equestrian", 5, "40 - 44", 10, "United States", 3], ["Equestrian", 5, "40 - 44", 1, "Spain", 0], ["Shooting", 5, "40 - 44", 1, "Belarus", 1], ["Equestrian", 5, "40 - 44", 1, "France", 1], ["Equestrian", 5, "40 - 44", 2, "Sweden", 0], ["Equestrian", 5, "40 - 44", 1, "Switzerland", 0], ["Cycling", 5, "40 - 44", 1, "France", 0], ["Shooting", 5, "40 - 44", 1, "Finland", 0], ["Equestrian", 5, "40 - 44", 1, "Canada", 1], ["Shooting", 5, "40 - 44", 1, "Ukraine", 0], ["Shooting", 5, "40 - 44", 1, "Qatar", 0], ["Archery", 5, "40 - 44", 1, "Japan", 0], ["Curling", 5, "40 - 44", 1, "Switzerland", 0], ["Shooting", 5, "40 - 44", 1, "Great Britain", 0], ["Archery", 5, "40 - 44", 1, "Italy", 0], ["Curling", 5, "40 - 44", 1, "Sweden", 1], ["Sailing", 5, "40 - 44", 1, "Sweden", 1], ["Equestrian", 5, "40 - 44", 3, "Great Britain", 0], ["Swimming", 5, "40 - 44", 1, "United States", 0], ["Canoeing", 5, "40 - 44", 1, "Germany", 1], ["Sailing", 5, "40 - 44", 1, "Australia", 1], ["Sailing", 5, "40 - 44", 3, "Brazil", 1], ["Rowing", 5, "40 - 44", 1, "Canada", 0], ["Equestrian", 5, "40 - 44", 2, "Saudi Arabia", 0], ["Rowing", 5, "40 - 44", 1, "Estonia", 0], ["Canoeing", 5, "40 - 44", 1, "Italy", 0], ["Rowing", 5, "40 - 44", 2, "Romania", 1], ["Sailing", 5, "40 - 44", 3, "United States", 2], ["Sailing", 5, "40 - 44", 1, "Argentina", 0], ["Sailing", 5, "40 - 44", 1, "Denmark", 1], ["Sailing", 5, "40 - 44", 1, "Norway", 0], ["Rowing", 5, "40 - 44", 1, "Great Britain", 0], ["Rowing", 5, "40 - 44", 1, "Denmark", 0], ["Cross Country Skiing", 5, "40 - 44", 1, "Norway", 0], ["Equestrian", 5, "40 - 44", 9, "Germany", 8], ["Equestrian", 5, "40 - 44", 4, "Australia", 1], ["Handball", 5, "40 - 44", 2, "Russia", 0], ["Softball", 5, "40 - 44", 1, "Japan", 0], ["Curling", 5, "40 - 44", 6, "Canada", 1], ["Equestrian", 6, "45 - 49", 1, "Canada", 0], ["Equestrian", 6, "45 - 49", 6, "Germany", 6], ["Shooting", 6, "45 - 49", 1, "Kuwait", 0], ["Equestrian", 6, "45 - 49", 1, "Sweden", 0], ["Sailing", 6, "45 - 49", 1, "Argentina", 0], ["Equestrian", 6, "45 - 49", 3, "United States", 1], ["Shooting", 6, "45 - 49", 1, "Germany", 0], ["Equestrian", 6, "45 - 49", 3, "Switzerland", 0], ["Sailing", 6, "45 - 49", 2, "United States", 2], ["Curling", 6, "45 - 49", 4, "Canada", 1], ["Shooting", 6, "45 - 49", 1, "Azerbaijan", 0], ["Sailing", 6, "45 - 49", 1, "Germany", 0], ["Shooting", 6, "45 - 49", 2, "Slovenia", 0], ["Shooting", 6, "45 - 49", 1, "Norway", 0], ["Shooting", 6, "45 - 49", 1, "Sweden", 0], ["Equestrian", 6, "45 - 49", 1, "Brazil", 0], ["Equestrian", 6, "45 - 49", 2, "Spain", 0], ["Equestrian", 6, "45 - 49", 3, "Great Britain", 1], ["Shooting", 6, "45 - 49", 1, "Russia", 0], ["Shooting", 6, "45 - 49", 1, "Australia", 0], ["Archery", 6, "45 - 49", 1, "United States", 0], ["Equestrian", 6, "45 - 49", 1, "Denmark", 0], ["Rowing", 7, "50 - 55", 1, "Canada", 0], ["Equestrian", 7, "50 - 55", 3, "Great Britain", 2], ["Equestrian", 7, "50 - 55", 1, "New Zealand", 0], ["Equestrian", 7, "50 - 55", 1, "Germany", 1], ["Archery", 7, "50 - 55", 1, "Italy", 0], ["Equestrian", 7, "50 - 55", 1, "Canada", 0], ["Equestrian", 7, "50 - 55", 1, "France", 1], ["Equestrian", 8, "56 - 61", 1, "Canada", 0],
        ["Equestrian", 8, "56 - 61", 1, "New Zealand", 0]
    ].filter(function (row) {
            return [
                    'Volleyball',
                    'Hockey',
                    'Weightlifting',
                    'Equestrian'
                ].indexOf(row[0]) >= 0;
        }),
    "header": [
        "sport_3_89",
        "BINS_INDEX_age_4_100",
        "age_4_100",
        "row_number_5_57",
        "country_4_59",
        "gold_medals_5_52"
    ],
    "format": "x-array"
});