Nebular is a set of essential modules for your next Angular application.
Its primary goal is to assemble together and connect the most awesome features and libraries creating an efficient ecosystem to speed up and simplify the development.

In simpler words, Nebular is a set of modules (components, services & styles) helping you to solve generic tasks easier so that you can focus on business logic.
<hr class="section-end">

<div class="note note-info">
  <div class="note-title">Current state</div>
  <div class="note-body">
    Nebular is in <i>RC</i> now, meaning that we are on the final path to the release.
  </div>
</div>
<hr class="section-end">

## What's included

What is included:

- **@nebular/theme**
  - Theme System - set of SCSS rules, which allow you to modify application looks & feel by changing style-variables, with fewer custom styles.
  - UI Kit - pure Angular components with two style themes and no 3rd party dependencies.
  - Style overriding for Bootstrap, so that the application has a consistent look & feel.
- **@nebular/auth**
  - Authentication components (login/register/reset password/restore password).
  - Multiple configurable providers (backend connectors).
  - Helpers for token management (storing, passing with HTTP requests, etc).
- *@nebular/acl* - module for roles and permissions management. Coming soon.
- *@nebular/dashboard* - module for draggable/resizable dashboards creation. Coming soon.
- *@nebular/data* - application data & state management. Coming soon.
- **Admin dashboard starter kit <a href="https://github.com/akveo/ngx-admin" target="_blank">ngx-admin</a>** - application based on Nebular modules with beautiful IOT components.
<hr class="section-end">

## The purpose

There are a lot of awesome front-end frameworks out there these days. 
They provide a massive quantity of useful features making our lives more comfortable. 
Our intention is not to create a new one as we are pretty much aware of the complexity and amount of work developers put on their creations. 
But as developers, we feel that nowadays front-end development is disjointed. 
You have to search for libraries, go through the different installation process, everything looks different, and sometimes it's just annoying that you can't just sit and start going. 
That's why we are on a mission to assemble together the most useful modules and libraries, join them with a unified application and graphical interface creating a great toolkit for easier setup.
<hr class="section-end">

## Assumptions

This documentation assumes that you are already familiar with JavaScript/TypeScript, Angular, CSS and Bootstrap.
<hr class="section-end">

## Looking for ng2-admin?
It's not gone and still supported! The ng2-admin is still available at <a href="https://github.com/akveo/ng2-admin/tree/ng2-admin" target="_blank">GitHub branch</a>.
<hr class="section-end">

## Have questions?
Didn't find something here? Look through the <a href="https://github.com/akveo/nebular/issues" target="_blank">issues</a> or simply drop us a line at <a href="mailto:contact@akveo.com">contact@akveo.com</a>.
<hr class="section-end">
