# Next steps: tools and techniques

Once you have understood the basic building blocks, you can begin to learn more about the features and tools that are available to help you develop and deliver Angular applications.  Angular provides a lot more features and services that are covered in this documentation.

#### Responsive programming tools

   * [Lifecycle hooks](guide/lifecycle-hooks): Tap into key moments in the lifetime of a component, from its creation to its destruction, by implementing the lifecycle hook interfaces.

   * [Observables and event processing](guide/observables): How to use observables with components and services to publish and subscribe to messages of any type, such as user-interaction events and asynchronous operation results.

#### Client-server interaction tools

  * [HTTP](guide/http): Communicate with a server to get data, save data, and invoke server-side actions with an HTTP client.

  * [Server-side Rendering](guide/universal): Angular Universal generates static application pages on the server through server-side rendering (SSR). This allows you to run your Angular app on the server in order to improve performance and show the first page quickly on mobile and low-powered devices, and also facilitate web crawlers.

  * [Service Workers](guide/service-worker-intro): A service worker is a script that runs in the web browser and manages caching for an application. Service workers function as a network proxy. They intercept outgoing HTTP requests and can, for example, deliver a cached response if one is available. You can significantly improve the user experience by using a service worker to reduce dependency on the network.

#### Domain-specific libraries

   * [Animations](guide/animations): Animate component behavior
without deep knowledge of animation techniques or CSS with Angular's animation library.

   * [Forms](guide/forms): Support complex data entry scenarios with HTML-based validation and dirty checking.

#### Support for the development cycle

   * [Testing Platform](guide/testing): Run unit tests on your application parts as they interact with the Angular framework.

   * [Internationalization](guide/i18n):  Angular's internationalization (i18n) tools can help you make your app available in multiple languages.

   * [Compilation](guide/aot-compiler): Angular provides just-in-time (JIT) compilation for the development environment, and ahead-of-time (AOT) compilation for the production environment.

   * [Security guidelines](guide/security): Learn about Angular's built-in protections against common web-app vulnerabilities and attacks such as cross-site scripting attacks.

#### Setup and deployment tools

   * [Setup for local development](guide/setup): Learn how to set up a new project for development with QuickStart.

   * [Installation](guide/npm-packages): The [Angular CLI](https://cli.angular.io/), Angular applications, and Angular itself depend on features and functionality provided by libraries that are available as [npm](https://docs.npmjs.com/) packages.

   * [Typescript Configuration](guide/typescript-configuration): TypeScript is the primary language for Angular application development.

   * [Browser support](guide/browser-support): Learn how to make your apps compatible across a wide range of browsers.

   * [Deployment](guide/deployment): Learn techniques for deploying your Angular application to a remote server.

<hr/>
