<h1 class="no-toc">What is Angular?</h1>

Angular is a platform that makes it easy to build applications with the web. Angular combines declarative templates, dependency injection, end to end tooling, and integrated best practices to solve development challenges. Angular empowers developers to build applications that live on the web, mobile, or the desktop

<div class="card-container">
  <a href="generated/live-examples/toh-pt1/stackblitz.html" target="_blank" class="docs-card"
    title="Experience Angular in a live coding environment">
      <section>Get a Glimpse of Angular</section>
      <p>A quick look at an Angular "hello world" application.</p>
      <p class="card-footer">Angular in Action</p>
  </a>

  <a href="guide/quickstart" class="docs-card" title="Angular Quickstart">
      <section>Get Going with Angular</section>
      <p>Get going on your own environment with the Quickstart.</p>
      <p class="card-footer">Quickstart</p>
  </a>

  <a href="guide/architecture" class="docs-card" title="Angular Architecture">
      <section>Fundamentals</section>
      <p>Learn Angular application fundamentals, starting with an architecture overview.</p>
      <p class="card-footer">Architecture</p>
  </a>
</div>

## Assumptions
This documentation assumes that you are already familiar with
[JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/A_re-introduction_to_JavaScript "Learn JavaScript"),
and some of the tools from the
[latest standards](https://babeljs.io/learn-es2015/ "Latest JavaScript standards") such as
[classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes "ES2015 Classes")
and [modules](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import "ES2015 Modules").
The code samples are written using [TypeScript](https://www.typescriptlang.org/ "TypeScript").
Most Angular code can be written with just the latest JavaScript,
using [types](https://www.typescriptlang.org/docs/handbook/classes.html "TypeScript Types") for dependency injection,
and using [decorators](https://www.typescriptlang.org/docs/handbook/decorators.html "Decorators") for metadata.

## Feedback

You can sit with us!

You can file documentation
[issues](https://github.com/angular/angular/issues "Angular Github issues") and create
[pull requests](https://github.com/angular/angular/pulls "Angular Github pull requests")
on the Angular Github repository.
The [contributing guide](https://github.com/angular/angular/blob/master/CONTRIBUTING.md "Contributing guide")
will help you contribute to the community.
Our community values  respectful, supportive communication.
Please consult and adhere to the
[code of conduct](https://github.com/angular/code-of-conduct/blob/master/CODE_OF_CONDUCT.md "contributor code of conduct").
