describe('Microtasks', function () {
  if (!global.Promise) return;

  function scheduleFn(task: Task) { Promise.resolve().then(<any>task.invoke); }

  it('should execute microtasks enqueued in the root zone', function(done) {
    var log = [];

    Zone.current.scheduleMicroTask('test', () => log.push(1), null, scheduleFn);
    Zone.current.scheduleMicroTask('test', () => log.push(2), null, scheduleFn);
    Zone.current.scheduleMicroTask('test', () => log.push(3), null, scheduleFn);

    setTimeout(function() {
      expect(log).toEqual([1, 2, 3]);
      done();
    }, 10);
  });

  it('should correctly scheduleMacroTask microtasks vs macrotasks', function(done) {
    var log = ['+root'];

    Zone.current.scheduleMicroTask('test', () => log.push('root.mit'), null, scheduleFn);

    setTimeout(function() {
      log.push('+mat1');
      Zone.current.scheduleMicroTask('test', () => log.push('mat1.mit'), null, scheduleFn);
      log.push('-mat1');
    }, 10);

    setTimeout(function() {
      log.push('mat2');
    }, 30);

    setTimeout(function() {
      expect(log).toEqual([
        '+root', '-root', 'root.mit',
        '+mat1', '-mat1', 'mat1.mit',
        'mat2']);
      done();
    }, 40);

    log.push('-root');
  });

  it('should execute Promise wrapCallback in the zone where they are scheduled', function(done) {
    var resolvedPromise = Promise.resolve(null);

    var testZone = Zone.current.fork({name: ''});

    testZone.run(function() {
      resolvedPromise.then(function() {
        expect(Zone.current).toBe(testZone);
        done();
      });
    });
  });

  it('should execute Promise wrapCallback in the zone where they are scheduled even if resolved ' +
      'in different zone.', function(done)
  {
    var resolve;
    var promise = new Promise(function (rs) {
      resolve = rs;
    });

    var testZone = Zone.current.fork({name: 'test'});

    testZone.run(function() {
      promise.then(function() {
        expect(Zone.current).toBe(testZone);
        done();
      });
    });

    Zone.current.fork({name: 'test'}).run(function() {
      resolve(null);
    });
  });

  describe('Promise', function() {
    it('should go through scheduleTask', function(done) {
      var called = false;
      var testZone = Zone.current.fork({
        name: 'test',
        onScheduleTask: function(delegate: ZoneDelegate, current: Zone, target: Zone,
                                 task: Task): Task {
          called = true;
          delegate.scheduleTask(target, task);
          return task;
        }
      });

      testZone.run(function() {
        Promise.resolve('value').then(function() {
          expect(called).toEqual(true);
          done();
        });
      });
    });
  });
});
export var __something__;
