---
order: 8
title: Internationalization
---

The default language of `antd@2.x` is still Chinese yet.
If you want to use English or other languages, you can follow instruction below.

## LocaleProvider

antd provide a React Compnent [LocaleProvider](/components/locale-provider) for configuring antd locale text globally.

```jsx
import { LocaleProvider } from 'antd';
import enUS from 'antd/lib/locale-provider/en_US';

return (
  <LocaleProvider locale={enUS}>
    <App />
  </LocaleProvider>
);
```

Supported languages:

- English - en_US
- French (Belgium) - fr_BE
- Russian - ru_RU
- Spanish - es_ES
- German - de_DE
- Czech - cs_CZ
- Portuguese (Brazil) - pt_BR
- Korean - ko_KR
- Swedish - sv_SE
- Dutch - nl_NL
- Catalan - ca_ES
- Japanese - ja_JP
- Turkish - tr_TR
- Slovak - sk_SK
- Estonian - et_EE
- Chinese (Traditional) - zh_TW

See usage and contributing way of a new locale package at [LocaleProvider](/components/locale-provider).

## i18n sample

We also provide you a complete sample of internationalization usage, which is using [react-intl](https://github.com/yahoo/react-intl) and LocaleProvider: [ant-design/intl-example](https://github.com/ant-design/intl-example).
