---
order: 8
title: 国际化
---

`antd` 目前的默认文案是中文，如果需要使用英文或其他语言，可以参考下面的方案。

## LocaleProvider

antd 提供了一个 React 组件 [LocaleProvider](/components/locale-provider) 用于全局配置国际化文案。

```jsx
import enUS from 'antd/lib/locale-provider/en_US';

return (
  <LocaleProvider locale={enUS}>
    <App />
  </LocaleProvider>
);
```

目前支持以下语言：

- 英文 - en_US
- 法语（比利时）- fr_BE
- 俄语 - ru_RU
- 西班牙语 - es_ES
- 德语 - de_DE
- 捷克语 - cs_CZ
- 葡萄牙（巴西）- pt_BR
- 韩语 - ko_KR
- 瑞典语 - sv_SE
- 荷兰语 - nl_NL
- 加泰罗尼亚 - ca_ES
- 日本语 - ja_JP
- 土耳其语 - tr_TR
- 斯洛伐克语 - sk_SK
- 爱沙尼亚语 - et_EE
- 繁體中文 - zh_TW

具体的使用方法和新语言包贡献方式请参考 [LocaleProvider 文档](/components/locale-provider)。

## i18n 项目示例

我们还提供了一个使用了 [react-intl](https://github.com/yahoo/react-intl) 和 LocaleProvider 的完整的国际化项目示例：[ant-design/intl-example](https://github.com/ant-design/intl-example)，欢迎参考使用。
