---
order: 1
title: Features
---

Unlike other design specifications, Ant Design pursues not only user experience, but also experience of desigers and developers, which practice a humanist design idea.

<div style="margin-left:-40px;margin-right:-40px;overflow:hidden;margin-top:30px;">
  <div class="ant-col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/OVirOHTeAdzDBuQ.png">
    <h5>Subtleties</h5>
    <div>By devoted to create tiny and beautiful change, make efforts in details, we could not only make products more solid and reliable, but also bring good suprises for users.</div>
  </div>
  <div class="ant-col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/iJbUiLYpuPBXUhV.png">
    <h5>Definiteness</h5>
    <div>Create an atmosphere of high definiteness and lower entropy, by making simple and scientific design patterns and using the same communicate channel.</div>
  </div>
  <div class="ant-col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/uSOjjlCRjRIhtIY.png">
    <h5>Happiness</h5>
    <div>Don't design for minimalism，design for getting job done and whatever makes designer happy and satisfied.</div>
  </div>
</div>

<style>
.features {
  padding: 0 40px;
  font-size: 12px;
}
.features h5 {
  font-size: 14px;
  margin-top: 16px;
}
@media only screen and (min-width: 320px) and (max-width: 767px) {
  .features {
    width: 100%;
    text-align: center;
    margin-bottom: 20px;;
  }
  .features img {
    width: 80%;
  }
}
</style>

---

## Subtleties

### Micro innovation

<img class="preview-img" align="right" alt="Number Input Sample" description="Clickable area zoom out when hovering" src="https://os.alipayobjects.com/rmsportal/GGXdyrOtvUtOKXe.png">

<img class="preview-img" align="right" alt="Pagination Sample" description="Click the ellipsis to switch multiple pager" src="https://os.alipayobjects.com/rmsportal/UEYPnVhQsOjytSa.png">

<img class="preview-img" align="right" alt="Charactor Count Sample" description="Make overflow text with color and underline instantly." src="https://os.alipayobjects.com/rmsportal/JxzQIRfMCtMjuaH.png">

"Diffrerence" is not always "better", but "better" is always different. Pursuing "better" in every details make our components is different, and also better naturally.

### Compositive innovation

<img class="preview-img" align="right" alt="Input inside text" description="Compose tag, input and text to help people understand what data need to input" src="https://os.alipayobjects.com/rmsportal/RGFMJRSgCAVCKOl.png">

<img class="preview-img" align="right" alt="Table with charts" description="Compose Table and Chart" src="https://os.alipayobjects.com/rmsportal/hjHOMRIbvIUUBXS.png">

Compose different components for more powerful functions, it is a good path to meet varies of different bussiness requirements.

---

## Definiteness

### Object oriented

<img class="preview-img" align="right" alt="Color Sample" description="Generate status colors via tint/shade functions from a original primary color" src="https://os.alipayobjects.com/rmsportal/MqsXoBBSDmoEDqn.png">

<img class="preview-img" align="right" alt="Typography Sample" description="Following『intimacy』principle, get the distance by a specified n value" src="https://os.alipayobjects.com/rmsportal/WNEbRORxzEvvFKy.png">

<img class="preview-img no-padding good" align="right" alt="Feedback - Good" description="Unify and simpcify the button text to same text like `Ok` or `Actions` in all situations, improve designers experience by sacrifice a little user experience." src="https://os.alipayobjects.com/rmsportal/rtbYGKfPOpWRJID.png">

<img class="preview-img no-padding bad" align="right" alt="Feedback - Bad" description="It is better for this certain situation but a disaster for text maintainers. It is very easy to make typo mistakes cause text are different and unpredicable in every pages." src="https://os.alipayobjects.com/rmsportal/OWLtvGCGmqawyPt.png">

We create a object-oriented design method and abstract UI patterns. That help us to do our jobs with continuity.

### Scientific design principles

See more at [『Ant Design Principles』](/docs/spec/proximity).

---

## Happiness

### Happiness of user

<img class="preview-img no-padding" align="right" alt="User Happiess Levels" description="Please read <em>Emotional Design 3</em> for more infomation." src="https://os.alipayobjects.com/rmsportal/sBjNEGgHEpNfqTs.png">

Beatuful looks, tide typography and smooth animation produce positive reaction at instinct level.

Good functions, perfermance and usability produce positive reaction at behavious level.

Self-image, satisfaction, and good memories bring user a combining experience of thoughts and emotions at learning level.

### Happiness of designer

<img class="preview-img no-padding" align="right" alt="Designer Happiess" description="Ant Design can not guarantee the success of products, but try to help those products <strong>successed correctly</strong> or <strong>failed correctly</strong>." src="https://os.alipayobjects.com/rmsportal/eMcdBWuZxRbvlvW.png">

From 0 to 1, Ant Design help designers to implement a quick prototype for trial and error.

From 1 to 100, Ant Design provide a complete UI solution, help designers to create their own product personality and improve user experience.
