---
order: 8
title: Internationalization
---

The default language of `antd@2.x` is English as of yet.
If you want to use other languages, you can follow the instructions below.

## LocaleProvider

antd provides a React Component [LocaleProvider](/components/locale-provider) for configuring antd locale text globally.

```jsx
import { LocaleProvider } from 'antd';
import frFR from 'antd/lib/locale-provider/fr_FR';

return (
  <LocaleProvider locale={frFR}>
    <App />
  </LocaleProvider>
);
```

You can see complete config at: [LocaleProvider](/components/locale-provider).

Note: `fr_FR` is the filename, follow below.

Supported languages:

|Language|Filename|
|---|---|
|Arabic|ar_EG|
|Bulgarian|bg_BG|
|Catalan|ca_ES|
|Czech|cs_CZ|
|German|de_DE|
|Greek|el_GR|
|English (Global)|en_GB|
|English|en_US|
|Spanish|es_ES|
|Estonian|et_EE|
|Persian|fa_IR|
|Finnish|fi_FI|
|French (Belgium)|fr_BE|
|French (France)|fr_FR|
|Hebrew|he_IL|
|Hindi|hi_IN|
|Hungarian|hu_HU|
|Indonesian|id_ID|
|Italian|it_IT|
|Icelandic|is_IS|
|Japanese|ja_JP|
|Kannada|kn_IN|
|Korean|ko_KR|
|Norwegian|nb_NO|
|Nepal|ne_NP|
|Dutch (Belgium)|nl_BE|
|Dutch|nl_NL|
|Polish|pl_PL|
|Portuguese (Brazil)|pt_BR|
|Portuguese|pt_PT|
|Slovak|sk_SK|
|Serbian|sr_RS|
|Slovenian|sl_SI|
|Swedish|sv_SE|
|Thai|th_TH|
|Turkish|tr_TR|
|Russian|ru_RU|
|Ukrainian|uk_UA|
|Vietnamese|vi_VN|
|Chinese (Simplified)|zh_CN|
|Chinese (Traditional)|zh_TW|

See usage and ways to contribute a new locale package at [LocaleProvider](/components/locale-provider).

## i18n sample

We also provide you a complete sample of internationalization usage, which is using [react-intl](https://github.com/yahoo/react-intl) and LocaleProvider: [ant-design/intl-example](https://github.com/ant-design/intl-example).
