---
category: Components
type: General
title: Icon
toc: false
---

Semantic vector graphics.

## List of icons

```__react
import IconDisplay from 'site/theme/template/IconDisplay';
ReactDOM.render(<IconDisplay />, mountNode);
```

## API

| Property | Description | Type | Default | Version |
| --- | --- | --- | --- | --- |
| type | Type of the ant design icon | string | - |  |
| style | Style properties of icon, like `fontSize` and `color` | CSSProperties | - |  |
| theme | Theme of the ant design icon | 'filled' \| 'outlined' \| 'twoTone' | 'outlined' | 3.9.0 |
| spin | Rotate icon with animation | boolean | false |  |
| rotate | Rotate degrees (added in 3.13.0, not working in IE9) | number | - | 3.13.0 |
| component | The component used for the root node. This will override the **`type`** property. | ComponentType<CustomIconComponentProps\> | - | 3.9.0 |
| twoToneColor | Only support the two-tone icon. Specific the primary color. | string (hex color) | - | 3.9.0 |

### SVG icons

We introduced SVG icons in `3.9.0` version replacing font icons which brings benefits below:

- Complete offline usage of icon, no dependency of CDN font icon file and no more empty square during downloading than no need to deploy icon font files locally either.
- Much more display accuracy in lower-level screens.
- Support multiple colors for icon.
- No need to change built-in icons with overriding styles by providing more props in component.

More discussion of SVG icon reference to [#10353](https://github.com/ant-design/ant-design/issues/10353).

> ⚠️ About the extra bundle size brought by all SVG icons we imported in 3.9.0, we will provide new API to allow developers importing icons as your need, you can trace [#12011](https://github.com/ant-design/ant-design/issues/12011) for further progress.
>
> Before this, you can use [webpack plugin](https://github.com/Beven91/webpack-ant-icon-loader) from community to chunk the icon file.

The properties `theme`, `component` and `twoToneColor` are added in `3.9.0`. The best practice is to pass the property `theme` to every `<Icon />` components.

```jsx
<Icon type="star" theme="filled" />
```

All the icons will render to `<svg>`. You can still set `style` and `className` for size and color of icons.

```jsx
<Icon type="message" style={{ fontSize: '16px', color: '#08c' }} theme="outlined" />
```

### Set TwoTone Color

When using the two-tone icons, you can use the static methods `Icon.getTwoToneColor()` and `Icon.setTwoToneColor(colorString)` to spicify the primary color.

```jsx
Icon.setTwoToneColor('#eb2f96');
Icon.getTwoToneColor(); // #eb2f96
```

### Custom Font Icon

We added a `createFromIconfontCN` function to help developer using their own icons deployed at [iconfont.cn](http://iconfont.cn/) in a convenient way.

> This method is specified for [iconfont.cn](http://iconfont.cn/).

```js
const MyIcon = Icon.createFromIconfontCN({
  scriptUrl: '//at.alicdn.com/t/font_8d5l8fzk5b87iudi.js', // generated by iconfont.cn
});

ReactDOM.render(<MyIcon type="icon-example" />, mountedNode);
```

It create a component that uses SVG sprites in essence.

The following options are available:

| Property | Description | Type | Default | Version |
| --- | --- | --- | --- | --- |
| scriptUrl | The URL generated by [iconfont.cn](http://iconfont.cn/) project. | string | - | 3.9.3 |
| extraCommonProps | Define extra properties to the component | `{ [key: string]: any }` | {} | 3.9.3 |

The property `scriptUrl` should be set to import the SVG sprite symbols.

See [iconfont.cn documents](http://iconfont.cn/help/detail?spm=a313x.7781069.1998910419.15&helptype=code) to learn about how to generate `scriptUrl`.

### Custom SVG Icon

You can import SVG icon as an react component by using `webpack` and [`@svgr/webpack`](https://www.npmjs.com/package/@svgr/webpack). `@svgr/webpack`'s `options` [reference](https://github.com/smooth-code/svgr#options).

```js
// webpack.config.js
{
  test: /\.svg(\?v=\d+\.\d+\.\d+)?$/,
  use: [
    {
      loader: 'babel-loader',
    },
    {
      loader: '@svgr/webpack',
      options: {
        babel: false,
        icon: true,
      },
    },
  ],
}
```

```jsx
import { Icon } from 'antd';
import MessageSvg from 'path/to/message.svg'; // path to your '*.svg' file.

ReactDOM.render(<Icon component={MessageSvg} />, mountNode);
```

The following properties are available for the component:

| Property | Description | Type | Default | Version |
| --- | --- | --- | --- | --- |
| width | The width of the `svg` element | string \| number | '1em' | 3.10.0 |
| height | The height of the `svg` element | string \| number | '1em' | 3.10.0 |
| fill | Define the color used to paint the `svg` element | string | 'currentColor' | 3.10.0 |
| className | The computed class name of the `svg` element | string | - | 3.10.0 |
| style | The computed style of the `svg` element | CSSProperties | - | 3.10.0 |
