---
order: 7
title: Third-Party Libraries
---

`antd` is designed to provide high-quality React UI components which follow the Ant Design Specification. So, we are not going to implement other functions which are not relative to `antd`'s target, and recommend using the excellent third-party library which have come from the React community:

| Category | Recommended Components |
| --- | --- |
| Router | [react-router](https://github.com/ReactTraining/react-router) |
| Layout | [@rebass/grid](https://github.com/rebassjs/grid) [react-blocks](http://whoisandy.github.io/react-blocks/) [react-flexbox-grid](https://github.com/roylee0704/react-flexbox-grid) |
| Drag and drop | [react-beautiful-dnd](https://github.com/atlassian/react-beautiful-dnd/) [react-dnd](https://github.com/gaearon/react-dnd) [react-sortable-hoc](https://github.com/clauderic/react-sortable-hoc) |
| Code Editor | [react-codemirror2](https://github.com/scniro/react-codemirror2) [react-monaco-editor](https://github.com/superRaytin/react-monaco-editor) |
| Rich Text Editor | [react-quill](https://github.com/zenoamaro/react-quill) [braft-editor](https://github.com/margox/braft-editor) |
| JSON Viewer | [react-json-view](https://github.com/mac-s-g/react-json-view) |
| Color Picker | [rc-color-picker](https://github.com/react-component/color-picker) [react-color](http://casesandberg.github.io/react-color/) |
| Media Query | [react-responsive](https://github.com/contra/react-responsive) [react-media](https://github.com/ReactTraining/react-media) |
| Copy to clipboard | [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) |
| Document head manager | [react-helmet](https://github.com/nfl/react-helmet) [react-document-title](https://github.com/gaearon/react-document-title) |
| Icons | [react-fa](https://github.com/andreypopp/react-fa) [react-icons](https://github.com/gorangajic/react-icons) |
| QR Code | [qrcode.react](https://github.com/zpao/qrcode.react) |
| Charts | [BizCharts](https://github.com/alibaba/BizCharts) [recharts](https://github.com/recharts/recharts/) [victory](https://github.com/FormidableLabs/victory) |
| Visual Graph Editor | [GGEditor](https://github.com/gaoli/GGEditor) |
| Top Progress Bar | [nprogress](https://github.com/rstacruz/nprogress) |
| i18n | [react-intl](https://github.com/yahoo/react-intl) |
| Code highlight | [react-syntax-highlighter](https://github.com/conorhastings/react-syntax-highlighter) |
| Markdown renderer | [react-markdown](http://rexxars.github.io/react-markdown/) |
| Infinite Scroll | [react-virtualized](https://github.com/bvaughn/react-virtualized) [antd-table-infinity](https://github.com/Leonard-Li777/antd-table-infinity) |
| Map | [react-google-maps](https://github.com/tomchentw/react-google-maps) [google-map-react](https://github.com/istarkov/google-map-react) [react-amap](https://github.com/ElemeFE/react-amap) |
| Context Menu | [react-contextmenu](https://github.com/vkbansal/react-contextmenu/) [react-contexify](https://github.com/fkhadra/react-contexify) |
| Emoji | [emoji-mart](https://github.com/missive/emoji-mart) |
| Split View | [react-split-pane](https://github.com/tomkp/react-split-pane) |
| Image Crop | [react-image-crop](https://github.com/DominicTobias/react-image-crop) |
| Trend Lines | [react-sparklines](https://github.com/borisyankov/react-sparklines) |
| Keywords highlight | [react-highlight-words](https://github.com/bvaughn/react-highlight-words) |
| Animation | [react-move](https://github.com/react-tools/react-move) [Ant Motion](https://motion.ant.design/components/tween-one) [react-spring](https://www.react-spring.io) |

<style>
.markdown table td:first-child {
  font-weight: 500;
  width: 25%;
  background: #fcfcfc;
}
.markdown table td > a:not(:last-child) {
  margin-right: 18px;
}
.markdown table td > a:not(:last-child):after {
  content: '|';
  color: #bbb;
  margin: 0 6px 0 8px;
  pointer-events: none;
  position: absolute;
}
</style>
