---
order: 7
title: 社区精选组件
---

`antd` 是 Ant Design 设计规范的 React 实现，所以我们倾向于只提供符合该规范、且带有视觉展现的 UI 组件，也尽量不重复造轮子。我们推荐使用以下社区已有的优秀实现，与 antd 形成互补：

| 类型 | 推荐组件 |
| --- | --- |
| 路由 | [react-router](https://github.com/ReactTraining/react-router) |
| 布局 | [@rebass/grid](https://github.com/rebassjs/grid) [react-blocks](https://github.com/whoisandy/react-blocks) [react-flexbox-grid](https://github.com/roylee0704/react-flexbox-grid) |
| 拖拽 | [react-beautiful-dnd](https://github.com/atlassian/react-beautiful-dnd/) [react-dnd](https://github.com/gaearon/react-dnd) [react-sortable-hoc](https://github.com/clauderic/react-sortable-hoc) |
| 代码编辑器 | [react-codemirror2](https://github.com/scniro/react-codemirror2) [react-monaco-editor](https://github.com/superRaytin/react-monaco-editor) |
| 富文本编辑器 | [react-quill](https://github.com/zenoamaro/react-quill) [braft-editor](https://github.com/margox/braft-editor) |
| JSON 显示器 | [react-json-view](https://github.com/mac-s-g/react-json-view) |
| 拾色器 | [rc-color-picker](https://github.com/react-component/color-picker) [react-color](http://casesandberg.github.io/react-color/) |
| 响应式 | [react-responsive](https://github.com/contra/react-responsive) [react-media](https://github.com/ReactTraining/react-media) |
| 复制到剪贴板 | [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) |
| 页面 meta 属性 | [react-helmet](https://github.com/nfl/react-helmet) [react-document-title](https://github.com/gaearon/react-document-title) |
| 图标 | [react-fa](https://github.com/andreypopp/react-fa) [react-icons](https://github.com/gorangajic/react-icons) |
| 二维码 | [qrcode.react](https://github.com/zpao/qrcode.react) |
| 可视化图表 | [BizCharts](https://github.com/alibaba/BizCharts) [recharts](https://github.com/recharts/recharts/) [victory](https://github.com/FormidableLabs/victory) |
| 可视化图编辑器 | [GGEditor](https://github.com/gaoli/GGEditor) |
| 顶部进度条 | [nprogress](https://github.com/rstacruz/nprogress) |
| 应用国际化 | [react-intl](https://github.com/yahoo/react-intl) |
| 代码高亮 | [react-syntax-highlighter](https://github.com/conorhastings/react-syntax-highlighter) |
| Markdown 渲染 | [react-markdown](http://rexxars.github.io/react-markdown/) |
| 无限滚动 | [react-virtualized](https://github.com/bvaughn/react-virtualized) [antd-table-infinity](https://github.com/Leonard-Li777/antd-table-infinity) |
| 地图 | [react-google-maps](https://github.com/tomchentw/react-google-maps) [google-map-react](https://github.com/istarkov/google-map-react) [react-amap 高德](https://github.com/ElemeFE/react-amap) |
| 右键菜单 | [react-contextmenu](https://github.com/vkbansal/react-contextmenu/) [react-contexify](https://github.com/fkhadra/react-contexify) |
| Emoji | [emoji-mart](https://github.com/missive/emoji-mart) |
| 分割面板 | [react-split-pane](https://github.com/tomkp/react-split-pane) |
| 图片裁切 | [react-image-crop](https://github.com/DominicTobias/react-image-crop) |
| 趋势线 | [react-sparklines](https://github.com/borisyankov/react-sparklines) |
| 关键字高亮 | [react-highlight-words](https://github.com/bvaughn/react-highlight-words) |
| 动画 | [react-move](https://github.com/react-tools/react-move) [Ant Motion](https://motion.ant.design/components/tween-one) [react-spring](https://www.react-spring.io) |

<style>
.markdown table td:first-child {
  font-weight: 500;
  width: 20%;
  background: #fcfcfc;
}
.markdown table td > a:not(:last-child) {
  margin-right: 18px;
}
.markdown table td > a:not(:last-child):after {
  content: '|';
  color: #bbb;
  margin: 0 6px 0 8px;
  pointer-events: none;
  position: absolute;
}
</style>
