---
category: Ant Design
order: 1
title: Design Values
---

Ant Design provides a practical evaluation of better design for both designers of Ant Design and designers who are using it. At the same time, it builds a foundation for design principles and design patterns which could provide guideline and general solutions for specified design goal.

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/kEwBspjVFChYqhqafCiW.png" />
</div>

Here is our design values:

## Nature

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/cdaxgaTMQCGTqjdlwwgt.png" alt="Nature" />
</div>

As a part of nature, it will have deep influence on user behavior, and designers should draw inspiration from it and apply it to our daily design work. We have started exploring and will pursue nature as our future direction.

- The visual system plays the most important role in human perception and cognition. By refining the objective laws in nature and applying it to the interface design, a more layered product experience is created. In addition, hearing systems or tactile systems could be added in future to bring more dimensions and more real product experience. See visual language.
- In the real product design, a series of methods such as behavior analysis, artificial intelligence and sensors could be applied to assist users to make effective decisions and reduce extra operations of users, so as to save users' mental and physical resources and make human-computer interaction more natural.

## Determinacy

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/ZxgRAMzXNrxHTcvMLchq.png" alt="Determine" />
</div>

The designers needs to make better design decisions and create a high-definition and low-entropy atmosphere for developer team. Meanwhile, different designers could produce the same design output which fit business needs based on the same understanding of business requirements and design system.

- **Keep restraint:** Don't make decision until we have to. Designers should focus on the valuable product features using minimal design elements to express. As Antoine de St.Exupery said: [“Perfection is achieved, not when there is nothing more to add, but when there is nothing left to take away.”](https://www.goodreads.com/quotes/19905-perfection-is-achieved-not-when-there-is-nothing-more-to)
- **Object-oriented:** Explore design rules and abstract them as "objects" to enhance the flexibility and maintainability of user interface design while reducing designer's subjective judgement and uncertainty of real world system. For example: color value conversion, spacing typesetting.
- **Modular:** Encapsulate the complex or reusable parts could provide limited interfaces to interact with other modules, ultimately reducing overall system complexity, resulting in better reliability and maintainability. Designers can use existed resources or abstract their own reusable resources, save unnecessary and low additional design to keep their focus on where creativity most needed.
