<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## BlockManager

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 blockManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const blockManager = editor.BlockManager;
```

-   [add][2]
-   [get][3]
-   [getAll][4]
-   [getAllVisible][5]
-   [remove][6]
-   [getConfig][7]
-   [getCategories][8]
-   [getContainer][9]
-   [render][10]

## getConfig

Get configuration object

Returns **[Object][11]** 

## onLoad

Load default blocks if the collection is empty

## add

Add new block to the collection.

### Parameters

-   `id` **[string][12]** Block id
-   `opts` **[Object][11]** Options
    -   `opts.label` **[string][12]** Name of the block
    -   `opts.content` **[string][12]** HTML content
    -   `opts.category` **([string][12] \| [Object][11])** Group the block inside a catgegory.
                                             You should pass objects with id property, eg:
                                             {id: 'some-uid', label: 'My category'}
                                             The string will be converted in:
                                             'someid' => {id: 'someid', label: 'someid'}
    -   `opts.attributes` **[Object][11]** Block attributes (optional, default `{}`)

### Examples

```javascript
blockManager.add('h1-block', {
  label: 'Heading',
  content: '<h1>Put your title here</h1>',
  category: 'Basic',
  attributes: {
    title: 'Insert h1 block'
  }
});
```

Returns **Block** Added block

## get

Return the block by id

### Parameters

-   `id` **[string][12]** Block id

### Examples

```javascript
const block = blockManager.get('h1-block');
console.log(JSON.stringify(block));
// {label: 'Heading', content: '<h1>Put your ...', ...}
```

## getAll

Return all blocks

### Examples

```javascript
const blocks = blockManager.getAll();
console.log(JSON.stringify(blocks));
// [{label: 'Heading', content: '<h1>Put your ...'}, ...]
```

Returns **Collection** 

## getAllVisible

Return the visible collection, which containes blocks actually rendered

Returns **Collection** 

## remove

Remove a block by id

### Parameters

-   `id` **[string][12]** Block id

Returns **Block** Removed block

## getCategories

Get all available categories.
It's possible to add categories only within blocks via 'add()' method

Returns **([Array][13] | Collection)** 

## getContainer

Return the Blocks container element

Returns **[HTMLElement][14]** 

## render

Render blocks

### Parameters

-   `blocks` **[Array][13]** Blocks to render, without the argument will render
                           all global blocks

### Examples

```javascript
// Render all blocks (inside the global collection)
blockManager.render();

// Render new set of blocks
const blocks = blockManager.getAll();
blockManager.render(blocks.filter(
 block => block.get('category') == 'sections'
));
// Or a new set from an array
blockManager.render([
 {label: 'Label text', content: '<div>Content</div>'}
]);

// Back to blocks from the global collection
blockManager.render();
```

Returns **[HTMLElement][14]** Rendered element

[1]: https://github.com/artf/grapesjs/blob/master/src/block_manager/config/config.js

[2]: #add

[3]: #get

[4]: #getall

[5]: #getallvisible

[6]: #remove

[7]: #getconfig

[8]: #getcategories

[9]: #getcontainer

[10]: #render

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[14]: https://developer.mozilla.org/docs/Web/HTML/Element
