<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## CssComposer

This module contains and manage CSS rules for the template inside the canvas.
You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 cssComposer: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const cssComposer = editor.CssComposer;
```

-   [load][2]
-   [store][3]
-   [add][4]
-   [get][5]
-   [getAll][6]
-   [clear][7]
-   [setIdRule][8]
-   [getIdRule][9]
-   [setClassRule][10]
-   [getClassRule][11]

## load

Load data from the passed object, if the object is empty will try to fetch them
autonomously from the storage manager.
The fetched data will be added to the collection

### Parameters

-   `data` **[Object][12]** Object of data to load

Returns **[Object][12]** Loaded rules

## store

Store data to the selected storage

### Parameters

-   `noStore` **[Boolean][13]** If true, won't store

Returns **[Object][12]** Data to store

## add

Add new rule to the collection, if not yet exists with the same selectors

### Parameters

-   `selectors` **[Array][14]&lt;Selector>** Array of selectors
-   `state` **[String][15]** Css rule state
-   `width` **[String][15]** For which device this style is oriented
-   `opts` **[Object][12]** Other options for the rule (optional, default `{}`)

### Examples

```javascript
var sm = editor.SelectorManager;
var sel1 = sm.add('myClass1');
var sel2 = sm.add('myClass2');
var rule = cssComposer.add([sel1, sel2], 'hover');
rule.set('style', {
  width: '100px',
  color: '#fff',
});
```

Returns **Model** 

## get

Get the rule

### Parameters

-   `selectors` **[Array][14]&lt;Selector>** Array of selectors
-   `state` **[String][15]** Css rule state
-   `width` **[String][15]** For which device this style is oriented
-   `ruleProps` **[Object][12]** Other rule props

### Examples

```javascript
var sm = editor.SelectorManager;
var sel1 = sm.add('myClass1');
var sel2 = sm.add('myClass2');
var rule = cssComposer.get([sel1, sel2], 'hover');
// Update the style
rule.set('style', {
  width: '300px',
  color: '#000',
});
```

Returns **(Model | null)** 

## getAll

Get the collection of rules

Returns **Collection** 

## clear

Remove all rules

Returns **this** 

## setIdRule

Add/update the CSS rule with id selector

### Parameters

-   `name` **[string][15]** Id selector name, eg. 'my-id'
-   `style` **[Object][12]** Style properties and values (optional, default `{}`)
-   `opts` **[Object][12]** Custom options, like `state` and `mediaText` (optional, default `{}`)

### Examples

```javascript
const rule = cc.setIdRule('myid', { color: 'red' });
const ruleHover = cc.setIdRule('myid', { color: 'blue' }, { state: 'hover' });
// This will add current CSS:
// #myid { color: red }
// #myid:hover { color: blue }
```

Returns **CssRule** The new/updated rule

## getIdRule

Get the CSS rule by id selector

### Parameters

-   `name` **[string][15]** Id selector name, eg. 'my-id'
-   `opts` **[Object][12]** Custom options, like `state` and `mediaText` (optional, default `{}`)

### Examples

```javascript
const rule = cc.getIdRule('myid');
const ruleHover = cc.setIdRule('myid', { state: 'hover' });
```

Returns **CssRule** 

## setClassRule

Add/update the CSS rule with class selector

### Parameters

-   `name` **[string][15]** Class selector name, eg. 'my-class'
-   `style` **[Object][12]** Style properties and values (optional, default `{}`)
-   `opts` **[Object][12]** Custom options, like `state` and `mediaText` (optional, default `{}`)

### Examples

```javascript
const rule = cc.setClassRule('myclass', { color: 'red' });
const ruleHover = cc.setClassRule('myclass', { color: 'blue' }, { state: 'hover' });
// This will add current CSS:
// .myclass { color: red }
// .myclass:hover { color: blue }
```

Returns **CssRule** The new/updated rule

## getClassRule

Get the CSS rule by class selector

### Parameters

-   `name` **[string][15]** Class selector name, eg. 'my-class'
-   `opts` **[Object][12]** Custom options, like `state` and `mediaText` (optional, default `{}`)

### Examples

```javascript
const rule = cc.getClassRule('myclass');
const ruleHover = cc.getClassRule('myclass', { state: 'hover' });
```

Returns **CssRule** 

[1]: https://github.com/artf/grapesjs/blob/master/src/css_composer/config/config.js

[2]: #load

[3]: #store

[4]: #add

[5]: #get

[6]: #getall

[7]: #clear

[8]: #setidrule

[9]: #getidrule

[10]: #setclassrule

[11]: #getclassrule

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String
