---
title: Introduction
---

# Introduction

## What is Vue Flow?

Vue Flow is a Vue 3 library that brings interactivity to flowcharts and graphs.

It is a tool to build your own diagrams, editors and whatever your imagination allows for.

Easily implement your own custom nodes and edges and expand on the basic functionality and on top of that Vue Flow comes
with a couple of additional components like a Background, a Minimap and Controls.

Check out the [examples](/examples/) if you want to dive directly into the code.

## Key Features

- 👶 __Easy setup__: Get started hassle-free - Built-in zoom- & pan features, element dragging, selection and much more

- 🎨 __Customizable__: Use your own custom nodes, edges, connection lines and expand on the Vue Flows functionality

- 🚀 __Fast__: Tracks changes reactively and only re-renders the appropriate elements

- 🧲 __Utils & Composition__: Comes with graph helper and state composable functions for advanced uses

- 📦 __Additional Components__:

  - 🖼 Background: With two built-in patterns and some configuration options like height, width or color.

  - 🧭 Minimap: Shows current nodes in a small map shape in the bottom right corner

  - 🕹 Controls: Control zoom behavior from a panel on the bottom left

- 🦾 __Reliable__: Fully written in TypeScript

::: warning Vue Flow is still version 0.x.x.
Expect breaking changes between versions!
:::
