+++
title = "htmx 0.0.4 has been released!"
date = 2020-05-24
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 0.0.4 Release

I'm pleased to announce the [0.0.4 release](https://unpkg.com/browse/htmx.org@0.0.4/) of htmx, this time with no 
project renaming.

#### Changes

This one had a lot of code clean up along with two major features:

##### Extensions

First off, htmx now has a proper [extensions](@/extensions/_index.md) mechanism, allowing us to create extensions that plug
in to the htmx life cycle and provide functionality that isn't in the core library.  Some extensions that have shipped
with this release and that you might find useful include:

* [`morphdom-swap`](@/extensions/morphdom-swap.md) - allows you to use the morphdom library for swapping in new content
* [`class-tools`](@/extensions/class-tools.md) - replaces the retired `hx-classes` attribute
* [`json-enc`](@/extensions/json-enc.md) - allows you to encode AJAX request bodies in JSON

See the full list of included [extensions here](@/extensions/_index.md#included).

This extension mechanism will allow us to introduce useful HTML-oriented features while keeping the core htmx code
focused on loading content.

##### Web Socket & Reworked Server Sent Events Support

htmx now has experimental support for [Web Sockets](https://developer.mozilla.org/en-US/docs/Web/API/WebSockets_API/Writing_WebSocket_client_applications)
with the [hx-ws](@/attributes/hx-ws.md) attribute:

```html
  <div hx-ws="connect wss:/chatroom">
    <div id="chat_room">
      ...
    </div>
    <form hx-ws="send">
        <input name="chat_message">
    </form>
  </div>
```

Additionally, the [Server Sent Event](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events)
support attribute was renamed to [hx-sse](@/attributes/hx-sse.md) and the syntax was standardized with the new web socket support
syntax:

```html
  <div hx-sse="connect /event_stream">
    <div hx-get="/chatroom" hx-trigger="sse:chatter">
      ...
    </div>
  </div>
```

There were also many, many bug fixes, many of them contributed by other developers.  So a big thank you to everyone
who helped!

Enjoy!
