+++
title = "Essays"
insert_anchor_links = "left"
page_template = "essay.html"
+++

### Hypermedia and REST
* [HATEOAS](@/essays/hateoas.md)
* [How Did REST Come To Mean The Opposite of REST?](@/essays/how-did-rest-come-to-mean-the-opposite-of-rest.md)
* [Two Approaches To Decoupling](@/essays/two-approaches-to-decoupling.md)
* [Hypermedia APIs vs. Data APIs](@/essays/hypermedia-apis-vs-data-apis.md)
* [Splitting Your Data & Application APIs: Going Further](@/essays/splitting-your-apis.md)
* [Hypermedia Clients](@/essays/hypermedia-clients.md)
* [HATEOAS Is For Humans](https://intercoolerjs.org/2016/05/08/hatoeas-is-for-humans.html)
* [Rescuing REST From the API Winter](https://intercoolerjs.org/2016/01/18/rescuing-rest.html)
* [Taking HTML Seriously](https://intercoolerjs.org/2020/01/14/taking-html-seriously)
* [REST Copypasta](@/essays/rest-copypasta.md)
* [The #ViewSource Affordance](@/essays/right-click-view-source.md)

### Why Hypermedia? Why Multi-Page Applications?
* [Hypermedia On Whatever you'd Like (HOWL)](@/essays/hypermedia-on-whatever-youd-like.md)
* [A Response To "Have SPAs Ruined The Web"](@/essays/a-response-to-rich-harris.md)
* [When To Use Hypermedia?](@/essays/when-to-use-hypermedia.md)
* [The API Churn/Security Trade-off](https://intercoolerjs.org/2016/02/17/api-churn-vs-security.html)
* [Does Hypermedia Scale?](@/essays/does-hypermedia-scale.md)
* [SPA Alternative](@/essays/spa-alternative.md)

### Building Hypermedia Applications
* [A Real World React to htmx Port](@/essays/a-real-world-react-to-htmx-port.md)
* [Another Real World React to htmx Port](@/essays/another-real-world-react-to-htmx-port.md)
* [Web Security Basics (with htmx)](@/essays/web-security-basics-with-htmx.md)
* [Hypermedia-Driven Applications (HDAs)](@/essays/hypermedia-driven-applications.md)
* [Hypermedia Friendly Scripting](@/essays/hypermedia-friendly-scripting.md)
* [10 Tips For Building SSR/HDA applications](@/essays/10-tips-for-SSR-HDA-apps.md)
* [Why I Tend Not To Use Content Negotiation](@/essays/why-tend-not-to-use-content-negotiation.md)
* [Template Fragments](@/essays/template-fragments.md)
* [View Transitions](@/essays/view-transitions.md)
* [Model/View/Controller](@/essays/mvc.md)

### Complexity Very Very Bad
* [The Grug Brained Developer](https://grugbrain.dev)
* [Locality of Behavior (LoB)](@/essays/locality-of-behaviour.md)
* [Complexity Budget](@/essays/complexity-budget.md)
* [Why htmx Does Not Have a Build Step](@/essays/no-build-step.md)
* [Is htmx Just Another JavaScript Framework?](@/essays/is-htmx-another-javascript-framework.md)
* [htmx Implementation Deep Dive (Video)](https://www.youtube.com/watch?v=javGxN-h9VQ)

## Banners
<div style="text-align: center;margin:32px">
  <img width="90%" loading="lazy" src="/img/createdwith.jpeg">
</div>

## Memes

<style>
  .memes {
    text-align: center;
  }
  .memes img {
     min-height: 200px;
     max-width: 100%;
     margin: 32px;
   }
</style>
<div class="memes">
<img loading="lazy" src="/img/memes/original.png">
<img loading="lazy" src="/img/memes/20yearold.png">
<img loading="lazy" src="/img/memes/whowillwin.png">
<img loading="lazy" src="/img/memes/uarealldoingitwrong.png">
<img loading="lazy" src="/img/memes/restapi.png">
<img loading="lazy" src="/img/memes/justusehtml.png">
<img loading="lazy" src="/img/memes/istudiedhtml.png">
<img loading="lazy" src="/img/memes/htmlvsjson.png">
<img loading="lazy" src="/img/memes/dontknowwhatclientsideroutingis.png">
<img loading="lazy" src="/img/memes/nocap.png">
<img loading="lazy" src="/img/memes/ie11enjoyer.png">
<img loading="lazy" src="/img/memes/hydration.png">
<img loading="lazy" src="/img/memes/viewsource.png">
<img loading="lazy" src="/img/memes/javascripthistory.png">
<img loading="lazy" src="/img/memes/bellcurve.png">
<img loading="lazy" src="/img/memes/drakearchitecture.png">
<img loading="lazy" src="/img/memes/bellcurve2.png">
<img loading="lazy" src="/img/memes/dbtohtml.png">
<img loading="lazy" src="/img/memes/normal.png">
<img loading="lazy" src="/img/memes/feelbad.png">
<img loading="lazy" src="/img/memes/drakememes.png">
<img loading="lazy" src="/img/memes/fullstack.jpg">
<img loading="lazy" src="/img/memes/frontenddevs.png">
<img loading="lazy" src="/img/memes/htmxanddjango.png">
<img loading="lazy" src="/img/memes/aye.png">
<img loading="lazy" src="/img/memes/extinction.png">
</div>
