import {
  create as svgCreate
} from 'tiny-svg';

export const BUSINESS_KNOWLEDGE_MODEL_OUTLINE_PATH = `
M2.45221 16.0068L18.7175 1.74436L18.0615 0.996331L18.7175 1.74436C19.2646 1.26455 19.9676 
1 20.6953 1H140.926C142.583 1 143.926 2.34295 143.926 3.99967L143.93 37.5457C143.93 
38.3668 143.593 39.152 142.999 39.7183L143.689 40.4424L142.999 39.7183L127.299 
54.6723C126.741 55.2036 126 55.5 125.23 55.5H4.53787C2.88599 55.5 1.54491 54.1646 1.5379 
52.5127L1.43066 27.229L1.43065 27.2248L1.4301 18.2626C1.43005 
17.3986 1.80255 16.5765 2.45221 16.0068Z
`;


export const KNOWLEDGE_SOURCE_OUTLINE_PATH = `
M1.79494 63.0032L1.2941 63.6423L1.79493 63.0032C1.71778 62.9427 1.6428 62.8741 1.57288 
62.8L1.01736 63.3241L1.57288 62.8C1.20495 62.41 1 61.8941 1 61.3579V2.65067C1 1.74066 
1.73867 1.00345 2.64868 1.00526L108.006 1.2145C109.66 1.21778 111 2.55996 111 
4.21449V21.7015V61.6762C111 63.3188 109.679 64.656 108.037 64.676L107.06 64.6879C106.66 
64.6927 106.26 64.6165 105.89 64.4652C105.04 64.1176 104.222 63.78 103.43 
63.4531C93.4866 59.3517 87.6891 56.9603 76.3991 58.1057C71.7035 58.5821 66.8747 60.74 
61.5721 63.1744C61.3243 63.2881 61.0753 63.4026 60.825 63.5177C55.6712 65.8868 49.9696 
68.5077 43.2365 70.3468C31.101 73.6617 15.2135 73.5179 1.79494 63.0032Z
`;

/**
 * @type {Dimensions}
 */
export const BUSINESS_KNOWLEDGE_MODEL_STANDARD_SIZE = { width: 135, height: 46 };

/**
 * @type {Dimensions}
 */
export const KNOWLEDGE_SOURCE_STANDARD_SIZE = { width: 100, height: 63 };

/**
 * Create a path element with given attributes.
 * @param {string} path
 * @param {Object} attrs
 * @param {Object} OUTLINE_STYLE
 * @return {SVGElement}
 */
export function createPath(path, attrs, OUTLINE_STYLE) {
  return svgCreate('path', {
    d: path,
    strokeWidth: 2,
    transform: `translate(${attrs.x}, ${attrs.y})`,
    ...OUTLINE_STYLE
  });
}