# Developers

Developer features allow extending and enhancing Chart.js in many different ways.

## Latest resources

The latest documentation and samples, including unreleased features, are available at:

- <https://www.chartjs.org/docs/master/>
- <https://www.chartjs.org/samples/master/>

## Development releases

Latest builds are available for testing at:

- <https://www.chartjs.org/dist/master/chart.js>
- <https://www.chartjs.org/dist/master/chart.min.js>

:::warning Warning

Development builds **must not** be used for production purposes or as replacement for a CDN. See [available CDNs](../getting-started/installation.md#cdn).

:::

## Browser support

All modern and up-to-date browsers are supported, including, but not limited to:

* Chrome
* Edge
* Firefox
* Safari

As of version 3, we have dropped Internet Explorer 11 support.

Browser support for the canvas element is available in all modern & major mobile browsers. [CanIUse](https://caniuse.com/#feat=canvas)

Run `npx browserslist` at the root of the [codebase](https://github.com/chartjs/Chart.js) to get a list of supported browsers.

Thanks to [BrowserStack](https://browserstack.com) for allowing our team to test on thousands of browsers.

## Previous versions

To migrate from version 2 to version 3, please see [the v3 migration guide](../getting-started/v3-migration).

Version 3 has a largely different API than earlier versions.

Most earlier version options have current equivalents or are the same.

Please note - documentation for previous versions is available online or in the GitHub repo.

- [2.9.4 Documentation](https://www.chartjs.org/docs/2.9.4/)
- [1.x Documentation](https://github.com/chartjs/Chart.js/tree/v1.1.1/docs)
