require 'rails_helper'

RSpec.describe 'Super Admin accounts API', type: :request do
  let(:super_admin) { create(:super_admin) }

  describe 'GET /super_admin/accounts' do
    context 'when it is an unauthenticated user' do
      it 'returns unauthorized' do
        get '/super_admin/accounts'
        expect(response).to have_http_status(:redirect)
      end
    end

    context 'when it is an authenticated user' do
      let!(:account) { create(:account) }

      it 'shows the list of accounts' do
        sign_in super_admin
        get '/super_admin/accounts'
        expect(response).to have_http_status(:success)
        expect(response.body).to include('New account')
        expect(response.body).to include(account.name)
      end
    end
  end
end
