---
category: api-reference
---

# CKEditor 5 CKBox integration

[![npm version](https://badge.fury.io/js/%40ckeditor%2Fckeditor5-ckbox.svg)](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)

This package implements the {@link features/ckbox CKBox file manager and uploader} integration for CKEditor 5. This feature allows you to easily insert images as well as links to files into the editor content. It is a bridge between the CKEditor 5 WYSIWYG editor and the CKBox file manager and uploader.

## Demo

Check out the {@link features/ckbox#demo demos} in the integration guide.

## Documentation

See the {@link features/ckbox CKBox integration} guide and the {@link module:ckbox/ckbox~CKBox plugin documentation} to learn more about the integration.

Check out the {@link features/image-upload Image upload guide} to learn about other ways to upload images into CKEditor 5.

## Installation

```bash
npm install --save @ckeditor/ckeditor5-ckbox
```

## Contribute

The source code of this package is available on GitHub in [https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-ckbox](https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-ckbox).

## External links

* [`@ckeditor/ckeditor5-ckbox` on npm](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)
* [`ckeditor/ckeditor5-ckbox` on GitHub](https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-ckbox)
* [Issue tracker](https://github.com/ckeditor/ckeditor5/issues)
* [Changelog](https://github.com/ckeditor/ckeditor5/blob/master/CHANGELOG.md)
