## Ignoring events propagation

It's a test for ignoring events fired in elements with a `data-cke-ignore-events` attribute ([#4600](https://github.com/ckeditor/ckeditor5/issues/4600)).

Events are logged in the browser's console.

### Case 1: Events ignoring

1. Focus the widget by clicking it.
1. Move mouse cursor over the left container (`Ignored container with data-cke-ignore-events="true"`).
1. Keep moving the cursor over the container.

	**Expected:** no further "Received mousemove event." logs are added.

1. Click on a "Click!" button in the container.

	**Expected:** No "Received click event." gets logged.

1. Click on the text input in the container.

	**Expected:** Text input gets focused.

1. Type few characters into the focused input.

	**Expected:** Text is inserted. No keyboard events are logged.

Note: you might get unexpected `focus` nad `blur` events in the process, it's a [known issue](https://github.com/ckeditor/ckeditor5/issues/8309).

### Case 2: Container without event ignoring

1. Focus the widget by clicking it.
1. Move mouse cursor over the right container (`Regular container`).
1. Keep moving the cursor over the container.

	**Expected:** "Received mousemove event." logs are added.

1. Click on a "Click!" button in the container.

	**Expected:** "Received click event." is logged.

1. Click on the text input in the container.

	**Expected:** Click events are logged. Editor decides what to do with the selection.

### Case 3: `imageLoaded` event

1. Reload the page (test).
1. Check the console.

	**Expected:** There's only **one** `Received imageLoaded event.` log.