---
category: features
menu-title: Productivity pack
order: -998
modified_at: 2023-05-31
badges: [ premium ]
---

# Productivity pack

The productivity pack is a set of exclusive premium features for the CKEditor 5 WYSIWYG editor, that make editing faster, easier, and more efficient.

<info-box>
These are only available to holders of a [CKEditor 5 commercial license](https://ckeditor.com/pricing/). Feel free to [contact us](https://ckeditor.com/contact/?sales=true#contact-form) to receive an offer tailored to your needs.
</info-box>

## Features included in the productivity pack

* Document outline

	The {@link features/document-outline document outline feature} lists the sections (headings) of the document next to the editor. The outline updates automatically as the user works on the document. It offers quick navigation to a specific section upon clicking.

* Format painter

	The {@link features/format-painter format painter feature} {@icon @ckeditor/ckeditor5-format-painter/theme/icons/paint-roller.svg} lets you copy text formatting (such as bold, italic, font size, color, etc.) and apply it in a different place in the edited document. It helps keep the formatting consistent and speeds up the creation of rich content.

* Slash commands

	The {@link features/slash-commands slash commands feature} lets you execute a command or any custom action by writing its name or alias directly in the editor. When you type a slash (<kbd>/</kbd>), the suggested commands are displayed in a panel next to it. You can also type a phrase after the <kbd>/</kbd> to filter the results in the panel and to easily find the desired command.

* Table of contents

	The {@link features/table-of-contents table of contents feature} {@icon @ckeditor/ckeditor5-document-outline/theme/icons/table-of-contents.svg} lets you insert a widget with a list of headings (section titles) that reflects the structure of the document and will be retained in the editor output data. The list stays up–to–date automatically as the user works on the document. Clicking a list item navigates the user to the corresponding document section.

* Templates

	The {@link features/template templates feature} {@icon @ckeditor/ckeditor5-template/theme/icons/template.svg} allows you to insert predefined content structures into the document. Templates can provide both smaller portions of content (e.g. a formatted table) and base structures for entire documents (e.g. a formal letter template).

* Paste from Office Enhanced

	The {@link features/paste-from-office Paste from Office Enhanced feature} lets you paste content from Microsoft Word and Microsoft Excel and preserve its original structure and formatting. It will retain the basic text styling, heading levels, links, lists, tables, and images.

## Free trial

Before committing, you may try out the productivity pack, just like all CKEditor 5 premium features. To do it, simply start your non-commitment [30-day free trial](https://orders.ckeditor.com/trial/premium-features).

Please refer to the {@link @trial guides/standalone/productivity-pack productivity pack trial} guide for information on how to start using these features in your CKEditor 5 WYSIWYG editor now.

<info-box>
	If you have any further comments or suggestions concerning these features, please [contact us](https://ckeditor.com/contact/) and share them. We will be happy to hear your feedback!
</info-box>
