---
menu-title: TypeScript package
category: package-generator
order: 43
modified_at: 2022-08-16
---

# TypeScript package content

This guide describes the contents of the `TypeScript` package generated by the {@link framework/package-generator/using-package-generator Package Generator}. Please bear in mind that the transition of CKEditor 5 codebase to TypeScript is still in progress and hence some errors might occur. If you encounter one, please [report it](#reporting-issues).

## Structure of the project

An overview of the project's directory structure:

```plain-text
├─ lang
│  └─ contexts.json        # Entries used for creating translations.
├─ sample
│  ├─ dll.html             # The editor initialized using the DLL builds.
│  ├─ index.html           # The sample file.
│  └─ ckeditor.ts          # The editor initialization script.
├─ src
│  ├─ pluginname.ts        # The plugin with example functionality.
│  ├─ augmentation.ts      # Type augmentations for the `@ckeditor/ckeditor5-core` module.
│  ├─ index.ts             # The modules exported by the package when using the DLL builds.
│  └─ **/*.ts              # All TypeScript source files should be saved here.
├─ tests
│  ├─ pluginname.ts
│  ├─ index.ts             # Tests for the plugin.
│  └─ **/*.ts              # All tests should be saved here.
├─ theme
│  ├─ icons
│  │  ├─ ckeditor.svg      # The CKEditor 5 icon displayed in the toolbar.
│  │  └─ **/*.svg          # All icon files should be saved here.
│  └─ **/*.css             # All CSS files should be saved here.
├─ typings
│  └─ **/*.d.ts            # Files containing type definitions.
│
├─ .editorconfig           # See link below for details.
├─ .eslintrc.js            # ESLint configuration file.
├─ .gitattributes          # See link below for details.
├─ .gitignore              # See link below for details.
├─ .stylelintrc            # Stylelint configuration file.
├─ ckeditor5-metadata.json # See link below for details.
├─ LICENSE.md              # All created packages fall under the MIT license.
├─ package.json            # See link below for details.
├─ tsconfig.json           # General TypeScript configuration.
├─ tsconfig.release.json   # Override for options from above file during release process.
└─ README.md               # Description of your project and usage instructions.

```

Guides for developing some of the files:
* [.editorconfig](https://editorconfig.org/)
* [.gitattributes](https://git-scm.com/docs/gitattributes)
* [.gitignore](https://git-scm.com/docs/gitignore)
* {@link framework/contributing/package-metadata ckeditor5-metadata.json}
* [package.json](https://docs.npmjs.com/cli/v7/configuring-npm/package-json)
* [tsconfig.json](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html)
* augmentation.ts - Read more in the [relevant issue](https://github.com/ckeditor/ckeditor5/issues/13433), {@link module:core/plugincollection~PluginsMap} and {@link module:core/commandcollection~CommandsMap}.

## Npm scripts

Npm scripts are a convenient way to provide commands in a project. They are defined in the `package.json` file and shared with other people contributing to the project. It ensures that the developers use the same commands with the same options (flags).

All the scripts can be executed by running `npm run <script>`. Pre and post commands with matching names will be run for those as well.

The following scripts are available in the package.

### `start`

Starts a HTTP server with the live-reload mechanism that allows previewing and testing plugins available in the package.

When the server has been started, the default browser will open the developer sample. This can be disabled by passing the `--no-open` option to that command.

You can also define the language that will translate the created editor by specifying the `--language [LANG]` option. It defaults to `'en'`.

Examples:

```bash
# Starts the server and opens the browser.
npm run start

# Disable auto-opening the browser.
npm run start -- --no-open

# Create the editor with the interface in German.
npm run start -- --language=de
```

### `test`

Allows executing unit tests for the package, specified in the `tests/` directory. The command accepts the following modifiers:

* `--coverage` &ndash; to create the code coverage report,
* `--watch` &ndash; to observe the source files (the command does not end after executing tests),
* `--source-map` &ndash; to generate source maps of the sources,
* `--verbose` &ndash; to print additional webpack logs.

Examples:

```bash
# Execute tests.
npm run test

# Generate code coverage report after each change in the sources.
npm run test -- --coverage --test
```

### `lint`

Runs ESLint, which analyzes the code (all `*.ts` files) to quickly find problems.

Examples:

```bash
# Execute ESLint.
npm run lint
```

### `stylelint`

Similar to the `lint` task, stylelint analyzes the CSS code (`*.css` files in the `theme/` directory) in the package.

Examples:

```bash
# Execute stylelint.
npm run stylelint
```

### `dll:build`

Creates a DLL-compatible package build which can be loaded into an editor using {@link installation/advanced/dll-builds DLL builds}.

Examples:

```bash
# Build the DLL file that is ready to publish.
npm run dll:build

# Build the DLL file and listen to changes in its sources.
npm run dll:build -- --watch
```

### `dll:serve`

Creates a simple HTTP server (without the live-reload mechanism) that allows verifying whether the DLL build of the package is compatible with the CKEditor 5 {@link installation/advanced/dll-builds DLL builds}.

Examples:

```bash
# Starts the HTTP server and opens the browser.
npm run dll:serve
```

<info-box hint>
    You can run `npm run dll:build -- --watch` and `npm run dll:serve` in two separate command terminals. That way, after you save your changes and reload the page, the content will update.
</info-box>

### `translations:collect`

Collects translation messages (arguments of the `t()` function) and context files, then validates whether the provided values do not interfere with the values specified in the `@ckeditor/ckeditor5-core` package.

The task may end with an error if one of the following conditions is met:

* Found the `Unused context` error &ndash; entries specified in the `lang/contexts.json` file are not used in source files. They should be removed.
* Found the `Context is duplicated for the id` error &ndash; some of the entries are duplicated. Consider removing them from the `lang/contexts.json` file, or rewrite them.
* Found the `Context for the message id is missing` error &ndash; entries specified in the source files are not described in the `lang/contexts.json` file. They should be added.

Examples:

```bash
npm run translations:collect
```

### `translations:download`

Download translations from the Transifex server. Depending on users' activity in the project, it creates translations files used for building the editor.

<info-box info>
The task requires passing an organization and project names. Usually, it matches the following format: `https://www.transifex.com/[ORGANIZATION]/[PROJECT]`.

To avoid passing these options every time the command calls for it, you can store it in `package.json`, next to the `ckeditor5-package-tools translations:download` command.
</info-box>

Examples:

```bash
npm run translations:download -- --organization [ORGANIZATION] --project [PROJECT]
```

### `translations:upload`

Uploads translation messages onto the Transifex server. It allows for the creation of translations into other languages by users using the Transifex platform.

<info-box info>
The task requires passing an organization and project names. Usually, it matches the following format: `https://www.transifex.com/[ORGANIZATION]/[PROJECT]`.

To avoid passing these options every time the command calls for it, you can store it in `package.json`, next to the `ckeditor5-package-tools translations:upload` command.
</info-box>

Examples:

```bash
npm run translations:upload -- --organization [ORGANIZATION] --project [PROJECT]
```

### `prepare`, `prepublishOnly` and `postpublish`

Npm supports some special [life cycle scripts](https://docs.npmjs.com/cli/v7/using-npm/scripts#life-cycle-scripts) that allow automatically performing operations in certain situations:

* `prepare` &ndash; triggers during package creation and before publishing.
* `prepublishOnly` &ndash; triggers only before publishing.
* `postpublish` &ndash; triggers after publishing.

Scripts in this package ensure that DLL-compatible package build is available after creation of the package, and that correct files are published:

* DLL-compatible package build.
* TypeScript files compiled to JavaScript, along with their typings exported.
* `package.json` field `main` points to a `.js` file.

...and that cleanup is performed afterwards:

* Compiled TypeScript files are removed, as they clutter `src` directory.
* `package.json` field `main` reverts to pointing to a `.ts` file.

### `ts:build` and `ts:clear`

Those scripts respectively compile TypeScript, and remove the compiled files. They are used in aforementioned life cycle scripts, and there is no need to call them manually.

## How to change ESLint configuration?

To change the ESLint configuration, edit the [.eslintrc.js](https://github.com/ckeditor/ckeditor5-package-generator/blob/master/.eslintrc.js) file. It is also a good idea to check out the [ESLint docs](https://eslint.org/docs/rules/).

### Why are the predefined ESLint rules recommended?

To make CKEditor 5 plugins compatible with each other, we needed to introduce certain limitations when importing files from packages. To learn more, visit the {@link installation/advanced/dll-builds DLL guide} and {@link framework/contributing/code-style#dll-builds-ckeditor5-rulesckeditor-imports see a detailed explanation} about the limitations.

## Translations

Packages created by this tool, just like the entirety of the CKEditor 5 ecosystem, include full support for localization. If you wish to include translations for your package, visit the {@link framework/deep-dive/localization dedicated translation guide} and learn more.

The package generator provides several tools for handling translations in the created package. We recommend the following flow when dealing with translations:

1. Call `npm run translations:download` &ndash; download the latest version of translations.
    * If there are changes in the `lang/translations/*` files, commit them as they represent new or updated translation files.
1. Call `npm run translations:collect` &ndash; verify whether contexts are up-to-date.
1. Call `npm run translations:upload` &ndash; upload new translations.
1. Call `npm run translations:download` &ndash; if new contexts were uploaded, it updates the `en.po` file in the package. Do not forget to commit the change.

## Reporting issues

If you found a problem with CKEditor 5 or the package generator, please, report an issue:

* [CKEditor 5](https://github.com/ckeditor/ckeditor5/issues/new/choose)
* [The package generator](https://github.com/ckeditor/ckeditor5-package-generator/issues/new)
