/*
 * vox.js 1.1.0-beta
 * https://github.com/daishihmr/vox.js
 * 
 * The MIT License (MIT)
 * Copyright © 2015, 2016 daishi_hmr, dev7.jp
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the “Software”), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
"use strict";var vox={};!function(){"undefined"!=typeof window?(vox.global=window,vox.global.vox=vox):vox.global=global,"undefined"!=typeof module&&(module.exports=vox)}(),function(){vox.VoxelData=function(){this.size=null,this.voxels=[],this.palette=[],this.anim=[{size:null,voxels:[]}]}}(),function(){vox.Xhr=function(){},vox.Xhr.prototype.getBinary=function(a){return new Promise(function(b,c){var d=new XMLHttpRequest;d.open("GET",a,!0),d.responseType="arraybuffer",d.onreadystatechange=function(){if(4===d.readyState&&(200===d.status||0===d.status)){var a=d.response;if(a){var c=new Uint8Array(a);b(c)}}},d.send(null)})}}(),function(){if(vox.Parser=function(){},vox.Parser.prototype.parse=function(a){var b=this;return(new vox.Xhr).getBinary(a).then(function(a){return new Promise(function(c,d){b.parseUint8Array(a,function(a,b){a?d(a):c(b)})})})},"undefined"!=typeof require){var a=require("fs");vox.Parser.prototype.parseFile=function(b,c){a.readFile(b,function(a,b){if(a)return c(a);for(var d=new Uint8Array(new ArrayBuffer(b.length)),e=0,f=b.length;e<f;e++)d[e]=b[e];this.parseUint8Array(d,c)}.bind(this))}}vox.Parser.prototype.parseUint8Array=function(a,d){var e=new b(a);try{c(e),e.data.size=e.data.anim[0].size,e.data.voxels=e.data.anim[0].voxels,0===e.data.palette.length?(v("(use default palette)"),e.data.palette=vox.defaultPalette):(e.data.palette.unshift(e.data.palette[0]),e.data.palette.pop()),d(null,e.data)}catch(f){d(f)}};var b=function(a){this.uint8Array=a,this.cursor=0,this.data=new vox.VoxelData,this._arrayArray=[],this._cursorArray=[]};b.prototype.next=function(){if(this.uint8Array.byteLength<=this.cursor)throw new Error("uint8Array index out of bounds: "+this.uint8Array.byteLength);return this.uint8Array[this.cursor++]},b.prototype.hasNext=function(){return this.cursor<this.uint8Array.byteLength},b.prototype.push=function(a){for(var b=new Uint8Array(a),c=0;c<b.length;c++)b[c]=this.next();this._arrayArray.push(this.uint8Array),this._cursorArray.push(this.cursor),this.uint8Array=b,this.cursor=0},b.prototype.pop=function(){this.uint8Array=this._arrayArray.pop(),this.cursor=this._cursorArray.pop()},b.prototype.parseInt32=function(){for(var a=0,b=0;b<4;b++)a+=this.next()*Math.pow(256,b);return~~a},b.prototype.parseString=function(){for(var a=this.parseInt32(),b="",c=0;c<a;c++)b+=String.fromCharCode(this.next());return b},b.prototype.parseDict=function(){for(var a=this.parseInt32(),b={},c=0;c<a;c++){var d=this.parseString(),e=this.parseString();b[d]=e}return b},b.prototype.parseRotation=function(){this.next()};var c=function(a){d(a),e(a),f(a)},d=function(a){for(var b="",c=0;c<4;c++)b+=String.fromCharCode(a.next());if("VOX "!==b)throw new Error("invalid magic number '"+b+"'")},e=function(a){var b=a.parseInt32();console.info(".vox format version "+b)},f=function(a){if(!a.hasNext())return!1;var b=g(a),c=h(a);for(i(a),j(b,c,a);f(a););return a.hasNext()},g=function(a){for(var b="",c=0;c<4;c++)b+=String.fromCharCode(a.next());return v("chunk id = "+b),b},h=function(a){return a.parseInt32()},i=function(a){a.parseInt32()},j=function(a,b,c){switch(c.push(b),a){case"PACK":k(c);break;case"SIZE":l(c);break;case"XYZI":m(c);break;case"RGBA":n(c);break;case"MATT":o(c);break;case"nTRN":p(c);break;case"nGRP":q(c);break;case"nSHP":r(c);break;case"MATL":s(c);break;default:t(c)}c.pop()},k=function(a){var b=a.parseInt32();v("  num of SIZE and XYZI chunks = "+b)},l=function(a){var b=a.parseInt32(),c=a.parseInt32(),d=a.parseInt32();v("  bounding box size = "+b+", "+c+", "+d);var e=a.data.anim[a.data.anim.length-1];e.size&&(e={size:null,voxels:[]},a.data.anim.push(e)),e.size={x:b,y:c,z:d}},m=function(a){var b=a.parseInt32();v("  voxel size = "+b);var c=a.data.anim[a.data.anim.length-1];c.voxels.length&&(c={size:null,voxels:[]},a.data.anim.push(c));for(var d=0;d<b;d++)c.voxels.push({x:a.next(),y:a.next(),z:a.next(),colorIndex:a.next()})},n=function(a){v("  palette");for(var b=0;b<256;b++){var c={r:a.next(),g:a.next(),b:a.next(),a:a.next()};a.data.palette.push(c)}},o=function(a){v("  material");var b=a.parseInt32();v("    id = "+b);var c=a.parseInt32();v("    type = "+c+" (0:diffuse 1:metal 2:glass 3:emissive)");var d=a.parseInt32();v("    weight = "+u(d));var e=a.parseInt32();v("    property bits = "+e.toString(2));var f=!!(1&e),g=!!(2&e),h=!!(4&e),i=!!(8&e),j=!!(16&e),k=!!(32&e),l=!!(64&e),m=!!(128&e);v("      Plastic = "+f),v("      Roughness = "+g),v("      Specular = "+h),v("      IOR = "+i),v("      Attenuation = "+j),v("      Power = "+k),v("      Glow = "+l),v("      isTotalPower = "+m);var n=0;f&&(n+=1),g&&(n+=1),h&&(n+=1),i&&(n+=1),j&&(n+=1),k&&(n+=1),l&&(n+=1);for(var o=[],p=0;p<n;p++)o[p]=a.parseInt32(),v("    normalized property value = "+u(o[p]))},p=function(a){for(var b=a.parseInt32(),c=a.parseDict(),d=a.parseInt32(),e=a.parseInt32(),f=a.parseInt32(),g=a.parseInt32(),h=[],i=0;i<g;i++)h[i]=a.parseDict();v("  nodeId = "+b),v("  nodeAttributes",c),v("  childNodeId = "+d),v("  reservedId = "+e),v("  layerId = "+f),v("  numOfFrames = "+g),v("  frameAttributes",h)},q=function(a){for(var b=a.parseInt32(),c=a.parseDict(),d=a.parseInt32(),e=[],f=0;f<d;f++)e[f]=a.parseInt32();v("  nodeId = "+b),v("  nodeAttributes",c),v("  numOfChildren = "+d),v("  childNodeIds",e)},r=function(a){for(var b=a.parseInt32(),c=a.parseDict(),d=a.parseInt32(),e=[],f=[],g=0;g<d;g++)e[g]=a.parseInt32(),f[g]=a.parseDict();v("  nodeId = "+b),v("  nodeAttributes",c),v("  numOfModels = "+d),v("  modelIds",e),v("  modelAttributes",f)},s=function(a){var b=a.parseInt32(),c=a.parseDict();v("  materialId = "+b),v("  properties",c)},t=function(a){},u=function(a){for(var b=a.toString(2);b.length<32;)b="0"+b;var c="0"==b[0]?1:-1,d=Number.parseInt(b.substring(1,9),2)-127,e=Number.parseFloat("1."+Number.parseInt(b.substring(9),2));return c*Math.pow(2,d)*e},v=function(a,b){}}(),function(){vox.MeshBuilder=function(a,b){null===vox.MeshBuilder.textureFactory&&(vox.MeshBuilder.textureFactory=new vox.TextureFactory),b=b||{},this.voxelData=a,this.voxelSize=b.voxelSize||vox.MeshBuilder.DEFAULT_PARAM.voxelSize,this.vertexColor=void 0===b.vertexColor?vox.MeshBuilder.DEFAULT_PARAM.vertexColor:b.vertexColor,this.optimizeFaces=void 0===b.optimizeFaces?vox.MeshBuilder.DEFAULT_PARAM.optimizeFaces:b.optimizeFaces,this.originToBottom=void 0===b.originToBottom?vox.MeshBuilder.DEFAULT_PARAM.originToBottom:b.originToBottom,this.geometry=null,this.material=null,this.build()},vox.MeshBuilder.DEFAULT_PARAM={voxelSize:1,vertexColor:!1,optimizeFaces:!0,originToBottom:!0},vox.MeshBuilder.prototype.build=function(){this.geometry=new THREE.Geometry,this.material=new THREE.MeshPhongMaterial,this.hashTable=e(this.voxelData.voxels);var a=-.5*(this.voxelData.size.x-1),b=-.5*(this.voxelData.size.y-1),c=this.originToBottom?0:-.5*(this.voxelData.size.z-1),d=new THREE.Matrix4;this.voxelData.voxels.forEach(function(e){var f=this._createVoxGeometry(e);f&&(d.makeTranslation((e.x+a)*this.voxelSize,(e.z+c)*this.voxelSize,-(e.y+b)*this.voxelSize),this.geometry.merge(f,d))}.bind(this)),this.optimizeFaces&&this.geometry.mergeVertices(),this.geometry.computeFaceNormals(),this.vertexColor?this.material.vertexColors=THREE.FaceColors:this.material.map=vox.MeshBuilder.textureFactory.getTexture(this.voxelData)},vox.MeshBuilder.prototype.getTexture=function(){return vox.MeshBuilder.textureFactory.getTexture(this.voxelData)},vox.MeshBuilder.prototype._createVoxGeometry=function(d){var e=[];if(this.optimizeFaces&&a.forEach(function(a){this.hashTable.has(d.x+a.x,d.y+a.y,d.z+a.z)&&e.push(a.ignoreFace)}.bind(this)),6===e.length)return null;var f=b.map(function(a){return new THREE.Vector3(a.x*this.voxelSize*.5,a.y*this.voxelSize*.5,a.z*this.voxelSize*.5)}.bind(this)),g=c.map(function(a){return{faceA:new THREE.Face3(a.faceA.a,a.faceA.b,a.faceA.c),faceB:new THREE.Face3(a.faceB.a,a.faceB.b,a.faceB.c)}});if(this.vertexColor)var h=this.voxelData.palette[d.colorIndex],i=new THREE.Color(h.r/255,h.g/255,h.b/255);var j=new THREE.Geometry;j.faceVertexUvs[0]=[],g.forEach(function(a,b){if(!(e.indexOf(b)>=0)){if(this.vertexColor)a.faceA.color=i,a.faceB.color=i;else{var c=new THREE.Vector2((d.colorIndex+.5)/256,.5);j.faceVertexUvs[0].push([c,c,c],[c,c,c])}j.faces.push(a.faceA,a.faceB)}}.bind(this));var k={};j.faces.forEach(function(a){k[a.a]=!0,k[a.b]=!0,k[a.c]=!0});var l=function(a){j.faces.forEach(function(b){b.a>a&&(b.a-=1),b.b>a&&(b.b-=1),b.c>a&&(b.c-=1)})},m=0;return f.forEach(function(a,b){k[b]?j.vertices.push(a):(l(b-m),m+=1)}),j},vox.MeshBuilder.prototype.createMesh=function(){return new THREE.Mesh(this.geometry,this.material)},vox.MeshBuilder.prototype.isOuterVoxel=function(b){return a.filter(function(a){return this.hashTable.has(b.x+a.x,b.y+a.y,b.z+a.z)}.bind(this)).length<6},vox.MeshBuilder.textureFactory=null;var a=[{x:-1,y:0,z:0,ignoreFace:0},{x:1,y:0,z:0,ignoreFace:1},{x:0,y:-1,z:0,ignoreFace:5},{x:0,y:1,z:0,ignoreFace:4},{x:0,y:0,z:-1,ignoreFace:2},{x:0,y:0,z:1,ignoreFace:3}],b=[{x:-1,y:1,z:-1},{x:1,y:1,z:-1},{x:-1,y:1,z:1},{x:1,y:1,z:1},{x:-1,y:-1,z:-1},{x:1,y:-1,z:-1},{x:-1,y:-1,z:1},{x:1,y:-1,z:1}],c=[{faceA:{a:6,b:2,c:0},faceB:{a:6,b:0,c:4}},{faceA:{a:5,b:1,c:3},faceB:{a:5,b:3,c:7}},{faceA:{a:5,b:7,c:6},faceB:{a:5,b:6,c:4}},{faceA:{a:2,b:3,c:1},faceB:{a:2,b:1,c:0}},{faceA:{a:4,b:0,c:1},faceB:{a:4,b:1,c:5}},{faceA:{a:7,b:3,c:2},faceB:{a:7,b:2,c:6}}],d=function(a,b,c){return"x"+a+"y"+b+"z"+c},e=function(a){var b={};return a.forEach(function(a){b[d(a.x,a.y,a.z)]=!0}),b.has=function(a,b,c){return d(a,b,c)in this},b}}(),function(){vox.TextureFactory=function(){},vox.TextureFactory.prototype.createCanvas=function(a){var b=document.createElement("canvas");b.width=256,b.height=1;for(var c=b.getContext("2d"),d=0,e=a.palette.length;d<e;d++){var f=a.palette[d];c.fillStyle="rgb("+f.r+","+f.g+","+f.b+")",c.fillRect(1*d,0,1,1)}return b},vox.TextureFactory.prototype.getTexture=function(c){var d=c.palette,e=b(d);if(e in a)return a[e];var f=this.createCanvas(c),g=new THREE.Texture(f);return g.needsUpdate=!0,a[e]=g,g};var a={},b=function(a){for(var b="",d=0;d<256;d++){var e=a[d];b+=c(e.r),b+=c(e.g),b+=c(e.b),b+=c(e.a)}return vox.md5(b)},c=function(a){var b=a.toString(16);return 1===b.length?"0"+b:b}}(),function(){vox.defaultPalette=[{r:255,g:255,b:255,a:255},{r:255,g:255,b:255,a:255},{r:255,g:255,b:204,a:255},{r:255,g:255,b:153,a:255},{r:255,g:255,b:102,a:255},{r:255,g:255,b:51,a:255},{r:255,g:255,b:0,a:255},{r:255,g:204,b:255,a:255},{r:255,g:204,b:204,a:255},{r:255,g:204,b:153,a:255},{r:255,g:204,b:102,a:255},{r:255,g:204,b:51,a:255},{r:255,g:204,b:0,a:255},{r:255,g:153,b:255,a:255},{r:255,g:153,b:204,a:255},{r:255,g:153,b:153,a:255},{r:255,g:153,b:102,a:255},{r:255,g:153,b:51,a:255},{r:255,g:153,b:0,a:255},{r:255,g:102,b:255,a:255},{r:255,g:102,b:204,a:255},{r:255,g:102,b:153,a:255},{r:255,g:102,b:102,a:255},{r:255,g:102,b:51,a:255},{r:255,g:102,b:0,a:255},{r:255,g:51,b:255,a:255},{r:255,g:51,b:204,a:255},{r:255,g:51,b:153,a:255},{r:255,g:51,b:102,a:255},{r:255,g:51,b:51,a:255},{r:255,g:51,b:0,a:255},{r:255,g:0,b:255,a:255},{r:255,g:0,b:204,a:255},{r:255,g:0,b:153,a:255},{r:255,g:0,b:102,a:255},{r:255,g:0,b:51,a:255},{r:255,g:0,b:0,a:255},{r:204,g:255,b:255,a:255},{r:204,g:255,b:204,a:255},{r:204,g:255,b:153,a:255},{r:204,g:255,b:102,a:255},{r:204,g:255,b:51,a:255},{r:204,g:255,b:0,a:255},{r:204,g:204,b:255,a:255},{r:204,g:204,b:204,a:255},{r:204,g:204,b:153,a:255},{r:204,g:204,b:102,a:255},{r:204,g:204,b:51,a:255},{r:204,g:204,b:0,a:255},{r:204,g:153,b:255,a:255},{r:204,g:153,b:204,a:255},{r:204,g:153,b:153,a:255},{r:204,g:153,b:102,a:255},{r:204,g:153,b:51,a:255},{r:204,g:153,b:0,a:255},{r:204,g:102,b:255,a:255},{r:204,g:102,b:204,a:255},{r:204,g:102,b:153,a:255},{r:204,g:102,b:102,a:255},{r:204,g:102,b:51,a:255},{r:204,g:102,b:0,a:255},{r:204,g:51,b:255,a:255},{r:204,g:51,b:204,a:255},{r:204,g:51,b:153,a:255},{r:204,g:51,b:102,a:255},{r:204,g:51,b:51,a:255},{r:204,g:51,b:0,a:255},{r:204,g:0,b:255,a:255},{r:204,g:0,b:204,a:255},{r:204,g:0,b:153,a:255},{r:204,g:0,b:102,a:255},{r:204,g:0,b:51,a:255},{r:204,g:0,b:0,a:255},{r:153,g:255,b:255,a:255},{r:153,g:255,b:204,a:255},{r:153,g:255,b:153,a:255},{r:153,g:255,b:102,a:255},{r:153,g:255,b:51,a:255},{r:153,g:255,b:0,a:255},{r:153,g:204,b:255,a:255},{r:153,g:204,b:204,a:255},{r:153,g:204,b:153,a:255},{r:153,g:204,b:102,a:255},{r:153,g:204,b:51,a:255},{r:153,g:204,b:0,a:255},{r:153,g:153,b:255,a:255},{r:153,g:153,b:204,a:255},{r:153,g:153,b:153,a:255},{r:153,g:153,b:102,a:255},{r:153,g:153,b:51,a:255},{r:153,g:153,b:0,a:255},{r:153,g:102,b:255,a:255},{r:153,g:102,b:204,a:255},{r:153,g:102,b:153,a:255},{r:153,g:102,b:102,a:255},{r:153,g:102,b:51,a:255},{r:153,g:102,b:0,a:255},{r:153,g:51,b:255,a:255},{r:153,g:51,b:204,a:255},{r:153,g:51,b:153,a:255},{r:153,g:51,b:102,a:255},{r:153,g:51,b:51,a:255},{r:153,g:51,b:0,a:255},{r:153,g:0,b:255,a:255},{r:153,g:0,b:204,a:255},{r:153,g:0,b:153,a:255},{r:153,g:0,b:102,a:255},{r:153,g:0,b:51,a:255},{r:153,g:0,b:0,a:255},{r:102,g:255,b:255,a:255},{r:102,g:255,b:204,a:255},{r:102,g:255,b:153,a:255},{r:102,g:255,b:102,a:255},{r:102,g:255,b:51,a:255},{r:102,g:255,b:0,a:255},{r:102,g:204,b:255,a:255},{r:102,g:204,b:204,a:255},{r:102,g:204,b:153,a:255},{r:102,g:204,b:102,a:255},{r:102,g:204,b:51,a:255},{r:102,g:204,b:0,a:255},{r:102,g:153,b:255,a:255},{r:102,g:153,b:204,a:255},{r:102,g:153,b:153,a:255},{r:102,g:153,b:102,a:255},{r:102,g:153,b:51,a:255},{r:102,g:153,b:0,a:255},{r:102,g:102,b:255,a:255},{r:102,g:102,b:204,a:255},{r:102,g:102,b:153,a:255},{r:102,g:102,b:102,a:255},{r:102,g:102,b:51,a:255},{r:102,g:102,b:0,a:255},{r:102,g:51,b:255,a:255},{r:102,g:51,b:204,a:255},{r:102,g:51,b:153,a:255},{r:102,g:51,b:102,a:255},{r:102,g:51,b:51,a:255},{r:102,g:51,b:0,a:255},{r:102,g:0,b:255,a:255},{r:102,g:0,b:204,a:255},{r:102,g:0,b:153,a:255},{r:102,g:0,b:102,a:255},{r:102,g:0,b:51,a:255},{r:102,g:0,b:0,a:255},{r:51,g:255,b:255,a:255},{r:51,g:255,b:204,a:255},{r:51,g:255,b:153,a:255},{r:51,g:255,b:102,a:255},{r:51,g:255,b:51,a:255},{r:51,g:255,b:0,a:255},{r:51,g:204,b:255,a:255},{r:51,g:204,b:204,a:255},{r:51,g:204,b:153,a:255},{r:51,g:204,b:102,a:255},{r:51,g:204,b:51,a:255},{r:51,g:204,b:0,a:255},{r:51,g:153,b:255,a:255},{r:51,g:153,b:204,a:255},{r:51,g:153,b:153,a:255},{r:51,g:153,b:102,a:255},{r:51,g:153,b:51,a:255},{r:51,g:153,b:0,a:255},{r:51,g:102,b:255,a:255},{r:51,g:102,b:204,a:255},{r:51,g:102,b:153,a:255},{r:51,g:102,b:102,a:255},{r:51,g:102,b:51,a:255},{r:51,g:102,b:0,a:255},{r:51,g:51,b:255,a:255},{r:51,g:51,b:204,a:255},{r:51,g:51,b:153,a:255},{r:51,g:51,b:102,a:255},{r:51,g:51,b:51,a:255},{r:51,g:51,b:0,a:255},{r:51,g:0,b:255,a:255},{r:51,g:0,b:204,a:255},{r:51,g:0,b:153,a:255},{r:51,g:0,b:102,a:255},{r:51,g:0,b:51,a:255},{r:51,g:0,b:0,a:255},{r:0,g:255,b:255,a:255},{r:0,g:255,b:204,a:255},{r:0,g:255,b:153,a:255},{r:0,g:255,b:102,a:255},{r:0,g:255,b:51,a:255},{r:0,g:255,b:0,a:255},{r:0,g:204,b:255,a:255},{r:0,g:204,b:204,a:255},{r:0,g:204,b:153,a:255},{r:0,g:204,b:102,a:255},{r:0,g:204,b:51,a:255},{r:0,g:204,b:0,a:255},{r:0,g:153,b:255,a:255},{r:0,g:153,b:204,a:255},{r:0,g:153,b:153,a:255},{r:0,g:153,b:102,a:255},{r:0,g:153,b:51,a:255},{r:0,g:153,b:0,a:255},{r:0,g:102,b:255,a:255},{r:0,g:102,b:204,a:255},{r:0,g:102,b:153,a:255},{r:0,g:102,b:102,a:255},{r:0,g:102,b:51,a:255},{r:0,g:102,b:0,a:255},{r:0,g:51,b:255,a:255},{r:0,g:51,b:204,a:255},{r:0,g:51,b:153,a:255},{r:0,g:51,b:102,a:255},{r:0,g:51,b:51,a:255},{r:0,g:51,b:0,a:255},{r:0,g:0,b:255,a:255},{r:0,g:0,b:204,a:255},{r:0,g:0,b:153,a:255},{r:0,g:0,b:102,a:255},{r:0,g:0,b:51,a:255},{r:238,g:0,b:0,a:255},{r:221,g:0,b:0,a:255},{r:187,g:0,b:0,a:255},{r:170,g:0,b:0,a:255},{r:136,g:0,b:0,a:255},{r:119,g:0,b:0,a:255},{r:85,g:0,b:0,a:255},{r:68,g:0,b:0,a:255},{r:34,g:0,b:0,a:255},{r:17,g:0,b:0,a:255},{r:0,g:238,b:0,a:255},{r:0,g:221,b:0,a:255},{r:0,g:187,b:0,a:255},{r:0,g:170,b:0,a:255},{r:0,g:136,b:0,a:255},{r:0,g:119,b:0,a:255},{r:0,g:85,b:0,a:255},{r:0,g:68,b:0,a:255},{r:0,g:34,b:0,a:255},{r:0,g:17,b:0,a:255},{r:0,g:0,b:238,a:255},{r:0,g:0,b:221,a:255},{r:0,g:0,b:187,a:255},{r:0,g:0,b:170,a:255},{r:0,g:0,b:136,a:255},{r:0,g:0,b:119,a:255},{r:0,g:0,b:85,a:255},{r:0,g:0,b:68,a:255},{r:0,g:0,b:34,a:255},{r:0,g:0,b:17,a:255},{r:238,g:238,b:238,a:255},{r:221,g:221,b:221,a:255},{r:187,g:187,b:187,a:255},{r:170,g:170,b:170,a:255},{r:136,g:136,b:136,a:255},{r:119,g:119,b:119,a:255},{r:85,g:85,b:85,a:255},{r:68,g:68,b:68,a:255},{r:34,g:34,b:34,a:255},{r:17,g:17,b:17,a:255}]}(),function(){function a(a,b,c){return a&b|~a&c}function b(a,b,c){return a&c|b&~c}function c(a,b,c){return a^b^c}function d(a,b,c){return b^(a|~c)}function e(a){return String.fromCharCode(255&a)+String.fromCharCode(a>>>8&255)+String.fromCharCode(a>>>16&255)+String.fromCharCode(a>>>24&255)}function f(a){for(;a<0;)a+=4294967296;for(;a>4294967295;)a-=4294967296;return a}function g(a,b,c,d,e){var g,h,i,k,l,m,n,o,p;g=d[0],h=d[1],i=d[2],k=d[3],l=e[0],m=e[1],n=e[2],p=c(b[h],b[i],b[k]),o=b[g]+p+a[l]+j[n],o=f(o),o=o<<m|o>>>32-m,o+=b[h],b[g]=f(o)}function h(a){var b,c,d,h,i,j,k,l,m,n,p,q,r;if(d=new Array(1732584193,4023233417,2562383102,271733878),i=a.length,j=63&i,(k=j<56?56-j:120-j)>0)for(a+="",n=0;n<k-1;n++)a+="\0";for(a+=e(8*i),a+=e(0),i+=k+8,b=new Array(0,1,2,3),c=new Array(16),h=new Array(4),q=0;q<i;q+=64){for(n=0,p=q;n<16;n++,p+=4)c[n]=a.charCodeAt(p)|a.charCodeAt(p+1)<<8|a.charCodeAt(p+2)<<16|a.charCodeAt(p+3)<<24;for(n=0;n<4;n++)h[n]=d[n];for(n=0;n<4;n++)for(l=o[n][0],m=o[n][1],p=0;p<16;p++)g(c,h,l,b,m[p]),r=b[0],b[0]=b[3],b[3]=b[2],b[2]=b[1],b[1]=r;for(n=0;n<4;n++)d[n]+=h[n],d[n]=f(d[n])}return e(d[0])+e(d[1])+e(d[2])+e(d[3])}function i(a){var b,c,d,e;for(e=h(a),c="",b=0;b<16;b++)d=e.charCodeAt(b),c+="0123456789abcdef".charAt(d>>4&15),c+="0123456789abcdef".charAt(15&d);return c}var j=new Array(0,3614090360,3905402710,606105819,3250441966,4118548399,1200080426,2821735955,4249261313,1770035416,2336552879,4294925233,2304563134,1804603682,4254626195,2792965006,1236535329,4129170786,3225465664,643717713,3921069994,3593408605,38016083,3634488961,3889429448,568446438,3275163606,4107603335,1163531501,2850285829,4243563512,1735328473,2368359562,4294588738,2272392833,1839030562,4259657740,2763975236,1272893353,4139469664,3200236656,681279174,3936430074,3572445317,76029189,3654602809,3873151461,530742520,3299628645,4096336452,1126891415,2878612391,4237533241,1700485571,2399980690,4293915773,2240044497,1873313359,4264355552,2734768916,1309151649,4149444226,3174756917,718787259,3951481745),k=new Array(new Array(0,7,1),new Array(1,12,2),new Array(2,17,3),new Array(3,22,4),new Array(4,7,5),new Array(5,12,6),new Array(6,17,7),new Array(7,22,8),new Array(8,7,9),new Array(9,12,10),new Array(10,17,11),new Array(11,22,12),new Array(12,7,13),new Array(13,12,14),new Array(14,17,15),new Array(15,22,16)),l=new Array(new Array(1,5,17),new Array(6,9,18),new Array(11,14,19),new Array(0,20,20),new Array(5,5,21),new Array(10,9,22),new Array(15,14,23),new Array(4,20,24),new Array(9,5,25),new Array(14,9,26),new Array(3,14,27),new Array(8,20,28),new Array(13,5,29),new Array(2,9,30),new Array(7,14,31),new Array(12,20,32)),m=new Array(new Array(5,4,33),new Array(8,11,34),new Array(11,16,35),new Array(14,23,36),new Array(1,4,37),new Array(4,11,38),new Array(7,16,39),new Array(10,23,40),new Array(13,4,41),new Array(0,11,42),new Array(3,16,43),new Array(6,23,44),new Array(9,4,45),new Array(12,11,46),new Array(15,16,47),new Array(2,23,48)),n=new Array(new Array(0,6,49),new Array(7,10,50),new Array(14,15,51),new Array(5,21,52),new Array(12,6,53),new Array(3,10,54),new Array(10,15,55),new Array(1,21,56),new Array(8,6,57),new Array(15,10,58),new Array(6,15,59),new Array(13,21,60),new Array(4,6,61),new Array(11,10,62),new Array(2,15,63),new Array(9,21,64)),o=new Array(new Array(a,k),new Array(b,l),new Array(c,m),new Array(d,n));vox.md5=i}();