import { toDate } from "../toDate/index.js";
import type { DateArg } from "../types.js";

/**
 * @name isBefore
 * @category Common Helpers
 * @summary Is the first date before the second one?
 *
 * @description
 * Is the first date before the second one?
 *
 * @param date - The date that should be before the other one to return true
 * @param dateToCompare - The date to compare with
 *
 * @returns The first date is before the second date
 *
 * @example
 * // Is 10 July 1989 before 11 February 1987?
 * const result = isBefore(new Date(1989, 6, 10), new Date(1987, 1, 11))
 * //=> false
 */
export function isBefore(
  date: DateArg<Date> & {},
  dateToCompare: DateArg<Date> & {},
): boolean {
  return +toDate(date) < +toDate(dateToCompare);
}
