import { toDate } from "../toDate/index.js";
import type { DateArg } from "../types.js";

/**
 * @name isFuture
 * @category Common Helpers
 * @summary Is the given date in the future?
 * @pure false
 *
 * @description
 * Is the given date in the future?
 *
 * @param date - The date to check
 *
 * @returns The date is in the future
 *
 * @example
 * // If today is 6 October 2014, is 31 December 2014 in the future?
 * const result = isFuture(new Date(2014, 11, 31))
 * //=> true
 */
export function isFuture(date: DateArg<Date> & {}): boolean {
  return +toDate(date) > Date.now();
}
