# Afrikaans (af) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ste                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5de                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ste                                           | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5de                                               | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1ste                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2de                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1ste kwartaal                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2de kwartaal                                      | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1ste                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2de                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1ste kwartaal                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2de kwartaal                                      | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1ste                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2de                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3de                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4de                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5de                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6de                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7de                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8ste                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9de                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10de                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11de                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12de                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | Jan                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Feb                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mrt                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Apr                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mei                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Jun                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Jul                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Aug                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Sep                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Okt                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nov                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Des                                               | Invalid Date             |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | Januarie                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Februarie                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Maart                                             | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | April                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mei                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Junie                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Julie                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Augustus                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | September                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Oktober                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | November                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Desember                                          | Invalid Date             |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                 | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1ste                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2de                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3de                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4de                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5de                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6de                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7de                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8ste                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9de                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10de                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11de                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12de                                              | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | Jan                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Feb                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mrt                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Apr                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mei                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Jun                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Jul                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Aug                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Sep                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Okt                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nov                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Des                                               | Invalid Date             |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | Januarie                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Februarie                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Maart                                             | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | April                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mei                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Junie                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Julie                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Augustus                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | September                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Oktober                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | November                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Desember                                          | Invalid Date             |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                 | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1ste                                              | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49ste                                             | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1ste                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ste                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1ste                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11de                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28ste                                             | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1ste Februarie                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11de Februarie                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28ste Februarie                                   | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42ste                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365ste                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Maandag                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vrydag                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Ma                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vr                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1ste                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5de                                               | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Maandag                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vrydag                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Ma                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vr                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2de                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6de                                               | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Maandag                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vrydag                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Ma                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vr                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2de                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6de                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Maa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vry                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Maandag                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vrydag                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Ma                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Vr                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | vm                                                | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | uur die oggend                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | uur die middag                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | uur die oggend                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | uur die middag                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | uur die oggend                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | uur die middag                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | uur die oggend                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | uur die middag                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | uur die oggend                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | uur die middag                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | uur die aand                                      | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11de                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11de                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11de                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ste                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11de                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11de                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11de                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ste                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1ste                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ste                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1ste                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55ste                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987/01/11                                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11                                        | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11                                        | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 Jan 1987                                       | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Feb 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Mrt 1987                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Apr 1987                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mei 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Jun 1987                                       | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Jul 1987                                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Aug 1987                                       | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Sep 1987                                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Okt 1987                                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Nov 1987                                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Des 1987                                       | Invalid Date             |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 Januarie 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Februarie 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Maart 1987                                     | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 April 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mei 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Junie 1987                                     | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Julie 1987                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Augustus 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 September 1987                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Oktober 1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 November 1987                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Desember 1987                                  | Invalid Date             |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | Sondag, 11 Januarie 1987                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Woensdag, 11 Februarie 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Woensdag, 11 Maart 1987                           | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | Saterdag, 11 April 1987                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Sondag, 29 Mei 1453                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Donderdag, 11 Junie 1987                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Saterdag, 11 Julie 1987                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Dinsdag, 11 Augustus 1987                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Vrydag, 11 September 1987                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Sondag, 11 Oktober 1987                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Woensdag, 11 November 1987                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Vrydag, 11 Desember 1987                          | Invalid Date             |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                             | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                          | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987/01/11, 12:13                                 | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11, 12:13                                 | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11, 12:13                                 | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11, 12:13                                 | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11, 12:13                                 | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11, 12:13                                 | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11, 12:13                                 | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11, 12:13                                 | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11, 12:13                                 | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11, 12:13                                 | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 Jan 1987, 12:13:14                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Feb 1987, 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Mrt 1987, 12:13:14                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Apr 1987, 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mei 1453, 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Jun 1987, 12:13:14                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Jul 1987, 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Aug 1987, 12:13:14                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Sep 1987, 12:13:14                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Okt 1987, 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Nov 1987, 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Des 1987, 12:13:14                             | Invalid Date             |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 Januarie 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Februarie 1987 om 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Maart 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 April 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mei 1453 om 23:59:59 GMT+0                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Junie 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Julie 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Augustus 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 September 1987 om 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Oktober 1987 om 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 November 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Desember 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | Sondag, 11 Januarie 1987 om 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | Woensdag, 11 Februarie 1987 om 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | Woensdag, 11 Maart 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | Saterdag, 11 April 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Sondag, 29 Mei 1453 om 23:59:59 GMT+00:00         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | Donderdag, 11 Junie 1987 om 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | Saterdag, 11 Julie 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | Dinsdag, 11 Augustus 1987 om 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | Vrydag, 11 September 1987 om 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | Sondag, 11 Oktober 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | Woensdag, 11 November 1987 om 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | Vrydag, 11 Desember 1987 om 12:13:14 GMT+00:00    | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result              | `includeSeconds: true` | `addSuffix: true`          |
| ------------------------ | ------------------- | ---------------------- | -------------------------- |
| 2006-01-01T00:00:00.000Z | ongeveer 6 jaar     | ongeveer 6 jaar        | oor ongeveer 6 jaar        |
| 2005-01-01T00:00:00.000Z | ongeveer 5 jaar     | ongeveer 5 jaar        | oor ongeveer 5 jaar        |
| 2004-01-01T00:00:00.000Z | ongeveer 4 jaar     | ongeveer 4 jaar        | oor ongeveer 4 jaar        |
| 2003-01-01T00:00:00.000Z | ongeveer 3 jaar     | ongeveer 3 jaar        | oor ongeveer 3 jaar        |
| 2002-01-01T00:00:00.000Z | ongeveer 2 jaar     | ongeveer 2 jaar        | oor ongeveer 2 jaar        |
| 2001-06-01T00:00:00.000Z | meer as 1 jaar      | meer as 1 jaar         | oor meer as 1 jaar         |
| 2001-02-01T00:00:00.000Z | ongeveer 1 jaar     | ongeveer 1 jaar        | oor ongeveer 1 jaar        |
| 2001-01-01T00:00:00.000Z | ongeveer 1 jaar     | ongeveer 1 jaar        | oor ongeveer 1 jaar        |
| 2000-06-01T00:00:00.000Z | 5 maande            | 5 maande               | oor 5 maande               |
| 2000-03-01T00:00:00.000Z | 2 maande            | 2 maande               | oor 2 maande               |
| 2000-02-01T00:00:00.000Z | ongeveer 1 maand    | ongeveer 1 maand       | oor ongeveer 1 maand       |
| 2000-01-15T00:00:00.000Z | 14 dae              | 14 dae                 | oor 14 dae                 |
| 2000-01-02T00:00:00.000Z | 1 dag               | 1 dag                  | oor 1 dag                  |
| 2000-01-01T06:00:00.000Z | ongeveer 6 ure      | ongeveer 6 ure         | oor ongeveer 6 ure         |
| 2000-01-01T01:00:00.000Z | ongeveer 1 uur      | ongeveer 1 uur         | oor ongeveer 1 uur         |
| 2000-01-01T00:45:00.000Z | ongeveer 1 uur      | ongeveer 1 uur         | oor ongeveer 1 uur         |
| 2000-01-01T00:30:00.000Z | 30 minute           | 30 minute              | oor 30 minute              |
| 2000-01-01T00:15:00.000Z | 15 minute           | 15 minute              | oor 15 minute              |
| 2000-01-01T00:01:00.000Z | 'n minuut           | 'n minuut              | oor 'n minuut              |
| 2000-01-01T00:00:25.000Z | minder as 'n minuut | 'n halwe minuut        | oor minder as 'n minuut    |
| 2000-01-01T00:00:15.000Z | minder as 'n minuut | minder as 20 sekondes  | oor minder as 'n minuut    |
| 2000-01-01T00:00:05.000Z | minder as 'n minuut | minder as 10 sekondes  | oor minder as 'n minuut    |
| 2000-01-01T00:00:00.000Z | minder as 'n minuut | minder as 5 sekondes   | minder as 'n minuut gelede |
| 1999-12-31T23:59:55.000Z | minder as 'n minuut | minder as 10 sekondes  | minder as 'n minuut gelede |
| 1999-12-31T23:59:45.000Z | minder as 'n minuut | minder as 20 sekondes  | minder as 'n minuut gelede |
| 1999-12-31T23:59:35.000Z | minder as 'n minuut | 'n halwe minuut        | minder as 'n minuut gelede |
| 1999-12-31T23:59:00.000Z | 'n minuut           | 'n minuut              | 'n minuut gelede           |
| 1999-12-31T23:45:00.000Z | 15 minute           | 15 minute              | 15 minute gelede           |
| 1999-12-31T23:30:00.000Z | 30 minute           | 30 minute              | 30 minute gelede           |
| 1999-12-31T23:15:00.000Z | ongeveer 1 uur      | ongeveer 1 uur         | ongeveer 1 uur gelede      |
| 1999-12-31T23:00:00.000Z | ongeveer 1 uur      | ongeveer 1 uur         | ongeveer 1 uur gelede      |
| 1999-12-31T18:00:00.000Z | ongeveer 6 ure      | ongeveer 6 ure         | ongeveer 6 ure gelede      |
| 1999-12-30T00:00:00.000Z | 2 dae               | 2 dae                  | 2 dae gelede               |
| 1999-12-15T00:00:00.000Z | 17 dae              | 17 dae                 | 17 dae gelede              |
| 1999-12-01T00:00:00.000Z | ongeveer 1 maand    | ongeveer 1 maand       | ongeveer 1 maand gelede    |
| 1999-11-01T00:00:00.000Z | 2 maande            | 2 maande               | 2 maande gelede            |
| 1999-06-01T00:00:00.000Z | 7 maande            | 7 maande               | 7 maande gelede            |
| 1999-01-01T00:00:00.000Z | ongeveer 1 jaar     | ongeveer 1 jaar        | ongeveer 1 jaar gelede     |
| 1998-12-01T00:00:00.000Z | ongeveer 1 jaar     | ongeveer 1 jaar        | ongeveer 1 jaar gelede     |
| 1998-06-01T00:00:00.000Z | meer as 1 jaar      | meer as 1 jaar         | meer as 1 jaar gelede      |
| 1998-01-01T00:00:00.000Z | ongeveer 2 jaar     | ongeveer 2 jaar        | ongeveer 2 jaar gelede     |
| 1997-01-01T00:00:00.000Z | ongeveer 3 jaar     | ongeveer 3 jaar        | ongeveer 3 jaar gelede     |
| 1996-01-01T00:00:00.000Z | ongeveer 4 jaar     | ongeveer 4 jaar        | ongeveer 4 jaar gelede     |
| 1995-01-01T00:00:00.000Z | ongeveer 5 jaar     | ongeveer 5 jaar        | ongeveer 5 jaar gelede     |
| 1994-01-01T00:00:00.000Z | ongeveer 6 jaar     | ongeveer 6 jaar        | ongeveer 6 jaar gelede     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 jaar      | oor 6 jaar         | 52608 ure                      |
| 2005-01-01T00:00:00.000Z | 5 jaar      | oor 5 jaar         | 43848 ure                      |
| 2004-01-01T00:00:00.000Z | 4 jaar      | oor 4 jaar         | 35064 ure                      |
| 2003-01-01T00:00:00.000Z | 3 jaar      | oor 3 jaar         | 26304 ure                      |
| 2002-01-01T00:00:00.000Z | 2 jaar      | oor 2 jaar         | 17544 ure                      |
| 2001-06-01T00:00:00.000Z | 1 jaar      | oor 1 jaar         | 12408 ure                      |
| 2001-02-01T00:00:00.000Z | 1 jaar      | oor 1 jaar         | 9528 ure                       |
| 2001-01-01T00:00:00.000Z | 1 jaar      | oor 1 jaar         | 8784 ure                       |
| 2000-06-01T00:00:00.000Z | 5 maande    | oor 5 maande       | 3648 ure                       |
| 2000-03-01T00:00:00.000Z | 2 maande    | oor 2 maande       | 1440 ure                       |
| 2000-02-01T00:00:00.000Z | 1 maand     | oor 1 maand        | 744 ure                        |
| 2000-01-15T00:00:00.000Z | 14 dae      | oor 14 dae         | 336 ure                        |
| 2000-01-02T00:00:00.000Z | 1 dag       | oor 1 dag          | 24 ure                         |
| 2000-01-01T06:00:00.000Z | 6 ure       | oor 6 ure          | 6 ure                          |
| 2000-01-01T01:00:00.000Z | 1 uur       | oor 1 uur          | 1 uur                          |
| 2000-01-01T00:45:00.000Z | 45 minute   | oor 45 minute      | 1 uur                          |
| 2000-01-01T00:30:00.000Z | 30 minute   | oor 30 minute      | 1 uur                          |
| 2000-01-01T00:15:00.000Z | 15 minute   | oor 15 minute      | 0 ure                          |
| 2000-01-01T00:01:00.000Z | 'n minuut   | oor 'n minuut      | 0 ure                          |
| 2000-01-01T00:00:25.000Z | 25 sekondes | oor 25 sekondes    | 0 ure                          |
| 2000-01-01T00:00:15.000Z | 15 sekondes | oor 15 sekondes    | 0 ure                          |
| 2000-01-01T00:00:05.000Z | 5 sekondes  | oor 5 sekondes     | 0 ure                          |
| 2000-01-01T00:00:00.000Z | 0 sekondes  | 0 sekondes gelede  | 0 ure                          |
| 1999-12-31T23:59:55.000Z | 5 sekondes  | 5 sekondes gelede  | 0 ure                          |
| 1999-12-31T23:59:45.000Z | 15 sekondes | 15 sekondes gelede | 0 ure                          |
| 1999-12-31T23:59:35.000Z | 25 sekondes | 25 sekondes gelede | 0 ure                          |
| 1999-12-31T23:59:00.000Z | 'n minuut   | 'n minuut gelede   | 0 ure                          |
| 1999-12-31T23:45:00.000Z | 15 minute   | 15 minute gelede   | 0 ure                          |
| 1999-12-31T23:30:00.000Z | 30 minute   | 30 minute gelede   | 1 uur                          |
| 1999-12-31T23:15:00.000Z | 45 minute   | 45 minute gelede   | 1 uur                          |
| 1999-12-31T23:00:00.000Z | 1 uur       | 1 uur gelede       | 1 uur                          |
| 1999-12-31T18:00:00.000Z | 6 ure       | 6 ure gelede       | 6 ure                          |
| 1999-12-30T00:00:00.000Z | 2 dae       | 2 dae gelede       | 48 ure                         |
| 1999-12-15T00:00:00.000Z | 17 dae      | 17 dae gelede      | 408 ure                        |
| 1999-12-01T00:00:00.000Z | 1 maand     | 1 maand gelede     | 744 ure                        |
| 1999-11-01T00:00:00.000Z | 2 maande    | 2 maande gelede    | 1464 ure                       |
| 1999-06-01T00:00:00.000Z | 7 maande    | 7 maande gelede    | 5136 ure                       |
| 1999-01-01T00:00:00.000Z | 1 jaar      | 1 jaar gelede      | 8760 ure                       |
| 1998-12-01T00:00:00.000Z | 1 jaar      | 1 jaar gelede      | 9504 ure                       |
| 1998-06-01T00:00:00.000Z | 2 jaar      | 2 jaar gelede      | 13896 ure                      |
| 1998-01-01T00:00:00.000Z | 2 jaar      | 2 jaar gelede      | 17520 ure                      |
| 1997-01-01T00:00:00.000Z | 3 jaar      | 3 jaar gelede      | 26280 ure                      |
| 1996-01-01T00:00:00.000Z | 4 jaar      | 4 jaar gelede      | 35064 ure                      |
| 1995-01-01T00:00:00.000Z | 5 jaar      | 5 jaar gelede      | 43824 ure                      |
| 1994-01-01T00:00:00.000Z | 6 jaar      | 6 jaar gelede      | 52584 ure                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 2000/01/10               |
| 2000-01-05T00:00:00.000Z | Woensdag om 00:00        |
| 2000-01-02T00:00:00.000Z | môre om 00:00            |
| 2000-01-01T00:00:00.000Z | vandag om 00:00          |
| 1999-12-31T00:00:00.000Z | gister om 00:00          |
| 1999-12-27T00:00:00.000Z | verlede Maandag om 00:00 |
| 1999-12-21T00:00:00.000Z | 1999/12/21               |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 jaar     |
| {"years":1}   | 1 jaar     |
| {"years":2}   | 2 jaar     |
| {"months":0}  | 0 maande   |
| {"months":1}  | 1 maand    |
| {"months":2}  | 2 maande   |
| {"weeks":0}   | 0 weke     |
| {"weeks":1}   | 1 week     |
| {"weeks":2}   | 2 weke     |
| {"days":0}    | 0 dae      |
| {"days":1}    | 1 dag      |
| {"days":2}    | 2 dae      |
| {"hours":0}   | 0 ure      |
| {"hours":1}   | 1 uur      |
| {"hours":2}   | 2 ure      |
| {"minutes":0} | 0 minute   |
| {"minutes":1} | 'n minuut  |
| {"minutes":2} | 2 minute   |
| {"seconds":0} | 0 sekondes |
| {"seconds":1} | 1 sekonde  |
| {"seconds":2} | 2 sekondes |
