# Arabic (ar-EG) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                    | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                 | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                    | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ر1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | الربع الأول                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ر1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | الربع الأول                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                   | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | ينا                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبر                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونـ                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يولـ                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسـ                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتـ                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتـ                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفـ                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسـ                                                 | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | يناير                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                                    | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                   | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | ينا                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبر                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونـ                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يولـ                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسـ                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتـ                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتـ                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفـ                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسـ                                                 | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | يناير                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أ                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                                    | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                                   | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                   | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                   | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 فبراير                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 فبراير                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 فبراير                                            | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                  | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | الاثنين                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ن                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | الاثنين                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ن                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | الاثنين                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ن                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                    | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | الاثنين                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ن                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                    | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | اثنين                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                                 | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                    | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | في الصباح                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                             | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | في الصباح                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | في الصباح                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | في الصباح                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | في الصباح                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                             | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                    | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                    | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                           | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                           | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                           | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                           | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11/ينا/1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/فبر/1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/مارس/1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/أبريل/1987                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/مايو/1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/يونـ/1987                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/يولـ/1987                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/أغسـ/1987                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/سبتـ/1987                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/أكتـ/1987                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/نوفـ/1987                                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/ديسـ/1987                                         | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 يناير 1987                                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987                                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987                                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987                                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987                                       | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | الأحد، 11 يناير 1987                                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فبراير 1987                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أبريل 1987                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 مايو 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 يونيو 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 يوليو 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أغسطس 1987                              | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987                                | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987                             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987                               | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 م                                              | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 م                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 م                                              | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 م                                              | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 م                                              | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 م                                              | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 م                                              | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 م                                              | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 م                                              | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 م                                              | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 م                                              | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 م                                              | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 م                                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 م                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 م                                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 م                                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م                                           | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 م                                           | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 م                                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 م                                           | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 م                                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 م                                           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 م                                           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 م                                           | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م GMT+0                                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 م GMT+0                                     | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 م GMT+00:00                                 | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13 م                                  | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 م                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13 م                                  | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13 م                                  | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59 م                                  | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13 م                                  | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13 م                                  | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13 م                                  | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13 م                                  | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13 م                                  | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 م                                  | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13 م                                  | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11/ينا/1987, 12:13:14 م                              | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/فبر/1987, 12:13:14 م                              | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/مارس/1987, 12:13:14 م                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/أبريل/1987, 12:13:14 م                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/مايو/1453, 11:59:59 م                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/يونـ/1987, 12:13:14 م                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/يولـ/1987, 12:13:14 م                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/أغسـ/1987, 12:13:14 م                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/سبتـ/1987, 12:13:14 م                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/أكتـ/1987, 12:13:14 م                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/نوفـ/1987, 12:13:14 م                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/ديسـ/1987, 12:13:14 م                             | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 يناير 1987 الساعة 12:13:14 م GMT+0                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987 الساعة 12:13:14 م GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987 الساعة 12:13:14 م GMT+0                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987 الساعة 12:13:14 م GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453 الساعة 11:59:59 م GMT+0                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987 الساعة 12:13:14 م GMT+0                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987 الساعة 12:13:14 م GMT+0                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987 الساعة 12:13:14 م GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987 الساعة 12:13:14 م GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987 الساعة 12:13:14 م GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987 الساعة 12:13:14 م GMT+0               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987 الساعة 12:13:14 م GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | الأحد، 11 يناير 1987 الساعة 12:13:14 م GMT+00:00     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فبراير 1987 الساعة 12:13:14 م GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987 الساعة 12:13:14 م GMT+00:00   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أبريل 1987 الساعة 12:13:14 م GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 مايو 1453 الساعة 11:59:59 م GMT+00:00      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 يونيو 1987 الساعة 12:13:14 م GMT+00:00    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 يوليو 1987 الساعة 12:13:14 م GMT+00:00     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أغسطس 1987 الساعة 12:13:14 م GMT+00:00  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987 الساعة 12:13:14 م GMT+00:00   | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987 الساعة 12:13:14 م GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987 الساعة 12:13:14 م GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987 الساعة 12:13:14 م GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | حوالي 6 سنين  | حوالي 6 سنين           | في خلال حوالي 6 سنين  |
| 2005-01-01T00:00:00.000Z | حوالي 5 سنين  | حوالي 5 سنين           | في خلال حوالي 5 سنين  |
| 2004-01-01T00:00:00.000Z | حوالي 4 سنين  | حوالي 4 سنين           | في خلال حوالي 4 سنين  |
| 2003-01-01T00:00:00.000Z | حوالي 3 سنين  | حوالي 3 سنين           | في خلال حوالي 3 سنين  |
| 2002-01-01T00:00:00.000Z | حوالي سنتين   | حوالي سنتين            | في خلال حوالي سنتين   |
| 2001-06-01T00:00:00.000Z | أكثر من سنة   | أكثر من سنة            | في خلال أكثر من سنة   |
| 2001-02-01T00:00:00.000Z | حوالي سنة     | حوالي سنة              | في خلال حوالي سنة     |
| 2001-01-01T00:00:00.000Z | حوالي سنة     | حوالي سنة              | في خلال حوالي سنة     |
| 2000-06-01T00:00:00.000Z | 5 أشهر        | 5 أشهر                 | في خلال 5 أشهر        |
| 2000-03-01T00:00:00.000Z | شهرين         | شهرين                  | في خلال شهرين         |
| 2000-02-01T00:00:00.000Z | حوالي شهر     | حوالي شهر              | في خلال حوالي شهر     |
| 2000-01-15T00:00:00.000Z | 14 يوم        | 14 يوم                 | في خلال 14 يوم        |
| 2000-01-02T00:00:00.000Z | يوم           | يوم                    | في خلال يوم           |
| 2000-01-01T06:00:00.000Z | حوالي 6 ساعات | حوالي 6 ساعات          | في خلال حوالي 6 ساعات |
| 2000-01-01T01:00:00.000Z | حوالي ساعة    | حوالي ساعة             | في خلال حوالي ساعة    |
| 2000-01-01T00:45:00.000Z | حوالي ساعة    | حوالي ساعة             | في خلال حوالي ساعة    |
| 2000-01-01T00:30:00.000Z | 30 دقيقة      | 30 دقيقة               | في خلال 30 دقيقة      |
| 2000-01-01T00:15:00.000Z | 15 دقيقة      | 15 دقيقة               | في خلال 15 دقيقة      |
| 2000-01-01T00:01:00.000Z | دقيقة         | دقيقة                  | في خلال دقيقة         |
| 2000-01-01T00:00:25.000Z | أقل من دقيقة  | نص دقيقة               | في خلال أقل من دقيقة  |
| 2000-01-01T00:00:15.000Z | أقل من دقيقة  | أقل من 20 ثانية        | في خلال أقل من دقيقة  |
| 2000-01-01T00:00:05.000Z | أقل من دقيقة  | أقل من 10 ثواني        | في خلال أقل من دقيقة  |
| 2000-01-01T00:00:00.000Z | أقل من دقيقة  | أقل من 5 ثواني         | منذ أقل من دقيقة      |
| 1999-12-31T23:59:55.000Z | أقل من دقيقة  | أقل من 10 ثواني        | منذ أقل من دقيقة      |
| 1999-12-31T23:59:45.000Z | أقل من دقيقة  | أقل من 20 ثانية        | منذ أقل من دقيقة      |
| 1999-12-31T23:59:35.000Z | أقل من دقيقة  | نص دقيقة               | منذ أقل من دقيقة      |
| 1999-12-31T23:59:00.000Z | دقيقة         | دقيقة                  | منذ دقيقة             |
| 1999-12-31T23:45:00.000Z | 15 دقيقة      | 15 دقيقة               | منذ 15 دقيقة          |
| 1999-12-31T23:30:00.000Z | 30 دقيقة      | 30 دقيقة               | منذ 30 دقيقة          |
| 1999-12-31T23:15:00.000Z | حوالي ساعة    | حوالي ساعة             | منذ حوالي ساعة        |
| 1999-12-31T23:00:00.000Z | حوالي ساعة    | حوالي ساعة             | منذ حوالي ساعة        |
| 1999-12-31T18:00:00.000Z | حوالي 6 ساعات | حوالي 6 ساعات          | منذ حوالي 6 ساعات     |
| 1999-12-30T00:00:00.000Z | يومين         | يومين                  | منذ يومين             |
| 1999-12-15T00:00:00.000Z | 17 يوم        | 17 يوم                 | منذ 17 يوم            |
| 1999-12-01T00:00:00.000Z | حوالي شهر     | حوالي شهر              | منذ حوالي شهر         |
| 1999-11-01T00:00:00.000Z | شهرين         | شهرين                  | منذ شهرين             |
| 1999-06-01T00:00:00.000Z | 7 أشهر        | 7 أشهر                 | منذ 7 أشهر            |
| 1999-01-01T00:00:00.000Z | حوالي سنة     | حوالي سنة              | منذ حوالي سنة         |
| 1998-12-01T00:00:00.000Z | حوالي سنة     | حوالي سنة              | منذ حوالي سنة         |
| 1998-06-01T00:00:00.000Z | أكثر من سنة   | أكثر من سنة            | منذ أكثر من سنة       |
| 1998-01-01T00:00:00.000Z | حوالي سنتين   | حوالي سنتين            | منذ حوالي سنتين       |
| 1997-01-01T00:00:00.000Z | حوالي 3 سنين  | حوالي 3 سنين           | منذ حوالي 3 سنين      |
| 1996-01-01T00:00:00.000Z | حوالي 4 سنين  | حوالي 4 سنين           | منذ حوالي 4 سنين      |
| 1995-01-01T00:00:00.000Z | حوالي 5 سنين  | حوالي 5 سنين           | منذ حوالي 5 سنين      |
| 1994-01-01T00:00:00.000Z | حوالي 6 سنين  | حوالي 6 سنين           | منذ حوالي 6 سنين      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 أعوام  | في خلال 6 أعوام   | 52608 ساعة                     |
| 2005-01-01T00:00:00.000Z | 5 أعوام  | في خلال 5 أعوام   | 43848 ساعة                     |
| 2004-01-01T00:00:00.000Z | 4 أعوام  | في خلال 4 أعوام   | 35064 ساعة                     |
| 2003-01-01T00:00:00.000Z | 3 أعوام  | في خلال 3 أعوام   | 26304 ساعة                     |
| 2002-01-01T00:00:00.000Z | عامين    | في خلال عامين     | 17544 ساعة                     |
| 2001-06-01T00:00:00.000Z | عام      | في خلال عام       | 12408 ساعة                     |
| 2001-02-01T00:00:00.000Z | عام      | في خلال عام       | 9528 ساعة                      |
| 2001-01-01T00:00:00.000Z | عام      | في خلال عام       | 8784 ساعة                      |
| 2000-06-01T00:00:00.000Z | 5 أشهر   | في خلال 5 أشهر    | 3648 ساعة                      |
| 2000-03-01T00:00:00.000Z | شهرين    | في خلال شهرين     | 1440 ساعة                      |
| 2000-02-01T00:00:00.000Z | شهر      | في خلال شهر       | 744 ساعة                       |
| 2000-01-15T00:00:00.000Z | 14 يوم   | في خلال 14 يوم    | 336 ساعة                       |
| 2000-01-02T00:00:00.000Z | يوم      | في خلال يوم       | 24 ساعة                        |
| 2000-01-01T06:00:00.000Z | 6 ساعات  | في خلال 6 ساعات   | 6 ساعات                        |
| 2000-01-01T01:00:00.000Z | ساعة     | في خلال ساعة      | ساعة                           |
| 2000-01-01T00:45:00.000Z | 45 دقيقة | في خلال 45 دقيقة  | ساعة                           |
| 2000-01-01T00:30:00.000Z | 30 دقيقة | في خلال 30 دقيقة  | ساعة                           |
| 2000-01-01T00:15:00.000Z | 15 دقيقة | في خلال 15 دقيقة  | 0 ساعات                        |
| 2000-01-01T00:01:00.000Z | دقيقة    | في خلال دقيقة     | 0 ساعات                        |
| 2000-01-01T00:00:25.000Z | 25 ثانية | في خلال 25 ثانية  | 0 ساعات                        |
| 2000-01-01T00:00:15.000Z | 15 ثانية | في خلال 15 ثانية  | 0 ساعات                        |
| 2000-01-01T00:00:05.000Z | 5 ثواني  | في خلال 5 ثواني   | 0 ساعات                        |
| 2000-01-01T00:00:00.000Z | 0 ثواني  | منذ 0 ثواني       | 0 ساعات                        |
| 1999-12-31T23:59:55.000Z | 5 ثواني  | منذ 5 ثواني       | 0 ساعات                        |
| 1999-12-31T23:59:45.000Z | 15 ثانية | منذ 15 ثانية      | 0 ساعات                        |
| 1999-12-31T23:59:35.000Z | 25 ثانية | منذ 25 ثانية      | 0 ساعات                        |
| 1999-12-31T23:59:00.000Z | دقيقة    | منذ دقيقة         | 0 ساعات                        |
| 1999-12-31T23:45:00.000Z | 15 دقيقة | منذ 15 دقيقة      | 0 ساعات                        |
| 1999-12-31T23:30:00.000Z | 30 دقيقة | منذ 30 دقيقة      | ساعة                           |
| 1999-12-31T23:15:00.000Z | 45 دقيقة | منذ 45 دقيقة      | ساعة                           |
| 1999-12-31T23:00:00.000Z | ساعة     | منذ ساعة          | ساعة                           |
| 1999-12-31T18:00:00.000Z | 6 ساعات  | منذ 6 ساعات       | 6 ساعات                        |
| 1999-12-30T00:00:00.000Z | يومين    | منذ يومين         | 48 ساعة                        |
| 1999-12-15T00:00:00.000Z | 17 يوم   | منذ 17 يوم        | 408 ساعة                       |
| 1999-12-01T00:00:00.000Z | شهر      | منذ شهر           | 744 ساعة                       |
| 1999-11-01T00:00:00.000Z | شهرين    | منذ شهرين         | 1464 ساعة                      |
| 1999-06-01T00:00:00.000Z | 7 أشهر   | منذ 7 أشهر        | 5136 ساعة                      |
| 1999-01-01T00:00:00.000Z | عام      | منذ عام           | 8760 ساعة                      |
| 1998-12-01T00:00:00.000Z | عام      | منذ عام           | 9504 ساعة                      |
| 1998-06-01T00:00:00.000Z | عامين    | منذ عامين         | 13896 ساعة                     |
| 1998-01-01T00:00:00.000Z | عامين    | منذ عامين         | 17520 ساعة                     |
| 1997-01-01T00:00:00.000Z | 3 أعوام  | منذ 3 أعوام       | 26280 ساعة                     |
| 1996-01-01T00:00:00.000Z | 4 أعوام  | منذ 4 أعوام       | 35064 ساعة                     |
| 1995-01-01T00:00:00.000Z | 5 أعوام  | منذ 5 أعوام       | 43824 ساعة                     |
| 1994-01-01T00:00:00.000Z | 6 أعوام  | منذ 6 أعوام       | 52584 ساعة                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                          |
| ------------------------ | ------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                      |
| 2000-01-05T00:00:00.000Z | الأربعاء الساعة 12:00 ص         |
| 2000-01-02T00:00:00.000Z | بكرة الساعة 12:00 ص             |
| 2000-01-01T00:00:00.000Z | النهاردة الساعة 12:00 ص         |
| 1999-12-31T00:00:00.000Z | إمبارح الساعة 12:00 ص           |
| 1999-12-27T00:00:00.000Z | الاثنين اللي جاي الساعة 12:00 ص |
| 1999-12-21T00:00:00.000Z | 21/12/1999                      |

## `formatDuration`

| Duration      | Result   |
| ------------- | -------- |
| {"years":0}   | 0 أعوام  |
| {"years":1}   | عام      |
| {"years":2}   | عامين    |
| {"months":0}  | 0 أشهر   |
| {"months":1}  | شهر      |
| {"months":2}  | شهرين    |
| {"weeks":0}   | 0 أسابيع |
| {"weeks":1}   | أسبوع    |
| {"weeks":2}   | أسبوعين  |
| {"days":0}    | 0 أيام   |
| {"days":1}    | يوم      |
| {"days":2}    | يومين    |
| {"hours":0}   | 0 ساعات  |
| {"hours":1}   | ساعة     |
| {"hours":2}   | ساعتين   |
| {"minutes":0} | 0 دقايق  |
| {"minutes":1} | دقيقة    |
| {"minutes":2} | دقيقتين  |
| {"seconds":0} | 0 ثواني  |
| {"seconds":1} | ثانية    |
| {"seconds":2} | ثانيتين  |
