# Belarusian (be) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-ы                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ы                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-ы                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ы                                                 | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-ы                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-ы кв.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і кв.                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-ы квартал                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і квартал                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-ы                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-ы кв.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і кв.                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-ы квартал                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-і квартал                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1-ы                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-і                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-і                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-ы                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-ы                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-ы                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ы                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-ы                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-ы                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-ы                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-ы                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-ы                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | студз.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лют.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | сак.                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | крас.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | мая                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | чэрв.                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ліп.                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | жн.                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | вер.                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | кастр.                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ліст.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | снеж.                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | студзеня                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лютага                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | сакавіка                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | красавіка                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | мая                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | чэрвеня                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ліпеня                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | жніўня                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | верасня                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | кастрычніка                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | лістапада                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | снежня                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | М                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ч                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Ж                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | В                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1-ы                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-і                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-і                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-ы                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-ы                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-ы                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ы                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-ы                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-ы                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-ы                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-ы                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-ы                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | студз.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лют.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | сак.                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | крас.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | чэрв.                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ліп.                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | жн.                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | вер.                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | кастр.                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ліст.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | снеж.                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | студзень                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | люты                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | сакавік                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | красавік                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | чэрвень                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ліпень                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | жнівень                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | верасень                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | кастрычнік                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | лістапад                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | снежань                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | М                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ч                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Ж                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | В                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-ы                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ы                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-ы                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ы                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1-га                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-га                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-га                                               | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1-га лютага                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-га лютага                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-га лютага                                        | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-і                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-ы                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | панядзелак                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятніца                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-ы                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ы                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | панядзелак                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятніца                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-ы                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ы                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | панядзелак                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятніца                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-ы                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ы                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | пан                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пят                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | панядзелак                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пятніца                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ран.                                                | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночы                                                | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ран.                                                | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночы                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ран.                                                | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночы                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | раніцы                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | вечара                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночы                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ран.                                                | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночы                                                | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-я                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-я                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-я                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-я                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-я                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-я                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-я                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-я                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-я                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-я                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-я                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-я                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987                                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987                                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987                                          | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 студз. 1987 г.                                   | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лют. 1987 г.                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 сак. 1987 г.                                     | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 крас. 1987 г.                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г.                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 чэрв. 1987 г.                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ліп. 1987 г.                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 жн. 1987 г.                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 вер. 1987 г.                                     | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 кастр. 1987 г.                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ліст. 1987 г.                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 снеж. 1987 г.                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 студзеня 1987 г.                                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лютага 1987 г.                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 сакавіка 1987 г.                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 красавіка 1987 г.                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г.                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 чэрвеня 1987 г.                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ліпеня 1987 г.                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 жніўня 1987 г.                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 верасня 1987 г.                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 кастрычніка 1987 г.                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 лістапада 1987 г.                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 снежня 1987 г.                                   | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | нядзеля, 11 студзеня 1987 г.                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | серада, 11 лютага 1987 г.                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | серада, 11 сакавіка 1987 г.                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | субота, 11 красавіка 1987 г.                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | нядзеля, 29 мая 1453 г.                             | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | чацвер, 11 чэрвеня 1987 г.                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | субота, 11 ліпеня 1987 г.                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | аўторак, 11 жніўня 1987 г.                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | пятніца, 11 верасня 1987 г.                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | нядзеля, 11 кастрычніка 1987 г.                     | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | серада, 11 лістапада 1987 г.                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | пятніца, 11 снежня 1987 г.                          | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                               | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                            | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987, 12:13                                   | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987, 12:13                                   | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987, 12:13                                   | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                   | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987, 12:13                                   | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987, 12:13                                   | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987, 12:13                                   | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987, 12:13                                   | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987, 12:13                                   | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987, 12:13                                   | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987, 12:13                                   | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 студз. 1987 г., 12:13:14                         | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лют. 1987 г., 12:13:14                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 сак. 1987 г., 12:13:14                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 крас. 1987 г., 12:13:14                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г., 23:59:59                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 чэрв. 1987 г., 12:13:14                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ліп. 1987 г., 12:13:14                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 жн. 1987 г., 12:13:14                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 вер. 1987 г., 12:13:14                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 кастр. 1987 г., 12:13:14                         | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ліст. 1987 г., 12:13:14                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 снеж. 1987 г., 12:13:14                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 студзеня 1987 г., 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лютага 1987 г., 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 сакавіка 1987 г., 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 красавіка 1987 г., 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мая 1453 г., 23:59:59 GMT+0                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 чэрвеня 1987 г., 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ліпеня 1987 г., 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 жніўня 1987 г., 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 верасня 1987 г., 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 кастрычніка 1987 г., 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 лістапада 1987 г., 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 снежня 1987 г., 12:13:14 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | нядзеля, 11 студзеня 1987 г., 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | серада, 11 лютага 1987 г., 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | серада, 11 сакавіка 1987 г., 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | субота, 11 красавіка 1987 г., 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | нядзеля, 29 мая 1453 г., 23:59:59 GMT+00:00         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | чацвер, 11 чэрвеня 1987 г., 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | субота, 11 ліпеня 1987 г., 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | аўторак, 11 жніўня 1987 г., 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | пятніца, 11 верасня 1987 г., 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | нядзеля, 11 кастрычніка 1987 г., 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | серада, 11 лістапада 1987 г., 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | пятніца, 11 снежня 1987 г., 12:13:14 GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | --------------- | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | каля 6 гадоў    | каля 6 гадоў           | прыблізна праз 6 гадоў   |
| 2005-01-01T00:00:00.000Z | каля 5 гадоў    | каля 5 гадоў           | прыблізна праз 5 гадоў   |
| 2004-01-01T00:00:00.000Z | каля 4 гадоў    | каля 4 гадоў           | прыблізна праз 4 гады    |
| 2003-01-01T00:00:00.000Z | каля 3 гадоў    | каля 3 гадоў           | прыблізна праз 3 гады    |
| 2002-01-01T00:00:00.000Z | каля 2 гадоў    | каля 2 гадоў           | прыблізна праз 2 гады    |
| 2001-06-01T00:00:00.000Z | больш за 1 год  | больш за 1 год         | больш, чым праз 1 год    |
| 2001-02-01T00:00:00.000Z | каля 1 года     | каля 1 года            | прыблізна праз 1 год     |
| 2001-01-01T00:00:00.000Z | каля 1 года     | каля 1 года            | прыблізна праз 1 год     |
| 2000-06-01T00:00:00.000Z | 5 месяцаў       | 5 месяцаў              | праз 5 месяцаў           |
| 2000-03-01T00:00:00.000Z | 2 месяцы        | 2 месяцы               | праз 2 месяцы            |
| 2000-02-01T00:00:00.000Z | каля 1 месяца   | каля 1 месяца          | прыблізна праз 1 месяц   |
| 2000-01-15T00:00:00.000Z | 14 дзён         | 14 дзён                | праз 14 дзён             |
| 2000-01-02T00:00:00.000Z | 1 дзень         | 1 дзень                | праз 1 дзень             |
| 2000-01-01T06:00:00.000Z | каля 6 гадзін   | каля 6 гадзін          | прыблізна праз 6 гадзін  |
| 2000-01-01T01:00:00.000Z | каля 1 гадзіны  | каля 1 гадзіны         | прыблізна праз 1 гадзіну |
| 2000-01-01T00:45:00.000Z | каля 1 гадзіны  | каля 1 гадзіны         | прыблізна праз 1 гадзіну |
| 2000-01-01T00:30:00.000Z | 30 хвілін       | 30 хвілін              | праз 30 хвілін           |
| 2000-01-01T00:15:00.000Z | 15 хвілін       | 15 хвілін              | праз 15 хвілін           |
| 2000-01-01T00:01:00.000Z | 1 хвіліна       | 1 хвіліна              | праз 1 хвіліну           |
| 2000-01-01T00:00:25.000Z | менш за хвіліну | паўхвіліны             | менш, чым праз хвіліну   |
| 2000-01-01T00:00:15.000Z | менш за хвіліну | менш за 20 секунд      | менш, чым праз хвіліну   |
| 2000-01-01T00:00:05.000Z | менш за хвіліну | менш за 10 секунд      | менш, чым праз хвіліну   |
| 2000-01-01T00:00:00.000Z | менш за хвіліну | менш за 5 секунд       | менш за хвіліну таму     |
| 1999-12-31T23:59:55.000Z | менш за хвіліну | менш за 10 секунд      | менш за хвіліну таму     |
| 1999-12-31T23:59:45.000Z | менш за хвіліну | менш за 20 секунд      | менш за хвіліну таму     |
| 1999-12-31T23:59:35.000Z | менш за хвіліну | паўхвіліны             | менш за хвіліну таму     |
| 1999-12-31T23:59:00.000Z | 1 хвіліна       | 1 хвіліна              | 1 хвіліну таму           |
| 1999-12-31T23:45:00.000Z | 15 хвілін       | 15 хвілін              | 15 хвілін таму           |
| 1999-12-31T23:30:00.000Z | 30 хвілін       | 30 хвілін              | 30 хвілін таму           |
| 1999-12-31T23:15:00.000Z | каля 1 гадзіны  | каля 1 гадзіны         | каля 1 гадзіны таму      |
| 1999-12-31T23:00:00.000Z | каля 1 гадзіны  | каля 1 гадзіны         | каля 1 гадзіны таму      |
| 1999-12-31T18:00:00.000Z | каля 6 гадзін   | каля 6 гадзін          | каля 6 гадзін таму       |
| 1999-12-30T00:00:00.000Z | 2 дні           | 2 дні                  | 2 дні таму               |
| 1999-12-15T00:00:00.000Z | 17 дзён         | 17 дзён                | 17 дзён таму             |
| 1999-12-01T00:00:00.000Z | каля 1 месяца   | каля 1 месяца          | каля 1 месяца таму       |
| 1999-11-01T00:00:00.000Z | 2 месяцы        | 2 месяцы               | 2 месяцы таму            |
| 1999-06-01T00:00:00.000Z | 7 месяцаў       | 7 месяцаў              | 7 месяцаў таму           |
| 1999-01-01T00:00:00.000Z | каля 1 года     | каля 1 года            | каля 1 года таму         |
| 1998-12-01T00:00:00.000Z | каля 1 года     | каля 1 года            | каля 1 года таму         |
| 1998-06-01T00:00:00.000Z | больш за 1 год  | больш за 1 год         | больш за 1 год таму      |
| 1998-01-01T00:00:00.000Z | каля 2 гадоў    | каля 2 гадоў           | каля 2 гадоў таму        |
| 1997-01-01T00:00:00.000Z | каля 3 гадоў    | каля 3 гадоў           | каля 3 гадоў таму        |
| 1996-01-01T00:00:00.000Z | каля 4 гадоў    | каля 4 гадоў           | каля 4 гадоў таму        |
| 1995-01-01T00:00:00.000Z | каля 5 гадоў    | каля 5 гадоў           | каля 5 гадоў таму        |
| 1994-01-01T00:00:00.000Z | каля 6 гадоў    | каля 6 гадоў           | каля 6 гадоў таму        |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 гадоў   | праз 6 гадоў      | 52608 гадзін                   |
| 2005-01-01T00:00:00.000Z | 5 гадоў   | праз 5 гадоў      | 43848 гадзін                   |
| 2004-01-01T00:00:00.000Z | 4 гады    | праз 4 гады       | 35064 гадзіны                  |
| 2003-01-01T00:00:00.000Z | 3 гады    | праз 3 гады       | 26304 гадзіны                  |
| 2002-01-01T00:00:00.000Z | 2 гады    | праз 2 гады       | 17544 гадзіны                  |
| 2001-06-01T00:00:00.000Z | 1 год     | праз 1 год        | 12408 гадзін                   |
| 2001-02-01T00:00:00.000Z | 1 год     | праз 1 год        | 9528 гадзін                    |
| 2001-01-01T00:00:00.000Z | 1 год     | праз 1 год        | 8784 гадзіны                   |
| 2000-06-01T00:00:00.000Z | 5 месяцаў | праз 5 месяцаў    | 3648 гадзін                    |
| 2000-03-01T00:00:00.000Z | 2 месяцы  | праз 2 месяцы     | 1440 гадзін                    |
| 2000-02-01T00:00:00.000Z | 1 месяц   | праз 1 месяц      | 744 гадзіны                    |
| 2000-01-15T00:00:00.000Z | 14 дзён   | праз 14 дзён      | 336 гадзін                     |
| 2000-01-02T00:00:00.000Z | 1 дзень   | праз 1 дзень      | 24 гадзіны                     |
| 2000-01-01T06:00:00.000Z | 6 гадзін  | праз 6 гадзін     | 6 гадзін                       |
| 2000-01-01T01:00:00.000Z | 1 гадзіна | праз 1 гадзіну    | 1 гадзіна                      |
| 2000-01-01T00:45:00.000Z | 45 хвілін | праз 45 хвілін    | 1 гадзіна                      |
| 2000-01-01T00:30:00.000Z | 30 хвілін | праз 30 хвілін    | 1 гадзіна                      |
| 2000-01-01T00:15:00.000Z | 15 хвілін | праз 15 хвілін    | 0 гадзін                       |
| 2000-01-01T00:01:00.000Z | 1 хвіліна | праз 1 хвіліну    | 0 гадзін                       |
| 2000-01-01T00:00:25.000Z | 25 секунд | праз 25 секунд    | 0 гадзін                       |
| 2000-01-01T00:00:15.000Z | 15 секунд | праз 15 секунд    | 0 гадзін                       |
| 2000-01-01T00:00:05.000Z | 5 секунд  | праз 5 секунд     | 0 гадзін                       |
| 2000-01-01T00:00:00.000Z | 0 секунд  | 0 секунд таму     | 0 гадзін                       |
| 1999-12-31T23:59:55.000Z | 5 секунд  | 5 секунд таму     | 0 гадзін                       |
| 1999-12-31T23:59:45.000Z | 15 секунд | 15 секунд таму    | 0 гадзін                       |
| 1999-12-31T23:59:35.000Z | 25 секунд | 25 секунд таму    | 0 гадзін                       |
| 1999-12-31T23:59:00.000Z | 1 хвіліна | 1 хвіліну таму    | 0 гадзін                       |
| 1999-12-31T23:45:00.000Z | 15 хвілін | 15 хвілін таму    | 0 гадзін                       |
| 1999-12-31T23:30:00.000Z | 30 хвілін | 30 хвілін таму    | 1 гадзіна                      |
| 1999-12-31T23:15:00.000Z | 45 хвілін | 45 хвілін таму    | 1 гадзіна                      |
| 1999-12-31T23:00:00.000Z | 1 гадзіна | 1 гадзіну таму    | 1 гадзіна                      |
| 1999-12-31T18:00:00.000Z | 6 гадзін  | 6 гадзін таму     | 6 гадзін                       |
| 1999-12-30T00:00:00.000Z | 2 дні     | 2 дні таму        | 48 гадзін                      |
| 1999-12-15T00:00:00.000Z | 17 дзён   | 17 дзён таму      | 408 гадзін                     |
| 1999-12-01T00:00:00.000Z | 1 месяц   | 1 месяц таму      | 744 гадзіны                    |
| 1999-11-01T00:00:00.000Z | 2 месяцы  | 2 месяцы таму     | 1464 гадзіны                   |
| 1999-06-01T00:00:00.000Z | 7 месяцаў | 7 месяцаў таму    | 5136 гадзін                    |
| 1999-01-01T00:00:00.000Z | 1 год     | 1 год таму        | 8760 гадзін                    |
| 1998-12-01T00:00:00.000Z | 1 год     | 1 год таму        | 9504 гадзіны                   |
| 1998-06-01T00:00:00.000Z | 2 гады    | 2 гады таму       | 13896 гадзін                   |
| 1998-01-01T00:00:00.000Z | 2 гады    | 2 гады таму       | 17520 гадзін                   |
| 1997-01-01T00:00:00.000Z | 3 гады    | 3 гады таму       | 26280 гадзін                   |
| 1996-01-01T00:00:00.000Z | 4 гады    | 4 гады таму       | 35064 гадзіны                  |
| 1995-01-01T00:00:00.000Z | 5 гадоў   | 5 гадоў таму      | 43824 гадзіны                  |
| 1994-01-01T00:00:00.000Z | 6 гадоў   | 6 гадоў таму      | 52584 гадзіны                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                    |
| ------------------------ | ------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                |
| 2000-01-05T00:00:00.000Z | у наступную сераду а 0:00 |
| 2000-01-02T00:00:00.000Z | заўтра а 0:00             |
| 2000-01-01T00:00:00.000Z | сёння а 0:00              |
| 1999-12-31T00:00:00.000Z | учора а 0:00              |
| 1999-12-27T00:00:00.000Z | у панядзелак а 0:00       |
| 1999-12-21T00:00:00.000Z | 21.12.1999                |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 гадоў   |
| {"years":1}   | 1 год     |
| {"years":2}   | 2 гады    |
| {"months":0}  | 0 месяцаў |
| {"months":1}  | 1 месяц   |
| {"months":2}  | 2 месяцы  |
| {"weeks":0}   | 0 тыдняў  |
| {"weeks":1}   | 1 тыдзень |
| {"weeks":2}   | 2 тыдні   |
| {"days":0}    | 0 дзён    |
| {"days":1}    | 1 дзень   |
| {"days":2}    | 2 дні     |
| {"hours":0}   | 0 гадзін  |
| {"hours":1}   | 1 гадзіна |
| {"hours":2}   | 2 гадзіны |
| {"minutes":0} | 0 хвілін  |
| {"minutes":1} | 1 хвіліна |
| {"minutes":2} | 2 хвіліны |
| {"seconds":0} | 0 секунд  |
| {"seconds":1} | 1 секунда |
| {"seconds":2} | 2 секунды |
