# Central Kurdish (ckb) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                                 | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                            | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                            | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                               | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | چ1م                                                             | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | چ2م                                                             | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | چارەگی یەکەم                                                    | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | چارەگی دووەم                                                    | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                               | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | چ1م                                                             | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | چ2م                                                             | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | چارەگی یەکەم                                                    | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | چارەگی دووەم                                                    | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | کان-دوو                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | شوب                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئاد                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | نیس                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مایس                                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | حوز                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | تەم                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاب                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئەل                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تش-یەک                                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | تش-دوو                                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | کان-یەک                                                         | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | کانوونی دووەم                                                   | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | شوبات                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئادار                                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | نیسان                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مایس                                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | حوزەیران                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | تەمموز                                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاب                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئەیلول                                                          | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تشرینی یەکەم                                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | تشرینی دووەم                                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | کانوونی یەکەم                                                   | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ک-د                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ش                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئا                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ن                                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ح                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ت                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئا                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئە                                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تش-ی                                                            | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | تش-د                                                            | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | ک-ی                                                             | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                              | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | کان-دوو                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | شوب                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئاد                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | نیس                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مایس                                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | حوز                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | تەم                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاب                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئەل                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تش-یەک                                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | تش-دوو                                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | کان-یەک                                                         | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | کانوونی دووەم                                                   | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | شوبات                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئادار                                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | نیسان                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مایس                                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | حوزەیران                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | تەمموز                                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاب                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئەیلول                                                          | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تشرینی یەکەم                                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | تشرینی دووەم                                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | کانوونی یەکەم                                                   | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ک-د                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ش                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | ئا                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ن                                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ح                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ت                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئا                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ئە                                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | تش-ی                                                            | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | تش-د                                                            | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | ک-ی                                                             | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                               | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                                              | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                              | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                              | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 شوبات                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 شوبات                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 شوبات                                                        | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                             | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | EE           | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | دوو شەمە                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | د-ش                                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هە                                                              | Invalid Date             |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | دوو-شە                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەی                                                             | Invalid Date             |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                               | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | دوو شەمە                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | د-ش                                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هە                                                              | Invalid Date             |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | دوو-شە                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەی                                                             | Invalid Date             |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                               | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | دوو شەمە                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | د-ش                                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هە                                                              | Invalid Date             |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | دوو-شە                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەی                                                             | Invalid Date             |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | دوو-شەم                                                         | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | دوو شەمە                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەینی                                                           | Invalid Date             |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | د-ش                                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هە                                                              | Invalid Date             |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | دوو-شە                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | هەی                                                             | Invalid Date             |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | پێش نیوەڕۆ                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | دوای نیوەڕۆ                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | دوای نیوەڕۆ                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پێش نیوەڕۆ                                                      | 2019-02-11T12:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | پ                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ                                                               | 2019-02-11T12:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د-ن                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ-ن                                                             | 2019-02-11T12:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | پێش نیوەڕۆ                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | دوای نیوەڕۆ                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | دوای نیوەڕۆ                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پێش نیوەڕۆ                                                      | 2019-02-11T12:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | پ                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | د                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | د                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | پ                                                               | 2019-02-11T12:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | لە بەیانیدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | لە دوای نیوەڕۆدا                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | لە ئێوارەدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | لە شەودا                                                        | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | لە بەیانیدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | لە دوای نیوەڕۆدا                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | لە ئێوارەدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | لە شەودا                                                        | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | لە بەیانیدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | لە دوای نیوەڕۆدا                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | لە ئێوارەدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | لە شەودا                                                        | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | لە بەیانیدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | لە دوای نیوەڕۆدا                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | لە ئێوارەدا                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | لە شەودا                                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | لە بەیانیدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | لە دوای نیوەڕۆدا                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | لە ئێوارەدا                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | لە شەودا                                                        | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                              | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                               | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                              | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                               | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                              | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 01/11/1987                                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987                                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987                                                      | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987                                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453                                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987                                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987                                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987                                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987                                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987                                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987                                                      | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | کان-دوو 11, 1987                                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | شوب 11, 1987                                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | ئاد 11, 1987                                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | نیس 11, 1987                                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | مایس 29, 1453                                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | حوز 11, 1987                                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | تەم 11, 1987                                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاب 11, 1987                                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | ئەل 11, 1987                                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | تش-یەک 11, 1987                                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | تش-دوو 11, 1987                                                 | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | کان-یەک 11, 1987                                                | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | کانوونی دووەم 11, 1987                                          | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | شوبات 11, 1987                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | ئادار 11, 1987                                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | نیسان 11, 1987                                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | مایس 29, 1453                                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | حوزەیران 11, 1987                                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | تەمموز 11, 1987                                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاب 11, 1987                                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | ئەیلول 11, 1987                                                 | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | تشرینی یەکەم 11, 1987                                           | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | تشرینی دووەم 11, 1987                                           | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | کانوونی یەکەم 11, 1987                                          | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | یەک شەمە, کانوونی دووەم 11, 1987                                | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | چوار شەمە, شوبات 11, 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | چوار شەمە, ئادار 11, 1987                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | شەمە, نیسان 11, 1987                                            | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | یەک شەمە, مایس 29, 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | پێنج شەمە, حوزەیران 11, 1987                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | شەمە, تەمموز 11, 1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | سێ شەمە, ئاب 11, 1987                                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | هەینی, ئەیلول 11, 1987                                          | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | یەک شەمە, تشرینی یەکەم 11, 1987                                 | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | چوار شەمە, تشرینی دووەم 11, 1987                                | 1987-12-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | هەینی, کانوونی یەکەم 11, 1987                                   | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-01-11T00:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-02-11T00:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-03-11T00:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-04-11T00:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 د-ن                                                       | 1453-05-29T11:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-06-11T00:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-07-11T00:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-08-11T00:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-09-11T00:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-10-11T00:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-11-11T00:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 د-ن                                                       | 1987-12-11T00:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-01-11T00:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-02-11T00:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-03-11T00:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-04-11T00:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 د-ن                                                    | 1453-05-29T11:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-06-11T00:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-07-11T00:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-08-11T00:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-09-11T00:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-10-11T00:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-11-11T00:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 د-ن                                                    | 1987-12-11T00:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 د-ن GMT+0                                              | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 د-ن GMT+00:00                                          | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 01/11/1987, 12:13 د-ن                                           | 1987-01-11T00:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987, 12:13 د-ن                                           | 1987-02-11T00:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987, 12:13 د-ن                                           | 1987-03-11T00:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987, 12:13 د-ن                                           | 1987-04-11T00:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453, 11:59 د-ن                                           | 1453-05-29T11:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987, 12:13 د-ن                                           | 1987-06-11T00:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987, 12:13 د-ن                                           | 1987-07-11T00:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987, 12:13 د-ن                                           | 1987-08-11T00:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987, 12:13 د-ن                                           | 1987-09-11T00:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987, 12:13 د-ن                                           | 1987-10-11T00:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 د-ن                                           | 1987-11-11T00:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987, 12:13 د-ن                                           | 1987-12-11T00:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | کان-دوو 11, 1987, 12:13:14 د-ن                                  | 1987-01-11T00:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | شوب 11, 1987, 12:13:14 د-ن                                      | 1987-02-11T00:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | ئاد 11, 1987, 12:13:14 د-ن                                      | 1987-03-11T00:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | نیس 11, 1987, 12:13:14 د-ن                                      | 1987-04-11T00:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | مایس 29, 1453, 11:59:59 د-ن                                     | 1453-05-29T11:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | حوز 11, 1987, 12:13:14 د-ن                                      | 1987-06-11T00:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | تەم 11, 1987, 12:13:14 د-ن                                      | 1987-07-11T00:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاب 11, 1987, 12:13:14 د-ن                                      | 1987-08-11T00:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | ئەل 11, 1987, 12:13:14 د-ن                                      | 1987-09-11T00:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | تش-یەک 11, 1987, 12:13:14 د-ن                                   | 1987-10-11T00:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | تش-دوو 11, 1987, 12:13:14 د-ن                                   | 1987-11-11T00:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | کان-یەک 11, 1987, 12:13:14 د-ن                                  | 1987-12-11T00:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | کانوونی دووەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0               | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | شوبات 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | ئادار 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                       | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | نیسان 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | مایس 29, 1453 کاتژمێر 11:59:59 د-ن GMT+0                        | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | حوزەیران 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | تەمموز 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاب 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                         | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | ئەیلول 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | تشرینی یەکەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | تشرینی دووەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | کانوونی یەکەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | یەک شەمە, کانوونی دووەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | چوار شەمە, شوبات 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00        | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | چوار شەمە, ئادار 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00        | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | شەمە, نیسان 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | یەک شەمە, مایس 29, 1453 کاتژمێر 11:59:59 د-ن GMT+00:00          | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | پێنج شەمە, حوزەیران 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | شەمە, تەمموز 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00            | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | سێ شەمە, ئاب 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00            | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | هەینی, ئەیلول 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00           | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | یەک شەمە, تشرینی یەکەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | چوار شەمە, تشرینی دووەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | هەینی, کانوونی یەکەم 11, 1987 کاتژمێر 12:13:14 د-ن GMT+00:00    | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result              | `includeSeconds: true` | `addSuffix: true`              |
| ------------------------ | ------------------- | ---------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | دەوروبەری 6 ساڵ     | دەوروبەری 6 ساڵ        | لە ماوەی دەوروبەری 6 ساڵدا     |
| 2005-01-01T00:00:00.000Z | دەوروبەری 5 ساڵ     | دەوروبەری 5 ساڵ        | لە ماوەی دەوروبەری 5 ساڵدا     |
| 2004-01-01T00:00:00.000Z | دەوروبەری 4 ساڵ     | دەوروبەری 4 ساڵ        | لە ماوەی دەوروبەری 4 ساڵدا     |
| 2003-01-01T00:00:00.000Z | دەوروبەری 3 ساڵ     | دەوروبەری 3 ساڵ        | لە ماوەی دەوروبەری 3 ساڵدا     |
| 2002-01-01T00:00:00.000Z | دەوروبەری 2 ساڵ     | دەوروبەری 2 ساڵ        | لە ماوەی دەوروبەری 2 ساڵدا     |
| 2001-06-01T00:00:00.000Z | زیاتر لە ساڵێک      | زیاتر لە ساڵێک         | لە ماوەی زیاتر لە ساڵێکدا      |
| 2001-02-01T00:00:00.000Z | دەوروبەری 1 ساڵ     | دەوروبەری 1 ساڵ        | لە ماوەی دەوروبەری 1 ساڵدا     |
| 2001-01-01T00:00:00.000Z | دەوروبەری 1 ساڵ     | دەوروبەری 1 ساڵ        | لە ماوەی دەوروبەری 1 ساڵدا     |
| 2000-06-01T00:00:00.000Z | 5 مانگ              | 5 مانگ                 | لە ماوەی 5 مانگدا              |
| 2000-03-01T00:00:00.000Z | 2 مانگ              | 2 مانگ                 | لە ماوەی 2 مانگدا              |
| 2000-02-01T00:00:00.000Z | داوروبەری 1 مانگ    | داوروبەری 1 مانگ       | لە ماوەی داوروبەری 1 مانگدا    |
| 2000-01-15T00:00:00.000Z | 14 ژۆژ              | 14 ژۆژ                 | لە ماوەی 14 ژۆژدا              |
| 2000-01-02T00:00:00.000Z | 1 ڕۆژ               | 1 ڕۆژ                  | لە ماوەی 1 ڕۆژدا               |
| 2000-01-01T06:00:00.000Z | دەوروبەری 6 کاتژمێر | دەوروبەری 6 کاتژمێر    | لە ماوەی دەوروبەری 6 کاتژمێردا |
| 2000-01-01T01:00:00.000Z | دەوروبەری 1 کاتژمێر | دەوروبەری 1 کاتژمێر    | لە ماوەی دەوروبەری 1 کاتژمێردا |
| 2000-01-01T00:45:00.000Z | دەوروبەری 1 کاتژمێر | دەوروبەری 1 کاتژمێر    | لە ماوەی دەوروبەری 1 کاتژمێردا |
| 2000-01-01T00:30:00.000Z | 30 خولەک            | 30 خولەک               | لە ماوەی 30 خولەکدا            |
| 2000-01-01T00:15:00.000Z | 15 خولەک            | 15 خولەک               | لە ماوەی 15 خولەکدا            |
| 2000-01-01T00:01:00.000Z | 1 خولەک             | 1 خولەک                | لە ماوەی 1 خولەکدا             |
| 2000-01-01T00:00:25.000Z | کەمتر لە یەک خولەک  | نیو کاتژمێر            | لە ماوەی کەمتر لە یەک خولەکدا  |
| 2000-01-01T00:00:15.000Z | کەمتر لە یەک خولەک  | کەمتر لە 20 چرکە       | لە ماوەی کەمتر لە یەک خولەکدا  |
| 2000-01-01T00:00:05.000Z | کەمتر لە یەک خولەک  | کەمتر لە 10 چرکە       | لە ماوەی کەمتر لە یەک خولەکدا  |
| 2000-01-01T00:00:00.000Z | کەمتر لە یەک خولەک  | کەمتر لە 5 چرکە        | کەمتر لە یەک خولەکپێش ئێستا    |
| 1999-12-31T23:59:55.000Z | کەمتر لە یەک خولەک  | کەمتر لە 10 چرکە       | کەمتر لە یەک خولەکپێش ئێستا    |
| 1999-12-31T23:59:45.000Z | کەمتر لە یەک خولەک  | کەمتر لە 20 چرکە       | کەمتر لە یەک خولەکپێش ئێستا    |
| 1999-12-31T23:59:35.000Z | کەمتر لە یەک خولەک  | نیو کاتژمێر            | کەمتر لە یەک خولەکپێش ئێستا    |
| 1999-12-31T23:59:00.000Z | 1 خولەک             | 1 خولەک                | 1 خولەکپێش ئێستا               |
| 1999-12-31T23:45:00.000Z | 15 خولەک            | 15 خولەک               | 15 خولەکپێش ئێستا              |
| 1999-12-31T23:30:00.000Z | 30 خولەک            | 30 خولەک               | 30 خولەکپێش ئێستا              |
| 1999-12-31T23:15:00.000Z | دەوروبەری 1 کاتژمێر | دەوروبەری 1 کاتژمێر    | دەوروبەری 1 کاتژمێرپێش ئێستا   |
| 1999-12-31T23:00:00.000Z | دەوروبەری 1 کاتژمێر | دەوروبەری 1 کاتژمێر    | دەوروبەری 1 کاتژمێرپێش ئێستا   |
| 1999-12-31T18:00:00.000Z | دەوروبەری 6 کاتژمێر | دەوروبەری 6 کاتژمێر    | دەوروبەری 6 کاتژمێرپێش ئێستا   |
| 1999-12-30T00:00:00.000Z | 2 ژۆژ               | 2 ژۆژ                  | 2 ژۆژپێش ئێستا                 |
| 1999-12-15T00:00:00.000Z | 17 ژۆژ              | 17 ژۆژ                 | 17 ژۆژپێش ئێستا                |
| 1999-12-01T00:00:00.000Z | داوروبەری 1 مانگ    | داوروبەری 1 مانگ       | داوروبەری 1 مانگپێش ئێستا      |
| 1999-11-01T00:00:00.000Z | 2 مانگ              | 2 مانگ                 | 2 مانگپێش ئێستا                |
| 1999-06-01T00:00:00.000Z | 7 مانگ              | 7 مانگ                 | 7 مانگپێش ئێستا                |
| 1999-01-01T00:00:00.000Z | دەوروبەری 1 ساڵ     | دەوروبەری 1 ساڵ        | دەوروبەری 1 ساڵپێش ئێستا       |
| 1998-12-01T00:00:00.000Z | دەوروبەری 1 ساڵ     | دەوروبەری 1 ساڵ        | دەوروبەری 1 ساڵپێش ئێستا       |
| 1998-06-01T00:00:00.000Z | زیاتر لە ساڵێک      | زیاتر لە ساڵێک         | زیاتر لە ساڵێکپێش ئێستا        |
| 1998-01-01T00:00:00.000Z | دەوروبەری 2 ساڵ     | دەوروبەری 2 ساڵ        | دەوروبەری 2 ساڵپێش ئێستا       |
| 1997-01-01T00:00:00.000Z | دەوروبەری 3 ساڵ     | دەوروبەری 3 ساڵ        | دەوروبەری 3 ساڵپێش ئێستا       |
| 1996-01-01T00:00:00.000Z | دەوروبەری 4 ساڵ     | دەوروبەری 4 ساڵ        | دەوروبەری 4 ساڵپێش ئێستا       |
| 1995-01-01T00:00:00.000Z | دەوروبەری 5 ساڵ     | دەوروبەری 5 ساڵ        | دەوروبەری 5 ساڵپێش ئێستا       |
| 1994-01-01T00:00:00.000Z | دەوروبەری 6 ساڵ     | دەوروبەری 6 ساڵ        | دەوروبەری 6 ساڵپێش ئێستا       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`    | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | -------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ساڵ     | لە ماوەی 6 ساڵدا     | 52608 کاتژمێر                  |
| 2005-01-01T00:00:00.000Z | 5 ساڵ     | لە ماوەی 5 ساڵدا     | 43848 کاتژمێر                  |
| 2004-01-01T00:00:00.000Z | 4 ساڵ     | لە ماوەی 4 ساڵدا     | 35064 کاتژمێر                  |
| 2003-01-01T00:00:00.000Z | 3 ساڵ     | لە ماوەی 3 ساڵدا     | 26304 کاتژمێر                  |
| 2002-01-01T00:00:00.000Z | 2 ساڵ     | لە ماوەی 2 ساڵدا     | 17544 کاتژمێر                  |
| 2001-06-01T00:00:00.000Z | 1 ساڵ     | لە ماوەی 1 ساڵدا     | 12408 کاتژمێر                  |
| 2001-02-01T00:00:00.000Z | 1 ساڵ     | لە ماوەی 1 ساڵدا     | 9528 کاتژمێر                   |
| 2001-01-01T00:00:00.000Z | 1 ساڵ     | لە ماوەی 1 ساڵدا     | 8784 کاتژمێر                   |
| 2000-06-01T00:00:00.000Z | 5 مانگ    | لە ماوەی 5 مانگدا    | 3648 کاتژمێر                   |
| 2000-03-01T00:00:00.000Z | 2 مانگ    | لە ماوەی 2 مانگدا    | 1440 کاتژمێر                   |
| 2000-02-01T00:00:00.000Z | 1 مانگ    | لە ماوەی 1 مانگدا    | 744 کاتژمێر                    |
| 2000-01-15T00:00:00.000Z | 14 ژۆژ    | لە ماوەی 14 ژۆژدا    | 336 کاتژمێر                    |
| 2000-01-02T00:00:00.000Z | 1 ڕۆژ     | لە ماوەی 1 ڕۆژدا     | 24 کاتژمێر                     |
| 2000-01-01T06:00:00.000Z | 6 کاتژمێر | لە ماوەی 6 کاتژمێردا | 6 کاتژمێر                      |
| 2000-01-01T01:00:00.000Z | 1 کاتژمێر | لە ماوەی 1 کاتژمێردا | 1 کاتژمێر                      |
| 2000-01-01T00:45:00.000Z | 45 خولەک  | لە ماوەی 45 خولەکدا  | 1 کاتژمێر                      |
| 2000-01-01T00:30:00.000Z | 30 خولەک  | لە ماوەی 30 خولەکدا  | 1 کاتژمێر                      |
| 2000-01-01T00:15:00.000Z | 15 خولەک  | لە ماوەی 15 خولەکدا  | 0 کاتژمێر                      |
| 2000-01-01T00:01:00.000Z | 1 خولەک   | لە ماوەی 1 خولەکدا   | 0 کاتژمێر                      |
| 2000-01-01T00:00:25.000Z | 25 چرکە   | لە ماوەی 25 چرکەدا   | 0 کاتژمێر                      |
| 2000-01-01T00:00:15.000Z | 15 چرکە   | لە ماوەی 15 چرکەدا   | 0 کاتژمێر                      |
| 2000-01-01T00:00:05.000Z | 5 چرکە    | لە ماوەی 5 چرکەدا    | 0 کاتژمێر                      |
| 2000-01-01T00:00:00.000Z | 0 چرکە    | 0 چرکەپێش ئێستا      | 0 کاتژمێر                      |
| 1999-12-31T23:59:55.000Z | 5 چرکە    | 5 چرکەپێش ئێستا      | 0 کاتژمێر                      |
| 1999-12-31T23:59:45.000Z | 15 چرکە   | 15 چرکەپێش ئێستا     | 0 کاتژمێر                      |
| 1999-12-31T23:59:35.000Z | 25 چرکە   | 25 چرکەپێش ئێستا     | 0 کاتژمێر                      |
| 1999-12-31T23:59:00.000Z | 1 خولەک   | 1 خولەکپێش ئێستا     | 0 کاتژمێر                      |
| 1999-12-31T23:45:00.000Z | 15 خولەک  | 15 خولەکپێش ئێستا    | 0 کاتژمێر                      |
| 1999-12-31T23:30:00.000Z | 30 خولەک  | 30 خولەکپێش ئێستا    | 1 کاتژمێر                      |
| 1999-12-31T23:15:00.000Z | 45 خولەک  | 45 خولەکپێش ئێستا    | 1 کاتژمێر                      |
| 1999-12-31T23:00:00.000Z | 1 کاتژمێر | 1 کاتژمێرپێش ئێستا   | 1 کاتژمێر                      |
| 1999-12-31T18:00:00.000Z | 6 کاتژمێر | 6 کاتژمێرپێش ئێستا   | 6 کاتژمێر                      |
| 1999-12-30T00:00:00.000Z | 2 ژۆژ     | 2 ژۆژپێش ئێستا       | 48 کاتژمێر                     |
| 1999-12-15T00:00:00.000Z | 17 ژۆژ    | 17 ژۆژپێش ئێستا      | 408 کاتژمێر                    |
| 1999-12-01T00:00:00.000Z | 1 مانگ    | 1 مانگپێش ئێستا      | 744 کاتژمێر                    |
| 1999-11-01T00:00:00.000Z | 2 مانگ    | 2 مانگپێش ئێستا      | 1464 کاتژمێر                   |
| 1999-06-01T00:00:00.000Z | 7 مانگ    | 7 مانگپێش ئێستا      | 5136 کاتژمێر                   |
| 1999-01-01T00:00:00.000Z | 1 ساڵ     | 1 ساڵپێش ئێستا       | 8760 کاتژمێر                   |
| 1998-12-01T00:00:00.000Z | 1 ساڵ     | 1 ساڵپێش ئێستا       | 9504 کاتژمێر                   |
| 1998-06-01T00:00:00.000Z | 2 ساڵ     | 2 ساڵپێش ئێستا       | 13896 کاتژمێر                  |
| 1998-01-01T00:00:00.000Z | 2 ساڵ     | 2 ساڵپێش ئێستا       | 17520 کاتژمێر                  |
| 1997-01-01T00:00:00.000Z | 3 ساڵ     | 3 ساڵپێش ئێستا       | 26280 کاتژمێر                  |
| 1996-01-01T00:00:00.000Z | 4 ساڵ     | 4 ساڵپێش ئێستا       | 35064 کاتژمێر                  |
| 1995-01-01T00:00:00.000Z | 5 ساڵ     | 5 ساڵپێش ئێستا       | 43824 کاتژمێر                  |
| 1994-01-01T00:00:00.000Z | 6 ساڵ     | 6 ساڵپێش ئێستا       | 52584 کاتژمێر                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                                    |
| ------------------------ | ----------------------------------------- |
| 2000-01-10T00:00:00.000Z | 01/10/2000                                |
| 2000-01-05T00:00:00.000Z | چوار شەمە کاتژمێر 12:00 پ-ن               |
| 2000-01-02T00:00:00.000Z | بەیانی کاتژمێر 12:00 پ-ن                  |
| 2000-01-01T00:00:00.000Z | ئەمڕۆ کاتژمێر 12:00 پ-ن                   |
| 1999-12-31T00:00:00.000Z | دوێنێ کاتژمێر 12:00 پ-ن                   |
| 1999-12-27T00:00:00.000Z | هەفتەی ڕابردوو دوو شەمە کاتژمێر 12:00 پ-ن |
| 1999-12-21T00:00:00.000Z | 12/21/1999                                |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 ساڵ     |
| {"years":1}   | 1 ساڵ     |
| {"years":2}   | 2 ساڵ     |
| {"months":0}  | 0 مانگ    |
| {"months":1}  | 1 مانگ    |
| {"months":2}  | 2 مانگ    |
| {"weeks":0}   | 0 هەفتە   |
| {"weeks":1}   | 1 هەفتە   |
| {"weeks":2}   | 2 هەفتە   |
| {"days":0}    | 0 ژۆژ     |
| {"days":1}    | 1 ڕۆژ     |
| {"days":2}    | 2 ژۆژ     |
| {"hours":0}   | 0 کاتژمێر |
| {"hours":1}   | 1 کاتژمێر |
| {"hours":2}   | 2 کاتژمێر |
| {"minutes":0} | 0 خولەک   |
| {"minutes":1} | 1 خولەک   |
| {"minutes":2} | 2 خولەک   |
| {"seconds":0} | 0 چرکە    |
| {"seconds":1} | 1 چرکە    |
| {"seconds":2} | 2 چرکە    |
