# Czech (cs) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                 | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                              | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                           | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                              | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1. čtvrtletí                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čtvrtletí                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. čtvrtletí                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čtvrtletí                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1. čtvrtletí                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čtvrtletí                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. čtvrtletí                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čtvrtletí                                    | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                              | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | led                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | úno                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | bře                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | dub                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | kvě                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | čvn                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | čvc                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | srp                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | zář                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | říj                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lis                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | pro                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | ledna                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | února                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | března                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | dubna                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | května                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | června                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | července                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | srpna                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | září                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | října                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | listopadu                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | prosince                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | L                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Ú                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | B                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | D                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | K                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Č                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Č                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | S                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Z                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ř                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | L                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | P                                               | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                              | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | led                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | úno                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | bře                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | dub                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | kvě                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | čvn                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | čvc                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | srp                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | zář                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | říj                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lis                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | pro                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | leden                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | únor                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | březen                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | duben                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | květen                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | červen                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | červenec                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | srpen                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | září                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | říjen                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | listopad                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | prosinec                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | L                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Ú                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | B                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | D                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | K                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Č                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Č                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | S                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Z                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ř                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | L                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | P                                               | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                             | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11.                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                             | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1. února                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11. února                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28. února                                       | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | pondělí                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pátek                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | po                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | Invalid Date             |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | po                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                              | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | pondělí                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pátek                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | po                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | Invalid Date             |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | po                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                              | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | pondělí                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pátek                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | po                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | Invalid Date             |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | po                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pon                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pát                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | pondělí                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pátek                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | po                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | Invalid Date             |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | po                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pá                                              | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | dopoledne                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dopoledne                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | dopoledne                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dopoledne                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | odp.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                            | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ráno                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | večer                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noc                                             | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ráno                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | večer                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noc                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ráno                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | večer                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noc                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ráno                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | večer                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noc                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ráno                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | odpoledne                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | večer                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | noc                                             | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                             | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987                                      | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987                                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987                                      | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11. 1. 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. 2. 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. 3. 1987                                     | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. 4. 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 5. 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. 6. 1987                                     | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. 7. 1987                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. 8. 1987                                     | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. 9. 1987                                     | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. 10. 1987                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. 11. 1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. 12. 1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11. ledna 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. února 1987                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. března 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. dubna 1987                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. května 1453                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. června 1987                                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. července 1987                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. srpna 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. září 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. října 1987                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. listopadu 1987                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. prosince 1987                               | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | neděle, 11. ledna 1987                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | středa, 11. února 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | středa, 11. března 1987                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | sobota, 11. dubna 1987                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | neděle, 29. května 1453                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | čtvrtek, 11. června 1987                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | sobota, 11. července 1987                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | úterý, 11. srpna 1987                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | pátek, 11. září 1987                            | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | neděle, 11. října 1987                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | středa, 11. listopadu 1987                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | pátek, 11. prosince 1987                        | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                           | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                           | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                           | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                           | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                           | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                           | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                           | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                           | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                           | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                           | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                           | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                        | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                        | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                        | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                        | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                        | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                        | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                        | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                        | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                        | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                        | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                        | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987, 12:13                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987, 12:13                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987, 12:13                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987, 12:13                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987, 12:13                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987, 12:13                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987, 12:13                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987, 12:13                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987, 12:13                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987, 12:13                               | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11. 1. 1987, 12:13:14                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. 2. 1987, 12:13:14                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. 3. 1987, 12:13:14                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. 4. 1987, 12:13:14                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 5. 1453, 23:59:59                           | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. 6. 1987, 12:13:14                           | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. 7. 1987, 12:13:14                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. 8. 1987, 12:13:14                           | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. 9. 1987, 12:13:14                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. 10. 1987, 12:13:14                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. 11. 1987, 12:13:14                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. 12. 1987, 12:13:14                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11. ledna 1987 v 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. února 1987 v 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. března 1987 v 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. dubna 1987 v 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. května 1453 v 23:59:59 GMT+0                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. června 1987 v 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. července 1987 v 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. srpna 1987 v 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. září 1987 v 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. října 1987 v 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. listopadu 1987 v 12:13:14 GMT+0             | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. prosince 1987 v 12:13:14 GMT+0              | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | neděle, 11. ledna 1987 v 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | středa, 11. února 1987 v 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | středa, 11. března 1987 v 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | sobota, 11. dubna 1987 v 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | neděle, 29. května 1453 v 23:59:59 GMT+00:00    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | čtvrtek, 11. června 1987 v 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | sobota, 11. července 1987 v 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | úterý, 11. srpna 1987 v 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | pátek, 11. září 1987 v 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | neděle, 11. října 1987 v 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | středa, 11. listopadu 1987 v 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | pátek, 11. prosince 1987 v 12:13:14 GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | ------------------ | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | přibližně 6 roků   | přibližně 6 roků       | přibližně za 6 roků       |
| 2005-01-01T00:00:00.000Z | přibližně 5 roků   | přibližně 5 roků       | přibližně za 5 roků       |
| 2004-01-01T00:00:00.000Z | přibližně 4 roky   | přibližně 4 roky       | přibližně za 4 roky       |
| 2003-01-01T00:00:00.000Z | přibližně 3 roky   | přibližně 3 roky       | přibližně za 3 roky       |
| 2002-01-01T00:00:00.000Z | přibližně 2 roky   | přibližně 2 roky       | přibližně za 2 roky       |
| 2001-06-01T00:00:00.000Z | více než 1 rok     | více než 1 rok         | za více než 1 rok         |
| 2001-02-01T00:00:00.000Z | přibližně 1 rok    | přibližně 1 rok        | přibližně za 1 rok        |
| 2001-01-01T00:00:00.000Z | přibližně 1 rok    | přibližně 1 rok        | přibližně za 1 rok        |
| 2000-06-01T00:00:00.000Z | 5 měsíců           | 5 měsíců               | za 5 měsíců               |
| 2000-03-01T00:00:00.000Z | 2 měsíce           | 2 měsíce               | za 2 měsíce               |
| 2000-02-01T00:00:00.000Z | přibližně 1 měsíc  | přibližně 1 měsíc      | přibližně za 1 měsíc      |
| 2000-01-15T00:00:00.000Z | 14 dní             | 14 dní                 | za 14 dní                 |
| 2000-01-02T00:00:00.000Z | 1 den              | 1 den                  | za 1 den                  |
| 2000-01-01T06:00:00.000Z | přibližně 6 hodin  | přibližně 6 hodin      | přibližně za 6 hodin      |
| 2000-01-01T01:00:00.000Z | přibližně 1 hodina | přibližně 1 hodina     | přibližně za 1 hodinu     |
| 2000-01-01T00:45:00.000Z | přibližně 1 hodina | přibližně 1 hodina     | přibližně za 1 hodinu     |
| 2000-01-01T00:30:00.000Z | 30 minut           | 30 minut               | za 30 minut               |
| 2000-01-01T00:15:00.000Z | 15 minut           | 15 minut               | za 15 minut               |
| 2000-01-01T00:01:00.000Z | 1 minuta           | 1 minuta               | za 1 minutu               |
| 2000-01-01T00:00:25.000Z | méně než 1 minuta  | půl minuty             | za méně než 1 minutu      |
| 2000-01-01T00:00:15.000Z | méně než 1 minuta  | méně než 20 sekund     | za méně než 1 minutu      |
| 2000-01-01T00:00:05.000Z | méně než 1 minuta  | méně než 10 sekund     | za méně než 1 minutu      |
| 2000-01-01T00:00:00.000Z | méně než 1 minuta  | méně než 5 sekund      | méně než 1 minuta         |
| 1999-12-31T23:59:55.000Z | méně než 1 minuta  | méně než 10 sekund     | před méně než 1 minutou   |
| 1999-12-31T23:59:45.000Z | méně než 1 minuta  | méně než 20 sekund     | před méně než 1 minutou   |
| 1999-12-31T23:59:35.000Z | méně než 1 minuta  | půl minuty             | před méně než 1 minutou   |
| 1999-12-31T23:59:00.000Z | 1 minuta           | 1 minuta               | před 1 minutou            |
| 1999-12-31T23:45:00.000Z | 15 minut           | 15 minut               | před 15 minutami          |
| 1999-12-31T23:30:00.000Z | 30 minut           | 30 minut               | před 30 minutami          |
| 1999-12-31T23:15:00.000Z | přibližně 1 hodina | přibližně 1 hodina     | přibližně před 1 hodinou  |
| 1999-12-31T23:00:00.000Z | přibližně 1 hodina | přibližně 1 hodina     | přibližně před 1 hodinou  |
| 1999-12-31T18:00:00.000Z | přibližně 6 hodin  | přibližně 6 hodin      | přibližně před 6 hodinami |
| 1999-12-30T00:00:00.000Z | 2 dny              | 2 dny                  | před 2 dny                |
| 1999-12-15T00:00:00.000Z | 17 dní             | 17 dní                 | před 17 dny               |
| 1999-12-01T00:00:00.000Z | přibližně 1 měsíc  | přibližně 1 měsíc      | přibližně před 1 měsícem  |
| 1999-11-01T00:00:00.000Z | 2 měsíce           | 2 měsíce               | před 2 měsíci             |
| 1999-06-01T00:00:00.000Z | 7 měsíců           | 7 měsíců               | před 7 měsíci             |
| 1999-01-01T00:00:00.000Z | přibližně 1 rok    | přibližně 1 rok        | přibližně před 1 rokem    |
| 1998-12-01T00:00:00.000Z | přibližně 1 rok    | přibližně 1 rok        | přibližně před 1 rokem    |
| 1998-06-01T00:00:00.000Z | více než 1 rok     | více než 1 rok         | před více než 1 rokem     |
| 1998-01-01T00:00:00.000Z | přibližně 2 roky   | přibližně 2 roky       | přibližně před 2 roky     |
| 1997-01-01T00:00:00.000Z | přibližně 3 roky   | přibližně 3 roky       | přibližně před 3 roky     |
| 1996-01-01T00:00:00.000Z | přibližně 4 roky   | přibližně 4 roky       | přibližně před 4 roky     |
| 1995-01-01T00:00:00.000Z | přibližně 5 roků   | přibližně 5 roků       | přibližně před 5 roky     |
| 1994-01-01T00:00:00.000Z | přibližně 6 roků   | přibližně 6 roků       | přibližně před 6 roky     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 roků    | za 6 roků         | 52608 hodin                    |
| 2005-01-01T00:00:00.000Z | 5 roků    | za 5 roků         | 43848 hodin                    |
| 2004-01-01T00:00:00.000Z | 4 roky    | za 4 roky         | 35064 hodin                    |
| 2003-01-01T00:00:00.000Z | 3 roky    | za 3 roky         | 26304 hodin                    |
| 2002-01-01T00:00:00.000Z | 2 roky    | za 2 roky         | 17544 hodin                    |
| 2001-06-01T00:00:00.000Z | 1 rok     | za 1 rok          | 12408 hodin                    |
| 2001-02-01T00:00:00.000Z | 1 rok     | za 1 rok          | 9528 hodin                     |
| 2001-01-01T00:00:00.000Z | 1 rok     | za 1 rok          | 8784 hodin                     |
| 2000-06-01T00:00:00.000Z | 5 měsíců  | za 5 měsíců       | 3648 hodin                     |
| 2000-03-01T00:00:00.000Z | 2 měsíce  | za 2 měsíce       | 1440 hodin                     |
| 2000-02-01T00:00:00.000Z | 1 měsíc   | za 1 měsíc        | 744 hodin                      |
| 2000-01-15T00:00:00.000Z | 14 dní    | za 14 dní         | 336 hodin                      |
| 2000-01-02T00:00:00.000Z | 1 den     | za 1 den          | 24 hodin                       |
| 2000-01-01T06:00:00.000Z | 6 hodin   | za 6 hodin        | 6 hodin                        |
| 2000-01-01T01:00:00.000Z | 1 hodina  | za 1 hodinu       | 1 hodina                       |
| 2000-01-01T00:45:00.000Z | 45 minut  | za 45 minut       | 1 hodina                       |
| 2000-01-01T00:30:00.000Z | 30 minut  | za 30 minut       | 1 hodina                       |
| 2000-01-01T00:15:00.000Z | 15 minut  | za 15 minut       | 0 hodin                        |
| 2000-01-01T00:01:00.000Z | 1 minuta  | za 1 minutu       | 0 hodin                        |
| 2000-01-01T00:00:25.000Z | 25 sekund | za 25 sekund      | 0 hodin                        |
| 2000-01-01T00:00:15.000Z | 15 sekund | za 15 sekund      | 0 hodin                        |
| 2000-01-01T00:00:05.000Z | 5 sekund  | za 5 sekund       | 0 hodin                        |
| 2000-01-01T00:00:00.000Z | 0 sekund  | 0 sekund          | 0 hodin                        |
| 1999-12-31T23:59:55.000Z | 5 sekund  | před 5 sekundami  | 0 hodin                        |
| 1999-12-31T23:59:45.000Z | 15 sekund | před 15 sekundami | 0 hodin                        |
| 1999-12-31T23:59:35.000Z | 25 sekund | před 25 sekundami | 0 hodin                        |
| 1999-12-31T23:59:00.000Z | 1 minuta  | před 1 minutou    | 0 hodin                        |
| 1999-12-31T23:45:00.000Z | 15 minut  | před 15 minutami  | 0 hodin                        |
| 1999-12-31T23:30:00.000Z | 30 minut  | před 30 minutami  | 1 hodina                       |
| 1999-12-31T23:15:00.000Z | 45 minut  | před 45 minutami  | 1 hodina                       |
| 1999-12-31T23:00:00.000Z | 1 hodina  | před 1 hodinou    | 1 hodina                       |
| 1999-12-31T18:00:00.000Z | 6 hodin   | před 6 hodinami   | 6 hodin                        |
| 1999-12-30T00:00:00.000Z | 2 dny     | před 2 dny        | 48 hodin                       |
| 1999-12-15T00:00:00.000Z | 17 dní    | před 17 dny       | 408 hodin                      |
| 1999-12-01T00:00:00.000Z | 1 měsíc   | před 1 měsícem    | 744 hodin                      |
| 1999-11-01T00:00:00.000Z | 2 měsíce  | před 2 měsíci     | 1464 hodin                     |
| 1999-06-01T00:00:00.000Z | 7 měsíců  | před 7 měsíci     | 5136 hodin                     |
| 1999-01-01T00:00:00.000Z | 1 rok     | před 1 rokem      | 8760 hodin                     |
| 1998-12-01T00:00:00.000Z | 1 rok     | před 1 rokem      | 9504 hodin                     |
| 1998-06-01T00:00:00.000Z | 2 roky    | před 2 roky       | 13896 hodin                    |
| 1998-01-01T00:00:00.000Z | 2 roky    | před 2 roky       | 17520 hodin                    |
| 1997-01-01T00:00:00.000Z | 3 roky    | před 3 roky       | 26280 hodin                    |
| 1996-01-01T00:00:00.000Z | 4 roky    | před 4 roky       | 35064 hodin                    |
| 1995-01-01T00:00:00.000Z | 5 roků    | před 5 roky       | 43824 hodin                    |
| 1994-01-01T00:00:00.000Z | 6 roků    | před 6 roky       | 52584 hodin                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | v středu o 0:00          |
| 2000-01-02T00:00:00.000Z | zítra v 0:00             |
| 2000-01-01T00:00:00.000Z | dnes v 0:00              |
| 1999-12-31T00:00:00.000Z | včera v 0:00             |
| 1999-12-27T00:00:00.000Z | poslední pondělí ve 0:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 roků    |
| {"years":1}   | 1 rok     |
| {"years":2}   | 2 roky    |
| {"months":0}  | 0 měsíců  |
| {"months":1}  | 1 měsíc   |
| {"months":2}  | 2 měsíce  |
| {"weeks":0}   | 0 týdnů   |
| {"weeks":1}   | 1 týden   |
| {"weeks":2}   | 2 týdny   |
| {"days":0}    | 0 dní     |
| {"days":1}    | 1 den     |
| {"days":2}    | 2 dny     |
| {"hours":0}   | 0 hodin   |
| {"hours":1}   | 1 hodina  |
| {"hours":2}   | 2 hodiny  |
| {"minutes":0} | 0 minut   |
| {"minutes":1} | 1 minuta  |
| {"minutes":2} | 2 minuty  |
| {"seconds":0} | 0 sekund  |
| {"seconds":1} | 1 sekunda |
| {"seconds":2} | 2 sekundy |
