# Greek (el) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                          | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ος                                                   | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ος                                                      | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ος                                                   | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4ος                                                      | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1ο                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ο                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Τ1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Τ2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1ο τρίμηνο                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ο τρίμηνο                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                        | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1ο                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ο                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Τ1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Τ2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1ο τρίμηνο                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ο τρίμηνο                                               | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1ος                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2ος                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3ος                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4ος                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5ος                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6ος                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ος                                                      | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8ος                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9ος                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10ος                                                     | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11ος                                                     | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12ος                                                     | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | Ιαν                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φεβ                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μαρ                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Απρ                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μαΐ                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ιουν                                                     | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ιουλ                                                     | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Αυγ                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σεπ                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Οκτ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Νοε                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δεκ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | Ιανουαρίου                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φεβρουαρίου                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μαρτίου                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Απριλίου                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μαΐου                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ιουνίου                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ιουλίου                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Αυγούστου                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σεπτεμβρίου                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Οκτωβρίου                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Νοεμβρίου                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δεκεμβρίου                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φ                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μ                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Α                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μ                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Α                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σ                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ο                                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Ν                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δ                                                        | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1ος                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2ος                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3ος                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4ος                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5ος                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6ος                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ος                                                      | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8ος                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9ος                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10ος                                                     | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11ος                                                     | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12ος                                                     | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | Ιαν                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φεβ                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μάρ                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Απρ                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μάι                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ιούν                                                     | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ιούλ                                                     | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Αύγ                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σεπ                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Οκτ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Νοέ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δεκ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | Ιανουάριος                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φεβρουάριος                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μάρτιος                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Απρίλιος                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μάιος                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ιούνιος                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ιούλιος                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Αύγουστος                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σεπτέμβριος                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Οκτώβριος                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Νοέμβριος                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δεκέμβριος                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Φ                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Μ                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Α                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Μ                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ι                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Α                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Σ                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ο                                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Ν                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Δ                                                        | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1η                                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48η                                                      | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1η                                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48η                                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1η                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11η                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28η                                                      | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1η Φεβρουαρίου                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11η Φεβρουαρίου                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28η Φεβρουαρίου                                          | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42η                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365η                                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Δευτέρα                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρασκευή                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Δ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Π                                                        | 2019-02-14T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Δε                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Πα                                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1η                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5η                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Δευτέρα                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρασκευή                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Δ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Π                                                        | 2019-02-14T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Δε                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Πα                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1η                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5η                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Δευτέρα                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρασκευή                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Δ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Π                                                        | 2019-02-14T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Δε                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Πα                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1η                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5η                                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Δευ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Δευτέρα                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Παρασκευή                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Δ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Π                                                        | 2019-02-14T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Δε                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Πα                                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | πμ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μμ                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μμ                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | πμ                                                       | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μ.μ.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | π.μ.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | πμ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | μμ                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | μμ                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | πμ                                                       | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | πρωί                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | απόγευμα                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | βράδυ                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | νύχτα                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | πρωί                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | απόγευμα                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | βράδυ                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | νύχτα                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | πρωί                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | απόγευμα                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | βράδυ                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | νύχτα                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | πρωί                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | απόγευμα                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | βράδυ                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | νύχτα                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | πρωί                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | απόγευμα                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | βράδυ                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | νύχτα                                                    | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11η                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11η                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11η                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23η                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11η                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11η                                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11η                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23η                                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1ο                                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ο                                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1ο                                                       | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55ο                                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/1/87                                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/2/87                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/3/87                                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/4/87                                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53                                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/6/87                                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/7/87                                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/8/87                                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/9/87                                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/87                                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/87                                                 | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/87                                                 | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 Ιαν 1987                                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Φεβ 1987                                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Μαρ 1987                                              | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Απρ 1987                                              | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Μαΐ 1453                                              | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ιουν 1987                                             | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Ιουλ 1987                                             | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Αυγ 1987                                              | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Σεπ 1987                                              | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Οκτ 1987                                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Νοε 1987                                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Δεκ 1987                                              | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 Ιανουαρίου 1987                                       | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Φεβρουαρίου 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Μαρτίου 1987                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Απριλίου 1987                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Μαΐου 1453                                            | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ιουνίου 1987                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Ιουλίου 1987                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Αυγούστου 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Σεπτεμβρίου 1987                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Οκτωβρίου 1987                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Νοεμβρίου 1987                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Δεκεμβρίου 1987                                       | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | Κυριακή, 11 Ιανουαρίου 1987                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Τετάρτη, 11 Φεβρουαρίου 1987                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Τετάρτη, 11 Μαρτίου 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Σάββατο, 11 Απριλίου 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Κυριακή, 29 Μαΐου 1453                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Πέμπτη, 11 Ιουνίου 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Σάββατο, 11 Ιουλίου 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Τρίτη, 11 Αυγούστου 1987                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Παρασκευή, 11 Σεπτεμβρίου 1987                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Κυριακή, 11 Οκτωβρίου 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Τετάρτη, 11 Νοεμβρίου 1987                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Παρασκευή, 11 Δεκεμβρίου 1987                            | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 μ.μ.                                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 μ.μ.                                               | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 μ.μ.                                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 μ.μ.                                            | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 μ.μ. GMT+00:00                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/1/87, 12:13 μ.μ.                                      | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/2/87, 12:13 μ.μ.                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/3/87, 12:13 μ.μ.                                      | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/4/87, 12:13 μ.μ.                                      | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53, 11:59 μ.μ.                                      | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/6/87, 12:13 μ.μ.                                      | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/7/87, 12:13 μ.μ.                                      | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/8/87, 12:13 μ.μ.                                      | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/9/87, 12:13 μ.μ.                                      | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/87, 12:13 μ.μ.                                     | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/87, 12:13 μ.μ.                                     | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/87, 12:13 μ.μ.                                     | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 Ιαν 1987, 12:13:14 μ.μ.                               | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Φεβ 1987, 12:13:14 μ.μ.                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Μαρ 1987, 12:13:14 μ.μ.                               | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Απρ 1987, 12:13:14 μ.μ.                               | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Μαΐ 1453, 11:59:59 μ.μ.                               | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ιουν 1987, 12:13:14 μ.μ.                              | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Ιουλ 1987, 12:13:14 μ.μ.                              | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Αυγ 1987, 12:13:14 μ.μ.                               | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Σεπ 1987, 12:13:14 μ.μ.                               | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Οκτ 1987, 12:13:14 μ.μ.                               | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Νοε 1987, 12:13:14 μ.μ.                               | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Δεκ 1987, 12:13:14 μ.μ.                               | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 Ιανουαρίου 1987 - 12:13:14 μ.μ. GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Φεβρουαρίου 1987 - 12:13:14 μ.μ. GMT+0                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Μαρτίου 1987 - 12:13:14 μ.μ. GMT+0                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Απριλίου 1987 - 12:13:14 μ.μ. GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Μαΐου 1453 - 11:59:59 μ.μ. GMT+0                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ιουνίου 1987 - 12:13:14 μ.μ. GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Ιουλίου 1987 - 12:13:14 μ.μ. GMT+0                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Αυγούστου 1987 - 12:13:14 μ.μ. GMT+0                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Σεπτεμβρίου 1987 - 12:13:14 μ.μ. GMT+0                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Οκτωβρίου 1987 - 12:13:14 μ.μ. GMT+0                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Νοεμβρίου 1987 - 12:13:14 μ.μ. GMT+0                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Δεκεμβρίου 1987 - 12:13:14 μ.μ. GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | Κυριακή, 11 Ιανουαρίου 1987 - 12:13:14 μ.μ. GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | Τετάρτη, 11 Φεβρουαρίου 1987 - 12:13:14 μ.μ. GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | Τετάρτη, 11 Μαρτίου 1987 - 12:13:14 μ.μ. GMT+00:00       | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | Σάββατο, 11 Απριλίου 1987 - 12:13:14 μ.μ. GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Κυριακή, 29 Μαΐου 1453 - 11:59:59 μ.μ. GMT+00:00         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | Πέμπτη, 11 Ιουνίου 1987 - 12:13:14 μ.μ. GMT+00:00        | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | Σάββατο, 11 Ιουλίου 1987 - 12:13:14 μ.μ. GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | Τρίτη, 11 Αυγούστου 1987 - 12:13:14 μ.μ. GMT+00:00       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | Παρασκευή, 11 Σεπτεμβρίου 1987 - 12:13:14 μ.μ. GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | Κυριακή, 11 Οκτωβρίου 1987 - 12:13:14 μ.μ. GMT+00:00     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | Τετάρτη, 11 Νοεμβρίου 1987 - 12:13:14 μ.μ. GMT+00:00     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | Παρασκευή, 11 Δεκεμβρίου 1987 - 12:13:14 μ.μ. GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 | `includeSeconds: true`       | `addSuffix: true`           |
| ------------------------ | ---------------------- | ---------------------------- | --------------------------- |
| 2006-01-01T00:00:00.000Z | περίπου 6 χρόνια       | περίπου 6 χρόνια             | σε περίπου 6 χρόνια         |
| 2005-01-01T00:00:00.000Z | περίπου 5 χρόνια       | περίπου 5 χρόνια             | σε περίπου 5 χρόνια         |
| 2004-01-01T00:00:00.000Z | περίπου 4 χρόνια       | περίπου 4 χρόνια             | σε περίπου 4 χρόνια         |
| 2003-01-01T00:00:00.000Z | περίπου 3 χρόνια       | περίπου 3 χρόνια             | σε περίπου 3 χρόνια         |
| 2002-01-01T00:00:00.000Z | περίπου 2 χρόνια       | περίπου 2 χρόνια             | σε περίπου 2 χρόνια         |
| 2001-06-01T00:00:00.000Z | πάνω από 1 χρόνο       | πάνω από 1 χρόνο             | σε πάνω από 1 χρόνο         |
| 2001-02-01T00:00:00.000Z | περίπου 1 χρόνο        | περίπου 1 χρόνο              | σε περίπου 1 χρόνο          |
| 2001-01-01T00:00:00.000Z | περίπου 1 χρόνο        | περίπου 1 χρόνο              | σε περίπου 1 χρόνο          |
| 2000-06-01T00:00:00.000Z | 5 μήνες                | 5 μήνες                      | σε 5 μήνες                  |
| 2000-03-01T00:00:00.000Z | 2 μήνες                | 2 μήνες                      | σε 2 μήνες                  |
| 2000-02-01T00:00:00.000Z | περίπου 1 μήνας        | περίπου 1 μήνας              | σε περίπου 1 μήνας          |
| 2000-01-15T00:00:00.000Z | 14 ημέρες              | 14 ημέρες                    | σε 14 ημέρες                |
| 2000-01-02T00:00:00.000Z | 1 ημέρα                | 1 ημέρα                      | σε 1 ημέρα                  |
| 2000-01-01T06:00:00.000Z | περίπου 6 ώρες         | περίπου 6 ώρες               | σε περίπου 6 ώρες           |
| 2000-01-01T01:00:00.000Z | περίπου 1 ώρα          | περίπου 1 ώρα                | σε περίπου 1 ώρα            |
| 2000-01-01T00:45:00.000Z | περίπου 1 ώρα          | περίπου 1 ώρα                | σε περίπου 1 ώρα            |
| 2000-01-01T00:30:00.000Z | 30 λεπτά               | 30 λεπτά                     | σε 30 λεπτά                 |
| 2000-01-01T00:15:00.000Z | 15 λεπτά               | 15 λεπτά                     | σε 15 λεπτά                 |
| 2000-01-01T00:01:00.000Z | 1 λεπτό                | 1 λεπτό                      | σε 1 λεπτό                  |
| 2000-01-01T00:00:25.000Z | λιγότερο από ένα λεπτό | μισό λεπτό                   | σε λιγότερο από ένα λεπτό   |
| 2000-01-01T00:00:15.000Z | λιγότερο από ένα λεπτό | λιγότερο από 20 δευτερόλεπτα | σε λιγότερο από ένα λεπτό   |
| 2000-01-01T00:00:05.000Z | λιγότερο από ένα λεπτό | λιγότερο από 10 δευτερόλεπτα | σε λιγότερο από ένα λεπτό   |
| 2000-01-01T00:00:00.000Z | λιγότερο από ένα λεπτό | λιγότερο από 5 δευτερόλεπτα  | λιγότερο από ένα λεπτό πριν |
| 1999-12-31T23:59:55.000Z | λιγότερο από ένα λεπτό | λιγότερο από 10 δευτερόλεπτα | λιγότερο από ένα λεπτό πριν |
| 1999-12-31T23:59:45.000Z | λιγότερο από ένα λεπτό | λιγότερο από 20 δευτερόλεπτα | λιγότερο από ένα λεπτό πριν |
| 1999-12-31T23:59:35.000Z | λιγότερο από ένα λεπτό | μισό λεπτό                   | λιγότερο από ένα λεπτό πριν |
| 1999-12-31T23:59:00.000Z | 1 λεπτό                | 1 λεπτό                      | 1 λεπτό πριν                |
| 1999-12-31T23:45:00.000Z | 15 λεπτά               | 15 λεπτά                     | 15 λεπτά πριν               |
| 1999-12-31T23:30:00.000Z | 30 λεπτά               | 30 λεπτά                     | 30 λεπτά πριν               |
| 1999-12-31T23:15:00.000Z | περίπου 1 ώρα          | περίπου 1 ώρα                | περίπου 1 ώρα πριν          |
| 1999-12-31T23:00:00.000Z | περίπου 1 ώρα          | περίπου 1 ώρα                | περίπου 1 ώρα πριν          |
| 1999-12-31T18:00:00.000Z | περίπου 6 ώρες         | περίπου 6 ώρες               | περίπου 6 ώρες πριν         |
| 1999-12-30T00:00:00.000Z | 2 ημέρες               | 2 ημέρες                     | 2 ημέρες πριν               |
| 1999-12-15T00:00:00.000Z | 17 ημέρες              | 17 ημέρες                    | 17 ημέρες πριν              |
| 1999-12-01T00:00:00.000Z | περίπου 1 μήνας        | περίπου 1 μήνας              | περίπου 1 μήνας πριν        |
| 1999-11-01T00:00:00.000Z | 2 μήνες                | 2 μήνες                      | 2 μήνες πριν                |
| 1999-06-01T00:00:00.000Z | 7 μήνες                | 7 μήνες                      | 7 μήνες πριν                |
| 1999-01-01T00:00:00.000Z | περίπου 1 χρόνο        | περίπου 1 χρόνο              | περίπου 1 χρόνο πριν        |
| 1998-12-01T00:00:00.000Z | περίπου 1 χρόνο        | περίπου 1 χρόνο              | περίπου 1 χρόνο πριν        |
| 1998-06-01T00:00:00.000Z | πάνω από 1 χρόνο       | πάνω από 1 χρόνο             | πάνω από 1 χρόνο πριν       |
| 1998-01-01T00:00:00.000Z | περίπου 2 χρόνια       | περίπου 2 χρόνια             | περίπου 2 χρόνια πριν       |
| 1997-01-01T00:00:00.000Z | περίπου 3 χρόνια       | περίπου 3 χρόνια             | περίπου 3 χρόνια πριν       |
| 1996-01-01T00:00:00.000Z | περίπου 4 χρόνια       | περίπου 4 χρόνια             | περίπου 4 χρόνια πριν       |
| 1995-01-01T00:00:00.000Z | περίπου 5 χρόνια       | περίπου 5 χρόνια             | περίπου 5 χρόνια πριν       |
| 1994-01-01T00:00:00.000Z | περίπου 6 χρόνια       | περίπου 6 χρόνια             | περίπου 6 χρόνια πριν       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `addSuffix: true`    | With forced unit (i.e. `hour`) |
| ------------------------ | --------------- | -------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 χρόνια        | σε 6 χρόνια          | 52608 ώρες                     |
| 2005-01-01T00:00:00.000Z | 5 χρόνια        | σε 5 χρόνια          | 43848 ώρες                     |
| 2004-01-01T00:00:00.000Z | 4 χρόνια        | σε 4 χρόνια          | 35064 ώρες                     |
| 2003-01-01T00:00:00.000Z | 3 χρόνια        | σε 3 χρόνια          | 26304 ώρες                     |
| 2002-01-01T00:00:00.000Z | 2 χρόνια        | σε 2 χρόνια          | 17544 ώρες                     |
| 2001-06-01T00:00:00.000Z | 1 χρόνο         | σε 1 χρόνο           | 12408 ώρες                     |
| 2001-02-01T00:00:00.000Z | 1 χρόνο         | σε 1 χρόνο           | 9528 ώρες                      |
| 2001-01-01T00:00:00.000Z | 1 χρόνο         | σε 1 χρόνο           | 8784 ώρες                      |
| 2000-06-01T00:00:00.000Z | 5 μήνες         | σε 5 μήνες           | 3648 ώρες                      |
| 2000-03-01T00:00:00.000Z | 2 μήνες         | σε 2 μήνες           | 1440 ώρες                      |
| 2000-02-01T00:00:00.000Z | 1 μήνας         | σε 1 μήνας           | 744 ώρες                       |
| 2000-01-15T00:00:00.000Z | 14 ημέρες       | σε 14 ημέρες         | 336 ώρες                       |
| 2000-01-02T00:00:00.000Z | 1 ημέρα         | σε 1 ημέρα           | 24 ώρες                        |
| 2000-01-01T06:00:00.000Z | 6 ώρες          | σε 6 ώρες            | 6 ώρες                         |
| 2000-01-01T01:00:00.000Z | 1 ώρα           | σε 1 ώρα             | 1 ώρα                          |
| 2000-01-01T00:45:00.000Z | 45 λεπτά        | σε 45 λεπτά          | 1 ώρα                          |
| 2000-01-01T00:30:00.000Z | 30 λεπτά        | σε 30 λεπτά          | 1 ώρα                          |
| 2000-01-01T00:15:00.000Z | 15 λεπτά        | σε 15 λεπτά          | 0 ώρες                         |
| 2000-01-01T00:01:00.000Z | 1 λεπτό         | σε 1 λεπτό           | 0 ώρες                         |
| 2000-01-01T00:00:25.000Z | 25 δευτερόλεπτα | σε 25 δευτερόλεπτα   | 0 ώρες                         |
| 2000-01-01T00:00:15.000Z | 15 δευτερόλεπτα | σε 15 δευτερόλεπτα   | 0 ώρες                         |
| 2000-01-01T00:00:05.000Z | 5 δευτερόλεπτα  | σε 5 δευτερόλεπτα    | 0 ώρες                         |
| 2000-01-01T00:00:00.000Z | 0 δευτερόλεπτα  | 0 δευτερόλεπτα πριν  | 0 ώρες                         |
| 1999-12-31T23:59:55.000Z | 5 δευτερόλεπτα  | 5 δευτερόλεπτα πριν  | 0 ώρες                         |
| 1999-12-31T23:59:45.000Z | 15 δευτερόλεπτα | 15 δευτερόλεπτα πριν | 0 ώρες                         |
| 1999-12-31T23:59:35.000Z | 25 δευτερόλεπτα | 25 δευτερόλεπτα πριν | 0 ώρες                         |
| 1999-12-31T23:59:00.000Z | 1 λεπτό         | 1 λεπτό πριν         | 0 ώρες                         |
| 1999-12-31T23:45:00.000Z | 15 λεπτά        | 15 λεπτά πριν        | 0 ώρες                         |
| 1999-12-31T23:30:00.000Z | 30 λεπτά        | 30 λεπτά πριν        | 1 ώρα                          |
| 1999-12-31T23:15:00.000Z | 45 λεπτά        | 45 λεπτά πριν        | 1 ώρα                          |
| 1999-12-31T23:00:00.000Z | 1 ώρα           | 1 ώρα πριν           | 1 ώρα                          |
| 1999-12-31T18:00:00.000Z | 6 ώρες          | 6 ώρες πριν          | 6 ώρες                         |
| 1999-12-30T00:00:00.000Z | 2 ημέρες        | 2 ημέρες πριν        | 48 ώρες                        |
| 1999-12-15T00:00:00.000Z | 17 ημέρες       | 17 ημέρες πριν       | 408 ώρες                       |
| 1999-12-01T00:00:00.000Z | 1 μήνας         | 1 μήνας πριν         | 744 ώρες                       |
| 1999-11-01T00:00:00.000Z | 2 μήνες         | 2 μήνες πριν         | 1464 ώρες                      |
| 1999-06-01T00:00:00.000Z | 7 μήνες         | 7 μήνες πριν         | 5136 ώρες                      |
| 1999-01-01T00:00:00.000Z | 1 χρόνο         | 1 χρόνο πριν         | 8760 ώρες                      |
| 1998-12-01T00:00:00.000Z | 1 χρόνο         | 1 χρόνο πριν         | 9504 ώρες                      |
| 1998-06-01T00:00:00.000Z | 2 χρόνια        | 2 χρόνια πριν        | 13896 ώρες                     |
| 1998-01-01T00:00:00.000Z | 2 χρόνια        | 2 χρόνια πριν        | 17520 ώρες                     |
| 1997-01-01T00:00:00.000Z | 3 χρόνια        | 3 χρόνια πριν        | 26280 ώρες                     |
| 1996-01-01T00:00:00.000Z | 4 χρόνια        | 4 χρόνια πριν        | 35064 ώρες                     |
| 1995-01-01T00:00:00.000Z | 5 χρόνια        | 5 χρόνια πριν        | 43824 ώρες                     |
| 1994-01-01T00:00:00.000Z | 6 χρόνια        | 6 χρόνια πριν        | 52584 ώρες                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                                  |
| ------------------------ | --------------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/1/00                                 |
| 2000-01-05T00:00:00.000Z | Τετάρτη στις 12:00 π.μ.                 |
| 2000-01-02T00:00:00.000Z | αύριο στις 12:00 π.μ.                   |
| 2000-01-01T00:00:00.000Z | σήμερα στις 12:00 π.μ.                  |
| 1999-12-31T00:00:00.000Z | χθες στις 12:00 π.μ.                    |
| 1999-12-27T00:00:00.000Z | την προηγούμενη Δευτέρα στις 12:00 π.μ. |
| 1999-12-21T00:00:00.000Z | 21/12/99                                |

## `formatDuration`

| Duration      | Result         |
| ------------- | -------------- |
| {"years":0}   | 0 χρόνια       |
| {"years":1}   | 1 χρόνο        |
| {"years":2}   | 2 χρόνια       |
| {"months":0}  | 0 μήνες        |
| {"months":1}  | 1 μήνας        |
| {"months":2}  | 2 μήνες        |
| {"weeks":0}   | 0 εβδομάδες    |
| {"weeks":1}   | 1 εβδομάδα     |
| {"weeks":2}   | 2 εβδομάδες    |
| {"days":0}    | 0 ημέρες       |
| {"days":1}    | 1 ημέρα        |
| {"days":2}    | 2 ημέρες       |
| {"hours":0}   | 0 ώρες         |
| {"hours":1}   | 1 ώρα          |
| {"hours":2}   | 2 ώρες         |
| {"minutes":0} | 0 λεπτά        |
| {"minutes":1} | 1 λεπτό        |
| {"minutes":2} | 2 λεπτά        |
| {"seconds":0} | 0 δευτερόλεπτα |
| {"seconds":1} | 1 δευτερόλεπτο |
| {"seconds":2} | 2 δευτερόλεπτα |
