# West Frisian (fy) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987e                                             | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5e                                                | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987e                                             | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4e                                                | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1e                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1e fearnsjier                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e fearnsjier                                     | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1e                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1e fearnsjier                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2e fearnsjier                                     | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1e                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2e                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3e                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4e                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5e                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6e                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7e                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8e                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9e                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10e                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11e                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12e                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | jan.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mrt.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jun.                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | jannewaris                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febrewaris                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | maart                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maaie                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juny                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | july                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augustus                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septimber                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novimber                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desimber                                          | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | f                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | m                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | a                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | m                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | a                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | s                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | o                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | n                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | d                                                 | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1e                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2e                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3e                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4e                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5e                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6e                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7e                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8e                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9e                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10e                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11e                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12e                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | jan.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mrt.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jun.                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                              | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | jannewaris                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febrewaris                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | maart                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maaie                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juny                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | july                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augustus                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septimber                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novimber                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desimber                                          | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | f                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | m                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | a                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | m                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | a                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | s                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | o                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | n                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | d                                                 | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1e                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48e                                               | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1e                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48e                                               | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1e                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11e                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28e                                               | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1e febrewaris                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11e febrewaris                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28e febrewaris                                    | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42e                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365e                                              | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | moandei                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | freed                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | m                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | f                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | mo                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1e                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                                | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | moandei                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | freed                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | m                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | f                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | mo                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1e                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                                | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | moandei                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | freed                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | m                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | f                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | mo                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1e                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5e                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | moa                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | moandei                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | freed                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | m                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | f                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | mo                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | moarns                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | middeis                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | jûns                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nachts                                            | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | moarns                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | middeis                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | jûns                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nachts                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | moarns                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | middeis                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | jûns                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nachts                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | moarns                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | middeis                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | jûns                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nachts                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | moarns                                            | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | middeis                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | jûns                                              | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nachts                                            | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11e                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11e                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11e                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23e                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11e                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11e                                               | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11e                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23e                                               | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1e                                                | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55e                                               | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1e                                                | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55e                                               | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11-01-1987                                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-02-1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-03-1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-04-1987                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-1453                                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-06-1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-07-1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-08-1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-09-1987                                        | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-10-1987                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-11-1987                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-12-1987                                        | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 jan. 1987                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb. 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mrt. 1987                                      | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr. 1987                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai. 1453                                      | 1453-03-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jun. 1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jul. 1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 aug. 1987                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sep. 1987                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987                                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 des. 1987                                      | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 jannewaris 1987                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febrewaris 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 maart 1987                                     | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 april 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maaie 1453                                     | 1453-03-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juny 1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 july 1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 augustus 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 septimber 1987                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktober 1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novimber 1987                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 desimber 1987                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | snein 11 jannewaris 1987                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | woansdei 11 febrewaris 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | woansdei 11 maart 1987                            | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | sneon 11 april 1987                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | snein 29 maaie 1453                               | 1453-03-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | tongersdei 11 juny 1987                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | sneon 11 july 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | tiisdei 11 augustus 1987                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | freed 11 septimber 1987                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | snein 11 oktober 1987                             | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | woansdei 11 novimber 1987                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | freed 11 desimber 1987                            | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                             | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                          | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11-01-1987, 12:13                                 | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-02-1987, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-03-1987, 12:13                                 | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-04-1987, 12:13                                 | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-1453, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-06-1987, 12:13                                 | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-07-1987, 12:13                                 | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-08-1987, 12:13                                 | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-09-1987, 12:13                                 | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-10-1987, 12:13                                 | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-11-1987, 12:13                                 | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-12-1987, 12:13                                 | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 jan. 1987, 12:13:14                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb. 1987, 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mrt. 1987, 12:13:14                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr. 1987, 12:13:14                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai. 1453, 23:59:59                            | 1453-03-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jun. 1987, 12:13:14                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jul. 1987, 12:13:14                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 aug. 1987, 12:13:14                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sep. 1987, 12:13:14                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987, 12:13:14                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987, 12:13:14                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 des. 1987, 12:13:14                            | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 jannewaris 1987 om 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febrewaris 1987 om 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 maart 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 april 1987 om 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maaie 1453 om 23:59:59 GMT+0                   | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juny 1987 om 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 july 1987 om 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 augustus 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 septimber 1987 om 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktober 1987 om 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novimber 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 desimber 1987 om 12:13:14 GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | snein 11 jannewaris 1987 om 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | woansdei 11 febrewaris 1987 om 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | woansdei 11 maart 1987 om 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | sneon 11 april 1987 om 12:13:14 GMT+00:00         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | snein 29 maaie 1453 om 23:59:59 GMT+00:00         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | tongersdei 11 juny 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | sneon 11 july 1987 om 12:13:14 GMT+00:00          | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | tiisdei 11 augustus 1987 om 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | freed 11 septimber 1987 om 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | snein 11 oktober 1987 om 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | woansdei 11 novimber 1987 om 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | freed 11 desimber 1987 om 12:13:14 GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ----------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | sawat 6 jier      | sawat 6 jier           | oer sawat 6 jier      |
| 2005-01-01T00:00:00.000Z | sawat 5 jier      | sawat 5 jier           | oer sawat 5 jier      |
| 2004-01-01T00:00:00.000Z | sawat 4 jier      | sawat 4 jier           | oer sawat 4 jier      |
| 2003-01-01T00:00:00.000Z | sawat 3 jier      | sawat 3 jier           | oer sawat 3 jier      |
| 2002-01-01T00:00:00.000Z | sawat 2 jier      | sawat 2 jier           | oer sawat 2 jier      |
| 2001-06-01T00:00:00.000Z | mear as 1 jier    | mear as 1 jier         | oer mear as 1 jier    |
| 2001-02-01T00:00:00.000Z | sawat 1 jier      | sawat 1 jier           | oer sawat 1 jier      |
| 2001-01-01T00:00:00.000Z | sawat 1 jier      | sawat 1 jier           | oer sawat 1 jier      |
| 2000-06-01T00:00:00.000Z | 5 moannen         | 5 moannen              | oer 5 moannen         |
| 2000-03-01T00:00:00.000Z | 2 moannen         | 2 moannen              | oer 2 moannen         |
| 2000-02-01T00:00:00.000Z | sawat 1 moanne    | sawat 1 moanne         | oer sawat 1 moanne    |
| 2000-01-15T00:00:00.000Z | 14 dagen          | 14 dagen               | oer 14 dagen          |
| 2000-01-02T00:00:00.000Z | 1 dei             | 1 dei                  | oer 1 dei             |
| 2000-01-01T06:00:00.000Z | sawat 6 oere      | sawat 6 oere           | oer sawat 6 oere      |
| 2000-01-01T01:00:00.000Z | sawat 1 oere      | sawat 1 oere           | oer sawat 1 oere      |
| 2000-01-01T00:45:00.000Z | sawat 1 oere      | sawat 1 oere           | oer sawat 1 oere      |
| 2000-01-01T00:30:00.000Z | 30 minuten        | 30 minuten             | oer 30 minuten        |
| 2000-01-01T00:15:00.000Z | 15 minuten        | 15 minuten             | oer 15 minuten        |
| 2000-01-01T00:01:00.000Z | 1 minút           | 1 minút                | oer 1 minút           |
| 2000-01-01T00:00:25.000Z | minder as 1 minút | oardel minút           | oer minder as 1 minút |
| 2000-01-01T00:00:15.000Z | minder as 1 minút | minder as 20 sekonden  | oer minder as 1 minút |
| 2000-01-01T00:00:05.000Z | minder as 1 minút | minder as 10 sekonden  | oer minder as 1 minút |
| 2000-01-01T00:00:00.000Z | minder as 1 minút | minder as 5 sekonden   | minder as 1 minút lyn |
| 1999-12-31T23:59:55.000Z | minder as 1 minút | minder as 10 sekonden  | minder as 1 minút lyn |
| 1999-12-31T23:59:45.000Z | minder as 1 minút | minder as 20 sekonden  | minder as 1 minút lyn |
| 1999-12-31T23:59:35.000Z | minder as 1 minút | oardel minút           | minder as 1 minút lyn |
| 1999-12-31T23:59:00.000Z | 1 minút           | 1 minút                | 1 minút lyn           |
| 1999-12-31T23:45:00.000Z | 15 minuten        | 15 minuten             | 15 minuten lyn        |
| 1999-12-31T23:30:00.000Z | 30 minuten        | 30 minuten             | 30 minuten lyn        |
| 1999-12-31T23:15:00.000Z | sawat 1 oere      | sawat 1 oere           | sawat 1 oere lyn      |
| 1999-12-31T23:00:00.000Z | sawat 1 oere      | sawat 1 oere           | sawat 1 oere lyn      |
| 1999-12-31T18:00:00.000Z | sawat 6 oere      | sawat 6 oere           | sawat 6 oere lyn      |
| 1999-12-30T00:00:00.000Z | 2 dagen           | 2 dagen                | 2 dagen lyn           |
| 1999-12-15T00:00:00.000Z | 17 dagen          | 17 dagen               | 17 dagen lyn          |
| 1999-12-01T00:00:00.000Z | sawat 1 moanne    | sawat 1 moanne         | sawat 1 moanne lyn    |
| 1999-11-01T00:00:00.000Z | 2 moannen         | 2 moannen              | 2 moannen lyn         |
| 1999-06-01T00:00:00.000Z | 7 moannen         | 7 moannen              | 7 moannen lyn         |
| 1999-01-01T00:00:00.000Z | sawat 1 jier      | sawat 1 jier           | sawat 1 jier lyn      |
| 1998-12-01T00:00:00.000Z | sawat 1 jier      | sawat 1 jier           | sawat 1 jier lyn      |
| 1998-06-01T00:00:00.000Z | mear as 1 jier    | mear as 1 jier         | mear as 1 jier lyn    |
| 1998-01-01T00:00:00.000Z | sawat 2 jier      | sawat 2 jier           | sawat 2 jier lyn      |
| 1997-01-01T00:00:00.000Z | sawat 3 jier      | sawat 3 jier           | sawat 3 jier lyn      |
| 1996-01-01T00:00:00.000Z | sawat 4 jier      | sawat 4 jier           | sawat 4 jier lyn      |
| 1995-01-01T00:00:00.000Z | sawat 5 jier      | sawat 5 jier           | sawat 5 jier lyn      |
| 1994-01-01T00:00:00.000Z | sawat 6 jier      | sawat 6 jier           | sawat 6 jier lyn      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 jier      | oer 6 jier        | 52608 oere                     |
| 2005-01-01T00:00:00.000Z | 5 jier      | oer 5 jier        | 43848 oere                     |
| 2004-01-01T00:00:00.000Z | 4 jier      | oer 4 jier        | 35064 oere                     |
| 2003-01-01T00:00:00.000Z | 3 jier      | oer 3 jier        | 26304 oere                     |
| 2002-01-01T00:00:00.000Z | 2 jier      | oer 2 jier        | 17544 oere                     |
| 2001-06-01T00:00:00.000Z | 1 jier      | oer 1 jier        | 12408 oere                     |
| 2001-02-01T00:00:00.000Z | 1 jier      | oer 1 jier        | 9528 oere                      |
| 2001-01-01T00:00:00.000Z | 1 jier      | oer 1 jier        | 8784 oere                      |
| 2000-06-01T00:00:00.000Z | 5 moannen   | oer 5 moannen     | 3648 oere                      |
| 2000-03-01T00:00:00.000Z | 2 moannen   | oer 2 moannen     | 1440 oere                      |
| 2000-02-01T00:00:00.000Z | 1 moanne    | oer 1 moanne      | 744 oere                       |
| 2000-01-15T00:00:00.000Z | 14 dagen    | oer 14 dagen      | 336 oere                       |
| 2000-01-02T00:00:00.000Z | 1 dei       | oer 1 dei         | 24 oere                        |
| 2000-01-01T06:00:00.000Z | 6 oere      | oer 6 oere        | 6 oere                         |
| 2000-01-01T01:00:00.000Z | 1 oere      | oer 1 oere        | 1 oere                         |
| 2000-01-01T00:45:00.000Z | 45 minuten  | oer 45 minuten    | 1 oere                         |
| 2000-01-01T00:30:00.000Z | 30 minuten  | oer 30 minuten    | 1 oere                         |
| 2000-01-01T00:15:00.000Z | 15 minuten  | oer 15 minuten    | 0 oere                         |
| 2000-01-01T00:01:00.000Z | 1 minút     | oer 1 minút       | 0 oere                         |
| 2000-01-01T00:00:25.000Z | 25 sekonden | oer 25 sekonden   | 0 oere                         |
| 2000-01-01T00:00:15.000Z | 15 sekonden | oer 15 sekonden   | 0 oere                         |
| 2000-01-01T00:00:05.000Z | 5 sekonden  | oer 5 sekonden    | 0 oere                         |
| 2000-01-01T00:00:00.000Z | 0 sekonden  | 0 sekonden lyn    | 0 oere                         |
| 1999-12-31T23:59:55.000Z | 5 sekonden  | 5 sekonden lyn    | 0 oere                         |
| 1999-12-31T23:59:45.000Z | 15 sekonden | 15 sekonden lyn   | 0 oere                         |
| 1999-12-31T23:59:35.000Z | 25 sekonden | 25 sekonden lyn   | 0 oere                         |
| 1999-12-31T23:59:00.000Z | 1 minút     | 1 minút lyn       | 0 oere                         |
| 1999-12-31T23:45:00.000Z | 15 minuten  | 15 minuten lyn    | 0 oere                         |
| 1999-12-31T23:30:00.000Z | 30 minuten  | 30 minuten lyn    | 1 oere                         |
| 1999-12-31T23:15:00.000Z | 45 minuten  | 45 minuten lyn    | 1 oere                         |
| 1999-12-31T23:00:00.000Z | 1 oere      | 1 oere lyn        | 1 oere                         |
| 1999-12-31T18:00:00.000Z | 6 oere      | 6 oere lyn        | 6 oere                         |
| 1999-12-30T00:00:00.000Z | 2 dagen     | 2 dagen lyn       | 48 oere                        |
| 1999-12-15T00:00:00.000Z | 17 dagen    | 17 dagen lyn      | 408 oere                       |
| 1999-12-01T00:00:00.000Z | 1 moanne    | 1 moanne lyn      | 744 oere                       |
| 1999-11-01T00:00:00.000Z | 2 moannen   | 2 moannen lyn     | 1464 oere                      |
| 1999-06-01T00:00:00.000Z | 7 moannen   | 7 moannen lyn     | 5136 oere                      |
| 1999-01-01T00:00:00.000Z | 1 jier      | 1 jier lyn        | 8760 oere                      |
| 1998-12-01T00:00:00.000Z | 1 jier      | 1 jier lyn        | 9504 oere                      |
| 1998-06-01T00:00:00.000Z | 2 jier      | 2 jier lyn        | 13896 oere                     |
| 1998-01-01T00:00:00.000Z | 2 jier      | 2 jier lyn        | 17520 oere                     |
| 1997-01-01T00:00:00.000Z | 3 jier      | 3 jier lyn        | 26280 oere                     |
| 1996-01-01T00:00:00.000Z | 4 jier      | 4 jier lyn        | 35064 oere                     |
| 1995-01-01T00:00:00.000Z | 5 jier      | 5 jier lyn        | 43824 oere                     |
| 1994-01-01T00:00:00.000Z | 6 jier      | 6 jier lyn        | 52584 oere                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  |
| ------------------------ | ----------------------- |
| 2000-01-10T00:00:00.000Z | 10-01-2000              |
| 2000-01-05T00:00:00.000Z | woansdei om 00:00       |
| 2000-01-02T00:00:00.000Z | moarn om 00:00          |
| 2000-01-01T00:00:00.000Z | hjoed om 00:00          |
| 1999-12-31T00:00:00.000Z | juster om 00:00         |
| 1999-12-27T00:00:00.000Z | ôfrûne moandei om 00:00 |
| 1999-12-21T00:00:00.000Z | 21-12-1999              |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 jier     |
| {"years":1}   | 1 jier     |
| {"years":2}   | 2 jier     |
| {"months":0}  | 0 moannen  |
| {"months":1}  | 1 moanne   |
| {"months":2}  | 2 moannen  |
| {"weeks":0}   | 0 wiken    |
| {"weeks":1}   | 1 wike     |
| {"weeks":2}   | 2 wiken    |
| {"days":0}    | 0 dagen    |
| {"days":1}    | 1 dei      |
| {"days":2}    | 2 dagen    |
| {"hours":0}   | 0 oere     |
| {"hours":1}   | 1 oere     |
| {"hours":2}   | 2 oere     |
| {"minutes":0} | 0 minuten  |
| {"minutes":1} | 1 minút    |
| {"minutes":2} | 2 minuten  |
| {"seconds":0} | 0 sekonden |
| {"seconds":1} | 1 sekonde  |
| {"seconds":2} | 2 sekonden |
