# Haitian Creole (ht) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987yèm                                            | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5yèm                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987yèm                                            | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4yèm                                               | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1ye                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1ye trim.                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm trim.                                         | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1ye trimès                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm trimès                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | T1                                                 | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                 | Invalid Date             |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1ye                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1ye trim.                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm trim.                                         | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1ye trimès                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2yèm trimès                                        | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1ye                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2yèm                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3yèm                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4yèm                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5yèm                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6yèm                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7yèm                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8yèm                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9yèm                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10yèm                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11yèm                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12yèm                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | janv.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | fevr.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mas                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | avr.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | me                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jen                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jiyè                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | out                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sept.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | janvye                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | fevrye                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mas                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | avril                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | me                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jen                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jiyè                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | out                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septanm                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktòb                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novanm                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desanm                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | O                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                  | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1ye                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2yèm                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3yèm                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4yèm                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5yèm                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6yèm                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7yèm                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8yèm                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9yèm                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10yèm                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11yèm                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12yèm                                              | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | janv.                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | fevr.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mas                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | avr.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | me                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jen                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jiyè                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | out                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sept.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | janvye                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | fevrye                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mas                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | avril                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | me                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jen                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jiyè                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | out                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septanm                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktòb                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novanm                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desanm                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | O                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                  | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1ye                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48yèm                                              | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1ye                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48yèm                                              | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1ye                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11yèm                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28yèm                                              | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1ye fevrye                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11yèm fevrye                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28yèm fevrye                                       | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42yèm                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365yèm                                             | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | lendi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vandredi                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | L                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | le                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | va                                                 | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1ye                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5yèm                                               | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | lendi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vandredi                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | L                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | le                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | va                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1ye                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5yèm                                               | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | lendi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vandredi                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | L                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | le                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | va                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1ye                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5yèm                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | len.                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | van.                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | lendi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vandredi                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | L                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | le                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | va                                                 | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | maten                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | aprèmidi                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | swa                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | maten                                              | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | maten                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | aprèmidi                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | swa                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | maten                                              | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | maten                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | aprèmidi                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | swa                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | maten                                              | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | nan maten                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | nan aprèmidi                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | nan aswè                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nan maten                                          | 2019-02-11T04:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | mat.                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ap.m.                                              | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | swa                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | mat.                                               | 2019-02-11T04:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11yèm                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11yèm                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11yèm                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23yèm                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11yèm                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11yèm                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11yèm                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23yèm                                              | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1ye                                                | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55yèm                                              | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1ye                                                | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55yèm                                              | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                         | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 janv. 1987                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 fevr. 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mas 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 avr. 1987                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 me 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jen 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jiyè 1987                                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 out 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sept. 1987                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987                                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987                                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 des. 1987                                       | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 janvye 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 fevrye 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mas 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 avril 1987                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 me 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jen 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jiyè 1987                                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 out 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 septanm 1987                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktòb 1987                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novanm 1987                                     | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 desanm 1987                                     | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | dimanch 11 janvye 1987                             | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | mèkredi 11 fevrye 1987                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | mèkredi 11 mas 1987                                | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | samdi 11 avril 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanch 29 me 1453                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | jedi 11 jen 1987                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | samdi 11 jiyè 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | madi 11 out 1987                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | vandredi 11 septanm 1987                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | dimanch 11 oktòb 1987                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | mèkredi 11 novanm 1987                             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | vandredi 11 desanm 1987                            | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                              | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                              | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                              | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                              | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                              | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                              | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                              | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                              | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                              | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                              | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                              | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                           | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                           | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                           | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                           | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13                                  | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13                                  | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13                                  | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                  | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13                                  | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13                                  | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13                                  | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13                                  | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13                                  | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13                                  | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13                                  | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 janv. 1987, 12:13:14                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 fevr. 1987, 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mas 1987, 12:13:14                              | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 avr. 1987, 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 me 1453, 23:59:59                               | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jen 1987, 12:13:14                              | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jiyè 1987, 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 out 1987, 12:13:14                              | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sept. 1987, 12:13:14                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987, 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987, 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 des. 1987, 12:13:14                             | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 janvye 1987 nan lè 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 fevrye 1987 nan lè 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mas 1987 nan lè 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 avril 1987 nan lè 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 me 1453 nan lè 23:59:59 GMT+0                   | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 jen 1987 nan lè 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jiyè 1987 nan lè 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 out 1987 nan lè 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 septanm 1987 nan lè 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktòb 1987 nan lè 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novanm 1987 nan lè 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 desanm 1987 nan lè 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | dimanch 11 janvye 1987 nan lè 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | mèkredi 11 fevrye 1987 nan lè 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | mèkredi 11 mas 1987 nan lè 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | samdi 11 avril 1987 nan lè 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanch 29 me 1453 nan lè 23:59:59 GMT+00:00       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | jedi 11 jen 1987 nan lè 12:13:14 GMT+00:00         | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | samdi 11 jiyè 1987 nan lè 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | madi 11 out 1987 nan lè 12:13:14 GMT+00:00         | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | vandredi 11 septanm 1987 nan lè 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | dimanch 11 oktòb 1987 nan lè 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | mèkredi 11 novanm 1987 nan lè 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | vandredi 11 desanm 1987 nan lè 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result               | `includeSeconds: true` | `addSuffix: true`          |
| ------------------------ | -------------------- | ---------------------- | -------------------------- |
| 2006-01-01T00:00:00.000Z | anviwon 6 an         | anviwon 6 an           | nan anviwon 6 an           |
| 2005-01-01T00:00:00.000Z | anviwon 5 an         | anviwon 5 an           | nan anviwon 5 an           |
| 2004-01-01T00:00:00.000Z | anviwon 4 an         | anviwon 4 an           | nan anviwon 4 an           |
| 2003-01-01T00:00:00.000Z | anviwon 3 an         | anviwon 3 an           | nan anviwon 3 an           |
| 2002-01-01T00:00:00.000Z | anviwon 2 an         | anviwon 2 an           | nan anviwon 2 an           |
| 2001-06-01T00:00:00.000Z | plis pase 1 an       | plis pase 1 an         | nan plis pase 1 an         |
| 2001-02-01T00:00:00.000Z | anviwon 1 an         | anviwon 1 an           | nan anviwon 1 an           |
| 2001-01-01T00:00:00.000Z | anviwon 1 an         | anviwon 1 an           | nan anviwon 1 an           |
| 2000-06-01T00:00:00.000Z | 5 mwa                | 5 mwa                  | nan 5 mwa                  |
| 2000-03-01T00:00:00.000Z | 2 mwa                | 2 mwa                  | nan 2 mwa                  |
| 2000-02-01T00:00:00.000Z | anviwon 1 mwa        | anviwon 1 mwa          | nan anviwon 1 mwa          |
| 2000-01-15T00:00:00.000Z | 14 jou               | 14 jou                 | nan 14 jou                 |
| 2000-01-02T00:00:00.000Z | 1 jou                | 1 jou                  | nan 1 jou                  |
| 2000-01-01T06:00:00.000Z | anviwon 6 è          | anviwon 6 è            | nan anviwon 6 è            |
| 2000-01-01T01:00:00.000Z | anviwon inè          | anviwon inè            | nan anviwon inè            |
| 2000-01-01T00:45:00.000Z | anviwon inè          | anviwon inè            | nan anviwon inè            |
| 2000-01-01T00:30:00.000Z | 30 minit             | 30 minit               | nan 30 minit               |
| 2000-01-01T00:15:00.000Z | 15 minit             | 15 minit               | nan 15 minit               |
| 2000-01-01T00:01:00.000Z | 1 minit              | 1 minit                | nan 1 minit                |
| 2000-01-01T00:00:25.000Z | mwens pase yon minit | 30 segond              | nan mwens pase yon minit   |
| 2000-01-01T00:00:15.000Z | mwens pase yon minit | mwens pase 20 segond   | nan mwens pase yon minit   |
| 2000-01-01T00:00:05.000Z | mwens pase yon minit | mwens pase 10 segond   | nan mwens pase yon minit   |
| 2000-01-01T00:00:00.000Z | mwens pase yon minit | mwens pase 5 segond    | sa fè mwens pase yon minit |
| 1999-12-31T23:59:55.000Z | mwens pase yon minit | mwens pase 10 segond   | sa fè mwens pase yon minit |
| 1999-12-31T23:59:45.000Z | mwens pase yon minit | mwens pase 20 segond   | sa fè mwens pase yon minit |
| 1999-12-31T23:59:35.000Z | mwens pase yon minit | 30 segond              | sa fè mwens pase yon minit |
| 1999-12-31T23:59:00.000Z | 1 minit              | 1 minit                | sa fè 1 minit              |
| 1999-12-31T23:45:00.000Z | 15 minit             | 15 minit               | sa fè 15 minit             |
| 1999-12-31T23:30:00.000Z | 30 minit             | 30 minit               | sa fè 30 minit             |
| 1999-12-31T23:15:00.000Z | anviwon inè          | anviwon inè            | sa fè anviwon inè          |
| 1999-12-31T23:00:00.000Z | anviwon inè          | anviwon inè            | sa fè anviwon inè          |
| 1999-12-31T18:00:00.000Z | anviwon 6 è          | anviwon 6 è            | sa fè anviwon 6 è          |
| 1999-12-30T00:00:00.000Z | 2 jou                | 2 jou                  | sa fè 2 jou                |
| 1999-12-15T00:00:00.000Z | 17 jou               | 17 jou                 | sa fè 17 jou               |
| 1999-12-01T00:00:00.000Z | anviwon 1 mwa        | anviwon 1 mwa          | sa fè anviwon 1 mwa        |
| 1999-11-01T00:00:00.000Z | 2 mwa                | 2 mwa                  | sa fè 2 mwa                |
| 1999-06-01T00:00:00.000Z | 7 mwa                | 7 mwa                  | sa fè 7 mwa                |
| 1999-01-01T00:00:00.000Z | anviwon 1 an         | anviwon 1 an           | sa fè anviwon 1 an         |
| 1998-12-01T00:00:00.000Z | anviwon 1 an         | anviwon 1 an           | sa fè anviwon 1 an         |
| 1998-06-01T00:00:00.000Z | plis pase 1 an       | plis pase 1 an         | sa fè plis pase 1 an       |
| 1998-01-01T00:00:00.000Z | anviwon 2 an         | anviwon 2 an           | sa fè anviwon 2 an         |
| 1997-01-01T00:00:00.000Z | anviwon 3 an         | anviwon 3 an           | sa fè anviwon 3 an         |
| 1996-01-01T00:00:00.000Z | anviwon 4 an         | anviwon 4 an           | sa fè anviwon 4 an         |
| 1995-01-01T00:00:00.000Z | anviwon 5 an         | anviwon 5 an           | sa fè anviwon 5 an         |
| 1994-01-01T00:00:00.000Z | anviwon 6 an         | anviwon 6 an           | sa fè anviwon 6 an         |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 an      | nan 6 an          | 52608 lè                       |
| 2005-01-01T00:00:00.000Z | 5 an      | nan 5 an          | 43848 lè                       |
| 2004-01-01T00:00:00.000Z | 4 an      | nan 4 an          | 35064 lè                       |
| 2003-01-01T00:00:00.000Z | 3 an      | nan 3 an          | 26304 lè                       |
| 2002-01-01T00:00:00.000Z | 2 an      | nan 2 an          | 17544 lè                       |
| 2001-06-01T00:00:00.000Z | 1 an      | nan 1 an          | 12408 lè                       |
| 2001-02-01T00:00:00.000Z | 1 an      | nan 1 an          | 9528 lè                        |
| 2001-01-01T00:00:00.000Z | 1 an      | nan 1 an          | 8784 lè                        |
| 2000-06-01T00:00:00.000Z | 5 mwa     | nan 5 mwa         | 3648 lè                        |
| 2000-03-01T00:00:00.000Z | 2 mwa     | nan 2 mwa         | 1440 lè                        |
| 2000-02-01T00:00:00.000Z | 1 mwa     | nan 1 mwa         | 744 lè                         |
| 2000-01-15T00:00:00.000Z | 14 jou    | nan 14 jou        | 336 lè                         |
| 2000-01-02T00:00:00.000Z | 1 jou     | nan 1 jou         | 24 lè                          |
| 2000-01-01T06:00:00.000Z | 6 lè      | nan 6 lè          | 6 lè                           |
| 2000-01-01T01:00:00.000Z | 1 lè      | nan 1 lè          | 1 lè                           |
| 2000-01-01T00:45:00.000Z | 45 minit  | nan 45 minit      | 1 lè                           |
| 2000-01-01T00:30:00.000Z | 30 minit  | nan 30 minit      | 1 lè                           |
| 2000-01-01T00:15:00.000Z | 15 minit  | nan 15 minit      | 0 lè                           |
| 2000-01-01T00:01:00.000Z | 1 minit   | nan 1 minit       | 0 lè                           |
| 2000-01-01T00:00:25.000Z | 25 segond | nan 25 segond     | 0 lè                           |
| 2000-01-01T00:00:15.000Z | 15 segond | nan 15 segond     | 0 lè                           |
| 2000-01-01T00:00:05.000Z | 5 segond  | nan 5 segond      | 0 lè                           |
| 2000-01-01T00:00:00.000Z | 0 segond  | sa fè 0 segond    | 0 lè                           |
| 1999-12-31T23:59:55.000Z | 5 segond  | sa fè 5 segond    | 0 lè                           |
| 1999-12-31T23:59:45.000Z | 15 segond | sa fè 15 segond   | 0 lè                           |
| 1999-12-31T23:59:35.000Z | 25 segond | sa fè 25 segond   | 0 lè                           |
| 1999-12-31T23:59:00.000Z | 1 minit   | sa fè 1 minit     | 0 lè                           |
| 1999-12-31T23:45:00.000Z | 15 minit  | sa fè 15 minit    | 0 lè                           |
| 1999-12-31T23:30:00.000Z | 30 minit  | sa fè 30 minit    | 1 lè                           |
| 1999-12-31T23:15:00.000Z | 45 minit  | sa fè 45 minit    | 1 lè                           |
| 1999-12-31T23:00:00.000Z | 1 lè      | sa fè 1 lè        | 1 lè                           |
| 1999-12-31T18:00:00.000Z | 6 lè      | sa fè 6 lè        | 6 lè                           |
| 1999-12-30T00:00:00.000Z | 2 jou     | sa fè 2 jou       | 48 lè                          |
| 1999-12-15T00:00:00.000Z | 17 jou    | sa fè 17 jou      | 408 lè                         |
| 1999-12-01T00:00:00.000Z | 1 mwa     | sa fè 1 mwa       | 744 lè                         |
| 1999-11-01T00:00:00.000Z | 2 mwa     | sa fè 2 mwa       | 1464 lè                        |
| 1999-06-01T00:00:00.000Z | 7 mwa     | sa fè 7 mwa       | 5136 lè                        |
| 1999-01-01T00:00:00.000Z | 1 an      | sa fè 1 an        | 8760 lè                        |
| 1998-12-01T00:00:00.000Z | 1 an      | sa fè 1 an        | 9504 lè                        |
| 1998-06-01T00:00:00.000Z | 2 an      | sa fè 2 an        | 13896 lè                       |
| 1998-01-01T00:00:00.000Z | 2 an      | sa fè 2 an        | 17520 lè                       |
| 1997-01-01T00:00:00.000Z | 3 an      | sa fè 3 an        | 26280 lè                       |
| 1996-01-01T00:00:00.000Z | 4 an      | sa fè 4 an        | 35064 lè                       |
| 1995-01-01T00:00:00.000Z | 5 an      | sa fè 5 an        | 43824 lè                       |
| 1994-01-01T00:00:00.000Z | 6 an      | sa fè 6 an        | 52584 lè                       |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                   |
| 2000-01-05T00:00:00.000Z | mèkredi pwochen nan lè 00:00 |
| 2000-01-02T00:00:00.000Z | demen nan lè 00:00           |
| 2000-01-01T00:00:00.000Z | jodi a 00:00                 |
| 1999-12-31T00:00:00.000Z | yè nan lè 00:00              |
| 1999-12-27T00:00:00.000Z | lendi pase nan lè 00:00      |
| 1999-12-21T00:00:00.000Z | 21/12/1999                   |

## `formatDuration`

| Duration      | Result   |
| ------------- | -------- |
| {"years":0}   | 0 an     |
| {"years":1}   | 1 an     |
| {"years":2}   | 2 an     |
| {"months":0}  | 0 mwa    |
| {"months":1}  | 1 mwa    |
| {"months":2}  | 2 mwa    |
| {"weeks":0}   | 0 semèn  |
| {"weeks":1}   | 1 semèn  |
| {"weeks":2}   | 2 semèn  |
| {"days":0}    | 0 jou    |
| {"days":1}    | 1 jou    |
| {"days":2}    | 2 jou    |
| {"hours":0}   | 0 lè     |
| {"hours":1}   | 1 lè     |
| {"hours":2}   | 2 lè     |
| {"minutes":0} | 0 minit  |
| {"minutes":1} | 1 minit  |
| {"minutes":2} | 2 minit  |
| {"seconds":0} | 0 segond |
| {"seconds":1} | 1 segond |
| {"seconds":2} | 2 segond |
