# Japanese (Hiragana) (ja-Hira) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                             | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ねん                                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ねん                                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ねん                                                    | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ねん                                                       | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | だい1しはんき                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | だい2しはんき                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | だい1しはんき                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | だい2しはんき                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                           | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | だい1しはんき                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | だい2しはんき                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | だい1しはんき                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | だい2しはんき                                               | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | 1                                                           | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                          | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                          | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | 1がつ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2がつ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3がつ                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4がつ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5がつ                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6がつ                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7がつ                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8がつ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9がつ                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10がつ                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11がつ                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12がつ                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | 1                                                           | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                          | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                          | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | だい1しゅう                                                 | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | だい49しゅう                                                | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | だい1しゅう                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | だい48しゅう                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1にち                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11にち                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28にち                                                      | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1にち 2がつ                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11にち 2がつ                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28にち 2がつ                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                         | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | げつようび                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きんようび                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                           | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | げつようび                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きんようび                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                           | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | げつようび                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きんようび                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | げつようび                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きんようび                                                  | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | げつ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | きん                                                        | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ごぜん                                                      | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | あさ                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | よる                                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | しんや                                                      | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | あさ                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | よる                                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | しんや                                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | あさ                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | よる                                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | しんや                                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | あさ                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | よる                                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | しんや                                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | あさ                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ごご                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | よる                                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | しんや                                                      | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11じ                                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11じ                                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11じ                                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23じ                                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11じ                                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11じ                                                        | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11じ                                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23じ                                                        | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1ふん                                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ふん                                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1びょう                                                     | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55びょう                                                    | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987/01/11                                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11                                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11                                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11                                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11                                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11                                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11                                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11                                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11                                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11                                                  | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 1987/01/11                                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11                                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11                                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11                                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11                                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11                                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11                                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11                                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11                                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11                                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987ねん1がつ11にち                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987ねん2がつ11にち                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987ねん3がつ11にち                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987ねん4がつ11にち                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453ねん5がつ29にち                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987ねん6がつ11にち                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987ねん7がつ11にち                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987ねん8がつ11にち                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987ねん9がつ11にち                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987ねん10がつ11にち                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987ねん11がつ11にち                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987ねん12がつ11にち                                        | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | 1987ねん1がつ11にちにちようび                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987ねん2がつ11にちすいようび                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987ねん3がつ11にちすいようび                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987ねん4がつ11にちどようび                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453ねん5がつ29にちにちようび                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987ねん6がつ11にちもくようび                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987ねん7がつ11にちどようび                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987ねん8がつ11にちかようび                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987ねん9がつ11にちきんようび                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987ねん10がつ11にちにちようび                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987ねん11がつ11にちすいようび                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987ねん12がつ11にちきんようび                              | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                       | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                       | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                       | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                       | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                       | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                       | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                       | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                       | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                       | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                       | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                       | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                                    | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                                    | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                                    | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                                    | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                    | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                                    | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                                    | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                                    | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                                    | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                                    | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                                    | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                                    | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23じ59ふん59びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12じ13ふん14びょう GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987/01/11 12:13                                            | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13                                            | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11 12:13                                            | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11 12:13                                            | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59                                            | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11 12:13                                            | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11 12:13                                            | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11 12:13                                            | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11 12:13                                            | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11 12:13                                            | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11 12:13                                            | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11 12:13                                            | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 1987/01/11 12:13:14                                         | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13:14                                         | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11 12:13:14                                         | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11 12:13:14                                         | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59:59                                         | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11 12:13:14                                         | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11 12:13:14                                         | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11 12:13:14                                         | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11 12:13:14                                         | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11 12:13:14                                         | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11 12:13:14                                         | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11 12:13:14                                         | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987ねん1がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987ねん2がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987ねん3がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987ねん4がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453ねん5がつ29にち 23:59:59 GMT+0                          | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987ねん6がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987ねん7がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987ねん8がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987ねん9がつ11にち 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987ねん10がつ11にち 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987ねん11がつ11にち 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987ねん12がつ11にち 12:13:14 GMT+0                         | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | 1987ねん1がつ11にちにちようび 12じ13ふん14びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987ねん2がつ11にちすいようび 12じ13ふん14びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987ねん3がつ11にちすいようび 12じ13ふん14びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987ねん4がつ11にちどようび 12じ13ふん14びょう GMT+00:00    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453ねん5がつ29にちにちようび 23じ59ふん59びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987ねん6がつ11にちもくようび 12じ13ふん14びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987ねん7がつ11にちどようび 12じ13ふん14びょう GMT+00:00    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987ねん8がつ11にちかようび 12じ13ふん14びょう GMT+00:00    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987ねん9がつ11にちきんようび 12じ13ふん14びょう GMT+00:00  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987ねん10がつ11にちにちようび 12じ13ふん14びょう GMT+00:00 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987ねん11がつ11にちすいようび 12じ13ふん14びょう GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987ねん12がつ11にちきんようび 12じ13ふん14びょう GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `includeSeconds: true` | `addSuffix: true` |
| ------------------------ | ------------- | ---------------------- | ----------------- |
| 2006-01-01T00:00:00.000Z | やく6ねん     | やく6ねん              | やく6ねんあと     |
| 2005-01-01T00:00:00.000Z | やく5ねん     | やく5ねん              | やく5ねんあと     |
| 2004-01-01T00:00:00.000Z | やく4ねん     | やく4ねん              | やく4ねんあと     |
| 2003-01-01T00:00:00.000Z | やく3ねん     | やく3ねん              | やく3ねんあと     |
| 2002-01-01T00:00:00.000Z | やく2ねん     | やく2ねん              | やく2ねんあと     |
| 2001-06-01T00:00:00.000Z | 1ねんいじょう | 1ねんいじょう          | 1ねんいじょうあと |
| 2001-02-01T00:00:00.000Z | やく1ねん     | やく1ねん              | やく1ねんあと     |
| 2001-01-01T00:00:00.000Z | やく1ねん     | やく1ねん              | やく1ねんあと     |
| 2000-06-01T00:00:00.000Z | 5かげつ       | 5かげつ                | 5かげつあと       |
| 2000-03-01T00:00:00.000Z | 2かげつ       | 2かげつ                | 2かげつあと       |
| 2000-02-01T00:00:00.000Z | やく1かげつ   | やく1かげつ            | やく1かげつあと   |
| 2000-01-15T00:00:00.000Z | 14にち        | 14にち                 | 14にちあと        |
| 2000-01-02T00:00:00.000Z | 1にち         | 1にち                  | 1にちあと         |
| 2000-01-01T06:00:00.000Z | やく6じかん   | やく6じかん            | やく6じかんあと   |
| 2000-01-01T01:00:00.000Z | やく1じかん   | やく1じかん            | やく1じかんあと   |
| 2000-01-01T00:45:00.000Z | やく1じかん   | やく1じかん            | やく1じかんあと   |
| 2000-01-01T00:30:00.000Z | 30ふん        | 30ふん                 | 30ふんあと        |
| 2000-01-01T00:15:00.000Z | 15ふん        | 15ふん                 | 15ふんあと        |
| 2000-01-01T00:01:00.000Z | 1ぷん         | 1ぷん                  | 1ぷんあと         |
| 2000-01-01T00:00:25.000Z | 1ぷんみまん   | 30びょう               | やく1ぷんあと     |
| 2000-01-01T00:00:15.000Z | 1ぷんみまん   | 20びょうみまん         | やく1ぷんあと     |
| 2000-01-01T00:00:05.000Z | 1ぷんみまん   | 10びょうみまん         | やく1ぷんあと     |
| 2000-01-01T00:00:00.000Z | 1ぷんみまん   | 5びょうみまん          | やく1ぷんまえ     |
| 1999-12-31T23:59:55.000Z | 1ぷんみまん   | 10びょうみまん         | やく1ぷんまえ     |
| 1999-12-31T23:59:45.000Z | 1ぷんみまん   | 20びょうみまん         | やく1ぷんまえ     |
| 1999-12-31T23:59:35.000Z | 1ぷんみまん   | 30びょう               | やく1ぷんまえ     |
| 1999-12-31T23:59:00.000Z | 1ぷん         | 1ぷん                  | 1ぷんまえ         |
| 1999-12-31T23:45:00.000Z | 15ふん        | 15ふん                 | 15ふんまえ        |
| 1999-12-31T23:30:00.000Z | 30ふん        | 30ふん                 | 30ふんまえ        |
| 1999-12-31T23:15:00.000Z | やく1じかん   | やく1じかん            | やく1じかんまえ   |
| 1999-12-31T23:00:00.000Z | やく1じかん   | やく1じかん            | やく1じかんまえ   |
| 1999-12-31T18:00:00.000Z | やく6じかん   | やく6じかん            | やく6じかんまえ   |
| 1999-12-30T00:00:00.000Z | 2にち         | 2にち                  | 2にちまえ         |
| 1999-12-15T00:00:00.000Z | 17にち        | 17にち                 | 17にちまえ        |
| 1999-12-01T00:00:00.000Z | やく1かげつ   | やく1かげつ            | やく1かげつまえ   |
| 1999-11-01T00:00:00.000Z | 2かげつ       | 2かげつ                | 2かげつまえ       |
| 1999-06-01T00:00:00.000Z | 7かげつ       | 7かげつ                | 7かげつまえ       |
| 1999-01-01T00:00:00.000Z | やく1ねん     | やく1ねん              | やく1ねんまえ     |
| 1998-12-01T00:00:00.000Z | やく1ねん     | やく1ねん              | やく1ねんまえ     |
| 1998-06-01T00:00:00.000Z | 1ねんいじょう | 1ねんいじょう          | 1ねんいじょうまえ |
| 1998-01-01T00:00:00.000Z | やく2ねん     | やく2ねん              | やく2ねんまえ     |
| 1997-01-01T00:00:00.000Z | やく3ねん     | やく3ねん              | やく3ねんまえ     |
| 1996-01-01T00:00:00.000Z | やく4ねん     | やく4ねん              | やく4ねんまえ     |
| 1995-01-01T00:00:00.000Z | やく5ねん     | やく5ねん              | やく5ねんまえ     |
| 1994-01-01T00:00:00.000Z | やく6ねん     | やく6ねん              | やく6ねんまえ     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6ねん    | 6ねんあと         | 52608じかん                    |
| 2005-01-01T00:00:00.000Z | 5ねん    | 5ねんあと         | 43848じかん                    |
| 2004-01-01T00:00:00.000Z | 4ねん    | 4ねんあと         | 35064じかん                    |
| 2003-01-01T00:00:00.000Z | 3ねん    | 3ねんあと         | 26304じかん                    |
| 2002-01-01T00:00:00.000Z | 2ねん    | 2ねんあと         | 17544じかん                    |
| 2001-06-01T00:00:00.000Z | 1ねん    | 1ねんあと         | 12408じかん                    |
| 2001-02-01T00:00:00.000Z | 1ねん    | 1ねんあと         | 9528じかん                     |
| 2001-01-01T00:00:00.000Z | 1ねん    | 1ねんあと         | 8784じかん                     |
| 2000-06-01T00:00:00.000Z | 5かげつ  | 5かげつあと       | 3648じかん                     |
| 2000-03-01T00:00:00.000Z | 2かげつ  | 2かげつあと       | 1440じかん                     |
| 2000-02-01T00:00:00.000Z | 1かげつ  | 1かげつあと       | 744じかん                      |
| 2000-01-15T00:00:00.000Z | 14にち   | 14にちあと        | 336じかん                      |
| 2000-01-02T00:00:00.000Z | 1にち    | 1にちあと         | 24じかん                       |
| 2000-01-01T06:00:00.000Z | 6じかん  | 6じかんあと       | 6じかん                        |
| 2000-01-01T01:00:00.000Z | 1じかん  | 1じかんあと       | 1じかん                        |
| 2000-01-01T00:45:00.000Z | 45ふん   | 45ふんあと        | 1じかん                        |
| 2000-01-01T00:30:00.000Z | 30ふん   | 30ふんあと        | 1じかん                        |
| 2000-01-01T00:15:00.000Z | 15ふん   | 15ふんあと        | 0じかん                        |
| 2000-01-01T00:01:00.000Z | 1ぷん    | 1ぷんあと         | 0じかん                        |
| 2000-01-01T00:00:25.000Z | 25びょう | 25びょうあと      | 0じかん                        |
| 2000-01-01T00:00:15.000Z | 15びょう | 15びょうあと      | 0じかん                        |
| 2000-01-01T00:00:05.000Z | 5びょう  | 5びょうあと       | 0じかん                        |
| 2000-01-01T00:00:00.000Z | 0びょう  | 0びょうまえ       | 0じかん                        |
| 1999-12-31T23:59:55.000Z | 5びょう  | 5びょうまえ       | 0じかん                        |
| 1999-12-31T23:59:45.000Z | 15びょう | 15びょうまえ      | 0じかん                        |
| 1999-12-31T23:59:35.000Z | 25びょう | 25びょうまえ      | 0じかん                        |
| 1999-12-31T23:59:00.000Z | 1ぷん    | 1ぷんまえ         | 0じかん                        |
| 1999-12-31T23:45:00.000Z | 15ふん   | 15ふんまえ        | 0じかん                        |
| 1999-12-31T23:30:00.000Z | 30ふん   | 30ふんまえ        | 1じかん                        |
| 1999-12-31T23:15:00.000Z | 45ふん   | 45ふんまえ        | 1じかん                        |
| 1999-12-31T23:00:00.000Z | 1じかん  | 1じかんまえ       | 1じかん                        |
| 1999-12-31T18:00:00.000Z | 6じかん  | 6じかんまえ       | 6じかん                        |
| 1999-12-30T00:00:00.000Z | 2にち    | 2にちまえ         | 48じかん                       |
| 1999-12-15T00:00:00.000Z | 17にち   | 17にちまえ        | 408じかん                      |
| 1999-12-01T00:00:00.000Z | 1かげつ  | 1かげつまえ       | 744じかん                      |
| 1999-11-01T00:00:00.000Z | 2かげつ  | 2かげつまえ       | 1464じかん                     |
| 1999-06-01T00:00:00.000Z | 7かげつ  | 7かげつまえ       | 5136じかん                     |
| 1999-01-01T00:00:00.000Z | 1ねん    | 1ねんまえ         | 8760じかん                     |
| 1998-12-01T00:00:00.000Z | 1ねん    | 1ねんまえ         | 9504じかん                     |
| 1998-06-01T00:00:00.000Z | 2ねん    | 2ねんまえ         | 13896じかん                    |
| 1998-01-01T00:00:00.000Z | 2ねん    | 2ねんまえ         | 17520じかん                    |
| 1997-01-01T00:00:00.000Z | 3ねん    | 3ねんまえ         | 26280じかん                    |
| 1996-01-01T00:00:00.000Z | 4ねん    | 4ねんまえ         | 35064じかん                    |
| 1995-01-01T00:00:00.000Z | 5ねん    | 5ねんまえ         | 43824じかん                    |
| 1994-01-01T00:00:00.000Z | 6ねん    | 6ねんまえ         | 52584じかん                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 2000/01/10                   |
| 2000-01-05T00:00:00.000Z | よくしゅうのすいようびの0:00 |
| 2000-01-02T00:00:00.000Z | あしたの0:00                 |
| 2000-01-01T00:00:00.000Z | きょうの0:00                 |
| 1999-12-31T00:00:00.000Z | きのうの0:00                 |
| 1999-12-27T00:00:00.000Z | せんしゅうのげつようびの0:00 |
| 1999-12-21T00:00:00.000Z | 1999/12/21                   |

## `formatDuration`

| Duration      | Result      |
| ------------- | ----------- |
| {"years":0}   | 0ねん       |
| {"years":1}   | 1ねん       |
| {"years":2}   | 2ねん       |
| {"months":0}  | 0かげつ     |
| {"months":1}  | 1かげつ     |
| {"months":2}  | 2かげつ     |
| {"weeks":0}   | 0しゅうかん |
| {"weeks":1}   | 1しゅうかん |
| {"weeks":2}   | 2しゅうかん |
| {"days":0}    | 0にち       |
| {"days":1}    | 1にち       |
| {"days":2}    | 2にち       |
| {"hours":0}   | 0じかん     |
| {"hours":1}   | 1じかん     |
| {"hours":2}   | 2じかん     |
| {"minutes":0} | 0ふん       |
| {"minutes":1} | 1ぷん       |
| {"minutes":2} | 2ふん       |
| {"seconds":0} | 0びょう     |
| {"seconds":1} | 1びょう     |
| {"seconds":2} | 2びょう     |
