# Japanese (ja) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                             | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987年                                      | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5年                                         | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987年                                      | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5年                                         | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 第1四半期                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第2四半期                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 第1四半期                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第2四半期                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                           | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 第1四半期                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第2四半期                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 第1四半期                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第2四半期                                   | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | 1                                           | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                          | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                          | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | 1月                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | 1                                           | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                          | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                          | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 第1週                                       | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 第49週                                      | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 第1週                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 第48週                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1日                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11日                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28日                                        | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1日 2月                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11日 2月                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28日 2月                                    | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                         | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | 月曜日                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                           | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | 月曜日                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                           | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | 月曜日                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | 月曜日                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | 月                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                          | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                        | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | 朝                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                        | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | 朝                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | 朝                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | 朝                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | 朝                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                        | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11時                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11時                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11時                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23時                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11時                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11時                                        | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11時                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23時                                        | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1分                                         | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55分                                        | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1秒                                         | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55秒                                        | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987/01/11                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11                                  | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 1987/01/11                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987年1月11日                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日                              | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | 1987年1月11日日曜日                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日水曜日                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日水曜日                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日土曜日                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日日曜日                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日木曜日                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日土曜日                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日火曜日                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日金曜日                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日日曜日                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日水曜日                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日金曜日                        | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                       | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                       | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                       | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                       | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                       | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                       | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                       | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                       | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                       | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                       | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                       | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                    | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                    | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                    | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                    | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                    | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                    | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                    | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                    | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                    | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                    | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                    | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                    | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                              | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23時59分59秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12時13分14秒 GMT+00:00                      | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987/01/11 12:13                            | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13                            | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11 12:13                            | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11 12:13                            | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59                            | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11 12:13                            | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11 12:13                            | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11 12:13                            | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11 12:13                            | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11 12:13                            | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11 12:13                            | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11 12:13                            | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 1987/01/11 12:13:14                         | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13:14                         | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987/03/11 12:13:14                         | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987/04/11 12:13:14                         | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59:59                         | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987/06/11 12:13:14                         | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987/07/11 12:13:14                         | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987/08/11 12:13:14                         | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987/09/11 12:13:14                         | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987/10/11 12:13:14                         | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987/11/11 12:13:14                         | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987/12/11 12:13:14                         | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987年1月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日 23:59:59 GMT+0                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | 1987年1月11日日曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日水曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日水曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日土曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日日曜日 23時59分59秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日木曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日土曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日火曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日金曜日 12時13分14秒 GMT+00:00  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日日曜日 12時13分14秒 GMT+00:00 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日水曜日 12時13分14秒 GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日金曜日 12時13分14秒 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result  | `includeSeconds: true` | `addSuffix: true` |
| ------------------------ | ------- | ---------------------- | ----------------- |
| 2006-01-01T00:00:00.000Z | 約6年   | 約6年                  | 約6年後           |
| 2005-01-01T00:00:00.000Z | 約5年   | 約5年                  | 約5年後           |
| 2004-01-01T00:00:00.000Z | 約4年   | 約4年                  | 約4年後           |
| 2003-01-01T00:00:00.000Z | 約3年   | 約3年                  | 約3年後           |
| 2002-01-01T00:00:00.000Z | 約2年   | 約2年                  | 約2年後           |
| 2001-06-01T00:00:00.000Z | 1年以上 | 1年以上                | 1年以上後         |
| 2001-02-01T00:00:00.000Z | 約1年   | 約1年                  | 約1年後           |
| 2001-01-01T00:00:00.000Z | 約1年   | 約1年                  | 約1年後           |
| 2000-06-01T00:00:00.000Z | 5か月   | 5か月                  | 5か月後           |
| 2000-03-01T00:00:00.000Z | 2か月   | 2か月                  | 2か月後           |
| 2000-02-01T00:00:00.000Z | 約1か月 | 約1か月                | 約1か月後         |
| 2000-01-15T00:00:00.000Z | 14日    | 14日                   | 14日後            |
| 2000-01-02T00:00:00.000Z | 1日     | 1日                    | 1日後             |
| 2000-01-01T06:00:00.000Z | 約6時間 | 約6時間                | 約6時間後         |
| 2000-01-01T01:00:00.000Z | 約1時間 | 約1時間                | 約1時間後         |
| 2000-01-01T00:45:00.000Z | 約1時間 | 約1時間                | 約1時間後         |
| 2000-01-01T00:30:00.000Z | 30分    | 30分                   | 30分後            |
| 2000-01-01T00:15:00.000Z | 15分    | 15分                   | 15分後            |
| 2000-01-01T00:01:00.000Z | 1分     | 1分                    | 1分後             |
| 2000-01-01T00:00:25.000Z | 1分未満 | 30秒                   | 約1分後           |
| 2000-01-01T00:00:15.000Z | 1分未満 | 20秒未満               | 約1分後           |
| 2000-01-01T00:00:05.000Z | 1分未満 | 10秒未満               | 約1分後           |
| 2000-01-01T00:00:00.000Z | 1分未満 | 5秒未満                | 約1分前           |
| 1999-12-31T23:59:55.000Z | 1分未満 | 10秒未満               | 約1分前           |
| 1999-12-31T23:59:45.000Z | 1分未満 | 20秒未満               | 約1分前           |
| 1999-12-31T23:59:35.000Z | 1分未満 | 30秒                   | 約1分前           |
| 1999-12-31T23:59:00.000Z | 1分     | 1分                    | 1分前             |
| 1999-12-31T23:45:00.000Z | 15分    | 15分                   | 15分前            |
| 1999-12-31T23:30:00.000Z | 30分    | 30分                   | 30分前            |
| 1999-12-31T23:15:00.000Z | 約1時間 | 約1時間                | 約1時間前         |
| 1999-12-31T23:00:00.000Z | 約1時間 | 約1時間                | 約1時間前         |
| 1999-12-31T18:00:00.000Z | 約6時間 | 約6時間                | 約6時間前         |
| 1999-12-30T00:00:00.000Z | 2日     | 2日                    | 2日前             |
| 1999-12-15T00:00:00.000Z | 17日    | 17日                   | 17日前            |
| 1999-12-01T00:00:00.000Z | 約1か月 | 約1か月                | 約1か月前         |
| 1999-11-01T00:00:00.000Z | 2か月   | 2か月                  | 2か月前           |
| 1999-06-01T00:00:00.000Z | 7か月   | 7か月                  | 7か月前           |
| 1999-01-01T00:00:00.000Z | 約1年   | 約1年                  | 約1年前           |
| 1998-12-01T00:00:00.000Z | 約1年   | 約1年                  | 約1年前           |
| 1998-06-01T00:00:00.000Z | 1年以上 | 1年以上                | 1年以上前         |
| 1998-01-01T00:00:00.000Z | 約2年   | 約2年                  | 約2年前           |
| 1997-01-01T00:00:00.000Z | 約3年   | 約3年                  | 約3年前           |
| 1996-01-01T00:00:00.000Z | 約4年   | 約4年                  | 約4年前           |
| 1995-01-01T00:00:00.000Z | 約5年   | 約5年                  | 約5年前           |
| 1994-01-01T00:00:00.000Z | 約6年   | 約6年                  | 約6年前           |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------ | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6年    | 6年後             | 52608時間                      |
| 2005-01-01T00:00:00.000Z | 5年    | 5年後             | 43848時間                      |
| 2004-01-01T00:00:00.000Z | 4年    | 4年後             | 35064時間                      |
| 2003-01-01T00:00:00.000Z | 3年    | 3年後             | 26304時間                      |
| 2002-01-01T00:00:00.000Z | 2年    | 2年後             | 17544時間                      |
| 2001-06-01T00:00:00.000Z | 1年    | 1年後             | 12408時間                      |
| 2001-02-01T00:00:00.000Z | 1年    | 1年後             | 9528時間                       |
| 2001-01-01T00:00:00.000Z | 1年    | 1年後             | 8784時間                       |
| 2000-06-01T00:00:00.000Z | 5か月  | 5か月後           | 3648時間                       |
| 2000-03-01T00:00:00.000Z | 2か月  | 2か月後           | 1440時間                       |
| 2000-02-01T00:00:00.000Z | 1か月  | 1か月後           | 744時間                        |
| 2000-01-15T00:00:00.000Z | 14日   | 14日後            | 336時間                        |
| 2000-01-02T00:00:00.000Z | 1日    | 1日後             | 24時間                         |
| 2000-01-01T06:00:00.000Z | 6時間  | 6時間後           | 6時間                          |
| 2000-01-01T01:00:00.000Z | 1時間  | 1時間後           | 1時間                          |
| 2000-01-01T00:45:00.000Z | 45分   | 45分後            | 1時間                          |
| 2000-01-01T00:30:00.000Z | 30分   | 30分後            | 1時間                          |
| 2000-01-01T00:15:00.000Z | 15分   | 15分後            | 0時間                          |
| 2000-01-01T00:01:00.000Z | 1分    | 1分後             | 0時間                          |
| 2000-01-01T00:00:25.000Z | 25秒   | 25秒後            | 0時間                          |
| 2000-01-01T00:00:15.000Z | 15秒   | 15秒後            | 0時間                          |
| 2000-01-01T00:00:05.000Z | 5秒    | 5秒後             | 0時間                          |
| 2000-01-01T00:00:00.000Z | 0秒    | 0秒前             | 0時間                          |
| 1999-12-31T23:59:55.000Z | 5秒    | 5秒前             | 0時間                          |
| 1999-12-31T23:59:45.000Z | 15秒   | 15秒前            | 0時間                          |
| 1999-12-31T23:59:35.000Z | 25秒   | 25秒前            | 0時間                          |
| 1999-12-31T23:59:00.000Z | 1分    | 1分前             | 0時間                          |
| 1999-12-31T23:45:00.000Z | 15分   | 15分前            | 0時間                          |
| 1999-12-31T23:30:00.000Z | 30分   | 30分前            | 1時間                          |
| 1999-12-31T23:15:00.000Z | 45分   | 45分前            | 1時間                          |
| 1999-12-31T23:00:00.000Z | 1時間  | 1時間前           | 1時間                          |
| 1999-12-31T18:00:00.000Z | 6時間  | 6時間前           | 6時間                          |
| 1999-12-30T00:00:00.000Z | 2日    | 2日前             | 48時間                         |
| 1999-12-15T00:00:00.000Z | 17日   | 17日前            | 408時間                        |
| 1999-12-01T00:00:00.000Z | 1か月  | 1か月前           | 744時間                        |
| 1999-11-01T00:00:00.000Z | 2か月  | 2か月前           | 1464時間                       |
| 1999-06-01T00:00:00.000Z | 7か月  | 7か月前           | 5136時間                       |
| 1999-01-01T00:00:00.000Z | 1年    | 1年前             | 8760時間                       |
| 1998-12-01T00:00:00.000Z | 1年    | 1年前             | 9504時間                       |
| 1998-06-01T00:00:00.000Z | 2年    | 2年前             | 13896時間                      |
| 1998-01-01T00:00:00.000Z | 2年    | 2年前             | 17520時間                      |
| 1997-01-01T00:00:00.000Z | 3年    | 3年前             | 26280時間                      |
| 1996-01-01T00:00:00.000Z | 4年    | 4年前             | 35064時間                      |
| 1995-01-01T00:00:00.000Z | 5年    | 5年前             | 43824時間                      |
| 1994-01-01T00:00:00.000Z | 6年    | 6年前             | 52584時間                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result             |
| ------------------------ | ------------------ |
| 2000-01-10T00:00:00.000Z | 2000/01/10         |
| 2000-01-05T00:00:00.000Z | 翌週の水曜日の0:00 |
| 2000-01-02T00:00:00.000Z | 明日の0:00         |
| 2000-01-01T00:00:00.000Z | 今日の0:00         |
| 1999-12-31T00:00:00.000Z | 昨日の0:00         |
| 1999-12-27T00:00:00.000Z | 先週の月曜日の0:00 |
| 1999-12-21T00:00:00.000Z | 1999/12/21         |

## `formatDuration`

| Duration      | Result |
| ------------- | ------ |
| {"years":0}   | 0年    |
| {"years":1}   | 1年    |
| {"years":2}   | 2年    |
| {"months":0}  | 0か月  |
| {"months":1}  | 1か月  |
| {"months":2}  | 2か月  |
| {"weeks":0}   | 0週間  |
| {"weeks":1}   | 1週間  |
| {"weeks":2}   | 2週間  |
| {"days":0}    | 0日    |
| {"days":1}    | 1日    |
| {"days":2}    | 2日    |
| {"hours":0}   | 0時間  |
| {"hours":1}   | 1時間  |
| {"hours":2}   | 2時間  |
| {"minutes":0} | 0分    |
| {"minutes":1} | 1分    |
| {"minutes":2} | 2分    |
| {"seconds":0} | 0秒    |
| {"seconds":1} | 1秒    |
| {"seconds":2} | 2秒    |
