# Latvian (lv) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                                | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                                          | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                             | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                                          | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                                             | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1. cet.                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. cet.                                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | pirmajā ceturksnī                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | otrajā ceturksnī                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                              | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1. cet.                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. cet.                                                        | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | pirmais ceturksnis                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | otrais ceturksnis                                              | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1.                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                            | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | janv.                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febr.                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | martā                                                          | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maijs                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jūn.                                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jūl.                                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sept.                                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                                           | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | janvārī                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februārī                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | martā                                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | aprīlī                                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maijā                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jūnijā                                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jūlijā                                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augustā                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septembrī                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktobrī                                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembrī                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | decembrī                                                       | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                              | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1.                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                            | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | janv.                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febr.                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | marts                                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maijs                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jūn.                                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jūl.                                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sept.                                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                                           | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | janvāris                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februāris                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | marts                                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | aprīlis                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maijs                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | jūnijs                                                         | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jūlijs                                                         | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augusts                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | septembris                                                     | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktobris                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembris                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | decembris                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                              | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                              | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                            | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                            | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1.                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11.                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                            | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1. februārī                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11. februārī                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28. februārī                                                   | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                                           | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | pirmdienā                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektdienā                                                     | 2019-02-11T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pk                                                             | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                             | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | pirmdienā                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektdienā                                                     | 2019-02-11T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pk                                                             | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                             | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | pirmdienā                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektdienā                                                     | 2019-02-11T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pk                                                             | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pirmd.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektd.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | pirmdiena                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piektdiena                                                     | 2019-02-11T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | P                                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pk                                                             | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                             | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | rītā                                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pēcpusd.                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakarā                                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktī                                                          | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | rītā                                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pēcpusd.                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakarā                                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktī                                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | rītā                                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pēcpusd.                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakarā                                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktī                                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | rītā                                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pēcpusdienā                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakarā                                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktī                                                          | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | rītā                                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | dienā                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakarā                                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktī                                                          | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                            | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                            | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                             | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                            | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                             | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                            | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987.                                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987.                                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987.                                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987.                                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453.                                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987.                                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987.                                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987.                                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987.                                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987.                                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987.                                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987.                                                    | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11.01.1987.                                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987.                                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987.                                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987.                                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453.                                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987.                                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987.                                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987.                                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987.                                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987.                                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987.                                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987.                                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987. gada 11. janvārī                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987. gada 11. februārī                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987. gada 11. martā                                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987. gada 11. aprīlī                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. gada 29. maijā                                           | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987. gada 11. jūnijā                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987. gada 11. jūlijā                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987. gada 11. augustā                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987. gada 11. septembrī                                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987. gada 11. oktobrī                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987. gada 11. novembrī                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987. gada 11. decembrī                                        | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | svētdienā, 1987. gada 11. janvārī                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | trešdienā, 1987. gada 11. februārī                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | trešdienā, 1987. gada 11. martā                                | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | sestdienā, 1987. gada 11. aprīlī                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | svētdienā, 1453. gada 29. maijā                                | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ceturtdienā, 1987. gada 11. jūnijā                             | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | sestdienā, 1987. gada 11. jūlijā                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | otrdienā, 1987. gada 11. augustā                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | piektdienā, 1987. gada 11. septembrī                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | svētdienā, 1987. gada 11. oktobrī                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | trešdienā, 1987. gada 11. novembrī                             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | piektdienā, 1987. gada 11. decembrī                            | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                          | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                          | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                          | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                          | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                          | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                          | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                          | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                          | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                          | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                          | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                          | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                                       | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                                       | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                                       | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                       | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                                       | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                                       | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                                       | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                                       | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                                       | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                                       | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                                       | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                                 | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                             | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987., 12:13                                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987., 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987., 12:13                                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987., 12:13                                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453., 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987., 12:13                                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987., 12:13                                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987., 12:13                                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987., 12:13                                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987., 12:13                                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987., 12:13                                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987., 12:13                                             | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11.01.1987., 12:13:14                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987., 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987., 12:13:14                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987., 12:13:14                                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453., 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987., 12:13:14                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987., 12:13:14                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987., 12:13:14                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987., 12:13:14                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987., 12:13:14                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987., 12:13:14                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987., 12:13:14                                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987. gada 11. janvārī plkst. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987. gada 11. februārī plkst. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987. gada 11. martā plkst. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987. gada 11. aprīlī plkst. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. gada 29. maijā plkst. 23:59:59 GMT+0                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987. gada 11. jūnijā plkst. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987. gada 11. jūlijā plkst. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987. gada 11. augustā plkst. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987. gada 11. septembrī plkst. 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987. gada 11. oktobrī plkst. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987. gada 11. novembrī plkst. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987. gada 11. decembrī plkst. 12:13:14 GMT+0                  | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | svētdienā, 1987. gada 11. janvārī plkst. 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | trešdienā, 1987. gada 11. februārī plkst. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | trešdienā, 1987. gada 11. martā plkst. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | sestdienā, 1987. gada 11. aprīlī plkst. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | svētdienā, 1453. gada 29. maijā plkst. 23:59:59 GMT+00:00      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | ceturtdienā, 1987. gada 11. jūnijā plkst. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | sestdienā, 1987. gada 11. jūlijā plkst. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | otrdienā, 1987. gada 11. augustā plkst. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | piektdienā, 1987. gada 11. septembrī plkst. 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | svētdienā, 1987. gada 11. oktobrī plkst. 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | trešdienā, 1987. gada 11. novembrī plkst. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | piektdienā, 1987. gada 11. decembrī plkst. 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`       |
| ------------------------ | ----------------- | ---------------------- | ----------------------- |
| 2006-01-01T00:00:00.000Z | apmēram 6 gadi    | apmēram 6 gadi         | pēc apmēram 6 gadiem    |
| 2005-01-01T00:00:00.000Z | apmēram 5 gadi    | apmēram 5 gadi         | pēc apmēram 5 gadiem    |
| 2004-01-01T00:00:00.000Z | apmēram 4 gadi    | apmēram 4 gadi         | pēc apmēram 4 gadiem    |
| 2003-01-01T00:00:00.000Z | apmēram 3 gadi    | apmēram 3 gadi         | pēc apmēram 3 gadiem    |
| 2002-01-01T00:00:00.000Z | apmēram 2 gadi    | apmēram 2 gadi         | pēc apmēram 2 gadiem    |
| 2001-06-01T00:00:00.000Z | ilgāk par 1 gadu  | ilgāk par 1 gadu       | pēc ilgāk par 1 gadu    |
| 2001-02-01T00:00:00.000Z | apmēram 1 gads    | apmēram 1 gads         | pēc apmēram 1 gada      |
| 2001-01-01T00:00:00.000Z | apmēram 1 gads    | apmēram 1 gads         | pēc apmēram 1 gada      |
| 2000-06-01T00:00:00.000Z | 5 mēneši          | 5 mēneši               | pēc 5 mēnešiem          |
| 2000-03-01T00:00:00.000Z | 2 mēneši          | 2 mēneši               | pēc 2 mēnešiem          |
| 2000-02-01T00:00:00.000Z | apmēram 1 mēnesis | apmēram 1 mēnesis      | pēc apmēram 1 mēneša    |
| 2000-01-15T00:00:00.000Z | 14 dienas         | 14 dienas              | pēc 14 dienām           |
| 2000-01-02T00:00:00.000Z | 1 diena           | 1 diena                | pēc 1 dienas            |
| 2000-01-01T06:00:00.000Z | apmēram 6 stundas | apmēram 6 stundas      | pēc apmēram 6 stundām   |
| 2000-01-01T01:00:00.000Z | apmēram 1 stunda  | apmēram 1 stunda       | pēc apmēram 1 stundas   |
| 2000-01-01T00:45:00.000Z | apmēram 1 stunda  | apmēram 1 stunda       | pēc apmēram 1 stundas   |
| 2000-01-01T00:30:00.000Z | 30 minūtes        | 30 minūtes             | pēc 30 minūtēm          |
| 2000-01-01T00:15:00.000Z | 15 minūtes        | 15 minūtes             | pēc 15 minūtēm          |
| 2000-01-01T00:01:00.000Z | 1 minūte          | 1 minūte               | pēc 1 minūtes           |
| 2000-01-01T00:00:25.000Z | mazāk par minūti  | pusminūte              | pēc mazāk par minūti    |
| 2000-01-01T00:00:15.000Z | mazāk par minūti  | mazāk nekā 20 sekundes | pēc mazāk par minūti    |
| 2000-01-01T00:00:05.000Z | mazāk par minūti  | mazāk nekā 10 sekundes | pēc mazāk par minūti    |
| 2000-01-01T00:00:00.000Z | mazāk par minūti  | mazāk nekā 5 sekundes  | pirms mazāk par minūti  |
| 1999-12-31T23:59:55.000Z | mazāk par minūti  | mazāk nekā 10 sekundes | pirms mazāk par minūti  |
| 1999-12-31T23:59:45.000Z | mazāk par minūti  | mazāk nekā 20 sekundes | pirms mazāk par minūti  |
| 1999-12-31T23:59:35.000Z | mazāk par minūti  | pusminūte              | pirms mazāk par minūti  |
| 1999-12-31T23:59:00.000Z | 1 minūte          | 1 minūte               | pirms 1 minūtes         |
| 1999-12-31T23:45:00.000Z | 15 minūtes        | 15 minūtes             | pirms 15 minūtēm        |
| 1999-12-31T23:30:00.000Z | 30 minūtes        | 30 minūtes             | pirms 30 minūtēm        |
| 1999-12-31T23:15:00.000Z | apmēram 1 stunda  | apmēram 1 stunda       | pirms apmēram 1 stundas |
| 1999-12-31T23:00:00.000Z | apmēram 1 stunda  | apmēram 1 stunda       | pirms apmēram 1 stundas |
| 1999-12-31T18:00:00.000Z | apmēram 6 stundas | apmēram 6 stundas      | pirms apmēram 6 stundām |
| 1999-12-30T00:00:00.000Z | 2 dienas          | 2 dienas               | pirms 2 dienām          |
| 1999-12-15T00:00:00.000Z | 17 dienas         | 17 dienas              | pirms 17 dienām         |
| 1999-12-01T00:00:00.000Z | apmēram 1 mēnesis | apmēram 1 mēnesis      | pirms apmēram 1 mēneša  |
| 1999-11-01T00:00:00.000Z | 2 mēneši          | 2 mēneši               | pirms 2 mēnešiem        |
| 1999-06-01T00:00:00.000Z | 7 mēneši          | 7 mēneši               | pirms 7 mēnešiem        |
| 1999-01-01T00:00:00.000Z | apmēram 1 gads    | apmēram 1 gads         | pirms apmēram 1 gada    |
| 1998-12-01T00:00:00.000Z | apmēram 1 gads    | apmēram 1 gads         | pirms apmēram 1 gada    |
| 1998-06-01T00:00:00.000Z | ilgāk par 1 gadu  | ilgāk par 1 gadu       | pirms ilgāk par 1 gadu  |
| 1998-01-01T00:00:00.000Z | apmēram 2 gadi    | apmēram 2 gadi         | pirms apmēram 2 gadiem  |
| 1997-01-01T00:00:00.000Z | apmēram 3 gadi    | apmēram 3 gadi         | pirms apmēram 3 gadiem  |
| 1996-01-01T00:00:00.000Z | apmēram 4 gadi    | apmēram 4 gadi         | pirms apmēram 4 gadiem  |
| 1995-01-01T00:00:00.000Z | apmēram 5 gadi    | apmēram 5 gadi         | pirms apmēram 5 gadiem  |
| 1994-01-01T00:00:00.000Z | apmēram 6 gadi    | apmēram 6 gadi         | pirms apmēram 6 gadiem  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 gadi      | pēc 6 gadiem      | 52608 stundas                  |
| 2005-01-01T00:00:00.000Z | 5 gadi      | pēc 5 gadiem      | 43848 stundas                  |
| 2004-01-01T00:00:00.000Z | 4 gadi      | pēc 4 gadiem      | 35064 stundas                  |
| 2003-01-01T00:00:00.000Z | 3 gadi      | pēc 3 gadiem      | 26304 stundas                  |
| 2002-01-01T00:00:00.000Z | 2 gadi      | pēc 2 gadiem      | 17544 stundas                  |
| 2001-06-01T00:00:00.000Z | 1 gads      | pēc 1 gada        | 12408 stundas                  |
| 2001-02-01T00:00:00.000Z | 1 gads      | pēc 1 gada        | 9528 stundas                   |
| 2001-01-01T00:00:00.000Z | 1 gads      | pēc 1 gada        | 8784 stundas                   |
| 2000-06-01T00:00:00.000Z | 5 mēneši    | pēc 5 mēnešiem    | 3648 stundas                   |
| 2000-03-01T00:00:00.000Z | 2 mēneši    | pēc 2 mēnešiem    | 1440 stundas                   |
| 2000-02-01T00:00:00.000Z | 1 mēnesis   | pēc 1 mēneša      | 744 stundas                    |
| 2000-01-15T00:00:00.000Z | 14 dienas   | pēc 14 dienām     | 336 stundas                    |
| 2000-01-02T00:00:00.000Z | 1 diena     | pēc 1 dienas      | 24 stundas                     |
| 2000-01-01T06:00:00.000Z | 6 stundas   | pēc 6 stundām     | 6 stundas                      |
| 2000-01-01T01:00:00.000Z | 1 stunda    | pēc 1 stundas     | 1 stunda                       |
| 2000-01-01T00:45:00.000Z | 45 minūtes  | pēc 45 minūtēm    | 1 stunda                       |
| 2000-01-01T00:30:00.000Z | 30 minūtes  | pēc 30 minūtēm    | 1 stunda                       |
| 2000-01-01T00:15:00.000Z | 15 minūtes  | pēc 15 minūtēm    | 0 stundas                      |
| 2000-01-01T00:01:00.000Z | 1 minūte    | pēc 1 minūtes     | 0 stundas                      |
| 2000-01-01T00:00:25.000Z | 25 sekundes | pēc 25 sekundēm   | 0 stundas                      |
| 2000-01-01T00:00:15.000Z | 15 sekundes | pēc 15 sekundēm   | 0 stundas                      |
| 2000-01-01T00:00:05.000Z | 5 sekundes  | pēc 5 sekundēm    | 0 stundas                      |
| 2000-01-01T00:00:00.000Z | 0 sekundes  | pirms 0 sekundēm  | 0 stundas                      |
| 1999-12-31T23:59:55.000Z | 5 sekundes  | pirms 5 sekundēm  | 0 stundas                      |
| 1999-12-31T23:59:45.000Z | 15 sekundes | pirms 15 sekundēm | 0 stundas                      |
| 1999-12-31T23:59:35.000Z | 25 sekundes | pirms 25 sekundēm | 0 stundas                      |
| 1999-12-31T23:59:00.000Z | 1 minūte    | pirms 1 minūtes   | 0 stundas                      |
| 1999-12-31T23:45:00.000Z | 15 minūtes  | pirms 15 minūtēm  | 0 stundas                      |
| 1999-12-31T23:30:00.000Z | 30 minūtes  | pirms 30 minūtēm  | 1 stunda                       |
| 1999-12-31T23:15:00.000Z | 45 minūtes  | pirms 45 minūtēm  | 1 stunda                       |
| 1999-12-31T23:00:00.000Z | 1 stunda    | pirms 1 stundas   | 1 stunda                       |
| 1999-12-31T18:00:00.000Z | 6 stundas   | pirms 6 stundām   | 6 stundas                      |
| 1999-12-30T00:00:00.000Z | 2 dienas    | pirms 2 dienām    | 48 stundas                     |
| 1999-12-15T00:00:00.000Z | 17 dienas   | pirms 17 dienām   | 408 stundas                    |
| 1999-12-01T00:00:00.000Z | 1 mēnesis   | pirms 1 mēneša    | 744 stundas                    |
| 1999-11-01T00:00:00.000Z | 2 mēneši    | pirms 2 mēnešiem  | 1464 stundas                   |
| 1999-06-01T00:00:00.000Z | 7 mēneši    | pirms 7 mēnešiem  | 5136 stundas                   |
| 1999-01-01T00:00:00.000Z | 1 gads      | pirms 1 gada      | 8760 stundas                   |
| 1998-12-01T00:00:00.000Z | 1 gads      | pirms 1 gada      | 9504 stundas                   |
| 1998-06-01T00:00:00.000Z | 2 gadi      | pirms 2 gadiem    | 13896 stundas                  |
| 1998-01-01T00:00:00.000Z | 2 gadi      | pirms 2 gadiem    | 17520 stundas                  |
| 1997-01-01T00:00:00.000Z | 3 gadi      | pirms 3 gadiem    | 26280 stundas                  |
| 1996-01-01T00:00:00.000Z | 4 gadi      | pirms 4 gadiem    | 35064 stundas                  |
| 1995-01-01T00:00:00.000Z | 5 gadi      | pirms 5 gadiem    | 43824 stundas                  |
| 1994-01-01T00:00:00.000Z | 6 gadi      | pirms 6 gadiem    | 52584 stundas                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                          |
| ------------------------ | ------------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000.                     |
| 2000-01-05T00:00:00.000Z | Nākamajā trešdienā plkst. 00:00 |
| 2000-01-02T00:00:00.000Z | Rīt plkst. 00:00                |
| 2000-01-01T00:00:00.000Z | Šodien plkst. 00:00             |
| 1999-12-31T00:00:00.000Z | Vakar plkst. 00:00              |
| 1999-12-27T00:00:00.000Z | pirmdienā plkst. 00:00          |
| 1999-12-21T00:00:00.000Z | 21.12.1999.                     |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 gadi     |
| {"years":1}   | 1 gads     |
| {"years":2}   | 2 gadi     |
| {"months":0}  | 0 mēneši   |
| {"months":1}  | 1 mēnesis  |
| {"months":2}  | 2 mēneši   |
| {"weeks":0}   | 0 nedēļu   |
| {"weeks":1}   | 1 nedēļa   |
| {"weeks":2}   | 2 nedēļu   |
| {"days":0}    | 0 dienas   |
| {"days":1}    | 1 diena    |
| {"days":2}    | 2 dienas   |
| {"hours":0}   | 0 stundas  |
| {"hours":1}   | 1 stunda   |
| {"hours":2}   | 2 stundas  |
| {"minutes":0} | 0 minūtes  |
| {"minutes":1} | 1 minūte   |
| {"minutes":2} | 2 minūtes  |
| {"seconds":0} | 0 sekundes |
| {"seconds":1} | 1 sekunde  |
| {"seconds":2} | 2 sekundes |
