# Mongolian (mn) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                                | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                                   | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                                | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                                   | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | I улирал                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II улирал                                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-р улирал                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-р улирал                                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | I                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II                                                                  | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | I улирал                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II улирал                                                           | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-р улирал                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-р улирал                                                          | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                                  | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | 1-р сар                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-р сар                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-р сар                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-р сар                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-р сар                                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-р сар                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-р сар                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-р сар                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-р сар                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | нэгдүгээр сар                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | хоёрдугаар сар                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | гуравдугаар сар                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | дөрөвдүгээр сар                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | тавдугаар сар                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | зургаадугаар сар                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | долоодугаар сар                                                     | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | наймдугаар сар                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | есдүгээр сар                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | аравдугаар сар                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | арваннэгдүгээр сар                                                  | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | арван хоёрдугаар сар                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | I                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | II                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | III                                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | IV                                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | V                                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | VI                                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | VII                                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | VIII                                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | IX                                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | X                                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | XI                                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | XII                                                                 | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                                  | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | 1-р сар                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-р сар                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-р сар                                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-р сар                                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-р сар                                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-р сар                                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-р сар                                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-р сар                                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-р сар                                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-р сар                                                            | 2019-01-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | Нэгдүгээр сар                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Хоёрдугаар сар                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Гуравдугаар сар                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Дөрөвдүгээр сар                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Тавдугаар сар                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Зургаадугаар сар                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Долоодугаар сар                                                     | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Наймдугаар сар                                                      | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Есдүгээр сар                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Аравдугаар сар                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Арваннэгдүгээр сар                                                  | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | Арван хоёрдугаар сар                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | I                                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | II                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | III                                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | IV                                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | V                                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | VI                                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | VII                                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | VIII                                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | IX                                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | X                                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | XI                                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | XII                                                                 | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                                  | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                                  | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                                  | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 хоёрдугаар сар                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 хоёрдугаар сар                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 хоёрдугаар сар                                                   | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                                 | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | даваа                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | баасан                                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Д                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Б                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Да                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ба                                                                  | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | даваа                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | баасан                                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Д                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Б                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Да                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ба                                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | даваа                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | баасан                                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Д                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Б                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Да                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ба                                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Дав                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баа                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Даваа                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Баасан                                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Д                                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Б                                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Да                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ба                                                                  | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ү.х.                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ү.ө.                                                                | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | өглөө                                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | өдөр                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | орой                                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | шөнө                                                                | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | өглөө                                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | өдөр                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | орой                                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | шөнө                                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | өглөө                                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | өдөр                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | орой                                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | шөнө                                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | өглөө                                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | өдөр                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | орой                                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | шөнө                                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | өглөө                                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | өдөр                                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | орой                                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | шөнө                                                                | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                                  | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                                  | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                                   | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                                  | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                                   | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                                  | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987.01.11                                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987.02.11                                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987.03.11                                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987.04.11                                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29                                                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987.06.11                                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987.07.11                                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987.08.11                                                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987.09.11                                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987.10.11                                                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987.11.11                                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987.12.11                                                          | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 1987 оны 1-р сарын 11                                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны 2-р сарын 11                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны 3-р сарын 11                                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны 4-р сарын 11                                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны 5-р сарын 29                                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны 6-р сарын 11                                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны 7-р сарын 11                                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны 8-р сарын 11                                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны 9-р сарын 11                                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны 10-р сарын 11                                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны 11-р сарын 11                                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны 12-р сарын 11                                              | 1987-01-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987 оны нэгдүгээр сарын 11                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны хоёрдугаар сарын 11                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны гуравдугаар сарын 11                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны дөрөвдүгээр сарын 11                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны тавдугаар сарын 29                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны зургаадугаар сарын 11                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны долоодугаар сарын 11                                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны наймдугаар сарын 11                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны есдүгээр сарын 11                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны аравдугаар сарын 11                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны арваннэгдүгээр сарын 11                                    | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны арван хоёрдугаар сарын 11                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | 1987 оны нэгдүгээр сарын 11, ням гараг                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны хоёрдугаар сарын 11, лхагва гараг                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны гуравдугаар сарын 11, лхагва гараг                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны дөрөвдүгээр сарын 11, бямба гараг                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны тавдугаар сарын 29, ням гараг                              | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны зургаадугаар сарын 11, пүрэв гараг                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны долоодугаар сарын 11, бямба гараг                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны наймдугаар сарын 11, мягмар гараг                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны есдүгээр сарын 11, баасан гараг                            | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны аравдугаар сарын 11, ням гараг                             | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны арваннэгдүгээр сарын 11, лхагва гараг                      | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны арван хоёрдугаар сарын 11, баасан гараг                    | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                               | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                                            | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                                      | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987.01.11 12:13                                                    | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987.02.11 12:13                                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987.03.11 12:13                                                    | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987.04.11 12:13                                                    | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29 23:59                                                    | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987.06.11 12:13                                                    | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987.07.11 12:13                                                    | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987.08.11 12:13                                                    | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987.09.11 12:13                                                    | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987.10.11 12:13                                                    | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987.11.11 12:13                                                    | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987.12.11 12:13                                                    | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 1987 оны 1-р сарын 11 12:13:14                                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны 2-р сарын 11 12:13:14                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны 3-р сарын 11 12:13:14                                      | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны 4-р сарын 11 12:13:14                                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны 5-р сарын 29 23:59:59                                      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны 6-р сарын 11 12:13:14                                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны 7-р сарын 11 12:13:14                                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны 8-р сарын 11 12:13:14                                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны 9-р сарын 11 12:13:14                                      | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны 10-р сарын 11 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны 11-р сарын 11 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны 12-р сарын 11 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987 оны нэгдүгээр сарын 11 12:13:14 GMT+0                          | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны хоёрдугаар сарын 11 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны гуравдугаар сарын 11 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны дөрөвдүгээр сарын 11 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны тавдугаар сарын 29 23:59:59 GMT+0                          | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны зургаадугаар сарын 11 12:13:14 GMT+0                       | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны долоодугаар сарын 11 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны наймдугаар сарын 11 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны есдүгээр сарын 11 12:13:14 GMT+0                           | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны аравдугаар сарын 11 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны арваннэгдүгээр сарын 11 12:13:14 GMT+0                     | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны арван хоёрдугаар сарын 11 12:13:14 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | 1987 оны нэгдүгээр сарын 11, ням гараг 12:13:14 GMT+00:00           | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 оны хоёрдугаар сарын 11, лхагва гараг 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 оны гуравдугаар сарын 11, лхагва гараг 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 оны дөрөвдүгээр сарын 11, бямба гараг 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 оны тавдугаар сарын 29, ням гараг 23:59:59 GMT+00:00           | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 оны зургаадугаар сарын 11, пүрэв гараг 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 оны долоодугаар сарын 11, бямба гараг 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 оны наймдугаар сарын 11, мягмар гараг 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 оны есдүгээр сарын 11, баасан гараг 12:13:14 GMT+00:00         | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 оны аравдугаар сарын 11, ням гараг 12:13:14 GMT+00:00          | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 оны арваннэгдүгээр сарын 11, лхагва гараг 12:13:14 GMT+00:00   | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 оны арван хоёрдугаар сарын 11, баасан гараг 12:13:14 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`              |
| ------------------------ | ------------------ | ---------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | ойролцоогоор 6 жил | ойролцоогоор 6 жил     | ойролцоогоор 6 жилийн дараа    |
| 2005-01-01T00:00:00.000Z | ойролцоогоор 5 жил | ойролцоогоор 5 жил     | ойролцоогоор 5 жилийн дараа    |
| 2004-01-01T00:00:00.000Z | ойролцоогоор 4 жил | ойролцоогоор 4 жил     | ойролцоогоор 4 жилийн дараа    |
| 2003-01-01T00:00:00.000Z | ойролцоогоор 3 жил | ойролцоогоор 3 жил     | ойролцоогоор 3 жилийн дараа    |
| 2002-01-01T00:00:00.000Z | ойролцоогоор 2 жил | ойролцоогоор 2 жил     | ойролцоогоор 2 жилийн дараа    |
| 2001-06-01T00:00:00.000Z | 1 жил гаран        | 1 жил гаран            | 1 жил гараны дараа             |
| 2001-02-01T00:00:00.000Z | ойролцоогоор 1 жил | ойролцоогоор 1 жил     | ойролцоогоор 1 жилийн дараа    |
| 2001-01-01T00:00:00.000Z | ойролцоогоор 1 жил | ойролцоогоор 1 жил     | ойролцоогоор 1 жилийн дараа    |
| 2000-06-01T00:00:00.000Z | 5 сар              | 5 сар                  | 5 сарын дараа                  |
| 2000-03-01T00:00:00.000Z | 2 сар              | 2 сар                  | 2 сарын дараа                  |
| 2000-02-01T00:00:00.000Z | ойролцоогоор 1 сар | ойролцоогоор 1 сар     | ойролцоогоор 1 сарын дараа     |
| 2000-01-15T00:00:00.000Z | 14 өдөр            | 14 өдөр                | 14 өдрийн дараа                |
| 2000-01-02T00:00:00.000Z | 1 өдөр             | 1 өдөр                 | 1 өдрийн дараа                 |
| 2000-01-01T06:00:00.000Z | ойролцоогоор 6 цаг | ойролцоогоор 6 цаг     | ойролцоогоор 6 цагийн дараа    |
| 2000-01-01T01:00:00.000Z | ойролцоогоор 1 цаг | ойролцоогоор 1 цаг     | ойролцоогоор 1 цагийн дараа    |
| 2000-01-01T00:45:00.000Z | ойролцоогоор 1 цаг | ойролцоогоор 1 цаг     | ойролцоогоор 1 цагийн дараа    |
| 2000-01-01T00:30:00.000Z | 30 минут           | 30 минут               | 30 минутын дараа               |
| 2000-01-01T00:15:00.000Z | 15 минут           | 15 минут               | 15 минутын дараа               |
| 2000-01-01T00:01:00.000Z | 1 минут            | 1 минут                | 1 минутын дараа                |
| 2000-01-01T00:00:25.000Z | минут хүрэхгүй     | хагас минут            | минут хүрэхгүй хугацааны дараа |
| 2000-01-01T00:00:15.000Z | минут хүрэхгүй     | 20 секунд хүрэхгүй     | минут хүрэхгүй хугацааны дараа |
| 2000-01-01T00:00:05.000Z | минут хүрэхгүй     | 10 секунд хүрэхгүй     | минут хүрэхгүй хугацааны дараа |
| 2000-01-01T00:00:00.000Z | минут хүрэхгүй     | 5 секунд хүрэхгүй      | минут хүрэхгүй хугацааны өмнө  |
| 1999-12-31T23:59:55.000Z | минут хүрэхгүй     | 10 секунд хүрэхгүй     | минут хүрэхгүй хугацааны өмнө  |
| 1999-12-31T23:59:45.000Z | минут хүрэхгүй     | 20 секунд хүрэхгүй     | минут хүрэхгүй хугацааны өмнө  |
| 1999-12-31T23:59:35.000Z | минут хүрэхгүй     | хагас минут            | минут хүрэхгүй хугацааны өмнө  |
| 1999-12-31T23:59:00.000Z | 1 минут            | 1 минут                | 1 минутын өмнө                 |
| 1999-12-31T23:45:00.000Z | 15 минут           | 15 минут               | 15 минутын өмнө                |
| 1999-12-31T23:30:00.000Z | 30 минут           | 30 минут               | 30 минутын өмнө                |
| 1999-12-31T23:15:00.000Z | ойролцоогоор 1 цаг | ойролцоогоор 1 цаг     | ойролцоогоор 1 цагийн өмнө     |
| 1999-12-31T23:00:00.000Z | ойролцоогоор 1 цаг | ойролцоогоор 1 цаг     | ойролцоогоор 1 цагийн өмнө     |
| 1999-12-31T18:00:00.000Z | ойролцоогоор 6 цаг | ойролцоогоор 6 цаг     | ойролцоогоор 6 цагийн өмнө     |
| 1999-12-30T00:00:00.000Z | 2 өдөр             | 2 өдөр                 | 2 өдрийн өмнө                  |
| 1999-12-15T00:00:00.000Z | 17 өдөр            | 17 өдөр                | 17 өдрийн өмнө                 |
| 1999-12-01T00:00:00.000Z | ойролцоогоор 1 сар | ойролцоогоор 1 сар     | ойролцоогоор 1 сарын өмнө      |
| 1999-11-01T00:00:00.000Z | 2 сар              | 2 сар                  | 2 сарын өмнө                   |
| 1999-06-01T00:00:00.000Z | 7 сар              | 7 сар                  | 7 сарын өмнө                   |
| 1999-01-01T00:00:00.000Z | ойролцоогоор 1 жил | ойролцоогоор 1 жил     | ойролцоогоор 1 жилийн өмнө     |
| 1998-12-01T00:00:00.000Z | ойролцоогоор 1 жил | ойролцоогоор 1 жил     | ойролцоогоор 1 жилийн өмнө     |
| 1998-06-01T00:00:00.000Z | 1 жил гаран        | 1 жил гаран            | 1 жил гараны өмнө              |
| 1998-01-01T00:00:00.000Z | ойролцоогоор 2 жил | ойролцоогоор 2 жил     | ойролцоогоор 2 жилийн өмнө     |
| 1997-01-01T00:00:00.000Z | ойролцоогоор 3 жил | ойролцоогоор 3 жил     | ойролцоогоор 3 жилийн өмнө     |
| 1996-01-01T00:00:00.000Z | ойролцоогоор 4 жил | ойролцоогоор 4 жил     | ойролцоогоор 4 жилийн өмнө     |
| 1995-01-01T00:00:00.000Z | ойролцоогоор 5 жил | ойролцоогоор 5 жил     | ойролцоогоор 5 жилийн өмнө     |
| 1994-01-01T00:00:00.000Z | ойролцоогоор 6 жил | ойролцоогоор 6 жил     | ойролцоогоор 6 жилийн өмнө     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 жил     | 6 жилийн дараа     | 52608 цаг                      |
| 2005-01-01T00:00:00.000Z | 5 жил     | 5 жилийн дараа     | 43848 цаг                      |
| 2004-01-01T00:00:00.000Z | 4 жил     | 4 жилийн дараа     | 35064 цаг                      |
| 2003-01-01T00:00:00.000Z | 3 жил     | 3 жилийн дараа     | 26304 цаг                      |
| 2002-01-01T00:00:00.000Z | 2 жил     | 2 жилийн дараа     | 17544 цаг                      |
| 2001-06-01T00:00:00.000Z | 1 жил     | 1 жилийн дараа     | 12408 цаг                      |
| 2001-02-01T00:00:00.000Z | 1 жил     | 1 жилийн дараа     | 9528 цаг                       |
| 2001-01-01T00:00:00.000Z | 1 жил     | 1 жилийн дараа     | 8784 цаг                       |
| 2000-06-01T00:00:00.000Z | 5 сар     | 5 сарын дараа      | 3648 цаг                       |
| 2000-03-01T00:00:00.000Z | 2 сар     | 2 сарын дараа      | 1440 цаг                       |
| 2000-02-01T00:00:00.000Z | 1 сар     | 1 сарын дараа      | 744 цаг                        |
| 2000-01-15T00:00:00.000Z | 14 өдөр   | 14 өдрийн дараа    | 336 цаг                        |
| 2000-01-02T00:00:00.000Z | 1 өдөр    | 1 өдрийн дараа     | 24 цаг                         |
| 2000-01-01T06:00:00.000Z | 6 цаг     | 6 цагийн дараа     | 6 цаг                          |
| 2000-01-01T01:00:00.000Z | 1 цаг     | 1 цагийн дараа     | 1 цаг                          |
| 2000-01-01T00:45:00.000Z | 45 минут  | 45 минутын дараа   | 1 цаг                          |
| 2000-01-01T00:30:00.000Z | 30 минут  | 30 минутын дараа   | 1 цаг                          |
| 2000-01-01T00:15:00.000Z | 15 минут  | 15 минутын дараа   | 0 цаг                          |
| 2000-01-01T00:01:00.000Z | 1 минут   | 1 минутын дараа    | 0 цаг                          |
| 2000-01-01T00:00:25.000Z | 25 секунд | 25 секундийн дараа | 0 цаг                          |
| 2000-01-01T00:00:15.000Z | 15 секунд | 15 секундийн дараа | 0 цаг                          |
| 2000-01-01T00:00:05.000Z | 5 секунд  | 5 секундийн дараа  | 0 цаг                          |
| 2000-01-01T00:00:00.000Z | 0 секунд  | 0 секундийн өмнө   | 0 цаг                          |
| 1999-12-31T23:59:55.000Z | 5 секунд  | 5 секундийн өмнө   | 0 цаг                          |
| 1999-12-31T23:59:45.000Z | 15 секунд | 15 секундийн өмнө  | 0 цаг                          |
| 1999-12-31T23:59:35.000Z | 25 секунд | 25 секундийн өмнө  | 0 цаг                          |
| 1999-12-31T23:59:00.000Z | 1 минут   | 1 минутын өмнө     | 0 цаг                          |
| 1999-12-31T23:45:00.000Z | 15 минут  | 15 минутын өмнө    | 0 цаг                          |
| 1999-12-31T23:30:00.000Z | 30 минут  | 30 минутын өмнө    | 1 цаг                          |
| 1999-12-31T23:15:00.000Z | 45 минут  | 45 минутын өмнө    | 1 цаг                          |
| 1999-12-31T23:00:00.000Z | 1 цаг     | 1 цагийн өмнө      | 1 цаг                          |
| 1999-12-31T18:00:00.000Z | 6 цаг     | 6 цагийн өмнө      | 6 цаг                          |
| 1999-12-30T00:00:00.000Z | 2 өдөр    | 2 өдрийн өмнө      | 48 цаг                         |
| 1999-12-15T00:00:00.000Z | 17 өдөр   | 17 өдрийн өмнө     | 408 цаг                        |
| 1999-12-01T00:00:00.000Z | 1 сар     | 1 сарын өмнө       | 744 цаг                        |
| 1999-11-01T00:00:00.000Z | 2 сар     | 2 сарын өмнө       | 1464 цаг                       |
| 1999-06-01T00:00:00.000Z | 7 сар     | 7 сарын өмнө       | 5136 цаг                       |
| 1999-01-01T00:00:00.000Z | 1 жил     | 1 жилийн өмнө      | 8760 цаг                       |
| 1998-12-01T00:00:00.000Z | 1 жил     | 1 жилийн өмнө      | 9504 цаг                       |
| 1998-06-01T00:00:00.000Z | 2 жил     | 2 жилийн өмнө      | 13896 цаг                      |
| 1998-01-01T00:00:00.000Z | 2 жил     | 2 жилийн өмнө      | 17520 цаг                      |
| 1997-01-01T00:00:00.000Z | 3 жил     | 3 жилийн өмнө      | 26280 цаг                      |
| 1996-01-01T00:00:00.000Z | 4 жил     | 4 жилийн өмнө      | 35064 цаг                      |
| 1995-01-01T00:00:00.000Z | 5 жил     | 5 жилийн өмнө      | 43824 цаг                      |
| 1994-01-01T00:00:00.000Z | 6 жил     | 6 жилийн өмнө      | 52584 цаг                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                            |
| ------------------------ | --------------------------------- |
| 2000-01-10T00:00:00.000Z | 2000.01.10                        |
| 2000-01-05T00:00:00.000Z | ирэх лхагва гарагийн 0:00 цагт    |
| 2000-01-02T00:00:00.000Z | маргааш 0:00 цагт                 |
| 2000-01-01T00:00:00.000Z | өнөөдөр 0:00 цагт                 |
| 1999-12-31T00:00:00.000Z | өчигдөр 0:00 цагт                 |
| 1999-12-27T00:00:00.000Z | өнгөрсөн даваа гарагийн 0:00 цагт |
| 1999-12-21T00:00:00.000Z | 1999.12.21                        |

## `formatDuration`

| Duration      | Result        |
| ------------- | ------------- |
| {"years":0}   | 0 жил         |
| {"years":1}   | 1 жил         |
| {"years":2}   | 2 жил         |
| {"months":0}  | 0 сар         |
| {"months":1}  | 1 сар         |
| {"months":2}  | 2 сар         |
| {"weeks":0}   | 0 долоо хоног |
| {"weeks":1}   | 1 долоо хоног |
| {"weeks":2}   | 2 долоо хоног |
| {"days":0}    | 0 өдөр        |
| {"days":1}    | 1 өдөр        |
| {"days":2}    | 2 өдөр        |
| {"hours":0}   | 0 цаг         |
| {"hours":1}   | 1 цаг         |
| {"hours":2}   | 2 цаг         |
| {"minutes":0} | 0 минут       |
| {"minutes":1} | 1 минут       |
| {"minutes":2} | 2 минут       |
| {"seconds":0} | 0 секунд      |
| {"seconds":1} | 1 секунд      |
| {"seconds":2} | 2 секунд      |
