# Norwegian Bokmål (nb) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                                | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                   | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                                | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                                   | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. kvartal                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. kvartal                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartal                                           | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1.                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                  | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | jan.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                                 | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | januar                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februar                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | august                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | september                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | november                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desember                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                    | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1.                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                  | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | jan.                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | des.                                                 | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | januar                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februar                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | august                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | september                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | november                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | desember                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                    | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                  | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                  | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1.                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11.                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                  | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1. februar                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11. februar                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28. februar                                          | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                                 | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | mandag                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ma                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | mandag                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ma                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | mandag                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ma                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | man                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | mandag                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                    | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ma                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                    | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                    | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | på morg.                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                            | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | på morg.                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | på morg.                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | på morgenen                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | på ettermiddagen                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | på morg.                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på etterm.                                           | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvelden                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                            | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                  | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                  | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                   | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                  | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                   | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                  | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987                                           | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987                                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987                                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                           | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987                                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987                                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987                                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987                                           | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987                                           | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11. jan. 1987                                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. feb. 1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. mars 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. apr. 1987                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. juni 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. juli 1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. aug. 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. sep. 1987                                        | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. okt. 1987                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. nov. 1987                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. des. 1987                                        | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11. januar 1987                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. februar 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. mars 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. april 1987                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. juni 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. juli 1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. august 1987                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. september 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. oktober 1987                                     | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. november 1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. desember 1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | søndag 11. januar 1987                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | onsdag 11. februar 1987                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | onsdag 11. mars 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | lørdag 11. april 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | søndag 29. mai 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | torsdag 11. juni 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | lørdag 11. juli 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | tirsdag 11. august 1987                              | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | fredag 11. september 1987                            | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | søndag 11. oktober 1987                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | onsdag 11. november 1987                             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | fredag 11. desember 1987                             | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                             | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | kl. 23:59:59 GMT+00:00                               | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                               | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987 12:13                                     | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987 12:13                                     | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987 12:13                                     | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987 12:13                                     | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453 23:59                                     | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987 12:13                                     | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987 12:13                                     | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987 12:13                                     | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987 12:13                                     | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987 12:13                                     | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987 12:13                                     | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987 12:13                                     | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11. jan. 1987 12:13:14                               | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. feb. 1987 12:13:14                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. mars 1987 12:13:14                               | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. apr. 1987 12:13:14                               | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453 23:59:59                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. juni 1987 12:13:14                               | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. juli 1987 12:13:14                               | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. aug. 1987 12:13:14                               | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. sep. 1987 12:13:14                               | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. okt. 1987 12:13:14                               | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. nov. 1987 12:13:14                               | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. des. 1987 12:13:14                               | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11. januar 1987 kl. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11. februar 1987 kl. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11. mars 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11. april 1987 kl. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. mai 1453 kl. 23:59:59 GMT+0                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11. juni 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11. juli 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11. august 1987 kl. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11. september 1987 kl. 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11. oktober 1987 kl. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11. november 1987 kl. 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11. desember 1987 kl. 12:13:14 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | søndag 11. januar 1987 kl. kl. 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | onsdag 11. februar 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | onsdag 11. mars 1987 kl. kl. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | lørdag 11. april 1987 kl. kl. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | søndag 29. mai 1453 kl. kl. 23:59:59 GMT+00:00       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | torsdag 11. juni 1987 kl. kl. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | lørdag 11. juli 1987 kl. kl. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | tirsdag 11. august 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | fredag 11. september 1987 kl. kl. 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | søndag 11. oktober 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | onsdag 11. november 1987 kl. kl. 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | fredag 11. desember 1987 kl. kl. 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                | `includeSeconds: true` | `addSuffix: true`           |
| ------------------------ | --------------------- | ---------------------- | --------------------------- |
| 2006-01-01T00:00:00.000Z | omtrent 6 år          | omtrent 6 år           | om omtrent 6 år             |
| 2005-01-01T00:00:00.000Z | omtrent 5 år          | omtrent 5 år           | om omtrent 5 år             |
| 2004-01-01T00:00:00.000Z | omtrent 4 år          | omtrent 4 år           | om omtrent 4 år             |
| 2003-01-01T00:00:00.000Z | omtrent 3 år          | omtrent 3 år           | om omtrent 3 år             |
| 2002-01-01T00:00:00.000Z | omtrent 2 år          | omtrent 2 år           | om omtrent 2 år             |
| 2001-06-01T00:00:00.000Z | over ett år           | over ett år            | om over ett år              |
| 2001-02-01T00:00:00.000Z | omtrent ett år        | omtrent ett år         | om omtrent ett år           |
| 2001-01-01T00:00:00.000Z | omtrent ett år        | omtrent ett år         | om omtrent ett år           |
| 2000-06-01T00:00:00.000Z | 5 måneder             | 5 måneder              | om 5 måneder                |
| 2000-03-01T00:00:00.000Z | 2 måneder             | 2 måneder              | om 2 måneder                |
| 2000-02-01T00:00:00.000Z | omtrent en måned      | omtrent en måned       | om omtrent en måned         |
| 2000-01-15T00:00:00.000Z | 14 dager              | 14 dager               | om 14 dager                 |
| 2000-01-02T00:00:00.000Z | en dag                | en dag                 | om en dag                   |
| 2000-01-01T06:00:00.000Z | omtrent 6 timer       | omtrent 6 timer        | om omtrent 6 timer          |
| 2000-01-01T01:00:00.000Z | omtrent en time       | omtrent en time        | om omtrent en time          |
| 2000-01-01T00:45:00.000Z | omtrent en time       | omtrent en time        | om omtrent en time          |
| 2000-01-01T00:30:00.000Z | 30 minutter           | 30 minutter            | om 30 minutter              |
| 2000-01-01T00:15:00.000Z | 15 minutter           | 15 minutter            | om 15 minutter              |
| 2000-01-01T00:01:00.000Z | ett minutt            | ett minutt             | om ett minutt               |
| 2000-01-01T00:00:25.000Z | mindre enn ett minutt | et halvt minutt        | om mindre enn ett minutt    |
| 2000-01-01T00:00:15.000Z | mindre enn ett minutt | mindre enn 20 sekunder | om mindre enn ett minutt    |
| 2000-01-01T00:00:05.000Z | mindre enn ett minutt | mindre enn 10 sekunder | om mindre enn ett minutt    |
| 2000-01-01T00:00:00.000Z | mindre enn ett minutt | mindre enn 5 sekunder  | mindre enn ett minutt siden |
| 1999-12-31T23:59:55.000Z | mindre enn ett minutt | mindre enn 10 sekunder | mindre enn ett minutt siden |
| 1999-12-31T23:59:45.000Z | mindre enn ett minutt | mindre enn 20 sekunder | mindre enn ett minutt siden |
| 1999-12-31T23:59:35.000Z | mindre enn ett minutt | et halvt minutt        | mindre enn ett minutt siden |
| 1999-12-31T23:59:00.000Z | ett minutt            | ett minutt             | ett minutt siden            |
| 1999-12-31T23:45:00.000Z | 15 minutter           | 15 minutter            | 15 minutter siden           |
| 1999-12-31T23:30:00.000Z | 30 minutter           | 30 minutter            | 30 minutter siden           |
| 1999-12-31T23:15:00.000Z | omtrent en time       | omtrent en time        | omtrent en time siden       |
| 1999-12-31T23:00:00.000Z | omtrent en time       | omtrent en time        | omtrent en time siden       |
| 1999-12-31T18:00:00.000Z | omtrent 6 timer       | omtrent 6 timer        | omtrent 6 timer siden       |
| 1999-12-30T00:00:00.000Z | 2 dager               | 2 dager                | 2 dager siden               |
| 1999-12-15T00:00:00.000Z | 17 dager              | 17 dager               | 17 dager siden              |
| 1999-12-01T00:00:00.000Z | omtrent en måned      | omtrent en måned       | omtrent en måned siden      |
| 1999-11-01T00:00:00.000Z | 2 måneder             | 2 måneder              | 2 måneder siden             |
| 1999-06-01T00:00:00.000Z | 7 måneder             | 7 måneder              | 7 måneder siden             |
| 1999-01-01T00:00:00.000Z | omtrent ett år        | omtrent ett år         | omtrent ett år siden        |
| 1998-12-01T00:00:00.000Z | omtrent ett år        | omtrent ett år         | omtrent ett år siden        |
| 1998-06-01T00:00:00.000Z | over ett år           | over ett år            | over ett år siden           |
| 1998-01-01T00:00:00.000Z | omtrent 2 år          | omtrent 2 år           | omtrent 2 år siden          |
| 1997-01-01T00:00:00.000Z | omtrent 3 år          | omtrent 3 år           | omtrent 3 år siden          |
| 1996-01-01T00:00:00.000Z | omtrent 4 år          | omtrent 4 år           | omtrent 4 år siden          |
| 1995-01-01T00:00:00.000Z | omtrent 5 år          | omtrent 5 år           | omtrent 5 år siden          |
| 1994-01-01T00:00:00.000Z | omtrent 6 år          | omtrent 6 år           | omtrent 6 år siden          |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 år        | om 6 år           | 52608 timer                    |
| 2005-01-01T00:00:00.000Z | 5 år        | om 5 år           | 43848 timer                    |
| 2004-01-01T00:00:00.000Z | 4 år        | om 4 år           | 35064 timer                    |
| 2003-01-01T00:00:00.000Z | 3 år        | om 3 år           | 26304 timer                    |
| 2002-01-01T00:00:00.000Z | 2 år        | om 2 år           | 17544 timer                    |
| 2001-06-01T00:00:00.000Z | ett år      | om ett år         | 12408 timer                    |
| 2001-02-01T00:00:00.000Z | ett år      | om ett år         | 9528 timer                     |
| 2001-01-01T00:00:00.000Z | ett år      | om ett år         | 8784 timer                     |
| 2000-06-01T00:00:00.000Z | 5 måneder   | om 5 måneder      | 3648 timer                     |
| 2000-03-01T00:00:00.000Z | 2 måneder   | om 2 måneder      | 1440 timer                     |
| 2000-02-01T00:00:00.000Z | en måned    | om en måned       | 744 timer                      |
| 2000-01-15T00:00:00.000Z | 14 dager    | om 14 dager       | 336 timer                      |
| 2000-01-02T00:00:00.000Z | en dag      | om en dag         | 24 timer                       |
| 2000-01-01T06:00:00.000Z | 6 timer     | om 6 timer        | 6 timer                        |
| 2000-01-01T01:00:00.000Z | en time     | om en time        | en time                        |
| 2000-01-01T00:45:00.000Z | 45 minutter | om 45 minutter    | en time                        |
| 2000-01-01T00:30:00.000Z | 30 minutter | om 30 minutter    | en time                        |
| 2000-01-01T00:15:00.000Z | 15 minutter | om 15 minutter    | 0 timer                        |
| 2000-01-01T00:01:00.000Z | ett minutt  | om ett minutt     | 0 timer                        |
| 2000-01-01T00:00:25.000Z | 25 sekunder | om 25 sekunder    | 0 timer                        |
| 2000-01-01T00:00:15.000Z | 15 sekunder | om 15 sekunder    | 0 timer                        |
| 2000-01-01T00:00:05.000Z | 5 sekunder  | om 5 sekunder     | 0 timer                        |
| 2000-01-01T00:00:00.000Z | 0 sekunder  | 0 sekunder siden  | 0 timer                        |
| 1999-12-31T23:59:55.000Z | 5 sekunder  | 5 sekunder siden  | 0 timer                        |
| 1999-12-31T23:59:45.000Z | 15 sekunder | 15 sekunder siden | 0 timer                        |
| 1999-12-31T23:59:35.000Z | 25 sekunder | 25 sekunder siden | 0 timer                        |
| 1999-12-31T23:59:00.000Z | ett minutt  | ett minutt siden  | 0 timer                        |
| 1999-12-31T23:45:00.000Z | 15 minutter | 15 minutter siden | 0 timer                        |
| 1999-12-31T23:30:00.000Z | 30 minutter | 30 minutter siden | en time                        |
| 1999-12-31T23:15:00.000Z | 45 minutter | 45 minutter siden | en time                        |
| 1999-12-31T23:00:00.000Z | en time     | en time siden     | en time                        |
| 1999-12-31T18:00:00.000Z | 6 timer     | 6 timer siden     | 6 timer                        |
| 1999-12-30T00:00:00.000Z | 2 dager     | 2 dager siden     | 48 timer                       |
| 1999-12-15T00:00:00.000Z | 17 dager    | 17 dager siden    | 408 timer                      |
| 1999-12-01T00:00:00.000Z | en måned    | en måned siden    | 744 timer                      |
| 1999-11-01T00:00:00.000Z | 2 måneder   | 2 måneder siden   | 1464 timer                     |
| 1999-06-01T00:00:00.000Z | 7 måneder   | 7 måneder siden   | 5136 timer                     |
| 1999-01-01T00:00:00.000Z | ett år      | ett år siden      | 8760 timer                     |
| 1998-12-01T00:00:00.000Z | ett år      | ett år siden      | 9504 timer                     |
| 1998-06-01T00:00:00.000Z | 2 år        | 2 år siden        | 13896 timer                    |
| 1998-01-01T00:00:00.000Z | 2 år        | 2 år siden        | 17520 timer                    |
| 1997-01-01T00:00:00.000Z | 3 år        | 3 år siden        | 26280 timer                    |
| 1996-01-01T00:00:00.000Z | 4 år        | 4 år siden        | 35064 timer                    |
| 1995-01-01T00:00:00.000Z | 5 år        | 5 år siden        | 43824 timer                    |
| 1994-01-01T00:00:00.000Z | 6 år        | 6 år siden        | 52584 timer                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | onsdag kl. 00:00         |
| 2000-01-02T00:00:00.000Z | i morgen kl. 00:00       |
| 2000-01-01T00:00:00.000Z | i dag kl. 00:00          |
| 1999-12-31T00:00:00.000Z | i går kl. 00:00          |
| 1999-12-27T00:00:00.000Z | forrige mandag kl. 00:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 år       |
| {"years":1}   | ett år     |
| {"years":2}   | 2 år       |
| {"months":0}  | 0 måneder  |
| {"months":1}  | en måned   |
| {"months":2}  | 2 måneder  |
| {"weeks":0}   | 0 uker     |
| {"weeks":1}   | en uke     |
| {"weeks":2}   | 2 uker     |
| {"days":0}    | 0 dager    |
| {"days":1}    | en dag     |
| {"days":2}    | 2 dager    |
| {"hours":0}   | 0 timer    |
| {"hours":1}   | en time    |
| {"hours":2}   | 2 timer    |
| {"minutes":0} | 0 minutter |
| {"minutes":1} | ett minutt |
| {"minutes":2} | 2 minutter |
| {"seconds":0} | 0 sekunder |
| {"seconds":1} | ett sekund |
| {"seconds":2} | 2 sekunder |
