# Occitan (oc) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ena                                            | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ena                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ena                                            | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4ena                                               | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1èr                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1èr trim.                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd trim.                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1èr trimèstre                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd trimèstre                                      | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | T1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1èr                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1èr trim.                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd trim.                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1èr trimèstre                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2nd trimèstre                                      | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1èr                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2nd                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3en                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4en                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5en                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6en                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7en                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8en                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9en                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10en                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11en                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12en                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | gen.                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febr.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | març                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | abr.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | junh                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ag.                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | set.                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oct.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | genièr                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febrièr                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | març                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | abril                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | junh                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julhet                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | agost                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | setembre                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | octòbre                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembre                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | decembre                                           | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | GN                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | FB                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | MÇ                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | AB                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | MA                                                 | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | JN                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | JL                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | AG                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ST                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | OC                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | NV                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | DC                                                 | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1èr                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2nd                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3en                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4en                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5en                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6en                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7en                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8en                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9en                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10en                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11en                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12en                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | gen.                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febr.                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | març                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | abr.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | junh                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ag.                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | set.                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oct.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | genièr                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febrièr                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | març                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | abril                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mai                                                | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | junh                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julhet                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | agost                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | setembre                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | octòbre                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembre                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | decembre                                           | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | GN                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | FB                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | MÇ                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | AB                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | MA                                                 | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | JN                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | JL                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | AG                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ST                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | OC                                                 | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | NV                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | DC                                                 | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1èra                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ena                                              | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1èra                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ena                                              | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1èr                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11en                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28en                                               | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1èr febrièr                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11en febrièr                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28en febrièr                                       | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42en                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365en                                              | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | diluns                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | divendres                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1èr                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5en                                                | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | diluns                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | divendres                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1èr                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5en                                                | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | diluns                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | divendres                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1èr                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5en                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | diluns                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | divendres                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | dl.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | dv.                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ante meridiem                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | post meridiem                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | post meridiem                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ante meridiem                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ante meridiem                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | post meridiem                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | post meridiem                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ante meridiem                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | del matin                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’aprèp-miègjorn                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | del ser                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la nuèch                                        | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | del matin                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’aprèp-miègjorn                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | del ser                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la nuèch                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | del matin                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’aprèp-miègjorn                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | del ser                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la nuèch                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | del matin                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’aprèp-miègjorn                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | del ser                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la nuèch                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | del matin                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’aprèp-miègjorn                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | del ser                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la nuèch                                        | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11ena                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ena                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11ena                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ena                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11ena                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ena                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11ena                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ena                                              | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1èra                                               | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ena                                              | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1èra                                               | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55ena                                              | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                         | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 gen. 1987                                       | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febr. 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 març 1987                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 abr. 1987                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 junh 1987                                       | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jul. 1987                                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ag. 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 set. 1987                                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oct. 1987                                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987                                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dec. 1987                                       | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 de genièr 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 de febrièr 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 de març 1987                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 de abril 1987                                   | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mai 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 de junh 1987                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 de julhet 1987                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 de agost 1987                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 de setembre 1987                                | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 de octòbre 1987                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 de novembre 1987                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 de decembre 1987                                | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | dimenge 11 de genièr 1987                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | dimècres 11 de febrièr 1987                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | dimècres 11 de març 1987                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | dissabte 11 de abril 1987                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | dimenge 29 de mai 1453                             | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | dijòus 11 de junh 1987                             | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | dissabte 11 de julhet 1987                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | dimars 11 de agost 1987                            | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | divendres 11 de setembre 1987                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | dimenge 11 de octòbre 1987                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | dimècres 11 de novembre 1987                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | divendres 11 de decembre 1987                      | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                              | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                              | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                              | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                              | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                              | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                              | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                              | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                              | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                              | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                              | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                              | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                           | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                           | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                           | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                           | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                     | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                 | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13                                  | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13                                  | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13                                  | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                  | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13                                  | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13                                  | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13                                  | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13                                  | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13                                  | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13                                  | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13                                  | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 gen. 1987, 12:13:14                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febr. 1987, 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 març 1987, 12:13:14                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 abr. 1987, 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453, 23:59:59                              | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 junh 1987, 12:13:14                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 jul. 1987, 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ag. 1987, 12:13:14                              | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 set. 1987, 12:13:14                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oct. 1987, 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987, 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dec. 1987, 12:13:14                             | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 de genièr 1987 a 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 de febrièr 1987 a 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 de març 1987 a 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 de abril 1987 a 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mai 1453 a 23:59:59 GMT+0                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 de junh 1987 a 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 de julhet 1987 a 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 de agost 1987 a 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 de setembre 1987 a 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 de octòbre 1987 a 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 de novembre 1987 a 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 de decembre 1987 a 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | dimenge 11 de genièr 1987 a 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | dimècres 11 de febrièr 1987 a 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | dimècres 11 de març 1987 a 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | dissabte 11 de abril 1987 a 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dimenge 29 de mai 1453 a 23:59:59 GMT+00:00        | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | dijòus 11 de junh 1987 a 12:13:14 GMT+00:00        | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | dissabte 11 de julhet 1987 a 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | dimars 11 de agost 1987 a 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | divendres 11 de setembre 1987 a 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | dimenge 11 de octòbre 1987 a 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | dimècres 11 de novembre 1987 a 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | divendres 11 de decembre 1987 a 12:13:14 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ----------------- | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | environ 6 ans     | environ 6 ans          | d’aquí environ 6 ans     |
| 2005-01-01T00:00:00.000Z | environ 5 ans     | environ 5 ans          | d’aquí environ 5 ans     |
| 2004-01-01T00:00:00.000Z | environ 4 ans     | environ 4 ans          | d’aquí environ 4 ans     |
| 2003-01-01T00:00:00.000Z | environ 3 ans     | environ 3 ans          | d’aquí environ 3 ans     |
| 2002-01-01T00:00:00.000Z | environ 2 ans     | environ 2 ans          | d’aquí environ 2 ans     |
| 2001-06-01T00:00:00.000Z | mai d’un an       | mai d’un an            | d’aquí mai d’un an       |
| 2001-02-01T00:00:00.000Z | environ 1 an      | environ 1 an           | d’aquí environ 1 an      |
| 2001-01-01T00:00:00.000Z | environ 1 an      | environ 1 an           | d’aquí environ 1 an      |
| 2000-06-01T00:00:00.000Z | 5 meses           | 5 meses                | d’aquí 5 meses           |
| 2000-03-01T00:00:00.000Z | 2 meses           | 2 meses                | d’aquí 2 meses           |
| 2000-02-01T00:00:00.000Z | environ 1 mes     | environ 1 mes          | d’aquí environ 1 mes     |
| 2000-01-15T00:00:00.000Z | 14 jorns          | 14 jorns               | d’aquí 14 jorns          |
| 2000-01-02T00:00:00.000Z | 1 jorn            | 1 jorn                 | d’aquí 1 jorn            |
| 2000-01-01T06:00:00.000Z | environ 6 oras    | environ 6 oras         | d’aquí environ 6 oras    |
| 2000-01-01T01:00:00.000Z | environ 1 ora     | environ 1 ora          | d’aquí environ 1 ora     |
| 2000-01-01T00:45:00.000Z | environ 1 ora     | environ 1 ora          | d’aquí environ 1 ora     |
| 2000-01-01T00:30:00.000Z | 30 minutas        | 30 minutas             | d’aquí 30 minutas        |
| 2000-01-01T00:15:00.000Z | 15 minutas        | 15 minutas             | d’aquí 15 minutas        |
| 2000-01-01T00:01:00.000Z | 1 minuta          | 1 minuta               | d’aquí 1 minuta          |
| 2000-01-01T00:00:25.000Z | mens d’una minuta | 30 segondas            | d’aquí mens d’una minuta |
| 2000-01-01T00:00:15.000Z | mens d’una minuta | mens de 20 segondas    | d’aquí mens d’una minuta |
| 2000-01-01T00:00:05.000Z | mens d’una minuta | mens de 10 segondas    | d’aquí mens d’una minuta |
| 2000-01-01T00:00:00.000Z | mens d’una minuta | mens de 5 segondas     | fa mens d’una minuta     |
| 1999-12-31T23:59:55.000Z | mens d’una minuta | mens de 10 segondas    | fa mens d’una minuta     |
| 1999-12-31T23:59:45.000Z | mens d’una minuta | mens de 20 segondas    | fa mens d’una minuta     |
| 1999-12-31T23:59:35.000Z | mens d’una minuta | 30 segondas            | fa mens d’una minuta     |
| 1999-12-31T23:59:00.000Z | 1 minuta          | 1 minuta               | fa 1 minuta              |
| 1999-12-31T23:45:00.000Z | 15 minutas        | 15 minutas             | fa 15 minutas            |
| 1999-12-31T23:30:00.000Z | 30 minutas        | 30 minutas             | fa 30 minutas            |
| 1999-12-31T23:15:00.000Z | environ 1 ora     | environ 1 ora          | fa environ 1 ora         |
| 1999-12-31T23:00:00.000Z | environ 1 ora     | environ 1 ora          | fa environ 1 ora         |
| 1999-12-31T18:00:00.000Z | environ 6 oras    | environ 6 oras         | fa environ 6 oras        |
| 1999-12-30T00:00:00.000Z | 2 jorns           | 2 jorns                | fa 2 jorns               |
| 1999-12-15T00:00:00.000Z | 17 jorns          | 17 jorns               | fa 17 jorns              |
| 1999-12-01T00:00:00.000Z | environ 1 mes     | environ 1 mes          | fa environ 1 mes         |
| 1999-11-01T00:00:00.000Z | 2 meses           | 2 meses                | fa 2 meses               |
| 1999-06-01T00:00:00.000Z | 7 meses           | 7 meses                | fa 7 meses               |
| 1999-01-01T00:00:00.000Z | environ 1 an      | environ 1 an           | fa environ 1 an          |
| 1998-12-01T00:00:00.000Z | environ 1 an      | environ 1 an           | fa environ 1 an          |
| 1998-06-01T00:00:00.000Z | mai d’un an       | mai d’un an            | fa mai d’un an           |
| 1998-01-01T00:00:00.000Z | environ 2 ans     | environ 2 ans          | fa environ 2 ans         |
| 1997-01-01T00:00:00.000Z | environ 3 ans     | environ 3 ans          | fa environ 3 ans         |
| 1996-01-01T00:00:00.000Z | environ 4 ans     | environ 4 ans          | fa environ 4 ans         |
| 1995-01-01T00:00:00.000Z | environ 5 ans     | environ 5 ans          | fa environ 5 ans         |
| 1994-01-01T00:00:00.000Z | environ 6 ans     | environ 6 ans          | fa environ 6 ans         |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ans       | d’aquí 6 ans       | 52608 oras                     |
| 2005-01-01T00:00:00.000Z | 5 ans       | d’aquí 5 ans       | 43848 oras                     |
| 2004-01-01T00:00:00.000Z | 4 ans       | d’aquí 4 ans       | 35064 oras                     |
| 2003-01-01T00:00:00.000Z | 3 ans       | d’aquí 3 ans       | 26304 oras                     |
| 2002-01-01T00:00:00.000Z | 2 ans       | d’aquí 2 ans       | 17544 oras                     |
| 2001-06-01T00:00:00.000Z | 1 an        | d’aquí 1 an        | 12408 oras                     |
| 2001-02-01T00:00:00.000Z | 1 an        | d’aquí 1 an        | 9528 oras                      |
| 2001-01-01T00:00:00.000Z | 1 an        | d’aquí 1 an        | 8784 oras                      |
| 2000-06-01T00:00:00.000Z | 5 meses     | d’aquí 5 meses     | 3648 oras                      |
| 2000-03-01T00:00:00.000Z | 2 meses     | d’aquí 2 meses     | 1440 oras                      |
| 2000-02-01T00:00:00.000Z | 1 mes       | d’aquí 1 mes       | 744 oras                       |
| 2000-01-15T00:00:00.000Z | 14 jorns    | d’aquí 14 jorns    | 336 oras                       |
| 2000-01-02T00:00:00.000Z | 1 jorn      | d’aquí 1 jorn      | 24 oras                        |
| 2000-01-01T06:00:00.000Z | 6 oras      | d’aquí 6 oras      | 6 oras                         |
| 2000-01-01T01:00:00.000Z | 1 ora       | d’aquí 1 ora       | 1 ora                          |
| 2000-01-01T00:45:00.000Z | 45 minutas  | d’aquí 45 minutas  | 1 ora                          |
| 2000-01-01T00:30:00.000Z | 30 minutas  | d’aquí 30 minutas  | 1 ora                          |
| 2000-01-01T00:15:00.000Z | 15 minutas  | d’aquí 15 minutas  | 0 oras                         |
| 2000-01-01T00:01:00.000Z | 1 minuta    | d’aquí 1 minuta    | 0 oras                         |
| 2000-01-01T00:00:25.000Z | 25 segondas | d’aquí 25 segondas | 0 oras                         |
| 2000-01-01T00:00:15.000Z | 15 segondas | d’aquí 15 segondas | 0 oras                         |
| 2000-01-01T00:00:05.000Z | 5 segondas  | d’aquí 5 segondas  | 0 oras                         |
| 2000-01-01T00:00:00.000Z | 0 segondas  | fa 0 segondas      | 0 oras                         |
| 1999-12-31T23:59:55.000Z | 5 segondas  | fa 5 segondas      | 0 oras                         |
| 1999-12-31T23:59:45.000Z | 15 segondas | fa 15 segondas     | 0 oras                         |
| 1999-12-31T23:59:35.000Z | 25 segondas | fa 25 segondas     | 0 oras                         |
| 1999-12-31T23:59:00.000Z | 1 minuta    | fa 1 minuta        | 0 oras                         |
| 1999-12-31T23:45:00.000Z | 15 minutas  | fa 15 minutas      | 0 oras                         |
| 1999-12-31T23:30:00.000Z | 30 minutas  | fa 30 minutas      | 1 ora                          |
| 1999-12-31T23:15:00.000Z | 45 minutas  | fa 45 minutas      | 1 ora                          |
| 1999-12-31T23:00:00.000Z | 1 ora       | fa 1 ora           | 1 ora                          |
| 1999-12-31T18:00:00.000Z | 6 oras      | fa 6 oras          | 6 oras                         |
| 1999-12-30T00:00:00.000Z | 2 jorns     | fa 2 jorns         | 48 oras                        |
| 1999-12-15T00:00:00.000Z | 17 jorns    | fa 17 jorns        | 408 oras                       |
| 1999-12-01T00:00:00.000Z | 1 mes       | fa 1 mes           | 744 oras                       |
| 1999-11-01T00:00:00.000Z | 2 meses     | fa 2 meses         | 1464 oras                      |
| 1999-06-01T00:00:00.000Z | 7 meses     | fa 7 meses         | 5136 oras                      |
| 1999-01-01T00:00:00.000Z | 1 an        | fa 1 an            | 8760 oras                      |
| 1998-12-01T00:00:00.000Z | 1 an        | fa 1 an            | 9504 oras                      |
| 1998-06-01T00:00:00.000Z | 2 ans       | fa 2 ans           | 13896 oras                     |
| 1998-01-01T00:00:00.000Z | 2 ans       | fa 2 ans           | 17520 oras                     |
| 1997-01-01T00:00:00.000Z | 3 ans       | fa 3 ans           | 26280 oras                     |
| 1996-01-01T00:00:00.000Z | 4 ans       | fa 4 ans           | 35064 oras                     |
| 1995-01-01T00:00:00.000Z | 5 ans       | fa 5 ans           | 43824 oras                     |
| 1994-01-01T00:00:00.000Z | 6 ans       | fa 6 ans           | 52584 oras                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                |
| ------------------------ | --------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000            |
| 2000-01-05T00:00:00.000Z | dimècres a 00:00      |
| 2000-01-02T00:00:00.000Z | deman a 00:00         |
| 2000-01-01T00:00:00.000Z | uèi a 00:00           |
| 1999-12-31T00:00:00.000Z | ièr a 00:00           |
| 1999-12-27T00:00:00.000Z | diluns passat a 00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999            |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 ans      |
| {"years":1}   | 1 an       |
| {"years":2}   | 2 ans      |
| {"months":0}  | 0 meses    |
| {"months":1}  | 1 mes      |
| {"months":2}  | 2 meses    |
| {"weeks":0}   | 0 setmanas |
| {"weeks":1}   | 1 setmana  |
| {"weeks":2}   | 2 setmanas |
| {"days":0}    | 0 jorns    |
| {"days":1}    | 1 jorn     |
| {"days":2}    | 2 jorns    |
| {"hours":0}   | 0 oras     |
| {"hours":1}   | 1 ora      |
| {"hours":2}   | 2 oras     |
| {"minutes":0} | 0 minutas  |
| {"minutes":1} | 1 minuta   |
| {"minutes":2} | 2 minutas  |
| {"seconds":0} | 0 segondas |
| {"seconds":1} | 1 segonda  |
| {"seconds":2} | 2 segondas |
