# Shqip (sq) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-të                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-të                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-të                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-të                                                 | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-rë                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-të                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 4-mujori I                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 4-mujori II                                          | 2019-10-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-rë                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-të                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 4-mujori I                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 4-mujori II                                          | 2019-10-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1-rë                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-të                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-të                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4t                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-të                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-të                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-të                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-të                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-të                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-të                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-të                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-të                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | Jan                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Shk                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mar                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Pri                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Maj                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Qer                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Kor                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Gus                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Sht                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Tet                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nën                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Dhj                                                  | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | Janar                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Shkurt                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Prill                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Maj                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Qershor                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Korrik                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Gusht                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Shtator                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Tetor                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nëntor                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Dhjetor                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | S                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | P                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Q                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | K                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | G                                                    | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | T                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                    | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1-rë                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-të                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-të                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4t                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-të                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-të                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-të                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-të                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-të                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-të                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-të                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-të                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | Jan                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Shk                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mar                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Pri                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Maj                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Qer                                                  | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Kor                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Gus                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Sht                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Tet                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nën                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Dhj                                                  | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | Janar                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Shkurt                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mars                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Prill                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Maj                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Qershor                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Korrik                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Gusht                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Shtator                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Tetor                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nëntor                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Dhjetor                                              | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | S                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | P                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Q                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | K                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | G                                                    | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | T                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                    | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-rë                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-të                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-rë                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-të                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1-rë                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-të                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-të                                                | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1-rë Shkurt                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-të Shkurt                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-të Shkurt                                         | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-të                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-të                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Hënë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Premte                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | H                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Hë                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pr                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-rë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-të                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Hënë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Premte                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | H                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Hë                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pr                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-rë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-të                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Hënë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Premte                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | H                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Hë                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pr                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-rë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-të                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Hën                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pre                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Hënë                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Premte                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | H                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                    | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Hë                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pr                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | pd                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | md                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | md                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | pd                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | p.d.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | m.d.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | m.d.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | p.d.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | p                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | m                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | m                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | p                                                    | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | MD                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | PD                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | pd                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | md                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | md                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | pd                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | p.d.                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | m.d.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | m.d.                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | p.d.                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | p                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | m                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | m                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | p                                                    | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | në mëngjes                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | në mbasdite                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | në mbrëmje                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | në mesnatë                                           | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | në mëngjes                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | në mbasdite                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | në mbrëmje                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | në mesnatë                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | në mëngjes                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | në mbasdite                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | në mbrëmje                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | në mesnatë                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | në mëngjes                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | në mbasdite                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | në mbrëmje                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | në mesnatë                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | në mëngjes                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | në mbasdite                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | në mbrëmje                                           | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | në mesnatë                                           | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-rë                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-të                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-rë                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-të                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 01/11/1987                                           | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987                                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987                                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453                                           | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987                                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987                                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987                                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                           | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987                                           | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | Jan 11, 1987                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Shk 11, 1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Mar 11, 1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Pri 11, 1987                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Maj 29, 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Qer 11, 1987                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Kor 11, 1987                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Gus 11, 1987                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Sht 11, 1987                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Tet 11, 1987                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Nën 11, 1987                                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Dhj 11, 1987                                         | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | Janar 11-të, 1987                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Shkurt 11-të, 1987                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Mars 11-të, 1987                                     | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Prill 11-të, 1987                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Maj 29-të, 1453                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Qershor 11-të, 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Korrik 11-të, 1987                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Gusht 11-të, 1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Shtator 11-të, 1987                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Tetor 11-të, 1987                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Nëntor 11-të, 1987                                   | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Dhjetor 11-të, 1987                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | Dielë, Janar 11-të, 1987                             | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Mërkurë, Shkurt 11-të, 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Mërkurë, Mars 11-të, 1987                            | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Shtunë, Prill 11-të, 1987                            | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Dielë, Maj 29-të, 1453                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Enjte, Qershor 11-të, 1987                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Shtunë, Korrik 11-të, 1987                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Martë, Gusht 11-të, 1987                             | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Premte, Shtator 11-të, 1987                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Dielë, Tetor 11-të, 1987                             | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Mërkurë, Nëntor 11-të, 1987                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Premte, Dhjetor 11-të, 1987                          | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 MD                                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 MD                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 MD                                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 MD                                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 MD                                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 MD                                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 MD                                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 MD                                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 MD                                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 MD                                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 MD                                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 MD                                             | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 MD                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 MD                                          | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 MD GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 MD GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 01/11/1987, 12:13 MD                                 | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987, 12:13 MD                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987, 12:13 MD                                 | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987, 12:13 MD                                 | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453, 11:59 MD                                 | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987, 12:13 MD                                 | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987, 12:13 MD                                 | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987, 12:13 MD                                 | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987, 12:13 MD                                 | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987, 12:13 MD                                 | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 MD                                 | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987, 12:13 MD                                 | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | Jan 11, 1987, 12:13:14 MD                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | Shk 11, 1987, 12:13:14 MD                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | Mar 11, 1987, 12:13:14 MD                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Pri 11, 1987, 12:13:14 MD                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Maj 29, 1453, 11:59:59 MD                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Qer 11, 1987, 12:13:14 MD                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Kor 11, 1987, 12:13:14 MD                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | Gus 11, 1987, 12:13:14 MD                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Sht 11, 1987, 12:13:14 MD                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Tet 11, 1987, 12:13:14 MD                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | Nën 11, 1987, 12:13:14 MD                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Dhj 11, 1987, 12:13:14 MD                            | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | Janar 11-të, 1987 në 12:13:14 MD GMT+0               | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | Shkurt 11-të, 1987 në 12:13:14 MD GMT+0              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | Mars 11-të, 1987 në 12:13:14 MD GMT+0                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | Prill 11-të, 1987 në 12:13:14 MD GMT+0               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Maj 29-të, 1453 në 11:59:59 MD GMT+0                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | Qershor 11-të, 1987 në 12:13:14 MD GMT+0             | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | Korrik 11-të, 1987 në 12:13:14 MD GMT+0              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | Gusht 11-të, 1987 në 12:13:14 MD GMT+0               | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | Shtator 11-të, 1987 në 12:13:14 MD GMT+0             | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | Tetor 11-të, 1987 në 12:13:14 MD GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | Nëntor 11-të, 1987 në 12:13:14 MD GMT+0              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | Dhjetor 11-të, 1987 në 12:13:14 MD GMT+0             | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | Dielë, Janar 11-të, 1987 në 12:13:14 MD GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | Mërkurë, Shkurt 11-të, 1987 në 12:13:14 MD GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | Mërkurë, Mars 11-të, 1987 në 12:13:14 MD GMT+00:00   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | Shtunë, Prill 11-të, 1987 në 12:13:14 MD GMT+00:00   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Dielë, Maj 29-të, 1453 në 11:59:59 MD GMT+00:00      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | Enjte, Qershor 11-të, 1987 në 12:13:14 MD GMT+00:00  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | Shtunë, Korrik 11-të, 1987 në 12:13:14 MD GMT+00:00  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | Martë, Gusht 11-të, 1987 në 12:13:14 MD GMT+00:00    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | Premte, Shtator 11-të, 1987 në 12:13:14 MD GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | Dielë, Tetor 11-të, 1987 në 12:13:14 MD GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | Mërkurë, Nëntor 11-të, 1987 në 12:13:14 MD GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | Premte, Dhjetor 11-të, 1987 në 12:13:14 MD GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result               | `includeSeconds: true` | `addSuffix: true`            |
| ------------------------ | -------------------- | ---------------------- | ---------------------------- |
| 2006-01-01T00:00:00.000Z | rreth 6 vite         | rreth 6 vite           | në rreth 6 vite              |
| 2005-01-01T00:00:00.000Z | rreth 5 vite         | rreth 5 vite           | në rreth 5 vite              |
| 2004-01-01T00:00:00.000Z | rreth 4 vite         | rreth 4 vite           | në rreth 4 vite              |
| 2003-01-01T00:00:00.000Z | rreth 3 vite         | rreth 3 vite           | në rreth 3 vite              |
| 2002-01-01T00:00:00.000Z | rreth 2 vite         | rreth 2 vite           | në rreth 2 vite              |
| 2001-06-01T00:00:00.000Z | mbi 1 vit            | mbi 1 vit              | në mbi 1 vit                 |
| 2001-02-01T00:00:00.000Z | rreth 1 vit          | rreth 1 vit            | në rreth 1 vit               |
| 2001-01-01T00:00:00.000Z | rreth 1 vit          | rreth 1 vit            | në rreth 1 vit               |
| 2000-06-01T00:00:00.000Z | 5 muaj               | 5 muaj                 | në 5 muaj                    |
| 2000-03-01T00:00:00.000Z | 2 muaj               | 2 muaj                 | në 2 muaj                    |
| 2000-02-01T00:00:00.000Z | rreth 1 muaj         | rreth 1 muaj           | në rreth 1 muaj              |
| 2000-01-15T00:00:00.000Z | 14 ditë              | 14 ditë                | në 14 ditë                   |
| 2000-01-02T00:00:00.000Z | 1 ditë               | 1 ditë                 | në 1 ditë                    |
| 2000-01-01T06:00:00.000Z | rreth 6 orë          | rreth 6 orë            | në rreth 6 orë               |
| 2000-01-01T01:00:00.000Z | rreth 1 orë          | rreth 1 orë            | në rreth 1 orë               |
| 2000-01-01T00:45:00.000Z | rreth 1 orë          | rreth 1 orë            | në rreth 1 orë               |
| 2000-01-01T00:30:00.000Z | 30 minuta            | 30 minuta              | në 30 minuta                 |
| 2000-01-01T00:15:00.000Z | 15 minuta            | 15 minuta              | në 15 minuta                 |
| 2000-01-01T00:01:00.000Z | 1 minutë             | 1 minutë               | në 1 minutë                  |
| 2000-01-01T00:00:25.000Z | më pak se një minute | gjysëm minuti          | në më pak se një minute      |
| 2000-01-01T00:00:15.000Z | më pak se një minute | më pak se 20 sekonda   | në më pak se një minute      |
| 2000-01-01T00:00:05.000Z | më pak se një minute | më pak se 10 sekonda   | në më pak se një minute      |
| 2000-01-01T00:00:00.000Z | më pak se një minute | më pak se 5 sekonda    | më pak se një minute më parë |
| 1999-12-31T23:59:55.000Z | më pak se një minute | më pak se 10 sekonda   | më pak se një minute më parë |
| 1999-12-31T23:59:45.000Z | më pak se një minute | më pak se 20 sekonda   | më pak se një minute më parë |
| 1999-12-31T23:59:35.000Z | më pak se një minute | gjysëm minuti          | më pak se një minute më parë |
| 1999-12-31T23:59:00.000Z | 1 minutë             | 1 minutë               | 1 minutë më parë             |
| 1999-12-31T23:45:00.000Z | 15 minuta            | 15 minuta              | 15 minuta më parë            |
| 1999-12-31T23:30:00.000Z | 30 minuta            | 30 minuta              | 30 minuta më parë            |
| 1999-12-31T23:15:00.000Z | rreth 1 orë          | rreth 1 orë            | rreth 1 orë më parë          |
| 1999-12-31T23:00:00.000Z | rreth 1 orë          | rreth 1 orë            | rreth 1 orë më parë          |
| 1999-12-31T18:00:00.000Z | rreth 6 orë          | rreth 6 orë            | rreth 6 orë më parë          |
| 1999-12-30T00:00:00.000Z | 2 ditë               | 2 ditë                 | 2 ditë më parë               |
| 1999-12-15T00:00:00.000Z | 17 ditë              | 17 ditë                | 17 ditë më parë              |
| 1999-12-01T00:00:00.000Z | rreth 1 muaj         | rreth 1 muaj           | rreth 1 muaj më parë         |
| 1999-11-01T00:00:00.000Z | 2 muaj               | 2 muaj                 | 2 muaj më parë               |
| 1999-06-01T00:00:00.000Z | 7 muaj               | 7 muaj                 | 7 muaj më parë               |
| 1999-01-01T00:00:00.000Z | rreth 1 vit          | rreth 1 vit            | rreth 1 vit më parë          |
| 1998-12-01T00:00:00.000Z | rreth 1 vit          | rreth 1 vit            | rreth 1 vit më parë          |
| 1998-06-01T00:00:00.000Z | mbi 1 vit            | mbi 1 vit              | mbi 1 vit më parë            |
| 1998-01-01T00:00:00.000Z | rreth 2 vite         | rreth 2 vite           | rreth 2 vite më parë         |
| 1997-01-01T00:00:00.000Z | rreth 3 vite         | rreth 3 vite           | rreth 3 vite më parë         |
| 1996-01-01T00:00:00.000Z | rreth 4 vite         | rreth 4 vite           | rreth 4 vite më parë         |
| 1995-01-01T00:00:00.000Z | rreth 5 vite         | rreth 5 vite           | rreth 5 vite më parë         |
| 1994-01-01T00:00:00.000Z | rreth 6 vite         | rreth 6 vite           | rreth 6 vite më parë         |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 vite     | në 6 vite          | 52608 orë                      |
| 2005-01-01T00:00:00.000Z | 5 vite     | në 5 vite          | 43848 orë                      |
| 2004-01-01T00:00:00.000Z | 4 vite     | në 4 vite          | 35064 orë                      |
| 2003-01-01T00:00:00.000Z | 3 vite     | në 3 vite          | 26304 orë                      |
| 2002-01-01T00:00:00.000Z | 2 vite     | në 2 vite          | 17544 orë                      |
| 2001-06-01T00:00:00.000Z | 1 vit      | në 1 vit           | 12408 orë                      |
| 2001-02-01T00:00:00.000Z | 1 vit      | në 1 vit           | 9528 orë                       |
| 2001-01-01T00:00:00.000Z | 1 vit      | në 1 vit           | 8784 orë                       |
| 2000-06-01T00:00:00.000Z | 5 muaj     | në 5 muaj          | 3648 orë                       |
| 2000-03-01T00:00:00.000Z | 2 muaj     | në 2 muaj          | 1440 orë                       |
| 2000-02-01T00:00:00.000Z | 1 muaj     | në 1 muaj          | 744 orë                        |
| 2000-01-15T00:00:00.000Z | 14 ditë    | në 14 ditë         | 336 orë                        |
| 2000-01-02T00:00:00.000Z | 1 ditë     | në 1 ditë          | 24 orë                         |
| 2000-01-01T06:00:00.000Z | 6 orë      | në 6 orë           | 6 orë                          |
| 2000-01-01T01:00:00.000Z | 1 orë      | në 1 orë           | 1 orë                          |
| 2000-01-01T00:45:00.000Z | 45 minuta  | në 45 minuta       | 1 orë                          |
| 2000-01-01T00:30:00.000Z | 30 minuta  | në 30 minuta       | 1 orë                          |
| 2000-01-01T00:15:00.000Z | 15 minuta  | në 15 minuta       | 0 orë                          |
| 2000-01-01T00:01:00.000Z | 1 minutë   | në 1 minutë        | 0 orë                          |
| 2000-01-01T00:00:25.000Z | 25 sekonda | në 25 sekonda      | 0 orë                          |
| 2000-01-01T00:00:15.000Z | 15 sekonda | në 15 sekonda      | 0 orë                          |
| 2000-01-01T00:00:05.000Z | 5 sekonda  | në 5 sekonda       | 0 orë                          |
| 2000-01-01T00:00:00.000Z | 0 sekonda  | 0 sekonda më parë  | 0 orë                          |
| 1999-12-31T23:59:55.000Z | 5 sekonda  | 5 sekonda më parë  | 0 orë                          |
| 1999-12-31T23:59:45.000Z | 15 sekonda | 15 sekonda më parë | 0 orë                          |
| 1999-12-31T23:59:35.000Z | 25 sekonda | 25 sekonda më parë | 0 orë                          |
| 1999-12-31T23:59:00.000Z | 1 minutë   | 1 minutë më parë   | 0 orë                          |
| 1999-12-31T23:45:00.000Z | 15 minuta  | 15 minuta më parë  | 0 orë                          |
| 1999-12-31T23:30:00.000Z | 30 minuta  | 30 minuta më parë  | 1 orë                          |
| 1999-12-31T23:15:00.000Z | 45 minuta  | 45 minuta më parë  | 1 orë                          |
| 1999-12-31T23:00:00.000Z | 1 orë      | 1 orë më parë      | 1 orë                          |
| 1999-12-31T18:00:00.000Z | 6 orë      | 6 orë më parë      | 6 orë                          |
| 1999-12-30T00:00:00.000Z | 2 ditë     | 2 ditë më parë     | 48 orë                         |
| 1999-12-15T00:00:00.000Z | 17 ditë    | 17 ditë më parë    | 408 orë                        |
| 1999-12-01T00:00:00.000Z | 1 muaj     | 1 muaj më parë     | 744 orë                        |
| 1999-11-01T00:00:00.000Z | 2 muaj     | 2 muaj më parë     | 1464 orë                       |
| 1999-06-01T00:00:00.000Z | 7 muaj     | 7 muaj më parë     | 5136 orë                       |
| 1999-01-01T00:00:00.000Z | 1 vit      | 1 vit më parë      | 8760 orë                       |
| 1998-12-01T00:00:00.000Z | 1 vit      | 1 vit më parë      | 9504 orë                       |
| 1998-06-01T00:00:00.000Z | 2 vite     | 2 vite më parë     | 13896 orë                      |
| 1998-01-01T00:00:00.000Z | 2 vite     | 2 vite më parë     | 17520 orë                      |
| 1997-01-01T00:00:00.000Z | 3 vite     | 3 vite më parë     | 26280 orë                      |
| 1996-01-01T00:00:00.000Z | 4 vite     | 4 vite më parë     | 35064 orë                      |
| 1995-01-01T00:00:00.000Z | 5 vite     | 5 vite më parë     | 43824 orë                      |
| 1994-01-01T00:00:00.000Z | 6 vite     | 6 vite më parë     | 52584 orë                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 01/10/2000                   |
| 2000-01-05T00:00:00.000Z | Mërkurë at 12:00 PD          |
| 2000-01-02T00:00:00.000Z | nesër në 12:00 PD            |
| 2000-01-01T00:00:00.000Z | sot në 12:00 PD              |
| 1999-12-31T00:00:00.000Z | dje në 12:00 PD              |
| 1999-12-27T00:00:00.000Z | të Hënë e shkuar në 12:00 PD |
| 1999-12-21T00:00:00.000Z | 12/21/1999                   |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 vite    |
| {"years":1}   | 1 vit     |
| {"years":2}   | 2 vite    |
| {"months":0}  | 0 muaj    |
| {"months":1}  | 1 muaj    |
| {"months":2}  | 2 muaj    |
| {"weeks":0}   | 0 javë    |
| {"weeks":1}   | 1 javë    |
| {"weeks":2}   | 2 javë    |
| {"days":0}    | 0 ditë    |
| {"days":1}    | 1 ditë    |
| {"days":2}    | 2 ditë    |
| {"hours":0}   | 0 orë     |
| {"hours":1}   | 1 orë     |
| {"hours":2}   | 2 orë     |
| {"minutes":0} | 0 minuta  |
| {"minutes":1} | 1 minutë  |
| {"minutes":2} | 2 minuta  |
| {"seconds":0} | 0 sekonda |
| {"seconds":1} | 1 sekondë |
| {"seconds":2} | 2 sekonda |
