# Tamil (ta) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                         | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                    | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4                                                       | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | காலா.1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | காலா.2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | ஒன்றாம் காலாண்டு                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | இரண்டாம் காலாண்டு                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                       | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | காலா.1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | காலா.2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | ஒன்றாம் காலாண்டு                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | இரண்டாம் காலாண்டு                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | ஜன.                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பிப்.                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மார்.                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏப்.                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூன்                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூலை                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆக.                                                     | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செப்.                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அக்.                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | நவ.                                                     | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டிச.                                                    | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | ஜனவரி                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பிப்ரவரி                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மார்ச்                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏப்ரல்                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூன்                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூலை                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆகஸ்ட்                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செப்டம்பர்                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அக்டோபர்                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | நவம்பர்                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டிசம்பர்                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ஜ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பி                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மா                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூ                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூ                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செ                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அ                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ந                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டி                                                      | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | ஜன.                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பிப்.                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மார்.                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏப்.                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூன்                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூலை                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆக.                                                     | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செப்.                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அக்.                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | நவ.                                                     | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டிச.                                                    | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | ஜனவரி                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பிப்ரவரி                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மார்ச்                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏப்ரல்                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூன்                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூலை                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆகஸ்ட்                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செப்டம்பர்                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அக்டோபர்                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | நவம்பர்                                                 | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டிசம்பர்                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ஜ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | பி                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | மா                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ஏ                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | மே                                                      | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ஜூ                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ஜூ                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ஆ                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | செ                                                      | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | அ                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ந                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | டி                                                      | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                      | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                      | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 பிப்ரவரி                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 பிப்ரவரி                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 பிப்ரவரி                                             | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | திங்கள்                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்ளி                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | திங்கள்                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்ளி                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | திங்கள்                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்ளி                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | திங்.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்.                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | திங்கள்                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெள்ளி                                                  | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | தி                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | வெ                                                      | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | மு.ப                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பி.ப                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பி.ப                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | மு.ப                                                    | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பிற்பகல்                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | முற்பகல்                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | மு.ப                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | பி.ப                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | பி.ப                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | மு.ப                                                    | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | காலை                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | மதியம்                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | மாலை                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | இரவு                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | காலை                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | மதியம்                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | மாலை                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | இரவு                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | காலை                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | மதியம்                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | மாலை                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | இரவு                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | காலை                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | மதியம்                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | மாலை                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | இரவு                                                    | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | கா.                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | மதி.                                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | மா.                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | இர.                                                     | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                       | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/1/87                                                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/2/87                                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/3/87                                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/4/87                                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53                                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/6/87                                                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/7/87                                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/8/87                                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/9/87                                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/87                                                | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/87                                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/87                                                | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 ஜன., 1987                                            | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 பிப்., 1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 மார்., 1987                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 ஏப்., 1987                                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 மே, 1453                                             | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 ஜூன், 1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ஜூலை, 1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ஆக., 1987                                            | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 செப்., 1987                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 அக்., 1987                                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 நவ., 1987                                            | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 டிச., 1987                                           | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 ஜனவரி, 1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 பிப்ரவரி, 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 மார்ச், 1987                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 ஏப்ரல், 1987                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 மே, 1453                                             | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 ஜூன், 1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ஜூலை, 1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ஆகஸ்ட், 1987                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 செப்டம்பர், 1987                                     | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 அக்டோபர், 1987                                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 நவம்பர், 1987                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 டிசம்பர், 1987                                       | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | ஞாயிறு, 11 ஜனவரி, 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | புதன், 11 பிப்ரவரி, 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | புதன், 11 மார்ச், 1987                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | சனி, 11 ஏப்ரல், 1987                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ஞாயிறு, 29 மே, 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | வியாழன், 11 ஜூன், 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | சனி, 11 ஜூலை, 1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | செவ்வாய், 11 ஆகஸ்ட், 1987                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | வெள்ளி, 11 செப்டம்பர், 1987                             | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | ஞாயிறு, 11 அக்டோபர், 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | புதன், 11 நவம்பர், 1987                                 | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | வெள்ளி, 11 டிசம்பர், 1987                               | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | பிற்பகல் 11:59                                          | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | பிற்பகல் 12:13                                          | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | பிற்பகல் 11:59:59                                       | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | பிற்பகல் 12:13:14                                       | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | பிற்பகல் 11:59:59 GMT+0                                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+0                                 | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | பிற்பகல் 11:59:59 GMT+00:00                             | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | பிற்பகல் 12:13:14 GMT+00:00                             | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/1/87, பிற்பகல் 12:13                                 | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/2/87, பிற்பகல் 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/3/87, பிற்பகல் 12:13                                 | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/4/87, பிற்பகல் 12:13                                 | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/5/53, பிற்பகல் 11:59                                 | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/6/87, பிற்பகல் 12:13                                 | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/7/87, பிற்பகல் 12:13                                 | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/8/87, பிற்பகல் 12:13                                 | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/9/87, பிற்பகல் 12:13                                 | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/87, பிற்பகல் 12:13                                | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/87, பிற்பகல் 12:13                                | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/87, பிற்பகல் 12:13                                | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 ஜன., 1987, பிற்பகல் 12:13:14                         | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 பிப்., 1987, பிற்பகல் 12:13:14                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 மார்., 1987, பிற்பகல் 12:13:14                       | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 ஏப்., 1987, பிற்பகல் 12:13:14                        | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 மே, 1453, பிற்பகல் 11:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 ஜூன், 1987, பிற்பகல் 12:13:14                        | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ஜூலை, 1987, பிற்பகல் 12:13:14                        | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ஆக., 1987, பிற்பகல் 12:13:14                         | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 செப்., 1987, பிற்பகல் 12:13:14                       | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 அக்., 1987, பிற்பகல் 12:13:14                        | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 நவ., 1987, பிற்பகல் 12:13:14                         | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 டிச., 1987, பிற்பகல் 12:13:14                        | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 ஜனவரி, 1987 பிற்பகல் 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 பிப்ரவரி, 1987 பிற்பகல் 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 மார்ச், 1987 பிற்பகல் 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 ஏப்ரல், 1987 பிற்பகல் 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 மே, 1453 பிற்பகல் 11:59:59 GMT+0                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 ஜூன், 1987 பிற்பகல் 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ஜூலை, 1987 பிற்பகல் 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ஆகஸ்ட், 1987 பிற்பகல் 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 செப்டம்பர், 1987 பிற்பகல் 12:13:14 GMT+0             | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 அக்டோபர், 1987 பிற்பகல் 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 நவம்பர், 1987 பிற்பகல் 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 டிசம்பர், 1987 பிற்பகல் 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | ஞாயிறு, 11 ஜனவரி, 1987 பிற்பகல் 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | புதன், 11 பிப்ரவரி, 1987 பிற்பகல் 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | புதன், 11 மார்ச், 1987 பிற்பகல் 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | சனி, 11 ஏப்ரல், 1987 பிற்பகல் 12:13:14 GMT+00:00        | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | ஞாயிறு, 29 மே, 1453 பிற்பகல் 11:59:59 GMT+00:00         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | வியாழன், 11 ஜூன், 1987 பிற்பகல் 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | சனி, 11 ஜூலை, 1987 பிற்பகல் 12:13:14 GMT+00:00          | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | செவ்வாய், 11 ஆகஸ்ட், 1987 பிற்பகல் 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | வெள்ளி, 11 செப்டம்பர், 1987 பிற்பகல் 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | ஞாயிறு, 11 அக்டோபர், 1987 பிற்பகல் 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | புதன், 11 நவம்பர், 1987 பிற்பகல் 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | வெள்ளி, 11 டிசம்பர், 1987 பிற்பகல் 12:13:14 GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                      | `includeSeconds: true`   | `addSuffix: true`               |
| ------------------------ | --------------------------- | ------------------------ | ------------------------------- |
| 2006-01-01T00:00:00.000Z | சுமார் 6 ஆண்டுகள்           | சுமார் 6 ஆண்டுகள்        | சுமார் 6 ஆண்டுகளில்             |
| 2005-01-01T00:00:00.000Z | சுமார் 5 ஆண்டுகள்           | சுமார் 5 ஆண்டுகள்        | சுமார் 5 ஆண்டுகளில்             |
| 2004-01-01T00:00:00.000Z | சுமார் 4 ஆண்டுகள்           | சுமார் 4 ஆண்டுகள்        | சுமார் 4 ஆண்டுகளில்             |
| 2003-01-01T00:00:00.000Z | சுமார் 3 ஆண்டுகள்           | சுமார் 3 ஆண்டுகள்        | சுமார் 3 ஆண்டுகளில்             |
| 2002-01-01T00:00:00.000Z | சுமார் 2 ஆண்டுகள்           | சுமார் 2 ஆண்டுகள்        | சுமார் 2 ஆண்டுகளில்             |
| 2001-06-01T00:00:00.000Z | 1 வருடத்திற்கு மேல்         | 1 வருடத்திற்கு மேல்      | 1 வருடத்திற்கும் மேலாக          |
| 2001-02-01T00:00:00.000Z | சுமார் 1 வருடம்             | சுமார் 1 வருடம்          | சுமார் 1 ஆண்டில்                |
| 2001-01-01T00:00:00.000Z | சுமார் 1 வருடம்             | சுமார் 1 வருடம்          | சுமார் 1 ஆண்டில்                |
| 2000-06-01T00:00:00.000Z | 5 மாதங்கள்                  | 5 மாதங்கள்               | 5 மாதங்களில்                    |
| 2000-03-01T00:00:00.000Z | 2 மாதங்கள்                  | 2 மாதங்கள்               | 2 மாதங்களில்                    |
| 2000-02-01T00:00:00.000Z | சுமார் 1 மாதம்              | சுமார் 1 மாதம்           | சுமார் 1 மாதத்தில்              |
| 2000-01-15T00:00:00.000Z | 14 நாட்கள்                  | 14 நாட்கள்               | 14 நாட்களில்                    |
| 2000-01-02T00:00:00.000Z | 1 நாள்                      | 1 நாள்                   | 1 நாளில்                        |
| 2000-01-01T06:00:00.000Z | சுமார் 6 மணி நேரம்          | சுமார் 6 மணி நேரம்       | சுமார் 6 மணி நேரத்திற்கு முன்பு |
| 2000-01-01T01:00:00.000Z | சுமார் 1 மணி நேரம்          | சுமார் 1 மணி நேரம்       | சுமார் 1 மணி நேரத்தில்          |
| 2000-01-01T00:45:00.000Z | சுமார் 1 மணி நேரம்          | சுமார் 1 மணி நேரம்       | சுமார் 1 மணி நேரத்தில்          |
| 2000-01-01T00:30:00.000Z | 30 நிமிடங்கள்               | 30 நிமிடங்கள்            | 30 நிமிடங்களில்                 |
| 2000-01-01T00:15:00.000Z | 15 நிமிடங்கள்               | 15 நிமிடங்கள்            | 15 நிமிடங்களில்                 |
| 2000-01-01T00:01:00.000Z | 1 நிமிடம்                   | 1 நிமிடம்                | 1 நிமிடத்தில்                   |
| 2000-01-01T00:00:25.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | அரை நிமிடம்              | ஒரு நிமிடத்திற்குள்             |
| 2000-01-01T00:00:15.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | 20 வினாடிகளுக்கு குறைவாக | ஒரு நிமிடத்திற்குள்             |
| 2000-01-01T00:00:05.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | 10 வினாடிகளுக்கு குறைவாக | ஒரு நிமிடத்திற்குள்             |
| 2000-01-01T00:00:00.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | 5 வினாடிகளுக்கு குறைவாக  | ஒரு நிமிடத்திற்கு முன்பு        |
| 1999-12-31T23:59:55.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | 10 வினாடிகளுக்கு குறைவாக | ஒரு நிமிடத்திற்கு முன்பு        |
| 1999-12-31T23:59:45.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | 20 வினாடிகளுக்கு குறைவாக | ஒரு நிமிடத்திற்கு முன்பு        |
| 1999-12-31T23:59:35.000Z | ஒரு நிமிடத்திற்கும் குறைவாக | அரை நிமிடம்              | ஒரு நிமிடத்திற்கு முன்பு        |
| 1999-12-31T23:59:00.000Z | 1 நிமிடம்                   | 1 நிமிடம்                | 1 நிமிடம் முன்பு                |
| 1999-12-31T23:45:00.000Z | 15 நிமிடங்கள்               | 15 நிமிடங்கள்            | 15 நிமிடங்களுக்கு முன்பு        |
| 1999-12-31T23:30:00.000Z | 30 நிமிடங்கள்               | 30 நிமிடங்கள்            | 30 நிமிடங்களுக்கு முன்பு        |
| 1999-12-31T23:15:00.000Z | சுமார் 1 மணி நேரம்          | சுமார் 1 மணி நேரம்       | சுமார் 1 மணி நேரத்திற்கு முன்பு |
| 1999-12-31T23:00:00.000Z | சுமார் 1 மணி நேரம்          | சுமார் 1 மணி நேரம்       | சுமார் 1 மணி நேரத்திற்கு முன்பு |
| 1999-12-31T18:00:00.000Z | சுமார் 6 மணி நேரம்          | சுமார் 6 மணி நேரம்       | சுமார் 6 மணி நேரத்தில்          |
| 1999-12-30T00:00:00.000Z | 2 நாட்கள்                   | 2 நாட்கள்                | 2 நாட்களுக்கு முன்பு            |
| 1999-12-15T00:00:00.000Z | 17 நாட்கள்                  | 17 நாட்கள்               | 17 நாட்களுக்கு முன்பு           |
| 1999-12-01T00:00:00.000Z | சுமார் 1 மாதம்              | சுமார் 1 மாதம்           | சுமார் 1 மாதத்திற்கு முன்பு     |
| 1999-11-01T00:00:00.000Z | 2 மாதங்கள்                  | 2 மாதங்கள்               | 2 மாதங்களுக்கு முன்பு           |
| 1999-06-01T00:00:00.000Z | 7 மாதங்கள்                  | 7 மாதங்கள்               | 7 மாதங்களுக்கு முன்பு           |
| 1999-01-01T00:00:00.000Z | சுமார் 1 வருடம்             | சுமார் 1 வருடம்          | சுமார் 1 வருடம் முன்பு          |
| 1998-12-01T00:00:00.000Z | சுமார் 1 வருடம்             | சுமார் 1 வருடம்          | சுமார் 1 வருடம் முன்பு          |
| 1998-06-01T00:00:00.000Z | 1 வருடத்திற்கு மேல்         | 1 வருடத்திற்கு மேல்      | 1 வருடம் முன்பு                 |
| 1998-01-01T00:00:00.000Z | சுமார் 2 ஆண்டுகள்           | சுமார் 2 ஆண்டுகள்        | சுமார் 2 ஆண்டுகளுக்கு முன்பு    |
| 1997-01-01T00:00:00.000Z | சுமார் 3 ஆண்டுகள்           | சுமார் 3 ஆண்டுகள்        | சுமார் 3 ஆண்டுகளுக்கு முன்பு    |
| 1996-01-01T00:00:00.000Z | சுமார் 4 ஆண்டுகள்           | சுமார் 4 ஆண்டுகள்        | சுமார் 4 ஆண்டுகளுக்கு முன்பு    |
| 1995-01-01T00:00:00.000Z | சுமார் 5 ஆண்டுகள்           | சுமார் 5 ஆண்டுகள்        | சுமார் 5 ஆண்டுகளுக்கு முன்பு    |
| 1994-01-01T00:00:00.000Z | சுமார் 6 ஆண்டுகள்           | சுமார் 6 ஆண்டுகள்        | சுமார் 6 ஆண்டுகளுக்கு முன்பு    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `addSuffix: true`        | With forced unit (i.e. `hour`) |
| ------------------------ | ------------- | ------------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ஆண்டுகள்    | 6 ஆண்டுகளில்             | 52608 மணி நேரம்                |
| 2005-01-01T00:00:00.000Z | 5 ஆண்டுகள்    | 5 ஆண்டுகளில்             | 43848 மணி நேரம்                |
| 2004-01-01T00:00:00.000Z | 4 ஆண்டுகள்    | 4 ஆண்டுகளில்             | 35064 மணி நேரம்                |
| 2003-01-01T00:00:00.000Z | 3 ஆண்டுகள்    | 3 ஆண்டுகளில்             | 26304 மணி நேரம்                |
| 2002-01-01T00:00:00.000Z | 2 ஆண்டுகள்    | 2 ஆண்டுகளில்             | 17544 மணி நேரம்                |
| 2001-06-01T00:00:00.000Z | 1 வருடம்      | 1 ஆண்டில்                | 12408 மணி நேரம்                |
| 2001-02-01T00:00:00.000Z | 1 வருடம்      | 1 ஆண்டில்                | 9528 மணி நேரம்                 |
| 2001-01-01T00:00:00.000Z | 1 வருடம்      | 1 ஆண்டில்                | 8784 மணி நேரம்                 |
| 2000-06-01T00:00:00.000Z | 5 மாதங்கள்    | 5 மாதங்களில்             | 3648 மணி நேரம்                 |
| 2000-03-01T00:00:00.000Z | 2 மாதங்கள்    | 2 மாதங்களில்             | 1440 மணி நேரம்                 |
| 2000-02-01T00:00:00.000Z | 1 மாதம்       | 1 மாதத்தில்              | 744 மணி நேரம்                  |
| 2000-01-15T00:00:00.000Z | 14 நாட்கள்    | 14 நாட்களில்             | 336 மணி நேரம்                  |
| 2000-01-02T00:00:00.000Z | 1 நாள்        | 1 நாளில்                 | 24 மணி நேரம்                   |
| 2000-01-01T06:00:00.000Z | 6 மணி நேரம்   | 6 மணி நேரத்தில்          | 6 மணி நேரம்                    |
| 2000-01-01T01:00:00.000Z | 1 மணி நேரம்   | 1 மணி நேரத்தில்          | 1 மணி நேரம்                    |
| 2000-01-01T00:45:00.000Z | 45 நிமிடங்கள் | 45 நிமிடங்களில்          | 1 மணி நேரம்                    |
| 2000-01-01T00:30:00.000Z | 30 நிமிடங்கள் | 30 நிமிடங்களில்          | 1 மணி நேரம்                    |
| 2000-01-01T00:15:00.000Z | 15 நிமிடங்கள் | 15 நிமிடங்களில்          | 0 மணி நேரம்                    |
| 2000-01-01T00:01:00.000Z | 1 நிமிடம்     | 1 நிமிடத்தில்            | 0 மணி நேரம்                    |
| 2000-01-01T00:00:25.000Z | 25 விநாடிகள்  | 25 வினாடிகளில்           | 0 மணி நேரம்                    |
| 2000-01-01T00:00:15.000Z | 15 விநாடிகள்  | 15 வினாடிகளில்           | 0 மணி நேரம்                    |
| 2000-01-01T00:00:05.000Z | 5 விநாடிகள்   | 5 வினாடிகளில்            | 0 மணி நேரம்                    |
| 2000-01-01T00:00:00.000Z | 0 விநாடிகள்   | 0 விநாடிகளுக்கு முன்பு   | 0 மணி நேரம்                    |
| 1999-12-31T23:59:55.000Z | 5 விநாடிகள்   | 5 விநாடிகளுக்கு முன்பு   | 0 மணி நேரம்                    |
| 1999-12-31T23:59:45.000Z | 15 விநாடிகள்  | 15 விநாடிகளுக்கு முன்பு  | 0 மணி நேரம்                    |
| 1999-12-31T23:59:35.000Z | 25 விநாடிகள்  | 25 விநாடிகளுக்கு முன்பு  | 0 மணி நேரம்                    |
| 1999-12-31T23:59:00.000Z | 1 நிமிடம்     | 1 நிமிடம் முன்பு         | 0 மணி நேரம்                    |
| 1999-12-31T23:45:00.000Z | 15 நிமிடங்கள் | 15 நிமிடங்களுக்கு முன்பு | 0 மணி நேரம்                    |
| 1999-12-31T23:30:00.000Z | 30 நிமிடங்கள் | 30 நிமிடங்களுக்கு முன்பு | 1 மணி நேரம்                    |
| 1999-12-31T23:15:00.000Z | 45 நிமிடங்கள் | 45 நிமிடங்களுக்கு முன்பு | 1 மணி நேரம்                    |
| 1999-12-31T23:00:00.000Z | 1 மணி நேரம்   | 1 மணி நேரத்திற்கு முன்பு | 1 மணி நேரம்                    |
| 1999-12-31T18:00:00.000Z | 6 மணி நேரம்   | 6 மணி நேரத்திற்கு முன்பு | 6 மணி நேரம்                    |
| 1999-12-30T00:00:00.000Z | 2 நாட்கள்     | 2 நாட்களுக்கு முன்பு     | 48 மணி நேரம்                   |
| 1999-12-15T00:00:00.000Z | 17 நாட்கள்    | 17 நாட்களுக்கு முன்பு    | 408 மணி நேரம்                  |
| 1999-12-01T00:00:00.000Z | 1 மாதம்       | 1 மாதம் முன்பு           | 744 மணி நேரம்                  |
| 1999-11-01T00:00:00.000Z | 2 மாதங்கள்    | 2 மாதங்களுக்கு முன்பு    | 1464 மணி நேரம்                 |
| 1999-06-01T00:00:00.000Z | 7 மாதங்கள்    | 7 மாதங்களுக்கு முன்பு    | 5136 மணி நேரம்                 |
| 1999-01-01T00:00:00.000Z | 1 வருடம்      | 1 வருடம் முன்பு          | 8760 மணி நேரம்                 |
| 1998-12-01T00:00:00.000Z | 1 வருடம்      | 1 வருடம் முன்பு          | 9504 மணி நேரம்                 |
| 1998-06-01T00:00:00.000Z | 2 ஆண்டுகள்    | 2 ஆண்டுகளுக்கு முன்பு    | 13896 மணி நேரம்                |
| 1998-01-01T00:00:00.000Z | 2 ஆண்டுகள்    | 2 ஆண்டுகளுக்கு முன்பு    | 17520 மணி நேரம்                |
| 1997-01-01T00:00:00.000Z | 3 ஆண்டுகள்    | 3 ஆண்டுகளுக்கு முன்பு    | 26280 மணி நேரம்                |
| 1996-01-01T00:00:00.000Z | 4 ஆண்டுகள்    | 4 ஆண்டுகளுக்கு முன்பு    | 35064 மணி நேரம்                |
| 1995-01-01T00:00:00.000Z | 5 ஆண்டுகள்    | 5 ஆண்டுகளுக்கு முன்பு    | 43824 மணி நேரம்                |
| 1994-01-01T00:00:00.000Z | 6 ஆண்டுகள்    | 6 ஆண்டுகளுக்கு முன்பு    | 52584 மணி நேரம்                |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                               |
| ------------------------ | ------------------------------------ |
| 2000-01-10T00:00:00.000Z | 10/1/00                              |
| 2000-01-05T00:00:00.000Z | புதன் முற்பகல் 12:00 மணிக்கு         |
| 2000-01-02T00:00:00.000Z | நாளை முற்பகல் 12:00 மணிக்கு          |
| 2000-01-01T00:00:00.000Z | இன்று முற்பகல் 12:00 மணிக்கு         |
| 1999-12-31T00:00:00.000Z | நேற்று முற்பகல் 12:00 மணிக்கு        |
| 1999-12-27T00:00:00.000Z | கடந்த திங்கள் முற்பகல் 12:00 மணிக்கு |
| 1999-12-21T00:00:00.000Z | 21/12/99                             |

## `formatDuration`

| Duration      | Result       |
| ------------- | ------------ |
| {"years":0}   | 0 ஆண்டுகள்   |
| {"years":1}   | 1 வருடம்     |
| {"years":2}   | 2 ஆண்டுகள்   |
| {"months":0}  | 0 மாதங்கள்   |
| {"months":1}  | 1 மாதம்      |
| {"months":2}  | 2 மாதங்கள்   |
| {"weeks":0}   | 0 வாரங்கள்   |
| {"weeks":1}   | 1 வாரம்      |
| {"weeks":2}   | 2 வாரங்கள்   |
| {"days":0}    | 0 நாட்கள்    |
| {"days":1}    | 1 நாள்       |
| {"days":2}    | 2 நாட்கள்    |
| {"hours":0}   | 0 மணி நேரம்  |
| {"hours":1}   | 1 மணி நேரம்  |
| {"hours":2}   | 2 மணி நேரம்  |
| {"minutes":0} | 0 நிமிடங்கள் |
| {"minutes":1} | 1 நிமிடம்    |
| {"minutes":2} | 2 நிமிடங்கள் |
| {"seconds":0} | 0 விநாடிகள்  |
| {"seconds":1} | 1 வினாடி     |
| {"seconds":2} | 2 விநாடிகள்  |
