# Ukrainian (uk) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-й                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-й                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-й                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-й                                                 | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-й                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-й кв.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й кв.                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-й квартал                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й квартал                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-й                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-й кв.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й кв.                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-й квартал                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-й квартал                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1-й                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-й                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-й                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-й                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-й                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-й                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-й                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-й                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-й                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-й                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-й                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-й                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | січ.                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лют.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | берез.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | квіт.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | трав.                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | черв.                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | лип.                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | серп.                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | верес.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | жовт.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | листоп.                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | груд.                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | січня                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лютого                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | березня                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | квітня                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | травня                                              | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | червня                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | липня                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | серпня                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | вересня                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | жовтня                                              | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | листопада                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | грудня                                              | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Б                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Т                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ч                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | В                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ж                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Г                                                   | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1-й                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-й                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-й                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-й                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-й                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-й                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-й                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-й                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-й                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-й                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-й                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-й                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | січ.                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лют.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | берез.                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | квіт.                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | трав.                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | черв.                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | лип.                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | серп.                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | верес.                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | жовт.                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | листоп.                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | груд.                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | січень                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | лютий                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | березень                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | квітень                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | травень                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | червень                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | липень                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | серпень                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | вересень                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | жовтень                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | листопад                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | грудень                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Б                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | К                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Т                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ч                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | С                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | В                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ж                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Л                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Г                                                   | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-й                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-й                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-й                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-й                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1-е                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-е                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-е                                                | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1-е лютого                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-е лютого                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-е лютого                                         | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-й                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-й                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | понеділок                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | п’ятниця                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-й                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | понеділок                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | п’ятниця                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-й                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | понеділок                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | п’ятниця                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-й                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-й                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | пон                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | птн                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | понеділок                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | п’ятниця                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                                   | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | пн                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                                  | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | пп                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | дп                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ПП                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ДП                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ранку                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночі                                                | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ранку                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночі                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ранку                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночі                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ранку                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночі                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ранку                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | дня                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | веч.                                                | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ночі                                                | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-а                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-а                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-а                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-а                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-а                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-а                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-а                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-а                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-а                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-а                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-а                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-а                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987                                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987                                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987                                          | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 січ. 1987 р.                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лют. 1987 р.                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 берез. 1987 р.                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 квіт. 1987 р.                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 трав. 1453 р.                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 черв. 1987 р.                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 лип. 1987 р.                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 серп. 1987 р.                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 верес. 1987 р.                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 жовт. 1987 р.                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 листоп. 1987 р.                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 груд. 1987 р.                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11-е січня 1987 р.                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-е лютого 1987 р.                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-е березня 1987 р.                                | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-е квітня 1987 р.                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-е травня 1453 р.                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-е червня 1987 р.                                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-е липня 1987 р.                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-е серпня 1987 р.                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-е вересня 1987 р.                                | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-е жовтня 1987 р.                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-е листопада 1987 р.                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-е грудня 1987 р.                                 | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | неділя, 11-е січня 1987 р.                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | середа, 11-е лютого 1987 р.                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | середа, 11-е березня 1987 р.                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | субота, 11-е квітня 1987 р.                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | неділя, 29-е травня 1453 р.                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | четвер, 11-е червня 1987 р.                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | субота, 11-е липня 1987 р.                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | вівторок, 11-е серпня 1987 р.                       | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | п’ятниця, 11-е вересня 1987 р.                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | неділя, 11-е жовтня 1987 р.                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | середа, 11-е листопада 1987 р.                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | п’ятниця, 11-е грудня 1987 р.                       | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                               | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                            | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987, 12:13                                   | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987, 12:13                                   | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987, 12:13                                   | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                   | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987, 12:13                                   | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987, 12:13                                   | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987, 12:13                                   | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987, 12:13                                   | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987, 12:13                                   | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987, 12:13                                   | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987, 12:13                                   | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 січ. 1987 р., 12:13:14                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 лют. 1987 р., 12:13:14                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 берез. 1987 р., 12:13:14                         | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 квіт. 1987 р., 12:13:14                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 трав. 1453 р., 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 черв. 1987 р., 12:13:14                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 лип. 1987 р., 12:13:14                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 серп. 1987 р., 12:13:14                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 верес. 1987 р., 12:13:14                         | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 жовт. 1987 р., 12:13:14                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 листоп. 1987 р., 12:13:14                        | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 груд. 1987 р., 12:13:14                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11-е січня 1987 р. о 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-е лютого 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-е березня 1987 р. о 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-е квітня 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-е травня 1453 р. о 23:59:59 GMT+0                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-е червня 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-е липня 1987 р. о 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-е серпня 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-е вересня 1987 р. о 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-е жовтня 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-е листопада 1987 р. о 12:13:14 GMT+0             | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-е грудня 1987 р. о 12:13:14 GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | неділя, 11-е січня 1987 р. о 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | середа, 11-е лютого 1987 р. о 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | середа, 11-е березня 1987 р. о 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | субота, 11-е квітня 1987 р. о 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | неділя, 29-е травня 1453 р. о 23:59:59 GMT+00:00    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | четвер, 11-е червня 1987 р. о 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | субота, 11-е липня 1987 р. о 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | вівторок, 11-е серпня 1987 р. о 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | п’ятниця, 11-е вересня 1987 р. о 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | неділя, 11-е жовтня 1987 р. о 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | середа, 11-е листопада 1987 р. о 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | п’ятниця, 11-е грудня 1987 р. о 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ---------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | близько 6 років  | близько 6 років        | приблизно за 6 років  |
| 2005-01-01T00:00:00.000Z | близько 5 років  | близько 5 років        | приблизно за 5 років  |
| 2004-01-01T00:00:00.000Z | близько 4 років  | близько 4 років        | приблизно за 4 роки   |
| 2003-01-01T00:00:00.000Z | близько 3 років  | близько 3 років        | приблизно за 3 роки   |
| 2002-01-01T00:00:00.000Z | близько 2 років  | близько 2 років        | приблизно за 2 роки   |
| 2001-06-01T00:00:00.000Z | більше 1 року    | більше 1 року          | більше, ніж за 1 рік  |
| 2001-02-01T00:00:00.000Z | близько 1 року   | близько 1 року         | приблизно за 1 рік    |
| 2001-01-01T00:00:00.000Z | близько 1 року   | близько 1 року         | приблизно за 1 рік    |
| 2000-06-01T00:00:00.000Z | 5 місяців        | 5 місяців              | за 5 місяців          |
| 2000-03-01T00:00:00.000Z | 2 місяці         | 2 місяці               | за 2 місяці           |
| 2000-02-01T00:00:00.000Z | близько 1 місяця | близько 1 місяця       | приблизно за 1 місяць |
| 2000-01-15T00:00:00.000Z | 14 днів          | 14 днів                | за 14 днів            |
| 2000-01-02T00:00:00.000Z | 1 день           | 1 день                 | за 1 день             |
| 2000-01-01T06:00:00.000Z | близько 6 годин  | близько 6 годин        | приблизно за 6 годин  |
| 2000-01-01T01:00:00.000Z | близько 1 години | близько 1 години       | приблизно за 1 годину |
| 2000-01-01T00:45:00.000Z | близько 1 години | близько 1 години       | приблизно за 1 годину |
| 2000-01-01T00:30:00.000Z | 30 хвилин        | 30 хвилин              | за 30 хвилин          |
| 2000-01-01T00:15:00.000Z | 15 хвилин        | 15 хвилин              | за 15 хвилин          |
| 2000-01-01T00:01:00.000Z | 1 хвилина        | 1 хвилина              | за 1 хвилину          |
| 2000-01-01T00:00:25.000Z | менше хвилини    | півхвилини             | менше, ніж за хвилину |
| 2000-01-01T00:00:15.000Z | менше хвилини    | менше 20 секунд        | менше, ніж за хвилину |
| 2000-01-01T00:00:05.000Z | менше хвилини    | менше 10 секунд        | менше, ніж за хвилину |
| 2000-01-01T00:00:00.000Z | менше хвилини    | менше 5 секунд         | менше хвилини тому    |
| 1999-12-31T23:59:55.000Z | менше хвилини    | менше 10 секунд        | менше хвилини тому    |
| 1999-12-31T23:59:45.000Z | менше хвилини    | менше 20 секунд        | менше хвилини тому    |
| 1999-12-31T23:59:35.000Z | менше хвилини    | півхвилини             | менше хвилини тому    |
| 1999-12-31T23:59:00.000Z | 1 хвилина        | 1 хвилина              | 1 хвилину тому        |
| 1999-12-31T23:45:00.000Z | 15 хвилин        | 15 хвилин              | 15 хвилин тому        |
| 1999-12-31T23:30:00.000Z | 30 хвилин        | 30 хвилин              | 30 хвилин тому        |
| 1999-12-31T23:15:00.000Z | близько 1 години | близько 1 години       | близько 1 години тому |
| 1999-12-31T23:00:00.000Z | близько 1 години | близько 1 години       | близько 1 години тому |
| 1999-12-31T18:00:00.000Z | близько 6 годин  | близько 6 годин        | близько 6 годин тому  |
| 1999-12-30T00:00:00.000Z | 2 днi            | 2 днi                  | 2 днi тому            |
| 1999-12-15T00:00:00.000Z | 17 днів          | 17 днів                | 17 днів тому          |
| 1999-12-01T00:00:00.000Z | близько 1 місяця | близько 1 місяця       | близько 1 місяця тому |
| 1999-11-01T00:00:00.000Z | 2 місяці         | 2 місяці               | 2 місяці тому         |
| 1999-06-01T00:00:00.000Z | 7 місяців        | 7 місяців              | 7 місяців тому        |
| 1999-01-01T00:00:00.000Z | близько 1 року   | близько 1 року         | близько 1 року тому   |
| 1998-12-01T00:00:00.000Z | близько 1 року   | близько 1 року         | близько 1 року тому   |
| 1998-06-01T00:00:00.000Z | більше 1 року    | більше 1 року          | більше 1 року тому    |
| 1998-01-01T00:00:00.000Z | близько 2 років  | близько 2 років        | близько 2 років тому  |
| 1997-01-01T00:00:00.000Z | близько 3 років  | близько 3 років        | близько 3 років тому  |
| 1996-01-01T00:00:00.000Z | близько 4 років  | близько 4 років        | близько 4 років тому  |
| 1995-01-01T00:00:00.000Z | близько 5 років  | близько 5 років        | близько 5 років тому  |
| 1994-01-01T00:00:00.000Z | близько 6 років  | близько 6 років        | близько 6 років тому  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 років   | за 6 років        | 52608 годин                    |
| 2005-01-01T00:00:00.000Z | 5 років   | за 5 років        | 43848 годин                    |
| 2004-01-01T00:00:00.000Z | 4 роки    | за 4 роки         | 35064 години                   |
| 2003-01-01T00:00:00.000Z | 3 роки    | за 3 роки         | 26304 години                   |
| 2002-01-01T00:00:00.000Z | 2 роки    | за 2 роки         | 17544 години                   |
| 2001-06-01T00:00:00.000Z | 1 рік     | за 1 рік          | 12408 годин                    |
| 2001-02-01T00:00:00.000Z | 1 рік     | за 1 рік          | 9528 годин                     |
| 2001-01-01T00:00:00.000Z | 1 рік     | за 1 рік          | 8784 години                    |
| 2000-06-01T00:00:00.000Z | 5 місяців | за 5 місяців      | 3648 годин                     |
| 2000-03-01T00:00:00.000Z | 2 місяці  | за 2 місяці       | 1440 годин                     |
| 2000-02-01T00:00:00.000Z | 1 місяць  | за 1 місяць       | 744 години                     |
| 2000-01-15T00:00:00.000Z | 14 днів   | за 14 днів        | 336 годин                      |
| 2000-01-02T00:00:00.000Z | 1 день    | за 1 день         | 24 години                      |
| 2000-01-01T06:00:00.000Z | 6 годин   | за 6 годин        | 6 годин                        |
| 2000-01-01T01:00:00.000Z | 1 годину  | за 1 годину       | 1 годину                       |
| 2000-01-01T00:45:00.000Z | 45 хвилин | за 45 хвилин      | 1 годину                       |
| 2000-01-01T00:30:00.000Z | 30 хвилин | за 30 хвилин      | 1 годину                       |
| 2000-01-01T00:15:00.000Z | 15 хвилин | за 15 хвилин      | 0 годин                        |
| 2000-01-01T00:01:00.000Z | 1 хвилина | за 1 хвилину      | 0 годин                        |
| 2000-01-01T00:00:25.000Z | 25 секунд | за 25 секунд      | 0 годин                        |
| 2000-01-01T00:00:15.000Z | 15 секунд | за 15 секунд      | 0 годин                        |
| 2000-01-01T00:00:05.000Z | 5 секунд  | за 5 секунд       | 0 годин                        |
| 2000-01-01T00:00:00.000Z | 0 секунд  | 0 секунд тому     | 0 годин                        |
| 1999-12-31T23:59:55.000Z | 5 секунд  | 5 секунд тому     | 0 годин                        |
| 1999-12-31T23:59:45.000Z | 15 секунд | 15 секунд тому    | 0 годин                        |
| 1999-12-31T23:59:35.000Z | 25 секунд | 25 секунд тому    | 0 годин                        |
| 1999-12-31T23:59:00.000Z | 1 хвилина | 1 хвилину тому    | 0 годин                        |
| 1999-12-31T23:45:00.000Z | 15 хвилин | 15 хвилин тому    | 0 годин                        |
| 1999-12-31T23:30:00.000Z | 30 хвилин | 30 хвилин тому    | 1 годину                       |
| 1999-12-31T23:15:00.000Z | 45 хвилин | 45 хвилин тому    | 1 годину                       |
| 1999-12-31T23:00:00.000Z | 1 годину  | 1 годину тому     | 1 годину                       |
| 1999-12-31T18:00:00.000Z | 6 годин   | 6 годин тому      | 6 годин                        |
| 1999-12-30T00:00:00.000Z | 2 днi     | 2 днi тому        | 48 годин                       |
| 1999-12-15T00:00:00.000Z | 17 днів   | 17 днів тому      | 408 годин                      |
| 1999-12-01T00:00:00.000Z | 1 місяць  | 1 місяць тому     | 744 години                     |
| 1999-11-01T00:00:00.000Z | 2 місяці  | 2 місяці тому     | 1464 години                    |
| 1999-06-01T00:00:00.000Z | 7 місяців | 7 місяців тому    | 5136 годин                     |
| 1999-01-01T00:00:00.000Z | 1 рік     | 1 рік тому        | 8760 годин                     |
| 1998-12-01T00:00:00.000Z | 1 рік     | 1 рік тому        | 9504 години                    |
| 1998-06-01T00:00:00.000Z | 2 роки    | 2 роки тому       | 13896 годин                    |
| 1998-01-01T00:00:00.000Z | 2 роки    | 2 роки тому       | 17520 годин                    |
| 1997-01-01T00:00:00.000Z | 3 роки    | 3 роки тому       | 26280 годин                    |
| 1996-01-01T00:00:00.000Z | 4 роки    | 4 роки тому       | 35064 години                   |
| 1995-01-01T00:00:00.000Z | 5 років   | 5 років тому      | 43824 години                   |
| 1994-01-01T00:00:00.000Z | 6 років   | 6 років тому      | 52584 години                   |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | у наступну середу о 0:00 |
| 2000-01-02T00:00:00.000Z | завтра о 0:00            |
| 2000-01-01T00:00:00.000Z | сьогодні о 0:00          |
| 1999-12-31T00:00:00.000Z | вчора о 0:00             |
| 1999-12-27T00:00:00.000Z | у понеділок о 0:00       |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 років   |
| {"years":1}   | 1 рік     |
| {"years":2}   | 2 роки    |
| {"months":0}  | 0 місяців |
| {"months":1}  | 1 місяць  |
| {"months":2}  | 2 місяці  |
| {"weeks":0}   | 0 тижнів  |
| {"weeks":1}   | 1 тиждень |
| {"weeks":2}   | 2 тижні   |
| {"days":0}    | 0 днів    |
| {"days":1}    | 1 день    |
| {"days":2}    | 2 днi     |
| {"hours":0}   | 0 годин   |
| {"hours":1}   | 1 годину  |
| {"hours":2}   | 2 години  |
| {"minutes":0} | 0 хвилин  |
| {"minutes":1} | 1 хвилина |
| {"minutes":2} | 2 хвилини |
| {"seconds":0} | 0 секунд  |
| {"seconds":1} | 1 секунда |
| {"seconds":2} | 2 секунди |
