# Uzbek (uz-Cyrl) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                             | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                             | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-чор.                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-чор.                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-чорак                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-чорак                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-чор.                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-чор.                                        | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-чорак                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-чорак                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | янв                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | фев                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | мар                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | апр                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | июн                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июл                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | авг                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | сен                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | окт                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ноя                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | дек                                           | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | январ                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | феврал                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | март                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | апрел                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | июн                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июл                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | август                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | сентабр                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | октабр                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ноябр                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | декабр                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | Я                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Ф                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | М                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | А                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | М                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | И                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | И                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | А                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | С                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | О                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Н                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Д                                             | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | янв                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | фев                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | мар                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | апр                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | июн                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июл                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | авг                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | сен                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | окт                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ноя                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | дек                                           | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | январ                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | феврал                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | март                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | апрел                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | май                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | июн                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | июл                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | август                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | сентабр                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | октабр                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ноябр                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | декабр                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | Я                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Ф                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | М                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | А                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | М                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | И                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | И                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | А                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | С                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | О                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Н                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Д                                             | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                            | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                            | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                            | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 феврал                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 феврал                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 феврал                                     | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                           | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | душанба                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жума                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Д                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ду                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жу                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | душанба                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жума                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Д                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ду                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жу                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | душанба                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жума                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Д                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ду                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жу                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | душ                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жум                                           | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | душанба                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жума                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Д                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ду                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жу                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | п.о.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | п.к.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | п.к.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | п.о.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | п.о.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | п.к.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | п.к.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | п.о.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | П.К.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | П.О.                                          | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | эрталаб                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пешиндан кейин                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кечаси                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тун                                           | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | эрталаб                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пешиндан кейин                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кечаси                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тун                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | эрталаб                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пешиндан кейин                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кечаси                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тун                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | эрталаб                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пешиндан кейин                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кечаси                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тун                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | эрталаб                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | пешиндан кейин                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кечаси                                        | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тун                                           | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                             | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                            | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                             | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                            | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 янв, 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 фев, 1987                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 мар, 1987                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 апр, 1987                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май, 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 июн, 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 июл, 1987                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 авг, 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 сен, 1987                                  | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 окт, 1987                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ноя, 1987                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 дек, 1987                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 январ, 1987                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 феврал, 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 март, 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 апрел, 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май, 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 июн, 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 июл, 1987                                  | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 август, 1987                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 сентабр, 1987                              | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 октабр, 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ноябр, 1987                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 декабр, 1987                               | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | якшанба, 11 январ, 1987                       | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | чоршанба, 11 феврал, 1987                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | чоршанба, 11 март, 1987                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | шанба, 11 апрел, 1987                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | якшанба, 29 май, 1453                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | пайшанба, 11 июн, 1987                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | шанба, 11 июл, 1987                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | сешанба, 11 август, 1987                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | жума, 11 сентабр, 1987                        | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | якшанба, 11 октабр, 1987                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | чоршанба, 11 ноябр, 1987                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | жума, 11 декабр, 1987                         | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                         | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                         | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                         | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                         | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                         | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                         | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                         | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                         | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                         | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                         | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                         | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                      | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                      | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                      | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                      | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                      | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                            | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13                             | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 янв, 1987, 12:13:14                        | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 фев, 1987, 12:13:14                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 мар, 1987, 12:13:14                        | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 апр, 1987, 12:13:14                        | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май, 1453, 23:59:59                        | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 июн, 1987, 12:13:14                        | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 июл, 1987, 12:13:14                        | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 авг, 1987, 12:13:14                        | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 сен, 1987, 12:13:14                        | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 окт, 1987, 12:13:14                        | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ноя, 1987, 12:13:14                        | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 дек, 1987, 12:13:14                        | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 январ, 1987, 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 феврал, 1987, 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 март, 1987, 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 апрел, 1987, 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май, 1453, 23:59:59 GMT+0                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 июн, 1987, 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 июл, 1987, 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 август, 1987, 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 сентабр, 1987, 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 октабр, 1987, 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 ноябр, 1987, 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 декабр, 1987, 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | якшанба, 11 январ, 1987, 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | чоршанба, 11 феврал, 1987, 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | чоршанба, 11 март, 1987, 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | шанба, 11 апрел, 1987, 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | якшанба, 29 май, 1453, 23:59:59 GMT+00:00     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | пайшанба, 11 июн, 1987, 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | шанба, 11 июл, 1987, 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | сешанба, 11 август, 1987, 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | жума, 11 сентабр, 1987, 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | якшанба, 11 октабр, 1987, 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | чоршанба, 11 ноябр, 1987, 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | жума, 11 декабр, 1987, 12:13:14 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | --------------- | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | тахминан 6 йил  | тахминан 6 йил         | тахминан 6 йилдан кейин  |
| 2005-01-01T00:00:00.000Z | тахминан 5 йил  | тахминан 5 йил         | тахминан 5 йилдан кейин  |
| 2004-01-01T00:00:00.000Z | тахминан 4 йил  | тахминан 4 йил         | тахминан 4 йилдан кейин  |
| 2003-01-01T00:00:00.000Z | тахминан 3 йил  | тахминан 3 йил         | тахминан 3 йилдан кейин  |
| 2002-01-01T00:00:00.000Z | тахминан 2 йил  | тахминан 2 йил         | тахминан 2 йилдан кейин  |
| 2001-06-01T00:00:00.000Z | 1 йилдан кўп    | 1 йилдан кўп           | 1 йилдан кўпдан кейин    |
| 2001-02-01T00:00:00.000Z | тахминан 1 йил  | тахминан 1 йил         | тахминан 1 йилдан кейин  |
| 2001-01-01T00:00:00.000Z | тахминан 1 йил  | тахминан 1 йил         | тахминан 1 йилдан кейин  |
| 2000-06-01T00:00:00.000Z | 5 ой            | 5 ой                   | 5 ойдан кейин            |
| 2000-03-01T00:00:00.000Z | 2 ой            | 2 ой                   | 2 ойдан кейин            |
| 2000-02-01T00:00:00.000Z | тахминан 1 ой   | тахминан 1 ой          | тахминан 1 ойдан кейин   |
| 2000-01-15T00:00:00.000Z | 14 кун          | 14 кун                 | 14 кундан кейин          |
| 2000-01-02T00:00:00.000Z | 1 кун           | 1 кун                  | 1 кундан кейин           |
| 2000-01-01T06:00:00.000Z | тахминан 6 соат | тахминан 6 соат        | тахминан 6 соатдан кейин |
| 2000-01-01T01:00:00.000Z | тахминан 1 соат | тахминан 1 соат        | тахминан 1 соатдан кейин |
| 2000-01-01T00:45:00.000Z | тахминан 1 соат | тахминан 1 соат        | тахминан 1 соатдан кейин |
| 2000-01-01T00:30:00.000Z | 30 дақиқа       | 30 дақиқа              | 30 дақиқадан кейин       |
| 2000-01-01T00:15:00.000Z | 15 дақиқа       | 15 дақиқа              | 15 дақиқадан кейин       |
| 2000-01-01T00:01:00.000Z | 1 дақиқа        | 1 дақиқа               | 1 дақиқадан кейин        |
| 2000-01-01T00:00:25.000Z | 1 дақиқадан кам | ярим дақиқа            | 1 дақиқадан камдан кейин |
| 2000-01-01T00:00:15.000Z | 1 дақиқадан кам | 20 сониядан кам        | 1 дақиқадан камдан кейин |
| 2000-01-01T00:00:05.000Z | 1 дақиқадан кам | 10 сониядан кам        | 1 дақиқадан камдан кейин |
| 2000-01-01T00:00:00.000Z | 1 дақиқадан кам | 5 сониядан кам         | 1 дақиқадан кам олдин    |
| 1999-12-31T23:59:55.000Z | 1 дақиқадан кам | 10 сониядан кам        | 1 дақиқадан кам олдин    |
| 1999-12-31T23:59:45.000Z | 1 дақиқадан кам | 20 сониядан кам        | 1 дақиқадан кам олдин    |
| 1999-12-31T23:59:35.000Z | 1 дақиқадан кам | ярим дақиқа            | 1 дақиқадан кам олдин    |
| 1999-12-31T23:59:00.000Z | 1 дақиқа        | 1 дақиқа               | 1 дақиқа олдин           |
| 1999-12-31T23:45:00.000Z | 15 дақиқа       | 15 дақиқа              | 15 дақиқа олдин          |
| 1999-12-31T23:30:00.000Z | 30 дақиқа       | 30 дақиқа              | 30 дақиқа олдин          |
| 1999-12-31T23:15:00.000Z | тахминан 1 соат | тахминан 1 соат        | тахминан 1 соат олдин    |
| 1999-12-31T23:00:00.000Z | тахминан 1 соат | тахминан 1 соат        | тахминан 1 соат олдин    |
| 1999-12-31T18:00:00.000Z | тахминан 6 соат | тахминан 6 соат        | тахминан 6 соат олдин    |
| 1999-12-30T00:00:00.000Z | 2 кун           | 2 кун                  | 2 кун олдин              |
| 1999-12-15T00:00:00.000Z | 17 кун          | 17 кун                 | 17 кун олдин             |
| 1999-12-01T00:00:00.000Z | тахминан 1 ой   | тахминан 1 ой          | тахминан 1 ой олдин      |
| 1999-11-01T00:00:00.000Z | 2 ой            | 2 ой                   | 2 ой олдин               |
| 1999-06-01T00:00:00.000Z | 7 ой            | 7 ой                   | 7 ой олдин               |
| 1999-01-01T00:00:00.000Z | тахминан 1 йил  | тахминан 1 йил         | тахминан 1 йил олдин     |
| 1998-12-01T00:00:00.000Z | тахминан 1 йил  | тахминан 1 йил         | тахминан 1 йил олдин     |
| 1998-06-01T00:00:00.000Z | 1 йилдан кўп    | 1 йилдан кўп           | 1 йилдан кўп олдин       |
| 1998-01-01T00:00:00.000Z | тахминан 2 йил  | тахминан 2 йил         | тахминан 2 йил олдин     |
| 1997-01-01T00:00:00.000Z | тахминан 3 йил  | тахминан 3 йил         | тахминан 3 йил олдин     |
| 1996-01-01T00:00:00.000Z | тахминан 4 йил  | тахминан 4 йил         | тахминан 4 йил олдин     |
| 1995-01-01T00:00:00.000Z | тахминан 5 йил  | тахминан 5 йил         | тахминан 5 йил олдин     |
| 1994-01-01T00:00:00.000Z | тахминан 6 йил  | тахминан 6 йил         | тахминан 6 йил олдин     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 йил     | 6 йилдан кейин     | 52608 соат                     |
| 2005-01-01T00:00:00.000Z | 5 йил     | 5 йилдан кейин     | 43848 соат                     |
| 2004-01-01T00:00:00.000Z | 4 йил     | 4 йилдан кейин     | 35064 соат                     |
| 2003-01-01T00:00:00.000Z | 3 йил     | 3 йилдан кейин     | 26304 соат                     |
| 2002-01-01T00:00:00.000Z | 2 йил     | 2 йилдан кейин     | 17544 соат                     |
| 2001-06-01T00:00:00.000Z | 1 йил     | 1 йилдан кейин     | 12408 соат                     |
| 2001-02-01T00:00:00.000Z | 1 йил     | 1 йилдан кейин     | 9528 соат                      |
| 2001-01-01T00:00:00.000Z | 1 йил     | 1 йилдан кейин     | 8784 соат                      |
| 2000-06-01T00:00:00.000Z | 5 ой      | 5 ойдан кейин      | 3648 соат                      |
| 2000-03-01T00:00:00.000Z | 2 ой      | 2 ойдан кейин      | 1440 соат                      |
| 2000-02-01T00:00:00.000Z | 1 ой      | 1 ойдан кейин      | 744 соат                       |
| 2000-01-15T00:00:00.000Z | 14 кун    | 14 кундан кейин    | 336 соат                       |
| 2000-01-02T00:00:00.000Z | 1 кун     | 1 кундан кейин     | 24 соат                        |
| 2000-01-01T06:00:00.000Z | 6 соат    | 6 соатдан кейин    | 6 соат                         |
| 2000-01-01T01:00:00.000Z | 1 соат    | 1 соатдан кейин    | 1 соат                         |
| 2000-01-01T00:45:00.000Z | 45 дақиқа | 45 дақиқадан кейин | 1 соат                         |
| 2000-01-01T00:30:00.000Z | 30 дақиқа | 30 дақиқадан кейин | 1 соат                         |
| 2000-01-01T00:15:00.000Z | 15 дақиқа | 15 дақиқадан кейин | 0 соат                         |
| 2000-01-01T00:01:00.000Z | 1 дақиқа  | 1 дақиқадан кейин  | 0 соат                         |
| 2000-01-01T00:00:25.000Z | 25 сония  | 25 сониядан кейин  | 0 соат                         |
| 2000-01-01T00:00:15.000Z | 15 сония  | 15 сониядан кейин  | 0 соат                         |
| 2000-01-01T00:00:05.000Z | 5 сония   | 5 сониядан кейин   | 0 соат                         |
| 2000-01-01T00:00:00.000Z | 0 сония   | 0 сония олдин      | 0 соат                         |
| 1999-12-31T23:59:55.000Z | 5 сония   | 5 сония олдин      | 0 соат                         |
| 1999-12-31T23:59:45.000Z | 15 сония  | 15 сония олдин     | 0 соат                         |
| 1999-12-31T23:59:35.000Z | 25 сония  | 25 сония олдин     | 0 соат                         |
| 1999-12-31T23:59:00.000Z | 1 дақиқа  | 1 дақиқа олдин     | 0 соат                         |
| 1999-12-31T23:45:00.000Z | 15 дақиқа | 15 дақиқа олдин    | 0 соат                         |
| 1999-12-31T23:30:00.000Z | 30 дақиқа | 30 дақиқа олдин    | 1 соат                         |
| 1999-12-31T23:15:00.000Z | 45 дақиқа | 45 дақиқа олдин    | 1 соат                         |
| 1999-12-31T23:00:00.000Z | 1 соат    | 1 соат олдин       | 1 соат                         |
| 1999-12-31T18:00:00.000Z | 6 соат    | 6 соат олдин       | 6 соат                         |
| 1999-12-30T00:00:00.000Z | 2 кун     | 2 кун олдин        | 48 соат                        |
| 1999-12-15T00:00:00.000Z | 17 кун    | 17 кун олдин       | 408 соат                       |
| 1999-12-01T00:00:00.000Z | 1 ой      | 1 ой олдин         | 744 соат                       |
| 1999-11-01T00:00:00.000Z | 2 ой      | 2 ой олдин         | 1464 соат                      |
| 1999-06-01T00:00:00.000Z | 7 ой      | 7 ой олдин         | 5136 соат                      |
| 1999-01-01T00:00:00.000Z | 1 йил     | 1 йил олдин        | 8760 соат                      |
| 1998-12-01T00:00:00.000Z | 1 йил     | 1 йил олдин        | 9504 соат                      |
| 1998-06-01T00:00:00.000Z | 2 йил     | 2 йил олдин        | 13896 соат                     |
| 1998-01-01T00:00:00.000Z | 2 йил     | 2 йил олдин        | 17520 соат                     |
| 1997-01-01T00:00:00.000Z | 3 йил     | 3 йил олдин        | 26280 соат                     |
| 1996-01-01T00:00:00.000Z | 4 йил     | 4 йил олдин        | 35064 соат                     |
| 1995-01-01T00:00:00.000Z | 5 йил     | 5 йил олдин        | 43824 соат                     |
| 1994-01-01T00:00:00.000Z | 6 йил     | 6 йил олдин        | 52584 соат                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                |
| ------------------------ | --------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000            |
| 2000-01-05T00:00:00.000Z | чоршанба 0:00 да      |
| 2000-01-02T00:00:00.000Z | эртага 0:00 да        |
| 2000-01-01T00:00:00.000Z | бугун 0:00 да         |
| 1999-12-31T00:00:00.000Z | кеча 0:00 да          |
| 1999-12-27T00:00:00.000Z | ўтган душанба 0:00 да |
| 1999-12-21T00:00:00.000Z | 21/12/1999            |

## `formatDuration`

| Duration      | Result   |
| ------------- | -------- |
| {"years":0}   | 0 йил    |
| {"years":1}   | 1 йил    |
| {"years":2}   | 2 йил    |
| {"months":0}  | 0 ой     |
| {"months":1}  | 1 ой     |
| {"months":2}  | 2 ой     |
| {"weeks":0}   | 0 хафта  |
| {"weeks":1}   | 1 хафта  |
| {"weeks":2}   | 2 хафта  |
| {"days":0}    | 0 кун    |
| {"days":1}    | 1 кун    |
| {"days":2}    | 2 кун    |
| {"hours":0}   | 0 соат   |
| {"hours":1}   | 1 соат   |
| {"hours":2}   | 2 соат   |
| {"minutes":0} | 0 дақиқа |
| {"minutes":1} | 1 дақиқа |
| {"minutes":2} | 2 дақиқа |
| {"seconds":0} | 0 сония  |
| {"seconds":1} | 1 сония  |
| {"seconds":2} | 2 сония  |
