import RSVP from '../../ext/rsvp';
import { getAdapter, setAdapter } from '../../test/adapter';
import TestPromise, { getLastPromise } from '../../test/promise';
import { run } from 'ember-metal';
import { isTesting, setTesting } from 'ember-debug';

const originalTestAdapter = getAdapter();
const originalTestingFlag = isTesting();

let asyncStarted = 0;
let asyncEnded = 0;

QUnit.module('ember-testing RSVP', {
  setup() {
    setTesting(true);
    setAdapter({
      asyncStart() {
        asyncStarted++;
        QUnit.stop();
      },
      asyncEnd() {
        asyncEnded++;
        QUnit.start();
      }
    });
  },
  teardown() {
    asyncStarted = 0;
    asyncEnded = 0;
    setAdapter(originalTestAdapter);
    setTesting(originalTestingFlag);
  }
});

QUnit.test('given `Ember.testing = true`, correctly informs the test suite about async steps', function() {
  expect(19);

  ok(!run.currentRunLoop, 'expect no run-loop');

  setTesting(true);

  equal(asyncStarted, 0);
  equal(asyncEnded, 0);

  let user = RSVP.Promise.resolve({
    name: 'tomster'
  });

  equal(asyncStarted, 0);
  equal(asyncEnded, 0);

  user.then(function(user) {
    equal(asyncStarted, 1);
    equal(asyncEnded, 1);

    equal(user.name, 'tomster');

    return RSVP.Promise.resolve(1).then(function() {
      equal(asyncStarted, 1);
      equal(asyncEnded, 1);
    });
  }).then(function() {
    equal(asyncStarted, 1);
    equal(asyncEnded, 1);

    return new RSVP.Promise(function(resolve) {
      QUnit.stop(); // raw async, we must inform the test framework manually
      setTimeout(function() {
        QUnit.start(); // raw async, we must inform the test framework manually

        equal(asyncStarted, 1);
        equal(asyncEnded, 1);

        resolve({
          name: 'async tomster'
        });

        equal(asyncStarted, 2);
        equal(asyncEnded, 1);
      }, 0);
    });
  }).then(function(user) {
    equal(user.name, 'async tomster');
    equal(asyncStarted, 2);
    equal(asyncEnded, 2);
  });
});


QUnit.module('TestPromise');

QUnit.test('does not throw error when falsy value passed to then', function() {
  expect(1);
  return new TestPromise(function(resolve) {
    resolve();
  })
  .then(null)
  .then(function() {
    ok(true);
  });
});

QUnit.test('able to get last Promise', function() {
  expect(2);

  var p1 = new TestPromise(function(resolve) {
    resolve();
  })
  .then(function() {
    ok(true);
  });

  var p2 = new TestPromise(function(resolve) {
    resolve();
  });

  deepEqual(getLastPromise(), p2);
  return p1;
});
